/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.SimpleNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.gauge.AbstractGaugeTickStyle;
import com.jidesoft.range.NumericRange;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.UIManager;

public class AbstractNumericGaugeAxis<TickStyle extends AbstractGaugeTickStyle> {
    public static final String PROPERTY_RANGE = "Range";
    public static final String PROPERTY_MAJOR_TICK_STYLE = "MajorTickStyle";
    public static final String PROPERTY_MINOR_TICK_STYLE = "MinorTickStyle";
    public static final String PROPERTY_MAJOR_TICK = "MajorTick";
    public static final String PROPERTY_MINOR_TICK = "MinorTick";
    private NumericTickCalculator tickCalculator;
    protected NumericRange range;
    private TickStyle majorTickStyle;
    private TickStyle minorTickStyle;
    protected double majorTickInterval;
    protected double minorTickInterval;
    private Font tickLabelFont = UIManager.getFont("Label.font");
    private Color tickLabelColor = Color.black;
    private Tick[] ticks;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private NumberFormat numberFormat = null;

    public AbstractNumericGaugeAxis() {
        this(0.0, 100.0, 10.0, 2.0);
    }

    public AbstractNumericGaugeAxis(double d, double d2) {
        this(d, d2, (d2 - d) / 10.0, (d2 - d) / 20.0);
    }

    public AbstractNumericGaugeAxis(double d, double d2, double d3, double d4) {
        this.minorTickInterval = d4;
        this.range = new NumericRange(d, d2);
        this.majorTickInterval = d3;
        this.updateTicks();
    }

    public void setRange(double d, double d2) {
        NumericRange numericRange = this.range;
        this.range = new NumericRange(d, d2);
        this.ticks = null;
        this.support.firePropertyChange(PROPERTY_RANGE, numericRange, this.range);
    }

    public void setRange(NumericRange numericRange) {
        NumericRange numericRange2 = this.range;
        this.range = numericRange;
        this.ticks = null;
        this.support.firePropertyChange(PROPERTY_RANGE, numericRange2, numericRange);
    }

    public NumericRange getRange() {
        return this.range;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public double getMajorTickInterval() {
        return this.majorTickInterval;
    }

    public void setMajorTickInterval(double d) {
        double d2 = this.majorTickInterval;
        this.majorTickInterval = d;
        this.updateTicks();
        this.support.firePropertyChange(PROPERTY_MAJOR_TICK, d2, d);
    }

    public double getMinorTickInterval() {
        return this.minorTickInterval;
    }

    public void setMinorTickInterval(double d) {
        double d2 = this.minorTickInterval;
        this.minorTickInterval = d;
        this.updateTicks();
        this.support.firePropertyChange(PROPERTY_MINOR_TICK, d2, d);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    protected void updateTicks() {
        assert (this.range != null);
        if (this.range.minimum() == this.range.maximum()) {
            this.ticks = new Tick[0];
        } else {
            this.tickCalculator = this.createTickCalculator(this.range.minimum(), this.range.maximum(), this.majorTickInterval, this.minorTickInterval);
            this.ticks = this.tickCalculator == null ? new Tick[0] : this.tickCalculator.calculateTicks(this.range);
        }
    }

    protected NumericTickCalculator createTickCalculator(double d, double d2, double d3, double d4) {
        SimpleNumericTickCalculator simpleNumericTickCalculator = new SimpleNumericTickCalculator(this.range.minimum(), d3, d4);
        if (this.numberFormat != null) {
            simpleNumericTickCalculator.setNumberFormat(this.numberFormat);
        }
        return simpleNumericTickCalculator;
    }

    public List<Tick> ticks() {
        assert (this.range != null);
        if (this.ticks == null) {
            this.updateTicks();
        }
        return Arrays.asList(this.ticks);
    }

    public double minimum() {
        return this.range.minimum();
    }

    public double maximum() {
        return this.range.maximum();
    }

    public TickStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public void setMajorTickStyle(TickStyle TickStyle) {
        TickStyle TickStyle2 = this.majorTickStyle;
        this.majorTickStyle = TickStyle;
        this.support.firePropertyChange(PROPERTY_MAJOR_TICK_STYLE, TickStyle2, TickStyle);
    }

    public TickStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public void setMinorTickStyle(TickStyle TickStyle) {
        TickStyle TickStyle2 = this.minorTickStyle;
        this.minorTickStyle = TickStyle;
        this.support.firePropertyChange(PROPERTY_MINOR_TICK_STYLE, TickStyle2, TickStyle);
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        this.tickLabelFont = font;
    }

    public Color getTickLabelColor() {
        return this.tickLabelColor;
    }

    public void setTickLabelColor(Color color) {
        this.tickLabelColor = color;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#<AbstractGaugeAxis");
        stringBuilder.append(" range=").append(this.range);
        stringBuilder.append('>');
        return stringBuilder.toString();
    }
}

