/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.scale.Period;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public abstract class AbstractPeriodBackgroundPainter<T>
implements PeriodBackgroundPainter<T> {
    public static final int OUTLINE_DEFAULT = 0;
    public static final int OUTLINE_START = 1;
    public static final int OUTLINE_END = 2;
    private final Period _period;

    protected abstract Paint getBackgroundPaint(T var1, T var2);

    protected abstract Paint getOutlinePaint(T var1, T var2);

    protected abstract Stroke getOutlineStroke(T var1, T var2);

    protected abstract int getOutlineSides(T var1, T var2);

    public AbstractPeriodBackgroundPainter(Period period) {
        this._period = period;
    }

    @Override
    public Period getPeriod() {
        return this._period;
    }

    @Override
    public void paintPeriodBackground(GanttChart<T, GanttEntry<T>> ganttChart, Graphics2D graphics2D, T t, T t2, int n, int n2, int n3, int n4) {
        boolean bl = ganttChart.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics2D.getClipBounds();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n5 = 0;
        int n6 = Math.max(n, rectangle.x);
        int n7 = rectangle.y;
        int n8 = n3 - n6;
        int n9 = Math.min(n8, rectangle.width);
        int n10 = rectangle.height;
        if (n >= rectangle.x) {
            n5 |= 1;
        }
        if (n3 <= rectangle.x + rectangle.width) {
            n5 |= 2;
        }
        n5 = this.adjustForLeftToRight(n5, bl);
        Paint paint2 = this.getBackgroundPaint(t, t2);
        if (paint2 != null) {
            this.paintBackground(graphics2D, paint2, n6, n7, n9, n10);
        }
        Paint paint3 = this.getOutlinePaint(t, t2);
        Stroke stroke2 = this.getOutlineStroke(t, t2);
        int n11 = this.getOutlineSides(t, t2);
        if (paint3 != null) {
            this.paintOutline(graphics2D, bl, paint3, stroke2, n11 & n5, n6, n7, n9, n10);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private int adjustForLeftToRight(int n, boolean bl) {
        if (!bl) {
            int n2 = 0;
            if ((n & 1) == 1) {
                n2 |= 2;
            }
            if ((n & 2) == 2) {
                n2 |= 1;
            }
            n = n2;
        }
        return n;
    }

    private void paintOutline(Graphics2D graphics2D, boolean bl, Paint paint, Stroke stroke, int n, int n2, int n3, int n4, int n5) {
        graphics2D.setPaint(paint);
        if (stroke != null) {
            graphics2D.setStroke(this.deriveStroke(stroke, n3));
        }
        boolean bl2 = (n & 1) == 1;
        boolean bl3 = (n & 2) == 2;
        int n6 = n3 + n5 - 1;
        if (bl2 && bl || bl3 && !bl) {
            graphics2D.drawLine(n2, n3, n2, n6);
        }
        if (bl3 && bl || bl2 && !bl) {
            int n7 = n2 + n4;
            graphics2D.drawLine(n7, n3, n7, n6);
        }
    }

    protected Stroke deriveStroke(Stroke stroke, int n) {
        BasicStroke basicStroke;
        float[] fArray;
        if (stroke instanceof BasicStroke && (fArray = (basicStroke = (BasicStroke)stroke).getDashArray()).length > 0 && (float)n >= 0.0f) {
            return new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), n);
        }
        return stroke;
    }

    protected void paintBackground(Graphics2D graphics2D, Paint paint, int n, int n2, int n3, int n4) {
        graphics2D.setPaint(paint);
        graphics2D.fillRect(n, n2, n3, n4);
    }
}

