/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.CheckBoxListExComboBox;
import com.jidesoft.combobox.DateComboBox;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.combobox.MultiSelectListComboBox;
import com.jidesoft.combobox.MultiSelectListExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.GridResource;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.TypeUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ValueEditor
extends JPanel {
    protected Class _dataType;
    protected ConverterContext _converterContext;
    protected Object[] _possibleValues;
    private Object[] _displayedValues;
    private Object[] _displayedValuesNoNull;
    protected JComponent _comboBox;
    private boolean _labelVisible = true;
    protected JLabel _valueLabel;
    private boolean _showEmpty = true;

    public ValueEditor(Class clazz, ConverterContext converterContext, Object[] objectArray) {
        this.reset(clazz, converterContext, objectArray);
    }

    void reset(Class clazz, ConverterContext converterContext, Object[] objectArray) {
        int n;
        boolean bl;
        this._dataType = clazz;
        this._converterContext = converterContext;
        this._possibleValues = objectArray;
        boolean bl2 = bl = this._possibleValues != null && this._possibleValues.length > 1 && this._possibleValues[this._possibleValues.length - 1] instanceof ConverterContext;
        if (!bl && this._possibleValues != null) {
            for (n = 0; n < this._possibleValues.length; ++n) {
                if (this._possibleValues[n] != null) continue;
                this._possibleValues[n] = "(Empty)";
            }
        }
        this._displayedValues = this._possibleValues;
        if (bl) {
            this._displayedValues = new String[this._possibleValues.length >> 1];
            for (n = (this._possibleValues.length >> 1) - 1; n >= 0; --n) {
                Object object = this._possibleValues[n + (this._possibleValues.length >> 1)];
                this._displayedValues[n] = ObjectConverterManager.toString(this._possibleValues[n], this._dataType, object instanceof ConverterContext ? (ConverterContext)object : null);
            }
        }
        if (this._displayedValues == null || this._displayedValues.length < 1 || !"(Empty)".equals(this._displayedValues[0])) {
            this._displayedValuesNoNull = this._displayedValues;
        } else {
            this._displayedValuesNoNull = new Object[this._displayedValues.length - 1];
            System.arraycopy(this._displayedValues, 1, this._displayedValuesNoNull, 0, this._displayedValuesNoNull.length);
        }
        this.initComponents();
    }

    public void setDataType(Class clazz, ConverterContext converterContext) {
        if (this._dataType != clazz || this._converterContext != converterContext) {
            if (!TypeUtils.isNumericType(this._dataType) || clazz != Number.class) {
                this._dataType = clazz;
            }
            this._converterContext = converterContext;
            this.initComponents();
            this.revalidate();
        }
    }

    protected void initComponents() {
        this.removeAll();
        if (this._dataType != null) {
            Object object;
            boolean bl;
            boolean bl2 = bl = this._possibleValues != null && this._possibleValues.length > 1 && this._possibleValues[this._possibleValues.length - 1] instanceof ConverterContext;
            if (this._dataType.isArray()) {
                this._comboBox = new CheckBoxListExComboBox(this._displayedValues, bl ? Array.newInstance(String.class, 0).getClass() : this._dataType);
                this._comboBox.setName("CompactField");
                if (((CheckBoxListExComboBox)this._comboBox).getModel() instanceof DefaultComboBoxModel) {
                    ((DefaultComboBoxModel)((CheckBoxListExComboBox)this._comboBox).getModel()).insertElementAt(CheckBoxList.ALL_ENTRY, 0);
                }
                ((CheckBoxListExComboBox)this._comboBox).setEditable(true);
            } else {
                this._comboBox = this.isShowEmpty() ? new ListExComboBox(this._displayedValues) : new ListExComboBox(this._displayedValuesNoNull);
                this._comboBox.setName("CompactField");
                if (this._comboBox instanceof JComboBox) {
                    ((ListExComboBox)this._comboBox).setEditable(true);
                }
            }
            if (this._comboBox instanceof AbstractComboBox) {
                ((AbstractComboBox)this._comboBox).setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            } else if (this._comboBox instanceof JComboBox) {
                ((JComboBox)this._comboBox).setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            }
            if (!bl) {
                if (this._comboBox instanceof AbstractComboBox) {
                    ((AbstractComboBox)this._comboBox).setConverterContext(this._converterContext);
                } else if (this._comboBox instanceof JComboBox) {
                    if (this._comboBox instanceof ExComboBox) {
                        ((ExComboBox)this._comboBox).setConverterContext(this._converterContext);
                    } else {
                        object = ((JComboBox)this._comboBox).getRenderer();
                        ((JComboBox)this._comboBox).setRenderer(new ListCellRenderer((ListCellRenderer)object){
                            final /* synthetic */ ListCellRenderer val$defaultRenderer;
                            {
                                this.val$defaultRenderer = listCellRenderer;
                            }

                            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                                return this.val$defaultRenderer.getListCellRendererComponent(jList, ValueEditor.this.convertElementToString(object, true), n, bl, bl2);
                            }
                        });
                    }
                }
            }
            this.setValue(null);
            this.setLayout(new JideBorderLayout(4, 4));
            this._valueLabel = new JLabel(this.getResourceString("FilterEditor.value"));
            this._valueLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.value.mnemonic").charAt(0));
            object = JideSwingUtilities.createLabeledComponent(this._valueLabel, this._comboBox, "First");
            this.add((Component)object);
            this._valueLabel.setVisible(this.isLabelVisible());
            this.customizeValueEditor((JPanel)object, this._dataType, this._comboBox);
        }
    }

    public void setEditable(boolean bl) {
        if (this._comboBox instanceof AbstractComboBox) {
            ((AbstractComboBox)this._comboBox).setEditable(bl);
        } else if (this._comboBox instanceof JComboBox) {
            ((JComboBox)this._comboBox).setEditable(bl);
        }
    }

    private String convertElementToString(Object object, boolean bl) {
        if (object == null || "(Empty)".equals(object)) {
            return GridResource.getResourceBundle(this.getLocale()).getString("Filter.null");
        }
        if (CheckBoxList.ALL_ENTRY.equals(object) || "(All)".equals(object)) {
            return GridResource.getResourceBundle(this.getLocale()).getString("Filter.all");
        }
        Class<?> clazz = bl && this._dataType.isArray() ? this._dataType.getComponentType() : this._dataType;
        return ObjectConverterManager.toString(object, clazz, this._converterContext);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._valueLabel != null) {
            this._valueLabel.setText(this.getResourceString("FilterEditor.value"));
            this._valueLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.value.mnemonic").charAt(0));
        }
    }

    protected void customizeValueEditor(JPanel jPanel, final Class clazz, JComponent jComponent) {
        if (Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz)) {
            DateComboBox dateComboBox = this.createDateComboBoxButton();
            dateComboBox.setButtonOnly(true);
            dateComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        Object object = itemEvent.getItem();
                        if (object instanceof Calendar && Date.class.isAssignableFrom(clazz)) {
                            ValueEditor.this.setValue(((Calendar)object).getTime());
                        } else if (Calendar.class.isAssignableFrom(clazz)) {
                            ValueEditor.this.setValue(object);
                        }
                    }
                }
            });
            jPanel.add((Component)dateComboBox, "After");
        }
    }

    protected DateComboBox createDateComboBoxButton() {
        return new DateComboBox(){

            @Override
            public AbstractButton createButtonComponent() {
                JButton jButton = new JButton(IconsFactory.getImageIcon(ValueEditor.class, "icons/date.png"));
                jButton.setMargin(new Insets(3, 3, 3, 3));
                return jButton;
            }
        };
    }

    public boolean isLabelVisible() {
        return this._labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this._labelVisible = bl;
        if (this._valueLabel != null) {
            this._valueLabel.setVisible(this.isLabelVisible());
        }
    }

    public Object getValue() {
        Object object;
        boolean bl;
        boolean bl2 = bl = this._possibleValues.length > 1 && this._possibleValues[this._possibleValues.length - 1] instanceof ConverterContext;
        if (this._comboBox instanceof MultiSelectListComboBox || this._comboBox instanceof MultiSelectListExComboBox) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = this._comboBox instanceof MultiSelectListComboBox ? ((AbstractComboBox)this._comboBox).getSelectedObjects() : ((MultiSelectListExComboBox)this._comboBox).getSelectedObjects();
            if (objectArray == null || !bl) {
                return objectArray;
            }
            Object[] objectArray3 = new Object[objectArray.length];
            block0: for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    objectArray3[i] = null;
                    continue;
                }
                for (int j = 0; j < this._displayedValues.length; ++j) {
                    if (!objectArray[i].equals(this._displayedValues[j])) continue;
                    objectArray3[i] = this._possibleValues[j];
                    continue block0;
                }
            }
            return objectArray3;
        }
        Object object2 = object = this._comboBox instanceof JComboBox ? ((JComboBox)this._comboBox).getSelectedItem() : ((AbstractComboBox)this._comboBox).getSelectedItem();
        if (object == null || !bl) {
            Object object3;
            if (this._comboBox instanceof JComboBox && object instanceof String && (object3 = ObjectConverterManager.fromString((String)object, this._dataType, this._converterContext)) != null) {
                if (object3.getClass().isAssignableFrom(this._dataType)) {
                    return object3;
                }
                if (TypeUtils.isNumericType(this._dataType) && TypeUtils.isNumericType(object3.getClass())) {
                    if (this._dataType == Float.class || this._dataType == Float.TYPE) {
                        return Float.valueOf(((Number)object3).floatValue());
                    }
                    if (this._dataType == Double.class || this._dataType == Double.TYPE) {
                        return ((Number)object3).doubleValue();
                    }
                    if (this._dataType == Long.class || this._dataType == Long.TYPE) {
                        return ((Number)object3).longValue();
                    }
                    if (this._dataType == Integer.class || this._dataType == Integer.TYPE) {
                        return ((Number)object3).intValue();
                    }
                    if (this._dataType == Short.class || this._dataType == Short.TYPE) {
                        return ((Number)object3).shortValue();
                    }
                }
            }
            return object;
        }
        for (int i = 0; i < this._displayedValues.length; ++i) {
            if (!object.equals(this._displayedValues[i])) continue;
            return this._possibleValues[i];
        }
        return null;
    }

    boolean setShowEmpty(boolean bl) {
        if (this._showEmpty != bl && this._displayedValues != this._displayedValuesNoNull) {
            this._showEmpty = bl;
            Object object = this.getValue();
            this.initComponents();
            this.setValue(object);
            return true;
        }
        return false;
    }

    boolean isShowEmpty() {
        return this._showEmpty;
    }

    public void setValue(Object object) {
        if (this._comboBox instanceof JComboBox) {
            ((JComboBox)this._comboBox).setSelectedItem(object);
        } else if (this._comboBox instanceof AbstractComboBox) {
            ((AbstractComboBox)this._comboBox).setSelectedItem(object);
        }
    }

    public String getValueInString() {
        return this.convertElementToString(this.getValue(), false);
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.filter.filterEditor", this.getLocale()).getString(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._comboBox != null) {
            this._comboBox.setEnabled(bl);
        }
    }
}

