/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.swing.JideSwingUtilities;

public class BetweenFilter<T>
extends AbstractFilter<T>
implements SqlFilterSupport {
    protected T _value1 = null;
    protected T _value2 = null;
    private static final long serialVersionUID = 9064088539548867200L;

    public BetweenFilter() {
    }

    public BetweenFilter(T t, T t2) {
        this(null, t, t2);
    }

    public BetweenFilter(String string, T t, T t2) {
        super(string);
        this._value1 = t;
        this._value2 = t2;
    }

    @Override
    public boolean isValueFiltered(T object) {
        if (this.getObjectGrouper() != null) {
            object = this.getObjectGrouper().getValue(object);
        }
        if (object == null) {
            return true;
        }
        if (object instanceof Number && this._value1 instanceof Number && this._value2 instanceof Number) {
            return ((Number)object).doubleValue() < ((Number)this._value1).doubleValue() || ((Number)object).doubleValue() > ((Number)this._value2).doubleValue();
        }
        if (object instanceof Comparable && this._value1 != null && this._value2 != null) {
            return ((Comparable)object).compareTo(this._value1) < 0 || ((Comparable)object).compareTo(this._value2) > 0;
        }
        if (this._value1 instanceof Comparable && this._value2 instanceof Comparable) {
            return ((Comparable)this._value1).compareTo(object) > 0 || ((Comparable)this._value2).compareTo(object) < 0;
        }
        return true;
    }

    @Override
    public String getOperator() {
        return " BETWEEN ";
    }

    public T getValue1() {
        return this._value1;
    }

    public void setValue1(T t) {
        this._value1 = t;
    }

    public T getValue2() {
        return this._value2;
    }

    public void setValue2(T t) {
        this._value2 = t;
    }

    @Override
    public boolean stricterThan(Filter filter) {
        if (this.getClass() != filter.getClass()) {
            return false;
        }
        T t = ((BetweenFilter)filter).getValue1();
        T t2 = ((BetweenFilter)filter).getValue2();
        if (t instanceof Number && this._value1 instanceof Number && t2 instanceof Number && this._value2 instanceof Number) {
            return ((Number)this._value1).doubleValue() >= ((Number)t).doubleValue() && ((Number)this._value2).doubleValue() <= ((Number)t2).doubleValue();
        }
        if (t instanceof Comparable && t2 instanceof Comparable && this._value1 != null && this._value2 != null) {
            return ((Comparable)t).compareTo(this._value1) <= 0 && ((Comparable)t2).compareTo(this._value2) >= 0;
        }
        if (this._value1 instanceof Comparable && this._value2 instanceof Comparable) {
            return ((Comparable)this._value1).compareTo(t) >= 0 && ((Comparable)this._value2).compareTo(t2) <= 0;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && JideSwingUtilities.equals(this.getValue1(), ((BetweenFilter)object).getValue1(), true) && JideSwingUtilities.equals(this.getValue2(), ((BetweenFilter)object).getValue2(), true);
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            clazz = objectGrouper.getType();
            converterContext = objectGrouper.getConverterContext();
        }
        String string = ObjectConverterManager.toString(this.getValue1(), clazz, converterContext) + "\t" + ObjectConverterManager.toString(this.getValue2(), clazz, converterContext);
        if (objectGrouper != null) {
            string = string + "\t" + objectGrouper.getName();
        }
        return string;
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        String[] stringArray = string.split("\t");
        this.setValue1(ObjectConverterManager.fromString(stringArray[0], clazz, converterContext));
        this.setValue2(ObjectConverterManager.fromString(stringArray[1], clazz, converterContext));
        if (stringArray.length >= 3) {
            this.setObjectGrouperName(stringArray[2]);
        }
        return new Object[]{this.getValue1(), this.getValue2()};
    }
}

