/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

public class IPTextField
extends JPanel {
    private JTextField[] _fields;
    private FocusListener _focusListener;
    private boolean _editable = true;
    private static final int MAX_IP_VALUE = 255;
    private int[] _subnetMask = new int[]{0, 0, 0, 0};
    public final String PROPERTY_SUBNET_MASK = "subnetMask";
    public final String PROPERTY_EDITABLE = "editable";
    private static int[] VALID_MASKS;
    protected transient ChangeEvent changeEvent = null;

    public IPTextField() {
        this.initComponents();
    }

    public IPTextField(String string) {
        this.initComponents();
        this.setText(string);
    }

    public IPTextField(int[] nArray) {
        this.initComponents();
        this.setValue(nArray);
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(true);
        this._focusListener = new TextFieldFocusListener();
        this._fields = new JTextField[4];
        JLabel[] jLabelArray = new JLabel[3];
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IPTextField.this.invalidate();
                IPTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IPTextField.this.invalidate();
                IPTextField.this.repaint();
            }
        };
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i] = this.createTextField(i == 0 ? null : this._fields[i - 1]);
            this.add(this._fields[i]);
            if (i != this._fields.length - 1) {
                jLabelArray[i] = this.createLabel();
                this.add(jLabelArray[i]);
            }
            this._fields[i].addFocusListener(focusListener);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                    for (JTextField jTextField : IPTextField.this._fields) {
                        jTextField.setEnabled(bl);
                    }
                    IPTextField.this.updateUI();
                } else if ("editable".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                    for (JTextField jTextField : IPTextField.this._fields) {
                        jTextField.setEditable(bl);
                    }
                    IPTextField.this.updateUI();
                } else if ("subnetMask".equals(propertyChangeEvent.getPropertyName())) {
                    int[] nArray = (int[])propertyChangeEvent.getNewValue();
                    int[] nArray2 = IPTextField.this.getValue();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray2[i] >= nArray[i]) continue;
                        IPTextField.this._fields[i].setText("" + nArray[i]);
                    }
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(this.isEnabled());
        jTextField.setEditable(this.isEditable());
        jTextField.updateUI();
        JideSwingUtilities.installColors(this, jTextField.getBackground(), jTextField.getForeground());
        JideSwingUtilities.installBorder(this, jTextField.getBorder());
    }

    public void setText(String string) {
        int[] nArray = IPTextField.convertStringToIP(string);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = this.getSubnetMask()[i];
            if (n < n2) {
                n = n2;
            }
            this._fields[i].setText("" + n);
        }
    }

    public String getText() {
        return IPTextField.convertIPToString(this.getValue());
    }

    public void setValue(int[] nArray) {
        this.setText(IPTextField.convertIPToString(nArray));
    }

    public int[] getValue() {
        String[] stringArray = this.getRawText();
        return IPTextField.convertStringToIP(stringArray);
    }

    public String[] getRawText() {
        String[] stringArray = new String[4];
        for (int i = 0; i < this._fields.length; ++i) {
            JTextField jTextField = this._fields[i];
            stringArray[i] = jTextField.getText().trim();
        }
        return stringArray;
    }

    public void setRawText(String[] stringArray) {
        for (int i = 0; i < this._fields.length; ++i) {
            JTextField jTextField = this._fields[i];
            if (i >= stringArray.length) continue;
            jTextField.setText(stringArray[i]);
        }
    }

    public boolean isValueValid() {
        String[] stringArray;
        for (String string : stringArray = this.getRawText()) {
            if (string == null || string.length() == 0) {
                return false;
            }
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    return false;
                }
                if (n <= 255) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public int[] getSubnetMask() {
        return this._subnetMask;
    }

    private boolean isValidMask(int n) {
        for (int n2 : VALID_MASKS) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public void setSubnetMask(int[] nArray) {
        if (nArray.length != 4) {
            throw new IllegalArgumentException("The subnetMask must have 4 octets.");
        }
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (!bl && n != 0) {
                throw new IllegalArgumentException("The subnetMask's " + IPTextField.getOrdinalValue(i + 1) + " mask " + n + " is not allowed at this position. Only zero is allowed here in order to make a valid subnet mask.");
            }
            if (!this.isValidMask(n)) {
                throw new IllegalArgumentException("The subnetMask's " + IPTextField.getOrdinalValue(i + 1) + " mask " + n + " is not a valid subnet mask.");
            }
            if (n == 255 || !bl) continue;
            bl = false;
        }
        int[] nArray2 = this._subnetMask;
        this._subnetMask = nArray;
        this.firePropertyChange("subnetMask", nArray2, this._subnetMask);
    }

    public void setSubnetMask(String string) {
        this.setSubnetMask(IPTextField.convertStringToIP(string));
    }

    public static String convertIPToString(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The value passed in is null");
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(nArray[0] & 0xFF).append('.').append(nArray[1] & 0xFF).append('.').append(nArray[2] & 0xFF).append('.').append(nArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    public static int[] convertStringToIP(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The value passed in is null");
        }
        String[] stringArray = string.split("\\.");
        return IPTextField.convertStringToIP(stringArray);
    }

    private static int[] convertStringToIP(String[] stringArray) {
        int[] nArray = new int[4];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() == 0) {
                nArray[i] = 0;
                continue;
            }
            try {
                nArray[i] = IPTextField.parseOctet(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    private static int parseOctet(String string) throws NumberFormatException {
        int n = Integer.parseInt(string);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    @Override
    public void requestFocus() {
        JTextField jTextField = this.getFirstTextField();
        if (jTextField != null) {
            jTextField.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl) {
        JTextField jTextField = this.getFirstTextField();
        if (jTextField != null) {
            return jTextField.requestFocus(bl);
        }
        return super.requestFocus(bl);
    }

    @Override
    public boolean requestFocusInWindow() {
        JTextField jTextField = this.getFirstTextField();
        if (jTextField != null) {
            return jTextField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public boolean hasFocus() {
        for (JTextField jTextField : this._fields) {
            if (!jTextField.hasFocus()) continue;
            return true;
        }
        return false;
    }

    protected JTextField createTextField(JTextField jTextField) {
        IPDocument iPDocument = new IPDocument();
        JTextField jTextField2 = new JTextField(iPDocument, "", 3);
        jTextField2.setOpaque(false);
        jTextField2.addFocusListener(this._focusListener);
        jTextField2.setBorder(BorderFactory.createEmptyBorder());
        jTextField2.setHorizontalAlignment(0);
        if (jTextField != null) {
            ((IPDocument)jTextField.getDocument()).setNextTextField(jTextField2);
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IPTextField.this.fireStateChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IPTextField.this.fireStateChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jTextField2.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!IPTextField.this.isChild(focusEvent.getOppositeComponent())) {
                    IPTextField.this.fireFocusEvent(new FocusEvent(IPTextField.this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!IPTextField.this.isChild(focusEvent.getOppositeComponent())) {
                    IPTextField.this.fireFocusEvent(new FocusEvent(IPTextField.this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
                }
            }
        });
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(8, 0), new BackspaceAction());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(37, 0), new LeftAction());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(39, 0), new RightAction());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(36, 0), new HomeAction());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(35, 0), new EndAction());
        return jTextField2;
    }

    @Override
    public void setFocusable(boolean bl) {
        for (JTextField jTextField : this._fields) {
            jTextField.setFocusable(bl);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.listenerList.add(FocusListener.class, focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.listenerList.remove(FocusListener.class, focusListener);
    }

    @Override
    public FocusListener[] getFocusListeners() {
        return (FocusListener[])this.listenerList.getListeners(FocusListener.class);
    }

    private void fireFocusEvent(FocusEvent focusEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FocusListener.class) continue;
            if (focusEvent.getID() == 1004) {
                ((FocusListener)objectArray[i + 1]).focusGained(focusEvent);
                continue;
            }
            if (focusEvent.getID() != 1005) continue;
            ((FocusListener)objectArray[i + 1]).focusLost(focusEvent);
        }
    }

    private boolean isChild(Component component) {
        for (JTextField jTextField : this._fields) {
            if (component != jTextField) continue;
            return true;
        }
        return false;
    }

    private JLabel createLabel() {
        NullLabel nullLabel = new NullLabel(".");
        nullLabel.setCursor(Cursor.getPredefinedCursor(2));
        return nullLabel;
    }

    private void insertStringToTextField(String string, JTextField jTextField) {
        if (jTextField == null) {
            return;
        }
        jTextField.requestFocus();
        Document document = jTextField.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, new SimpleAttributeSet());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean selectNextTextField() {
        JTextField jTextField = this.getNextTextField();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        return false;
    }

    private boolean selectFirstTextField() {
        JTextField jTextField = this.getFirstTextField();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean selectLastTextField() {
        JTextField jTextField = this.getLastTextField();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        jTextField.setCaretPosition(jTextField.getText().length());
        return true;
    }

    private JTextField getNextTextField() {
        for (int i = 0; i < this._fields.length; ++i) {
            JTextField jTextField = this._fields[i];
            if (!jTextField.hasFocus() || i == this._fields.length - 1) continue;
            return this._fields[i + 1];
        }
        return null;
    }

    private JTextField getFirstTextField() {
        for (JTextField jTextField : this._fields) {
            if (!jTextField.isEditable()) continue;
            return jTextField;
        }
        return null;
    }

    private JTextField getLastTextField() {
        for (int i = this._fields.length - 1; i >= 0; --i) {
            JTextField jTextField = this._fields[i];
            if (!jTextField.isEditable()) continue;
            return this._fields[i];
        }
        return null;
    }

    private int getTextFieldIndex(JTextField jTextField) {
        for (int i = 0; i < this._fields.length; ++i) {
            if (jTextField != this._fields[i]) continue;
            return i;
        }
        return -1;
    }

    protected boolean isNavigateToNextField(char c) {
        return c == '.' || c == ' ';
    }

    private boolean selectPreviousTextField() {
        JTextField jTextField = this.getPreviousTextField();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        return true;
    }

    private JTextField getPreviousTextField() {
        for (int i = this._fields.length - 1; i >= 0; --i) {
            JTextField jTextField = this._fields[i];
            if (!jTextField.hasFocus() || i <= 0) continue;
            return this._fields[i - 1];
        }
        return null;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        if (bl != this._editable) {
            boolean bl2 = this._editable;
            this._editable = bl;
            this.firePropertyChange("editable", bl2, this._editable);
            this.repaint();
        }
    }

    public JTextField[] getTextFields() {
        return this._fields;
    }

    private static String getOrdinalValue(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "first";
                break;
            }
            case 2: {
                string = "second";
                break;
            }
            case 3: {
                string = "third";
                break;
            }
            case 4: {
                string = "fourth";
            }
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public int getBaseline(int n, int n2) {
        if (SystemInfo.isJdk6Above()) {
            try {
                Method method = Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                Object object = method.invoke((Object)this._fields[0], n, n2);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setToolTipText(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < this.getComponents().length; ++i) {
            if (!(this.getComponents()[i] instanceof JComponent) || stringArray.length <= i) continue;
            ((JComponent)this.getComponents()[i]).setToolTipText(stringArray[i]);
        }
    }

    public void setToolTipText(String string, boolean bl) {
        if (bl) {
            String[] stringArray = new String[this.getComponents().length];
            Array.set(stringArray, 0, string);
            this.setToolTipText(stringArray);
        }
        super.setToolTipText(string);
    }

    @Override
    public void setToolTipText(String string) {
        this.setToolTipText(string, false);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(IPTextField.class.getName(), 4);
        }
        VALID_MASKS = new int[]{0, 128, 192, 224, 40, 248, 252, 254, 255};
    }

    private class EndAction
    extends DelegateAction {
        private static final long serialVersionUID = -5874470980014354322L;

        private EndAction() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == jTextField.getText().length() && IPTextField.this.selectLastTextField();
        }
    }

    private class HomeAction
    extends DelegateAction {
        private static final long serialVersionUID = 3432124570246941890L;

        private HomeAction() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == 0 && IPTextField.this.selectFirstTextField();
        }
    }

    private class RightAction
    extends DelegateAction {
        private static final long serialVersionUID = -6293248156577014686L;

        private RightAction() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == jTextField.getText().length() && IPTextField.this.selectNextTextField();
        }
    }

    private class LeftAction
    extends DelegateAction {
        private static final long serialVersionUID = -991378279249093542L;

        private LeftAction() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == 0 && IPTextField.this.selectPreviousTextField();
        }
    }

    private class BackspaceAction
    extends DelegateAction {
        private static final long serialVersionUID = -6915803736210830681L;

        private BackspaceAction() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getText().length() == 0 && IPTextField.this.selectPreviousTextField();
        }
    }

    private class IPDocument
    extends PlainDocument {
        protected JTextField nextTextField;
        private static final long serialVersionUID = -6916157796691243768L;

        IPDocument() {
        }

        public void setNextTextField(JTextField jTextField) {
            this.nextTextField = jTextField;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            if (string == null) {
                return;
            }
            int n3 = 3 - this.getLength();
            if (n3 == 0) {
                IPTextField.this.insertStringToTextField(string, this.nextTextField);
                return;
            }
            char[] cArray = new char[n3];
            int n4 = 0;
            int n5 = string.length();
            boolean bl = false;
            for (n2 = 0; n2 < n5; ++n2) {
                char c = string.charAt(n2);
                if (Character.isDigit(c)) {
                    cArray[n4] = c;
                    if (++n4 != n3) continue;
                    break;
                }
                if (!IPTextField.this.isNavigateToNextField(c) || Math.max(n, n4) <= 0) continue;
                bl = true;
                break;
            }
            super.insertString(n, new String(cArray, 0, n4), attributeSet);
            if (bl || n + n4 == 3) {
                if (n2 + 1 < n5) {
                    IPTextField.this.insertStringToTextField(string.substring(n2 + 1), this.nextTextField);
                } else {
                    IPTextField.this.selectNextTextField();
                }
            }
        }
    }

    private class TextFieldFocusListener
    extends FocusAdapter {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string;
            if (focusEvent.isTemporary()) {
                return;
            }
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string2 = jTextField.getText();
            if (string2.length() == 0) {
                return;
            }
            int n = 0;
            try {
                n = IPTextField.parseOctet(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = IPTextField.this.getTextFieldIndex(jTextField);
            if (n2 != -1 && n < IPTextField.this.getSubnetMask()[n2]) {
                n = IPTextField.this.getSubnetMask()[n2];
            }
            if (!(string = "" + n).equals(jTextField.getText())) {
                jTextField.setText(string);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.selectAll();
        }
    }
}

