/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.margin.LineMarginPainter;
import com.jidesoft.margin.AbstractRowMargin;
import com.jidesoft.margin.RowMarginPainter;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

public abstract class AbstractLineMargin
extends AbstractRowMargin
implements MouseListener,
MouseMotionListener {
    protected CodeEditor _editor;
    private int _mouseDragStartLine = -1;
    private int _ctrlStartLine = -1;

    public AbstractLineMargin(CodeEditor codeEditor) {
        super(new CodeEditorRowMarginSupport(codeEditor));
        this._editor = codeEditor;
    }

    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    public void addLineMarginPainter(LineMarginPainter lineMarginPainter) {
        this.addRowMarginPainter(lineMarginPainter);
    }

    public void removeLineMarginPainter(LineMarginPainter lineMarginPainter) {
        this.removeRowMarginPainter(lineMarginPainter);
    }

    protected List<RowMarginPainter> getLineMarginPainters() {
        return this.getRowMarginPainters();
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n) {
        this.paintLineMargin(graphics, rectangle, n);
    }

    public abstract void paintLineMargin(Graphics var1, Rectangle var2, int var3);

    @Override
    public abstract String getToolTipText(int var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = this._editor.getPainter().getLineHeight();
        int n3 = mouseEvent.getPoint().y / n2;
        int n4 = n3 + (n = this._editor.getFirstLine());
        if (n4 < 0 || n3 >= this._editor.getVisibleLines()) {
            return;
        }
        if ((mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
            this._ctrlStartLine = n4;
        } else if (this._ctrlStartLine >= 0 && (mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) != 0) {
            int n5 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n4, this._ctrlStartLine), 0)));
            int n6 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n4, this._ctrlStartLine) + 1));
            this._editor.select(n5, n6);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this._editor.getPainter().getLineHeight();
        int n2 = this._editor.getFirstLine();
        int n3 = mouseEvent.getPoint().y / n;
        this._mouseDragStartLine = n3 + n2;
        ((RowMarginSupport)this._marginSupport).scrollTo(this._mouseDragStartLine, this._mouseDragStartLine, this.isClickToSelect());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._mouseDragStartLine = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._mouseDragStartLine < 0) {
            return;
        }
        this._ctrlStartLine = -1;
        int n = this._editor.getPainter().getLineHeight();
        int n2 = this._editor.getFirstLine();
        int n3 = mouseEvent.getPoint().y / n;
        int n4 = n3 + n2;
        int n5 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n4, this._mouseDragStartLine), 0)));
        int n6 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n4, this._mouseDragStartLine + 1)));
        this._editor.select(n5, n6);
        if (n3 <= 0) {
            this._editor.setFirstLine(Math.max(0, n2 + n3 - 1));
        } else if (n3 > this._editor.getVisibleLines() - 1) {
            this._editor.setFirstLine(Math.min(this._editor.getVisualLineCount(), n4 - this._editor.getVisibleLines() + 1));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

