/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.action;

import com.jidesoft.editor.AbstractCodeEditorIntelliHints;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public abstract class InputHandler
extends KeyAdapter {
    public static final Action BACKSPACE = new backspace();
    public static final Action BACKSPACE_WORD = new backspace_word();
    public static final Action DELETE = new delete();
    public static final Action DELETE_WORD = new delete_word();
    public static final Action DELETE_LINE = new delete_line();
    public static final Action INSERT_BREAK = new insert_break();
    public static final Action SPLIT_LINE = new split_line();
    public static final Action START_NEW_LINE = new start_new_line();
    public static final Action INDENT_SELECTION = new indent_selection();
    public static final Action UNINDENT_SELECTION = new unindent_selection();
    public static final Action JOIN_LINES = new join_lines();
    public static final Action END = new end(false);
    public static final Action DOCUMENT_END = new document_end(false);
    public static final Action SELECT_ALL = new select_all();
    public static final Action SELECT_END = new end(true);
    public static final Action SELECT_DOC_END = new document_end(true);
    public static final Action HOME = new home(false);
    public static final Action DOCUMENT_HOME = new document_home(false);
    public static final Action SELECT_HOME = new home(true);
    public static final Action SELECT_DOC_HOME = new document_home(true);
    public static final Action NEXT_CHAR = new next_char(false);
    public static final Action NEXT_LINE = new next_line(false);
    public static final Action NEXT_PAGE = new next_page(false);
    public static final Action NEXT_WORD = new next_word(false);
    public static final Action SELECT_NEXT_CHAR = new next_char(true);
    public static final Action SELECT_NEXT_LINE = new next_line(true);
    public static final Action SELECT_NEXT_PAGE = new next_page(true);
    public static final Action SELECT_NEXT_WORD = new next_word(true);
    public static final Action OVERWRITE = new overwrite();
    public static final Action PREV_CHAR = new prev_char(false);
    public static final Action PREV_LINE = new prev_line(false);
    public static final Action PREV_PAGE = new prev_page(false);
    public static final Action PREV_WORD = new prev_word(false);
    public static final Action GOTO_LINE = new goto_line();
    public static final Action FIND = new find();
    public static final Action FIND_NEXT = new find_next();
    public static final Action FIND_PREVIOUS = new find_previous();
    public static final Action REPLACE = new replace();
    public static final Action QUICK_SEARCH = new quick_search();
    public static final Action SELECT_PREV_CHAR = new prev_char(true);
    public static final Action SELECT_PREV_LINE = new prev_line(true);
    public static final Action SELECT_PREV_PAGE = new prev_page(true);
    public static final Action SELECT_PREV_WORD = new prev_word(true);
    public static final Action SELECT_WORD = new select_word();
    public static final Action SELECT_TO_MATCHING_BRACKET = new select_to_matching_bracket();
    public static final Action REPEAT = new repeat();
    public static final Action TOGGLE_RECT = new toggle_rect();
    public static final Action DUPLICATE_SELECTION = new duplicate_selection();
    public static final Action LINE_COMMENTS = new line_comments();
    public static final Action BLOCK_COMMENTS = new block_comments();
    public static final Action CLIP_COPY = new clip_copy();
    public static final Action CLIP_PASTE = new clip_paste();
    public static final Action CLIP_PASTE_WITH_DIALOG = new clip_paste_with_dialog();
    public static final Action CLIP_CUT = new clip_cut();
    public static final Action UNDO = new undo();
    public static final Action REDO = new redo();
    public static final Action FOLD_SELECTION = new toggle_fold_selection();
    public static final Action EXPAND_FOLDING = new expand_folding();
    public static final Action COLLAPSE_FOLDING = new collapse_folding();
    public static final Action EXPAND_ALL = new expand_all();
    public static final Action COLLAPSE_ALL = new collapse_all();
    public static final Action INSERT_CHAR = new insert_char();
    public static final Action TOGGLE_CASE = new toggle_case();
    public static final Action ESCAPE = new escape();
    protected static final Hashtable<String, Action> ACTIONS = new Hashtable();
    private Timer _restartCaretBlinkTimer;
    protected Action _grabAction;
    protected boolean _repeat;
    protected int _repeatCount;
    protected MacroRecorder recorder;

    protected static void initDefaultActions() {
        ACTIONS.put("Backspace", BACKSPACE);
        ACTIONS.put("Delete to Word Start", BACKSPACE_WORD);
        ACTIONS.put("Delete", DELETE);
        ACTIONS.put("Delete to Word End", DELETE_WORD);
        ACTIONS.put("Delete Current Line", DELETE_LINE);
        ACTIONS.put("Insert Line Break", INSERT_BREAK);
        ACTIONS.put("Split Line", SPLIT_LINE);
        ACTIONS.put("Start New Line", START_NEW_LINE);
        ACTIONS.put("Indent Selection", INDENT_SELECTION);
        ACTIONS.put("Unindent Selection", UNINDENT_SELECTION);
        ACTIONS.put("Join Lines", JOIN_LINES);
        ACTIONS.put("Toggle Insert/Overwrite", OVERWRITE);
        ACTIONS.put("Toggle Rectangular Selection", TOGGLE_RECT);
        ACTIONS.put("Move Caret to Line Start", HOME);
        ACTIONS.put("Move Caret to Line End", END);
        ACTIONS.put("Select All", SELECT_ALL);
        ACTIONS.put("Select to Line Start", SELECT_HOME);
        ACTIONS.put("Select to Line End", SELECT_END);
        ACTIONS.put("Move Caret to Document Start", DOCUMENT_HOME);
        ACTIONS.put("Move Caret to Document End", DOCUMENT_END);
        ACTIONS.put("Select to Document Start", SELECT_DOC_HOME);
        ACTIONS.put("Select to Document End", SELECT_DOC_END);
        ACTIONS.put("Page Up", PREV_PAGE);
        ACTIONS.put("Page Down", NEXT_PAGE);
        ACTIONS.put("Select to Previous Page", SELECT_PREV_PAGE);
        ACTIONS.put("Select to Next Page", SELECT_NEXT_PAGE);
        ACTIONS.put("Move Caret to Previous Char", PREV_CHAR);
        ACTIONS.put("Select Previous Char", SELECT_PREV_CHAR);
        ACTIONS.put("Move Caret to Previous Word", PREV_WORD);
        ACTIONS.put("Select Previous Word", SELECT_PREV_WORD);
        ACTIONS.put("Move Caret to Next Char", NEXT_CHAR);
        ACTIONS.put("Select Next Char", SELECT_NEXT_CHAR);
        ACTIONS.put("Move Caret to Next Word", NEXT_WORD);
        ACTIONS.put("Select Next Word", SELECT_NEXT_WORD);
        ACTIONS.put("Move Caret to Previous Line", PREV_LINE);
        ACTIONS.put("Select Previous Line", SELECT_PREV_LINE);
        ACTIONS.put("Move Caret to Next Line", NEXT_LINE);
        ACTIONS.put("Select Next Line", SELECT_NEXT_LINE);
        ACTIONS.put("Goto Line", GOTO_LINE);
        ACTIONS.put("Select Word at Caret", SELECT_WORD);
        ACTIONS.put("Select to Matching Bracket", SELECT_TO_MATCHING_BRACKET);
        ACTIONS.put("Duplication Selection", DUPLICATE_SELECTION);
        ACTIONS.put("Line Comments", LINE_COMMENTS);
        ACTIONS.put("Block Comments", BLOCK_COMMENTS);
        ACTIONS.put("Undo", UNDO);
        ACTIONS.put("Redo", REDO);
        ACTIONS.put("Clipboard Copy", CLIP_COPY);
        ACTIONS.put("Clipboard Paste", CLIP_PASTE);
        ACTIONS.put("Clipboard Paste with Dialog", CLIP_PASTE_WITH_DIALOG);
        ACTIONS.put("Clipboard Cut", CLIP_CUT);
        ACTIONS.put("Find", FIND);
        ACTIONS.put("Find Next Occurrence", FIND_NEXT);
        ACTIONS.put("Find Previous Occurrence", FIND_PREVIOUS);
        ACTIONS.put("Replace", REPLACE);
        ACTIONS.put("Quick Search", QUICK_SEARCH);
        ACTIONS.put("Repeat", REPEAT);
        ACTIONS.put("Toggle Case", TOGGLE_CASE);
        ACTIONS.put("Fold Selection", FOLD_SELECTION);
        ACTIONS.put("Expand Folding", EXPAND_FOLDING);
        ACTIONS.put("Collapse Folding", COLLAPSE_FOLDING);
        ACTIONS.put("Expand All", EXPAND_ALL);
        ACTIONS.put("Collapse All", COLLAPSE_ALL);
        ACTIONS.put("Escape", ESCAPE);
    }

    public static void addAction(String string, Action action) {
        ACTIONS.put(string, action);
    }

    public static void addAction(Action action) {
        ACTIONS.put((String)action.getValue("Name"), action);
    }

    public static void removeAction(String string) {
        ACTIONS.remove(string);
    }

    public static Action getAction(String string) {
        return ACTIONS.get(string);
    }

    public static String getActionName(ActionListener actionListener) {
        Enumeration<String> enumeration = InputHandler.getActions();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (InputHandler.getAction(string) != actionListener) continue;
            return string;
        }
        return null;
    }

    public static Enumeration<String> getActions() {
        return ACTIONS.keys();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 17 || n == 16 || n == 18 || n == 157) {
            return;
        }
        if ((n2 & 0xFFFFFFFE) != 0 || keyEvent.isActionKey() || n == 8 || n == 127 || n == 10 || n == 9 || n == 27) {
            KeyStroke[] keyStrokeArray;
            Object object;
            if (this._grabAction != null && Character.isLetterOrDigit(keyEvent.getKeyChar())) {
                this.handleGrabAction(keyEvent);
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
            if (keyEvent.getSource() instanceof CodeEditor && (object = ((CodeEditor)keyEvent.getSource()).getClientProperty("INTELLI_HINTS")) instanceof AbstractCodeEditorIntelliHints && ((AbstractCodeEditorIntelliHints)object).isHintsPopupVisible()) {
                for (KeyStroke keyStroke2 : keyStrokeArray = ((AbstractCodeEditorIntelliHints)object).getDelegateKeyStrokes()) {
                    if (!keyStroke.equals(keyStroke2)) continue;
                    return;
                }
            }
            if ((object = this.findAction(keyStroke)) instanceof Action) {
                keyStrokeArray = keyEvent.getSource();
                this.pauseBlinksIfNecessary(keyStrokeArray);
                if (this.executeAction((Action)object, keyStrokeArray, null)) {
                    keyEvent.consume();
                }
            }
        }
    }

    private void pauseBlinksIfNecessary(Object object) {
        if (object instanceof CodeEditor && ((CodeEditor)object).isCaretBlinks()) {
            final CodeEditor codeEditor = (CodeEditor)object;
            if (this._restartCaretBlinkTimer == null) {
                this._restartCaretBlinkTimer = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        codeEditor.blinkCaret();
                        InputHandler.this._restartCaretBlinkTimer.stop();
                    }
                });
            }
            if (!codeEditor.isBlink()) {
                codeEditor.pauseBlink();
            }
            if (this._restartCaretBlinkTimer.isRunning()) {
                this._restartCaretBlinkTimer.restart();
            } else {
                this._restartCaretBlinkTimer.start();
            }
        }
    }

    private static boolean isTypedEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        if (c == '\uffff') {
            return false;
        }
        int n = keyEvent.getModifiers();
        if (SystemInfo.isAnyMac()) {
            return !keyEvent.isMetaDown() && !keyEvent.isControlDown();
        }
        return (n & 8) == (n & 2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, n);
        if (this.findAction(keyStroke) instanceof Action) {
            return;
        }
        if (InputHandler.isTypedEvent(keyEvent)) {
            this.pauseBlinksIfNecessary(keyEvent.getSource());
            char c = keyEvent.getKeyChar();
            if (this._grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            if (this._repeat && Character.isDigit(c)) {
                this._repeatCount *= 10;
                this._repeatCount += c - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, keyEvent.getSource(), String.valueOf(c));
            keyEvent.consume();
            this._repeatCount = 0;
            this._repeat = false;
        }
    }

    public abstract Object findAction(KeyStroke var1);

    public void grabNextKeyStroke(Action action) {
        this._grabAction = action;
    }

    public boolean isRepeatEnabled() {
        return this._repeat;
    }

    public void setRepeatEnabled(boolean bl) {
        this._repeat = bl;
    }

    public int getRepeatCount() {
        return this._repeat ? Math.max(1, this._repeatCount) : 1;
    }

    public void setRepeatCount(int n) {
        this._repeatCount = n;
    }

    public MacroRecorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(MacroRecorder macroRecorder) {
        this.recorder = macroRecorder;
    }

    public boolean executeAction(Action action, Object object, String string) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, string);
        if (action instanceof Wrapper && action.isEnabled()) {
            action.actionPerformed(actionEvent);
            return true;
        }
        boolean bl = this._repeat;
        if (action.isEnabled()) {
            if (action instanceof NonRepeatable) {
                action.actionPerformed(actionEvent);
            } else {
                for (int i = 0; i < Math.max(1, this._repeatCount); ++i) {
                    action.actionPerformed(actionEvent);
                }
            }
            if (this._grabAction == null) {
                if (this.recorder != null && !(action instanceof NonRecordable)) {
                    if (this._repeatCount != 1) {
                        this.recorder.actionPerformed(REPEAT, String.valueOf(this._repeatCount));
                    }
                    this.recorder.actionPerformed(action, string);
                }
                if (bl) {
                    this._repeat = false;
                    this._repeatCount = 0;
                }
            }
            return true;
        }
        return false;
    }

    public static CodeEditor getCodeEditor(EventObject eventObject) {
        Object object;
        if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
            Component component = (Component)object;
            while (true) {
                if (component instanceof CodeEditor) {
                    return (CodeEditor)component;
                }
                if (component == null) break;
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                    continue;
                }
                component = component.getParent();
            }
        }
        return null;
    }

    protected void handleGrabAction(KeyEvent keyEvent) {
        Action action = this._grabAction;
        this._grabAction = null;
        this.executeAction(action, keyEvent.getSource(), String.valueOf(keyEvent.getKeyChar()));
    }

    public String modifySelectionOnPaste(CodeEditor codeEditor, String string) {
        return string;
    }

    static {
        InputHandler.initDefaultActions();
    }

    private static class escape
    extends AbstractAction {
        private static final long serialVersionUID = -3839572006439644976L;

        private escape() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.escape();
        }
    }

    private static class toggle_case
    extends AbstractAction {
        private static final long serialVersionUID = -6537223538277293505L;

        private toggle_case() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleCase();
        }
    }

    private static class clip_cut
    extends AbstractAction {
        private static final long serialVersionUID = 2066986637759826811L;

        private clip_cut() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardCut();
        }
    }

    private static class clip_paste_with_dialog
    extends AbstractAction {
        private static final long serialVersionUID = 7351098860475703330L;

        private clip_paste_with_dialog() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.pasteWithDialog();
        }
    }

    private static class clip_paste
    extends AbstractAction {
        private static final long serialVersionUID = -751945309305263439L;

        private clip_paste() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardPaste();
        }
    }

    private static class clip_copy
    extends AbstractAction {
        private static final long serialVersionUID = 3315719351834564639L;

        private clip_copy() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardCopy();
        }
    }

    private static class insert_char
    extends AbstractAction
    implements NonRepeatable {
        private static final long serialVersionUID = -4569943151991610879L;

        private insert_char() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.insertChar(actionEvent.getActionCommand());
        }
    }

    private static class toggle_rect
    extends AbstractAction {
        private static final long serialVersionUID = -4097666487197541198L;

        private toggle_rect() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.getSelectionModel().setColumnSelectionMode(!codeEditor.getSelectionModel().isColumnSelectionMode());
        }
    }

    private static class goto_line
    extends AbstractAction {
        private static final long serialVersionUID = 3603408608295441876L;

        private goto_line() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.promptGotoLine();
        }
    }

    private static class repeat
    extends AbstractAction
    implements NonRecordable {
        private static final long serialVersionUID = 8715415707313946726L;

        private repeat() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.getInputHandler().setRepeatEnabled(true);
            String string = actionEvent.getActionCommand();
            if (string != null) {
                codeEditor.getInputHandler().setRepeatCount(Integer.parseInt(string));
            }
        }
    }

    private static class prev_word
    extends AbstractAction {
        private static final long serialVersionUID = -9184205017653379297L;
        private boolean select;

        public prev_word(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousWord(this.select);
        }
    }

    private static class prev_page
    extends AbstractAction {
        private static final long serialVersionUID = -1533953981392173385L;
        private boolean select;

        public prev_page(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousPage(this.select);
        }
    }

    private static class prev_line
    extends AbstractAction {
        private static final long serialVersionUID = 6816671179977654401L;
        private boolean select;

        public prev_line(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousLine(this.select);
        }
    }

    private static class prev_char
    extends AbstractAction {
        private static final long serialVersionUID = -4330484536395807904L;
        private boolean select;

        public prev_char(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousChar(this.select);
        }
    }

    private static class overwrite
    extends AbstractAction {
        private static final long serialVersionUID = 106897582803720514L;

        private overwrite() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleOverwrite();
        }
    }

    private static class next_word
    extends AbstractAction {
        private static final long serialVersionUID = -4198893112910778574L;
        private boolean select;

        public next_word(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextWord(this.select);
        }
    }

    private static class next_page
    extends AbstractAction {
        private static final long serialVersionUID = 3451566357915929033L;
        private boolean select;

        public next_page(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextPage(this.select);
        }
    }

    private static class next_line
    extends AbstractAction {
        private static final long serialVersionUID = 5906317859564151021L;
        private boolean select;

        public next_line(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextLine(this.select);
        }
    }

    private static class next_char
    extends AbstractAction {
        private static final long serialVersionUID = 13931417876929457L;
        private boolean select;

        public next_char(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextChar(this.select);
        }
    }

    private static class join_lines
    extends AbstractAction {
        private static final long serialVersionUID = -4029121321542759272L;

        private join_lines() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.joinLines();
        }
    }

    private static class unindent_selection
    extends AbstractAction {
        private static final long serialVersionUID = 8672968964589483207L;

        private unindent_selection() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.unindentSelection();
        }
    }

    private static class indent_selection
    extends AbstractAction {
        private static final long serialVersionUID = -3610821933550251237L;

        private indent_selection() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.indentSelection();
        }
    }

    private static class start_new_line
    extends AbstractAction {
        private static final long serialVersionUID = 3075515863437400165L;

        private start_new_line() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.startNewLine();
        }
    }

    private static class split_line
    extends AbstractAction {
        private static final long serialVersionUID = -7993210792538806158L;

        private split_line() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.splitLine();
        }
    }

    private static class insert_break
    extends AbstractAction {
        private static final long serialVersionUID = 2659131234173420341L;

        private insert_break() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.insertBreak();
        }
    }

    private static class document_home
    extends AbstractAction {
        private static final long serialVersionUID = -7726789645952689118L;
        private boolean select;

        public document_home(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToDocumentStart(this.select);
        }
    }

    private static class home
    extends AbstractAction {
        private static final long serialVersionUID = -5435672931188118039L;
        private boolean select;

        public home(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToLineStart(this.select);
        }
    }

    private static class document_end
    extends AbstractAction {
        private static final long serialVersionUID = -419496336497298905L;
        private boolean select;

        public document_end(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToDocumentEnd(this.select);
        }
    }

    private static class select_all
    extends AbstractAction {
        private static final long serialVersionUID = -2290680954398938706L;

        private select_all() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectAll();
        }
    }

    private static class end
    extends AbstractAction {
        private static final long serialVersionUID = -2618107777905306084L;
        private boolean select;

        public end(boolean bl) {
            this.select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToLineEnd(this.select);
        }
    }

    private static class delete_line
    extends AbstractAction {
        private static final long serialVersionUID = 7380920441924080889L;

        private delete_line() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteLine();
        }
    }

    private static class delete_word
    extends AbstractAction {
        private static final long serialVersionUID = -3073513876860168928L;

        private delete_word() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteWord();
        }
    }

    private static class delete
    extends AbstractAction {
        private static final long serialVersionUID = -9128330564099572892L;

        private delete() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteChar();
        }
    }

    private static class backspace_word
    extends AbstractAction {
        private static final long serialVersionUID = -12801451070031414L;

        private backspace_word() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.backspaceWord();
        }
    }

    private static class backspace
    extends AbstractAction {
        private static final long serialVersionUID = 2195300881172488912L;

        private backspace() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.backspaceChar();
        }
    }

    private static class replace
    extends AbstractAction {
        private static final long serialVersionUID = 216898672835723434L;

        private replace() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.replace();
        }
    }

    private static class find_previous
    extends AbstractAction {
        private static final long serialVersionUID = -4766805698324327183L;

        private find_previous() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.findPrevious();
        }
    }

    private static class find_next
    extends AbstractAction {
        private static final long serialVersionUID = -7900051882199803626L;

        private find_next() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.findNext();
        }
    }

    private static class find
    extends AbstractAction {
        private static final long serialVersionUID = 1344247353550639817L;

        private find() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.find();
        }
    }

    private static class quick_search
    extends AbstractAction {
        private static final long serialVersionUID = -6127293275004484560L;

        private quick_search() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.quickSearch("");
        }
    }

    private static class collapse_all
    extends AbstractAction {
        private static final long serialVersionUID = 6191068347139580160L;

        private collapse_all() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.collapseAll();
        }
    }

    private static class expand_all
    extends AbstractAction {
        private static final long serialVersionUID = 4395096353332537768L;

        private expand_all() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.expandAll();
        }
    }

    private static class collapse_folding
    extends AbstractAction {
        private static final long serialVersionUID = -4608093736925088489L;

        private collapse_folding() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.collapseFolding();
        }
    }

    private static class expand_folding
    extends AbstractAction {
        private static final long serialVersionUID = 7577956763623513443L;

        private expand_folding() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.expandFolding();
        }
    }

    private static class toggle_fold_selection
    extends AbstractAction {
        private static final long serialVersionUID = -7372541634524818440L;

        private toggle_fold_selection() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleFoldingSelection();
        }
    }

    private static class redo
    extends AbstractAction {
        private static final long serialVersionUID = -5288367014731605865L;

        private redo() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.redo();
        }
    }

    private static class undo
    extends AbstractAction {
        private static final long serialVersionUID = 437742589395720859L;

        private undo() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.undo();
        }
    }

    private static class select_to_matching_bracket
    extends AbstractAction {
        private static final long serialVersionUID = 7865726044327253386L;

        private select_to_matching_bracket() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectToMatchingBracket();
        }
    }

    private static class select_word
    extends AbstractAction {
        private static final long serialVersionUID = 1430066044262675939L;

        private select_word() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectWord();
        }
    }

    private static class block_comments
    extends AbstractAction {
        private static final long serialVersionUID = -7165863513036379748L;

        private block_comments() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.blockComments();
        }
    }

    private static class line_comments
    extends AbstractAction {
        private static final long serialVersionUID = -2561877503395933792L;

        private line_comments() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.lineComments();
        }
    }

    private static class duplicate_selection
    extends AbstractAction {
        private static final long serialVersionUID = 8566372647867701881L;

        private duplicate_selection() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.duplicateSelection();
        }
    }

    public static interface MacroRecorder {
        public void actionPerformed(Action var1, String var2);
    }

    public static interface Wrapper {
    }

    public static interface NonRecordable {
    }

    public static interface NonRepeatable {
    }
}

