/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextUtils {
    private static final int WHITESPACE = 0;
    private static final int WORD_CHAR = 1;
    private static final int SYMBOL = 2;

    public static int findPreviousOpenBracket(Document document, int n) throws BadLocationException {
        if (document.getLength() == 0) {
            return -1;
        }
        String string = document.getText(0, n);
        for (int i = n - 1; i >= 0; --i) {
            switch (string.charAt(i)) {
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static int findMatchingBracket(Document document, int n) throws BadLocationException {
        if (document.getLength() == 0) {
            return -1;
        }
        if (n >= document.getLength()) {
            return -1;
        }
        if (document instanceof LazyLoadDocument && !((LazyLoadDocument)document).isOffsetLoaded(n)) {
            return -1;
        }
        char c = '\u0000';
        if (n >= 0 && n < document.getLength()) {
            String string = document.getText(n, 1);
            c = string.length() > 0 ? (char)string.charAt(0) : (char)'\u0000';
        }
        char c2 = '\u0000';
        if (n + 1 < document.getLength()) {
            String string = document.getText(n + 1, 1);
            c2 = string.length() > 0 ? (char)string.charAt(0) : (char)'\u0000';
        }
        char c3 = '\u0000';
        boolean bl = false;
        switch (c) {
            case ')': {
                c3 = '(';
                bl = true;
                break;
            }
            case ']': {
                c3 = '[';
                bl = true;
                break;
            }
            case '}': {
                c3 = '{';
                bl = true;
            }
        }
        if (c3 == '\u0000') {
            ++n;
            switch (c2) {
                case '(': {
                    c3 = ')';
                    bl = false;
                    break;
                }
                case '[': {
                    c3 = ']';
                    bl = false;
                    break;
                }
                case '{': {
                    c3 = '}';
                    bl = false;
                    break;
                }
                default: {
                    return -1;
                }
            }
            c = c2;
        }
        if (document instanceof SyntaxDocument && ((SyntaxDocument)document).isInCommentOrLiteral(n)) {
            return -1;
        }
        if (!(document instanceof SyntaxDocument)) {
            if (bl) {
                int n2 = 1;
                String string = document.getText(0, n);
                for (int i = n - 1; i >= 0; --i) {
                    char c4 = string.charAt(i);
                    if (c4 == c) {
                        ++n2;
                        continue;
                    }
                    if (c4 != c3 || --n2 != 0) continue;
                    return i;
                }
            } else {
                int n3 = 1;
                int n4 = document.getLength() - ++n;
                String string = document.getText(n, n4);
                for (int i = 0; i < n4; ++i) {
                    char c5 = string.charAt(i);
                    int n5 = i + n;
                    if (c5 == c) {
                        ++n3;
                        continue;
                    }
                    if (c5 != c3 || --n3 != 0) continue;
                    return n5;
                }
            }
        } else {
            String[] stringArray = new String[]{"" + c, "" + c3};
            int n6 = 1;
            int n7 = n;
            if (bl) {
                while (n7 >= 0 && (n7 = ((SyntaxDocument)document).findPrevious(stringArray, n7, 0, true, false, false)) >= 0 && n7 < document.getLength()) {
                    char c6 = document.getText(n7, 1).charAt(0);
                    if (c6 == c) {
                        if (((SyntaxDocument)document).isInCommentOrLiteral(n7)) continue;
                        ++n6;
                        continue;
                    }
                    if (c6 != c3 || ((SyntaxDocument)document).isInCommentOrLiteral(n7) || --n6 != 0) continue;
                    return n7;
                }
            } else {
                while (n7 >= 0 && n7 < document.getLength() && (n7 = ((SyntaxDocument)document).findNext(stringArray, n7 + 1, document.getLength(), true, false, false)) >= 0 && n7 < document.getLength()) {
                    char c7 = document.getText(n7, 1).charAt(0);
                    if (c7 == c) {
                        if (((SyntaxDocument)document).isInCommentOrLiteral(n7)) continue;
                        ++n6;
                        continue;
                    }
                    if (c7 != c3 || ((SyntaxDocument)document).isInCommentOrLiteral(n7) || --n6 != 0) continue;
                    return n7;
                }
            }
        }
        return -1;
    }

    public static int findWordStart(String string, int n, String string2) {
        return TextUtils.findWordStart(string, n, string2, true, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl) {
        return TextUtils.findWordStart(string, n, string2, bl, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl, boolean bl2) {
        return TextUtils.findWordStart(string, n, string2, bl, bl2, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (n > string.length() - 1) {
            n = string.length() - 1;
        }
        char c = string.charAt(n);
        if (string2 == null) {
            string2 = "";
        }
        int n2 = Character.isWhitespace(c) ? 0 : (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 ? 1 : 2);
        block5: for (int i = n; i >= 0; --i) {
            c = string.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    if (!bl3) {
                        return i + 1;
                    }
                    if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1) {
                        n2 = 1;
                        continue block5;
                    }
                    n2 = 2;
                    continue block5;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl2) {
                        n2 = 0;
                        bl3 = false;
                        continue block5;
                    }
                    return i + 1;
                }
                case 2: {
                    if (!bl && n != i) {
                        return i + 1;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl2) {
                            n2 = 0;
                            bl3 = false;
                            continue block5;
                        }
                        return i + 1;
                    }
                    if (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1) continue block5;
                    return i + 1;
                }
            }
        }
        return 0;
    }

    public static int findWordEnd(String string, int n, String string2) {
        return TextUtils.findWordEnd(string, n, string2, true);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl) {
        return TextUtils.findWordEnd(string, n, string2, bl, false);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl, boolean bl2) {
        if (n > string.length() - 1) {
            n = string.length() - 1;
            ++n;
        }
        if (n != 0) {
            --n;
        }
        char c = string.charAt(n);
        if (string2 == null) {
            string2 = "";
        }
        int n2 = Character.isWhitespace(c) ? 0 : (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 ? 1 : 2);
        boolean bl3 = n2 != 0;
        block5: for (int i = n; i < string.length(); ++i) {
            c = string.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    if (bl3) {
                        return i;
                    }
                    n2 = Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 ? 1 : 2;
                    bl3 = true;
                    continue block5;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl2) {
                        n2 = 0;
                        continue block5;
                    }
                    return i;
                }
                case 2: {
                    if (!bl && i != n) {
                        return i;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl2) {
                            n2 = 0;
                            continue block5;
                        }
                        return i;
                    }
                    if (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1) continue block5;
                    return i;
                }
            }
        }
        return string.length() - (bl3 ? 1 : 0);
    }

    public static String getLeadingWhitespace(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n && ((c = string.charAt(i)) == ' ' || c == '\t'); ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String createWhiteSpace(int n, int n2, boolean bl, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            while (n-- > 0) {
                stringBuffer.append(' ');
            }
        } else if (n == 1) {
            stringBuffer.append(' ');
        } else {
            int n4 = (n + n3 % n2) / n2;
            if (n4 != 0) {
                n += n3;
            }
            while (n4-- > 0) {
                if (bl) {
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer.append(' ');
                    }
                    continue;
                }
                stringBuffer.append('\t');
            }
            n4 = n % n2;
            while (n4-- > 0) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public static String createWhiteSpace(int n, int n2, boolean bl) {
        return TextUtils.createWhiteSpace(n, n2, bl, 0);
    }

    public static String getLineBreak(int n) {
        switch (n) {
            case 2: {
                return "\r";
            }
            case 1: {
                return "\n";
            }
        }
        return "\r\n";
    }

    public static boolean isBracket(char c) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}';
    }
}

