/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.LazyLoadDocument;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

class LazyLoadUndoableEdit
extends AbstractUndoableEdit {
    private LazyLoadDocument _document;
    private List<UndoableEdit> _pageEdits;
    private static final long serialVersionUID = 664360116225632108L;

    public LazyLoadUndoableEdit(LazyLoadDocument lazyLoadDocument) {
        this._document = lazyLoadDocument;
        this._pageEdits = new ArrayList<UndoableEdit>();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return this._pageEdits.add(undoableEdit);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this._document.setBatchProcess(true);
        for (int i = this._pageEdits.size() - 1; i >= 2; --i) {
            UndoableEdit undoableEdit = this._pageEdits.get(i);
            undoableEdit.undo();
        }
        this._document.setBatchProcess(false);
        if (this._pageEdits.get(1) instanceof AbstractDocument.DefaultDocumentEvent) {
            if (((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(1)).getType() == DocumentEvent.EventType.REMOVE) {
                this._document.fireRemoveUpdate((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(1));
            } else if (((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(1)).getType() == DocumentEvent.EventType.INSERT) {
                this._document.fireInsertUpdate((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(1));
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this._document.setBatchProcess(true);
        for (int i = this._pageEdits.size() - 1; i >= 2; --i) {
            UndoableEdit undoableEdit = this._pageEdits.get(i);
            undoableEdit.redo();
        }
        this._document.setBatchProcess(false);
        if (this._pageEdits.get(0) instanceof AbstractDocument.DefaultDocumentEvent) {
            if (((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(0)).getType() == DocumentEvent.EventType.REMOVE) {
                this._document.fireRemoveUpdate((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(0));
            } else if (((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(0)).getType() == DocumentEvent.EventType.INSERT) {
                this._document.fireInsertUpdate((AbstractDocument.DefaultDocumentEvent)this._pageEdits.get(0));
            }
        }
    }
}

