/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import sun.awt.dnd.SunDragSourceContextPeer;

public class EditorDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;

    private static int getMotionThreshold() {
        return DragSource.getDragThreshold();
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        JComponent jComponent = this.getComponent(mouseEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        return SunDragSourceContextPeer.convertModifiersToDropAction(n, transferHandler.getSourceActions(jComponent));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
            int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
            if (n2 > EditorDragGestureRecognizer.getMotionThreshold() || n3 > EditorDragGestureRecognizer.getMotionThreshold()) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                this.dndArmedEvent = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private TransferHandler getTransferHandler(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? null : jComponent.getTransferHandler();
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? true : jComponent.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }
}

