/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

class CodeEditorDefaultTransferHandler
extends TransferHandler
implements UIResource {
    private static final long serialVersionUID = -8347546345832592407L;

    CodeEditorDefaultTransferHandler() {
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (!(jComponent instanceof CodeEditor)) {
            return null;
        }
        return new StringSelection(((CodeEditor)jComponent).isCopyVisibleTextOnly() ? ((CodeEditor)jComponent).getSelectedVisibleText() : ((CodeEditor)jComponent).getSelectedText());
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (!(jComponent instanceof CodeEditor)) {
            return;
        }
        if (n == 2) {
            CodeEditorUtils.deleteSelectedText((CodeEditor)jComponent);
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!(jComponent instanceof CodeEditor)) {
            return false;
        }
        CodeEditor codeEditor = (CodeEditor)jComponent;
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                codeEditor.insertChar(string);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }
}

