/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.IDocumentPane;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class PreviousState
implements Serializable {
    private static final long serialVersionUID = -4488476371532805788L;
    boolean floating;
    List<String> documentNames;
    int orientation;
    List<List<String>> allDocumentNames;
    Rectangle fcBounds;

    PreviousState() {
    }

    public static PreviousState createPreviousState(DocumentComponent documentComponent) {
        PreviousState previousState = new PreviousState();
        IDocumentPane iDocumentPane = documentComponent.getDocumentPane();
        int n = iDocumentPane.groupIndexOfDocument(documentComponent.getName());
        IDocumentGroup iDocumentGroup = iDocumentPane.getDocumentGroupAt(n);
        previousState.floating = iDocumentPane.isDocumentFloating(documentComponent.getName());
        previousState.documentNames = PreviousState.getDocumentNamesInGroup(iDocumentPane, iDocumentGroup);
        if (previousState.floating) {
            previousState.fcBounds = documentComponent.getComponent().getTopLevelAncestor().getBounds();
        } else if (iDocumentPane instanceof DocumentPane) {
            previousState.orientation = ((DocumentPane)iDocumentPane).getOrientation();
        }
        previousState.allDocumentNames = PreviousState.getDocumentNames(iDocumentPane);
        return previousState;
    }

    private static List<List<String>> getDocumentNames(IDocumentPane iDocumentPane) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (int i = 0; i < iDocumentPane.getDocumentGroupCount(); ++i) {
            IDocumentGroup iDocumentGroup = iDocumentPane.getDocumentGroupAt(i);
            arrayList.add(PreviousState.getDocumentNamesInGroup(iDocumentPane, iDocumentGroup));
        }
        return arrayList;
    }

    private static List<String> getDocumentNamesInGroup(IDocumentPane iDocumentPane, IDocumentGroup iDocumentGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < iDocumentGroup.getDocumentCount(); ++i) {
            String string = iDocumentPane.getNameOf(iDocumentGroup.getDocumentAt(i));
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void disposePreviousState(PreviousState previousState) {
        if (previousState == null) {
            return;
        }
        previousState.fcBounds = null;
        if (previousState.documentNames != null) {
            previousState.documentNames.clear();
        }
        if (previousState.allDocumentNames != null) {
            previousState.allDocumentNames.clear();
        }
    }

    public static IDocumentGroup findDocumentGroup(IDocumentPane iDocumentPane, PreviousState previousState, String string) {
        int[] nArray;
        int n = previousState.documentNames.indexOf(string);
        for (int n2 : nArray = PreviousState.reorderIndex(0, previousState.documentNames.size() - 1, n)) {
            IDocumentGroup iDocumentGroup;
            String string2 = previousState.documentNames.get(n2);
            if (string2.equals(string) || (iDocumentGroup = PreviousState.internalFindDocumentGroup(iDocumentPane, string2)) == null || previousState.floating != iDocumentPane.isDocumentFloating(string2)) continue;
            return iDocumentGroup;
        }
        return null;
    }

    public static int findDocumentIndex(IDocumentPane iDocumentPane, IDocumentGroup iDocumentGroup, PreviousState previousState, String string) {
        int[] nArray;
        int n = previousState.documentNames.indexOf(string);
        List<String> list = PreviousState.getDocumentNamesInGroup(iDocumentPane, iDocumentGroup);
        for (int n2 : nArray = PreviousState.reorderIndex(0, previousState.documentNames.size() - 1, n)) {
            int n3;
            String string2 = previousState.documentNames.get(n2);
            if (string2.equals(string) || (n3 = list.indexOf(string2)) == -1) continue;
            return n3 + (n2 > n ? 0 : 1);
        }
        return -1;
    }

    static int[] reorderIndex(int n, int n2, int n3) {
        int n4;
        int n5 = n2 - n + 1;
        if (n5 <= 0) {
            return new int[0];
        }
        int[] nArray = new int[n5 - 1];
        int n6 = Math.max(n3 - n, n2 - n3);
        int[] nArray2 = new int[n6 * 2];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray2[2 * n4] = n3 + (n4 + 1);
            nArray2[2 * n4 + 1] = n3 - (n4 + 1);
        }
        n4 = 0;
        for (int i = 0; i < n6 * 2; ++i) {
            if (nArray2[i] < n || nArray2[i] > n2) continue;
            nArray[n4] = nArray2[i];
            ++n4;
        }
        return nArray;
    }

    private static IDocumentGroup internalFindDocumentGroup(IDocumentPane iDocumentPane, String string) {
        for (int i = 0; i < iDocumentPane.getDocumentGroupCount(); ++i) {
            IDocumentGroup iDocumentGroup = iDocumentPane.getDocumentGroupAt(i);
            List<String> list = PreviousState.getDocumentNamesInGroup(iDocumentPane, iDocumentGroup);
            if (list.indexOf(string) == -1) continue;
            return iDocumentGroup;
        }
        return null;
    }

    public static int findDocumentGroupIndex(IDocumentPane iDocumentPane, PreviousState previousState, String string) {
        int[] nArray;
        int n = 0;
        for (int i = 0; i < previousState.allDocumentNames.size(); ++i) {
            boolean bl;
            boolean bl2 = bl = previousState.allDocumentNames.get(i).indexOf(string) != -1;
            if (!bl) continue;
            n = i;
            break;
        }
        for (int n2 : nArray = PreviousState.reorderIndex(0, previousState.allDocumentNames.size() - 1, n)) {
            if (n2 == n) continue;
            List<String> list = previousState.allDocumentNames.get(n2);
            for (String string2 : list) {
                int n3;
                if (iDocumentPane.isDocumentFloating(string2) || (n3 = iDocumentPane.groupIndexOfDocument(string2)) == -1) continue;
                return n3 + (n2 > n ? 0 : 1);
            }
        }
        return -1;
    }
}

