/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingFrameworkContour;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class OutlineContour
extends JComponent
implements DockingFrameworkContour {
    private static final Logger LOGGER_OUTLINE = Logger.getLogger(DefaultDockingManager.class.getName() + ".outline");
    private int _thickness = 4;
    private float _alpha = 0.5f;
    private static final int TAB_WIDTH = 42;
    private static final int TAB_LEADING = 8;
    private Color _lineColor = new Color(136, 136, 136);
    private int _tabHeight = 22;
    private boolean _allowDocking = true;
    private boolean _tabDocking;
    private int _tabSide;
    private boolean _floating;
    private Component _attachedComponent;
    private DockingManager _attachedDockingManager;
    private int _attachedSide;
    private boolean _single;
    private JComponent _saveDraggedComponent;
    private int _saveX;
    private int _saveY;
    private int _saveMouseModifier;
    private int _currentMouseX;
    private int _currentMouseY;
    private Container _relativeContainer;
    private int _outlineMode = 0;
    private OutlineHW _fullOutline;
    private Outline _topOutline;
    private Outline _bottomOutline;
    private Outline _leftOutline;
    private Outline _rightOutline;
    private Content _emptyContent;
    private boolean _ghost = false;
    private Component _glassPane;
    private boolean _changeCursor = false;
    private double _relativeX;
    private double _relativeY;
    private int _dragStartOffsetX;
    private int _dragStartOffsetY;
    private JLayeredPane _activeLayerPane;
    private RootPaneContainer _rootPaneContainer;
    private int _sensitiveAreaSize = 40;
    private int _outsideSensitiveAreaSize = 40;
    private DockingManager _dockingManager;

    public OutlineContour() {
        this(22);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
    }

    public OutlineContour(int n) {
        this._thickness = UIDefaultsLookup.getInt("Contour.thickness") == 0 ? 4 : UIDefaultsLookup.getInt("Contour.thickness");
        this._lineColor = UIDefaultsLookup.getColor("Contour.color") == null ? new Color(136, 136, 136) : UIDefaultsLookup.getColor("Contour.color");
        this.setTabHeight(n);
        if (this.isHeavyweight()) {
            this.initOutline();
        }
    }

    private boolean isHeavyweight() {
        return this.getOutlineMode() == 1 || this.getOutlineMode() == 2 || this.getOutlineMode() == 4 || this.getOutlineMode() == 5;
    }

    private void initOutline() {
        this._fullOutline = new OutlineHW();
        this._topOutline = new Outline();
        this._emptyContent = new Content();
        this._bottomOutline = new Outline();
        this._leftOutline = new Outline();
        this._rightOutline = new Outline();
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        if (!this._ghost && (n = this.getOutlineMode()) != 2 && n != 4 && n != 5) {
            this.paintOutline(graphics, false);
        }
    }

    private void paintOutline(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.getBounds();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.getOutlineMode() != 5 && this.getOutlineMode() != 4) {
            graphics2D.translate(-rectangle.x, -rectangle.y);
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        --rectangle.width;
        --rectangle.height;
        if (bl) {
            rectangle = SwingUtilities.convertRectangle(this, rectangle, this.getRelativeContainer());
        } else {
            graphics2D.setColor(this._lineColor);
        }
        if (this.getOutlineMode() != 2) {
            if (this.isTabDocking()) {
                if (this.getOutlineMode() != 3 && this.getOutlineMode() != 4) {
                    this.drawTab(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._tabHeight, 42, 8, this._thickness, this.getTabSide());
                } else {
                    this.fillTab(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._tabHeight, 42, 8, this._alpha, this.getTabSide());
                }
            } else if (this.getOutlineMode() != 3 && this.getOutlineMode() != 4) {
                this.drawRect(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._thickness);
            } else {
                this.fillTab(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._alpha);
            }
        }
        graphics2D.dispose();
    }

    private void paintTitle(Graphics graphics) {
        Serializable serializable;
        Object object;
        if (this._attachedDockingManager == null || !this._attachedDockingManager.isShowTitleOnOutline()) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Color color = graphics.getColor();
        if (this.getOutlineMode() == 3) {
            object = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
            if (object != null) {
                graphics.setColor(object.getDockableFrameTitleBarActiveForeground());
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("activeCaptionText"));
            }
        } else {
            graphics.setColor(this._lineColor);
        }
        graphics.setFont(UIDefaultsLookup.getFont("DockableFrame.font"));
        object = this._saveDraggedComponent;
        String string = "";
        if (object instanceof DockableFrame) {
            string = ((DockableFrame)object).getTitle();
        }
        if (!this.isSingle() && (serializable = ((Component)object).getParent()) instanceof JideTabbedPane && ((JideTabbedPane)serializable).getTabCount() > 1) {
            string = string + " (" + ((JideTabbedPane)serializable).getTabCount() + ")";
        }
        serializable = graphics.getFontMetrics();
        int n = rectangle.x + rectangle.width / 2 - ((FontMetrics)serializable).stringWidth(string) / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        JideSwingUtilities.drawString(this, graphics, string, n, n2);
        graphics.setColor(color);
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n == n3) {
            if (n4 > n2) {
                graphics.fillRect(n, n2, n5, n4 - n2);
            } else {
                graphics.fillRect(n, n4, n5, n2 - n4);
            }
        } else if (n2 == n4) {
            if (n3 > n) {
                graphics.fillRect(n, n2, n3 - n, n5);
            } else {
                graphics.fillRect(n3, n2, n - n3, n5);
            }
        }
    }

    private void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n3 <= n5) {
            this.drawLine(graphics, n, n2, n, n2 + n4, n5);
        } else if (n4 <= n5) {
            this.drawLine(graphics, n, n2, n + n3, n2, n5);
        } else {
            this.drawLine(graphics, n, n2, n + n3 - n5, n2, n5);
            this.drawLine(graphics, n + n3 - n5, n2, n + n3 - n5, n2 + n4 - n5, n5);
            this.drawLine(graphics, n + n3, n2 + n4 - n5, n + n5, n2 + n4 - n5, n5);
            this.drawLine(graphics, n, n2 + n4, n, n2 + n5, n5);
        }
        this.paintTitle(graphics);
    }

    private void fillTab(Graphics graphics, int n, int n2, int n3, int n4, float f) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.fillRect(n, n2, n3, n4);
        this.paintTitle(graphics2D);
        graphics2D.setComposite(composite);
        graphics2D.drawRect(n, n2, n3, n4);
        graphics2D.dispose();
    }

    private void drawTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        switch (n9) {
            case 1: {
                this.drawTopTab(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            case 3: {
                this.drawBottomTab(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            case 2: {
                this.drawLeftTab(graphics, n, n2, n3, n4, n6, n5, n7, n8);
                break;
            }
            case 4: {
                this.drawRightTab(graphics, n, n2, n3, n4, n6, n5, n7, n8);
            }
        }
        this.paintTitle(graphics);
    }

    private void drawTopTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawLine(graphics, n + n3 - n8, n2 + n5, n + n3 - n8, n2 + n4 - 1, n8);
        this.drawLine(graphics, n + n7 + n8, n2 + n5, n, n2 + n5, n8);
        this.drawLine(graphics, n + n6 + n7, n2 + n5, n + n6 + n7, n2, n8);
        this.drawLine(graphics, n + n6 + n7, n2, n + n7 + 1, n2, n8);
        this.drawLine(graphics, n + n7, n2, n + n7, n2 + n5, n8);
        this.drawLine(graphics, n + n3, n2 + n5, n + n6 + n7, n2 + n5, n8);
        this.drawLine(graphics, n, n2 + n5, n, n2 + n4, n8);
        this.drawLine(graphics, n, n2 + n4 - n8, n + n3, n2 + n4 - n8, n8);
    }

    private void fillTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8) {
        Polygon polygon;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        switch (n8) {
            case 3: {
                polygon = new Polygon(new int[]{n, n + n3, n + n3, n + n7 + n6, n + n7 + n6, n + n7, n + n7, n}, new int[]{n2, n2, n2 + n4 - n5, n2 + n4 - n5, n2 + n4, n2 + n4, n2 + n4 - n5, n2 + n4 - n5}, 8);
                break;
            }
            case 2: {
                polygon = new Polygon(new int[]{n, n + n5, n + n5, n + n3, n + n3, n + n5, n + n5, n}, new int[]{n2 + n7, n2 + n7, n2, n2, n2 + n4, n2 + n4, n2 + n7 + n6, n2 + n7 + n6}, 8);
                break;
            }
            case 4: {
                polygon = new Polygon(new int[]{n, n + n3 - n5, n + n3 - n5, n + n3, n + n3, n + n3 - n5, n + n3 - n5, n}, new int[]{n2, n2, n2 + n7, n2 + n7, n2 + n7 + n6, n2 + n7 + n6, n2 + n4, n2 + n4}, 8);
                break;
            }
            default: {
                polygon = new Polygon(new int[]{n + n7, n + n7 + n6, n + n7 + n6, n + n3, n + n3, n, n, n + n7}, new int[]{n2, n2, n2 + n5, n2 + n5, n2 + n4, n2 + n4, n2 + n5, n2 + n5}, 8);
            }
        }
        graphics2D.fillPolygon(polygon);
        this.paintTitle(graphics2D);
        graphics2D.setComposite(composite);
        graphics2D.drawPolygon(polygon);
        graphics2D.dispose();
    }

    private void drawBottomTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawLine(graphics, n, n2, n + n3 - 1, n2, n8);
        this.drawLine(graphics, n + n3 - n8, n2, n + n3 - n8, n2 + n4 - n5 - 1, n8);
        this.drawLine(graphics, n + n3, n2 + n4 - n5 - n8, n + n6 + n7, n2 + n4 - n5 - n8, n8);
        this.drawLine(graphics, n + n6 + n7, n2 + n4 - n5, n + n6 + n7, n2 + n4, n8);
        this.drawLine(graphics, n + n6 + n7, n2 + n4 - n8, n + n7 + 1, n2 + n4 - n8, n8);
        this.drawLine(graphics, n + n7, n2 + n4, n + n7, n2 + n4 - n5, n8);
        this.drawLine(graphics, n + n7 + n8, n2 + n4 - n5 - n8, n + 1, n2 + n4 - n5 - n8, n8);
        this.drawLine(graphics, n, n2 + n4 - n5, n, n2 + 1, n8);
    }

    private void drawLeftTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawLine(graphics, n + n6, n2, n + n3, n2, n8);
        this.drawLine(graphics, n + n3 - n8, n2, n + n3 - n8, n2 + n4 - 1, n8);
        this.drawLine(graphics, n + n6, n2, n + n6, n2 + n7 + n8, n8);
        this.drawLine(graphics, n + n6, n2 + n7, n, n2 + n7, n8);
        this.drawLine(graphics, n, n2 + n7, n, n2 + n5 + n7, n8);
        this.drawLine(graphics, n + n6, n2 + n5 + n7, n, n2 + n5 + n7, n8);
        this.drawLine(graphics, n + n6, n2 + n5 + n7, n + n6, n2 + n4, n8);
        this.drawLine(graphics, n + n6, n2 + n4 - n8, n + n3, n2 + n4 - n8, n8);
    }

    private void drawRightTab(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawLine(graphics, n, n2, n + n3 - n6, n2, n8);
        this.drawLine(graphics, n, n2 + n4 - n8, n + n3 - n6, n2 + n4 - n8, n8);
        this.drawLine(graphics, n + n3 - n6 - n8, n2, n + n3 - n6 - n8, n2 + n7 + n8, n8);
        this.drawLine(graphics, n + n3 - n6 - n8, n2 + n7, n + n3 - n8, n2 + n7, n8);
        this.drawLine(graphics, n + n3 - n8, n2 + n7, n + n3 - n8, n2 + n5 + n7 + n8, n8);
        this.drawLine(graphics, n + n3 - n6 - n8, n2 + n5 + n7, n + n3 - n8, n2 + n5 + n7, n8);
        this.drawLine(graphics, n + n3 - n6 - n8, n2 + n5 + n7, n + n3 - n6 - n8, n2 + n4, n8);
        this.drawLine(graphics, n, n2 + n4 - n8, n, n2 + 1, n8);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.isLightweight()) {
            if (!this.isHeavyweight()) {
                if (this._ghost && (this.getRelativeContainer() != null || this.getParent() != null)) {
                    Graphics graphics = this.getRelativeContainer().getGraphics();
                    graphics.setXORMode(this._lineColor);
                    this.paintOutline(graphics, true);
                }
                super.setBounds(n, n2, n3, n4);
            } else {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                if (this.getParent() != null) {
                    Rectangle rectangle2 = this.getParent().getBounds();
                    super.setBounds(n, n2, n3, n4);
                    if (this.getOutlineMode() == 1 && rectangle2.contains(rectangle)) {
                        this._leftOutline.setVisible(false);
                        this._rightOutline.setVisible(false);
                        this._topOutline.setVisible(false);
                        this._bottomOutline.setVisible(false);
                        this._emptyContent.setVisible(false);
                    } else {
                        super.setVisible(false);
                        Point point = rectangle.getLocation();
                        SwingUtilities.convertPointToScreen(point, this.getParent());
                        this.arrangeOutline(rectangle, point);
                    }
                }
            }
        } else if (this.getRelativeContainer() != null) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointToScreen(point, this.getRelativeContainer());
            super.setBounds(point.x, point.y, n3, n4);
        }
    }

    private void arrangeOutline(Rectangle rectangle, Point point) {
        if (this.getOutlineMode() == 5 || this.getOutlineMode() == 4) {
            this._fullOutline.setBounds(point.x, point.y, rectangle.width - 1, rectangle.height);
            if (!this._fullOutline.isVisible()) {
                this._fullOutline.setVisible(true);
            }
        } else {
            this._leftOutline.setBounds(point.x, point.y, this._thickness, rectangle.height - this._thickness);
            this._topOutline.setBounds(point.x + this._thickness, point.y, rectangle.width - this._thickness - 1, this._thickness);
            this._emptyContent.setBounds(point.x + this._currentMouseX - 1, point.y + this._currentMouseY - 1, 2, 2);
            this._rightOutline.setBounds(point.x + rectangle.width - this._thickness - 1, point.y + this._thickness, this._thickness, rectangle.height - this._thickness);
            this._bottomOutline.setBounds(point.x, point.y + rectangle.height - this._thickness, rectangle.width - 1, this._thickness);
            if (!this._topOutline.isVisible()) {
                this._topOutline.setVisible(true);
            }
            if (!this._leftOutline.isVisible()) {
                this._leftOutline.setVisible(true);
            }
            if (!this._rightOutline.isVisible()) {
                this._rightOutline.setVisible(true);
            }
            if (!this._bottomOutline.isVisible()) {
                this._bottomOutline.setVisible(true);
            }
            if (!this._emptyContent.isVisible()) {
                this._emptyContent.setVisible(true);
            }
        }
    }

    private void checkParent() {
        RootPaneContainer rootPaneContainer = this._rootPaneContainer;
        if (rootPaneContainer == null) {
            return;
        }
        if (rootPaneContainer instanceof JDialog) {
            this._fullOutline = this.recreateOutline(this._fullOutline, rootPaneContainer);
            this._leftOutline = this.recreateOutline(this._leftOutline, rootPaneContainer);
            this._rightOutline = this.recreateOutline(this._rightOutline, rootPaneContainer);
            this._topOutline = this.recreateOutline(this._topOutline, rootPaneContainer);
            this._bottomOutline = this.recreateOutline(this._bottomOutline, rootPaneContainer);
        } else {
            this._fullOutline = this.recreateOutline(this._fullOutline, null);
            this._leftOutline = this.recreateOutline(this._leftOutline, null);
            this._rightOutline = this.recreateOutline(this._rightOutline, null);
            this._topOutline = this.recreateOutline(this._topOutline, null);
            this._bottomOutline = this.recreateOutline(this._bottomOutline, null);
        }
    }

    private OutlineHW recreateOutline(OutlineHW outlineHW, RootPaneContainer rootPaneContainer) {
        if (outlineHW == null) {
            if (rootPaneContainer == null) {
                return new OutlineHW();
            }
            return new OutlineHW((JDialog)rootPaneContainer);
        }
        if (rootPaneContainer == null && outlineHW.getOwner() instanceof JDialog) {
            outlineHW.dispose();
            return new OutlineHW();
        }
        if (outlineHW.getOwner().getClass().getName().indexOf("SharedOwnerFrame") != -1) {
            outlineHW.dispose();
            return new OutlineHW((JDialog)rootPaneContainer);
        }
        return outlineHW;
    }

    private Outline recreateOutline(Outline outline, RootPaneContainer rootPaneContainer) {
        if (outline == null) {
            if (rootPaneContainer == null) {
                return new Outline();
            }
            return new Outline((JDialog)rootPaneContainer);
        }
        if (rootPaneContainer == null && outline.getOwner() instanceof JDialog) {
            outline.dispose();
            return new Outline();
        }
        if (outline.getOwner().getClass().getName().indexOf("SharedOwnerFrame") != -1) {
            outline.dispose();
            return new Outline((JDialog)rootPaneContainer);
        }
        return outline;
    }

    @Override
    public int getTabHeight() {
        return this._tabHeight;
    }

    @Override
    public void setTabHeight(int n) {
        this._tabHeight = n == 0 ? 22 : n;
    }

    @Override
    public boolean isTabDocking() {
        return this._tabDocking;
    }

    @Override
    public void setTabDocking(boolean bl) {
        this._tabDocking = bl;
        this.updateCursor();
    }

    @Override
    public int getTabSide() {
        return this._tabSide;
    }

    @Override
    public void setTabSide(int n) {
        this._tabSide = n;
    }

    @Override
    public boolean isFloating() {
        return this._floating;
    }

    @Override
    public void setFloating(boolean bl) {
        this._floating = bl;
        this.updateCursor();
    }

    @Override
    public Component getAttachedComponent() {
        return this._attachedComponent;
    }

    @Override
    public DockingManager getAttachedDockingManager() {
        return this._attachedDockingManager;
    }

    @Override
    public void setAttachedDockingManager(DockingManager dockingManager) {
        this._attachedDockingManager = dockingManager;
    }

    @Override
    public void setAttachedComponent(Component component) {
        this._attachedComponent = component;
    }

    @Override
    public int getAttachedSide() {
        return this._attachedSide;
    }

    @Override
    public void setAttachedSide(int n) {
        this._attachedSide = n;
        this.updateCursor();
    }

    private void updateCursor() {
        if (!this._dockingManager.isUseGlassPaneEnabled()) {
            return;
        }
        if (this.getGlassPane() == null) {
            return;
        }
        if (!this.isVisible() && this._floating) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(23));
            return;
        }
        DockingUtils.clearGlassPaneCursor(this._dockingManager);
        if (!this._changeCursor) {
            return;
        }
        if (!this.isVisible()) {
            DockingUtils.clearGlassPaneCursor(this._dockingManager);
            return;
        }
        if (this.isVisible() && (!this._allowDocking || this._floating)) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(29));
        } else if (this.isVisible() && this._tabDocking) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(28));
        } else if (this.getAttachedComponent() instanceof JideSplitPaneDivider) {
            if (((JideSplitPaneDivider)this.getAttachedComponent()).getJideSplitPane().getOrientation() == 1) {
                DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(31));
            } else {
                DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(30));
            }
        } else {
            switch (this._attachedSide) {
                case 1: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(24));
                    break;
                }
                case 2: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(25));
                    break;
                }
                case 4: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(26));
                    break;
                }
                case 8: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(27));
                    break;
                }
                default: {
                    DockingUtils.clearGlassPaneCursor(this._dockingManager);
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return this._single;
    }

    @Override
    public void setSingle(boolean bl) {
        this._single = bl;
    }

    @Override
    public boolean isAllowDocking() {
        return this._allowDocking;
    }

    @Override
    public void setAllowDocking(boolean bl) {
        this._allowDocking = bl;
        this.updateCursor();
    }

    @Override
    public Container getRelativeContainer() {
        return this._relativeContainer;
    }

    @Override
    public void setRelativeContainer(Container container) {
        this._relativeContainer = container;
    }

    @Override
    public int getSaveX() {
        return this._saveX;
    }

    @Override
    public int getSaveY() {
        return this._saveY;
    }

    @Override
    public int getSaveMouseModifier() {
        return this._saveMouseModifier;
    }

    @Override
    public JComponent getSaveDraggedComponent() {
        return this._saveDraggedComponent;
    }

    @Override
    public void beginDraggingFrame(JComponent jComponent, int n, int n2, double d, double d2, boolean bl) {
        this.setChangeCursor(UIDefaultsLookup.getBoolean("DockingFramework.changeCursor"));
        if (jComponent.isShowing() && jComponent.isVisible()) {
            this._dragStartOffsetX = n - jComponent.getLocationOnScreen().x;
            this._dragStartOffsetY = n2 - jComponent.getLocationOnScreen().y;
        } else {
            this._dragStartOffsetX = 0;
            this._dragStartOffsetY = 0;
        }
        this._relativeX = d;
        this._relativeY = d2;
        this._single = bl;
    }

    private boolean floatingFrameFreeze() {
        return "true".equals(SecurityUtils.getProperty("docking.freezeFloatingWhileNotRearrangable", "false"));
    }

    @Override
    public void dragFrame(JComponent jComponent, int n, int n2, int n3) {
        Cloneable cloneable;
        int n4 = this._dockingManager.getSnapGridSize();
        if (n4 > 0 && (n - this._dragStartOffsetX) % n4 != 0) {
            n = n > this._dragStartOffsetX ? (n += n4 - (n - this._dragStartOffsetX) % n4) : (n -= n4 - (this._dragStartOffsetX - n) % n4);
        }
        if (n4 > 0 && (n2 - this._dragStartOffsetY) % n4 != 0) {
            n2 = n2 > this._dragStartOffsetY ? (n2 += n4 - (n2 - this._dragStartOffsetY) % n4) : (n2 -= n4 - (this._dragStartOffsetY - n2) % n4);
        }
        this._saveDraggedComponent = jComponent;
        this._saveX = n;
        this._saveY = n2;
        this._saveMouseModifier = n3;
        DockableFrame dockableFrame = (DockableFrame)jComponent;
        Rectangle rectangle = dockableFrame.getUndockedBounds();
        if (!((!dockableFrame.isFloated() || this._dockingManager.isRearrangable() && dockableFrame.isRearrangable() || this.floatingFrameFreeze()) && dockableFrame.isDockable())) {
            Rectangle rectangle2 = this.calculateContourBounds(new Rectangle(0, 0, rectangle.width, rectangle.height), n, n2);
            Point point = rectangle2.getLocation();
            SwingUtilities.convertPointToScreen(point, this.getRootPaneContainerAsComponent());
            Container container = dockableFrame.getTopLevelAncestor();
            if (container instanceof FloatingContainer) {
                container.setLocation(point.x, point.y + (DockingUtils.isFloatingContainerDecorated((FloatingContainer)((Object)container)) ? 0 : 20));
                LOGGER_OUTLINE.fine("FloatingContainer.setLocation " + container.getX() + ", " + container.getY());
            }
            return;
        }
        if (!this._dockingManager.isRearrangable() || !dockableFrame.isRearrangable()) {
            return;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, this.getRootPaneContainerAsComponent());
        Component component = (Component)((Object)this._dockingManager.findFloatingComponentAt(point.x, point.y));
        DockedFrameContainer dockedFrameContainer = this.getDockingManager().getDockedFrameContainer();
        boolean bl = true;
        boolean bl2 = true;
        for (Container container = dockedFrameContainer; container != null && !(container instanceof JRootPane); container = container.getParent()) {
            if (!container.isVisible()) {
                bl = false;
                break;
            }
            if (container.isShowing()) continue;
            bl2 = false;
        }
        if (dockableFrame.isDockable() && this.isAllowDocking() && this.getDockingManager().isAutoDocking() && bl) {
            Serializable serializable;
            Serializable serializable2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Serializable serializable3;
            int n5;
            cloneable = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), n, n2, dockedFrameContainer);
            int n6 = n5 = this._dockingManager.isSideDockAllowed() ? DockingUtils.outsideOfComponent(dockedFrameContainer, cloneable.x, cloneable.y, this.getOutsideSensitiveAreaSize()) : 32;
            if (dockableFrame.getDockingManager() != null && dockableFrame.getDockingManager().isPreserveStateOnDragging() && dockableFrame.isFloated()) {
                n5 = 32;
            }
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            FloatingContainer floatingContainer = null;
            if (this.getDockingManager().isNestedFloatingAllowed() && component instanceof FloatingContainer) {
                floatingContainer = (FloatingContainer)((Object)component);
            }
            if (floatingContainer == null) {
                if (n5 != 32 && (n5 & this.getDockingManager().getAllowedDockSides()) == 0) {
                    n5 = 32;
                }
                if (n5 != 32 && this.getDockingManager().getMaximizedFrameKey() != null) {
                    n5 = 32;
                }
                if (n5 != 32 && n5 != 16 && DockingUtils.getContainerContainerOnSide(n5, this.getDockingManager().getDockedFrameContainer(), this.getDockingManager().getWorkspace()) != null) {
                    n5 = 32;
                }
                switch (n5) {
                    case 1: {
                        n9 = ((Component)dockedFrameContainer).getWidth();
                        n10 = Math.min(dockableFrame.getDockedHeight(), ((Component)dockedFrameContainer).getHeight() / 2);
                        n7 = 0;
                        n8 = 0;
                        break;
                    }
                    case 2: {
                        n9 = ((Component)dockedFrameContainer).getWidth();
                        n10 = Math.min(dockableFrame.getDockedHeight(), ((Component)dockedFrameContainer).getHeight() / 2);
                        n7 = 0;
                        n8 = ((Component)dockedFrameContainer).getHeight() - n10;
                        break;
                    }
                    case 8: {
                        n9 = Math.min(dockableFrame.getDockedWidth(), ((Component)dockedFrameContainer).getWidth() / 2);
                        n10 = ((Component)dockedFrameContainer).getHeight();
                        n7 = 0;
                        n8 = 0;
                        break;
                    }
                    case 4: {
                        n9 = Math.min(dockableFrame.getDockedWidth(), ((Component)dockedFrameContainer).getWidth() / 2);
                        n10 = ((Component)dockedFrameContainer).getHeight();
                        n7 = ((Component)dockedFrameContainer).getWidth() - n9;
                        n8 = 0;
                        break;
                    }
                }
                if (n5 != 32 && this.getDockingManager().isDropAllowed(dockableFrame, dockedFrameContainer, n5) && bl2) {
                    this.setAttachedComponent(dockedFrameContainer);
                    this.setAttachedDockingManager(this.getDockingManager());
                    this.setAttachedSide(n5);
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    Rectangle rectangle3 = this.calculateContourBounds(new Rectangle(n7, n8, n9, n10), dockedFrameContainer);
                    this.setContourBounds(rectangle3);
                    this.setTabDocking(false);
                    this.setFloating(false);
                    LOGGER_OUTLINE.fine("Dock to outside " + n5);
                    return;
                }
            }
            if (floatingContainer == null) {
                this.showOutline(this.getRootPaneContainer().getLayeredPane());
                serializable3 = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), n, n2, this.getDockingManager().getDockedFrameContainer());
                object5 = this.getDockingManager().getDockedFrameContainer().findComponentAt(((Point)serializable3).x, ((Point)serializable3).y);
                this.setAttachedDockingManager(this.getDockingManager());
                if (object5 == null && this.getDockingManager().isCrossDraggingAllowed() && (object4 = DefaultDockingManager.getAllDockingManagers()).size() >= 1 && !this.getDockingManager().isWithinFrameBoundsOnDragging()) {
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        if (object2 == this.getDockingManager() || !object2.isCrossDroppingAllowed() || object2.getFrame(dockableFrame.getKey()) != null) continue;
                        object = object2.getDockedFrameContainer();
                        serializable2 = SwingUtilities.convertPoint(this.getDockingManager().getDockedFrameContainer(), (Point)serializable3, (Component)object);
                        object5 = ((Container)object).findComponentAt(((Point)serializable2).x, ((Point)serializable2).y);
                        if (object5 == null) continue;
                        serializable = ((Component)object5).getParent();
                        boolean bl3 = true;
                        do {
                            if (serializable instanceof DockedFrameContainer) {
                                boolean bl4 = bl3 = serializable == object;
                                if (bl3 || !(serializable.getParent() instanceof ContainerContainer)) break;
                                DockingManager dockingManager = ((ContainerContainer)serializable.getParent()).getDockingManager();
                                if (dockableFrame.getDockingManager() == dockingManager || dockingManager.isCrossDroppingAllowed()) break;
                                serializable = serializable.getParent();
                                continue;
                            }
                            serializable = serializable.getParent();
                        } while (serializable != null);
                        if (!bl3) continue;
                        if (object2 != this.getAttachedDockingManager()) {
                            this.setAttachedDockingManager((DockingManager)object2);
                            this.showOutline(this.getAttachedDockingManager().getRootPaneContainer().getLayeredPane());
                        }
                        break;
                    }
                }
            } else {
                this.showOutline(floatingContainer.getLayeredPane());
                serializable3 = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), n, n2, floatingContainer.getContentPane());
                object5 = floatingContainer.getContentPane().findComponentAt(((Point)serializable3).x, ((Point)serializable3).y);
                this.setAttachedDockingManager(floatingContainer.getDockingManager());
            }
            object5 = DockingUtils.getValidParentOf((Component)object5, dockableFrame, this.isSingle());
            serializable3 = null;
            if (object5 instanceof DockableFrame) {
                serializable3 = (DockableFrame)object5;
                this.setAttachedComponent((Component)serializable3);
                this.setAttachedDockingManager(((DockableFrame)serializable3).getDockingManager());
            } else if (object5 instanceof FrameContainer) {
                serializable3 = ((FrameContainer)object5).getSelectedFrame();
                this.setAttachedComponent((Component)object5);
                this.setAttachedDockingManager(((DockableFrame)serializable3).getDockingManager());
            } else if (object5 instanceof DockableHolder) {
                this.setAttachedComponent((Component)object5);
                this.setAttachedDockingManager(((DockableHolder)object5).getDockingManager());
            } else {
                this.setAttachedComponent((Component)object5);
            }
            if (dockableFrame.getDockingManager() != null && dockableFrame.getDockingManager().isPreserveStateOnDragging()) {
                if (dockableFrame.isDocked() && serializable3 != null && ((DockableFrame)serializable3).isFloated()) {
                    object5 = null;
                }
                if (dockableFrame.isFloated() && DockingUtils.containsInMainContainer(this.getDockingManager().getDockedFrameContainer(), (Component)object5)) {
                    object5 = null;
                }
            }
            if (this.getDockingManager().isTabDockAllowed() && dockableFrame.isTabDockAllowed() && object5 instanceof BasicDockableFrameTitlePane && bl2) {
                object4 = ((Component)object5).getParent();
                if (object4 instanceof DockableFrame && ((DockableFrame)(serializable3 = (DockableFrame)object4)).getDockingManager().isDropAllowed(dockableFrame, (Component)serializable3, 16)) {
                    boolean bl5 = true;
                    if (((Component)serializable3).getParent() != null && ((Component)serializable3).getParent() instanceof FrameContainer && !((FrameContainer)((Component)serializable3).getParent()).isTabShown()) {
                        bl5 = false;
                    }
                    if (((Component)serializable3).getParent() instanceof FrameContainer) {
                        this.setTabHeight(((FrameContainer)((Component)serializable3).getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)((Component)serializable3).getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        object2 = this.calculateTabContourBounds(bl5, (Component)serializable3);
                        this.setContourBounds((Rectangle)object2);
                        this.setTabDocking(true);
                        this.setFloating(false);
                    }
                    LOGGER_OUTLINE.fine("tabDocking to " + ((DockableFrame)serializable3).getKey());
                    return;
                }
            } else if (this._dockingManager.isSideDockAllowed() && object5 != null && object5 instanceof ContainerContainerDivider && bl2) {
                object4 = ((Component)object5).getParent();
                object3 = null;
                if (object4 instanceof ContainerContainer) {
                    object3 = (ContainerContainer)object4;
                }
                if (object3 != null && ((ContainerContainer)object3).getDockingManager().isDropAllowed(dockableFrame, (Component)object5, -1)) {
                    if (((JideSplitPane)object3).getOrientation() == 1) {
                        n9 = dockableFrame.getDockedWidth();
                        n10 = ((JComponent)object3).getHeight();
                        n7 = ((Component)object5).getX() - n9 / 2;
                        n8 = ((Component)object5).getY();
                    } else {
                        n9 = ((JComponent)object3).getWidth();
                        n10 = dockableFrame.getDockedHeight();
                        n7 = ((Component)object5).getX();
                        n8 = ((Component)object5).getY() - n10 / 2;
                    }
                    object2 = this.calculateContourBounds(new Rectangle(n7, n8, n9, n10), (Component)object3);
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    this.setContourBounds((Rectangle)object2);
                    this.setTabDocking(false);
                    this.setFloating(false);
                    LOGGER_OUTLINE.fine("sideDocking");
                    return;
                }
            } else if (object5 != null && bl2 && (object5 instanceof Workspace || object5 instanceof FrameContainer && ((Component)object5).getParent() instanceof ContainerContainer)) {
                int n11;
                object4 = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), n, n2, (Component)object5);
                boolean bl6 = true;
                if (object5 instanceof FrameContainer && ((FrameContainer)object5).getSelectedFrame() != null && !((FrameContainer)object5).getSelectedFrame().isSideDockAllowed()) {
                    bl6 = false;
                } else if (!this._dockingManager.isSideDockAllowed()) {
                    bl6 = false;
                }
                if (object5 instanceof FrameContainer && bl6 && ((FrameContainer)object5).getUI() instanceof BasicJideTabbedPaneUI) {
                    object2 = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), n, n2, ((BasicJideTabbedPaneUI)((FrameContainer)object5).getUI())._tabScroller.viewport);
                    int n12 = ((BasicJideTabbedPaneUI)((FrameContainer)object5).getUI()).getTabAtLocation(((Point)object2).x, ((Point)object2).y);
                    if ((n12 >= 0 || ((BasicJideTabbedPaneUI)((FrameContainer)object5).getUI()).isEmptyTabArea(((Point)object2).x, ((Point)object2).y)) && this._dockingManager.isDropAllowed(dockableFrame, (Component)object5, 16)) {
                        boolean bl7 = true;
                        if (((Component)serializable3).getParent() != null && ((Component)serializable3).getParent() instanceof FrameContainer && !((FrameContainer)((Component)serializable3).getParent()).isTabShown()) {
                            bl7 = false;
                        }
                        this.setTabHeight(((FrameContainer)((Component)serializable3).getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)((Component)serializable3).getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        serializable = this.calculateTabContourBounds(bl7, (Component)serializable3);
                        this.setContourBounds((Rectangle)serializable);
                        this.setTabDocking(true);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("tabDocking to DockableFrame " + ((DockableFrame)serializable3).getKey());
                        return;
                    }
                }
                int n13 = n11 = bl6 ? DockingUtils.sideOfComponent((Component)object5, ((Point)object4).x, ((Point)object4).y, this.getSensitiveAreaSize(), dockableFrame.isTabDockAllowed()) : 16;
                if (16 == n11 && !dockableFrame.isTabDockAllowed()) {
                    n11 = 32;
                }
                if ((object5 instanceof Workspace || object5 instanceof FrameContainer) && n11 != 32 && (n11 & this.getAttachedDockingManager().getAllowedDockSides()) == 0) {
                    n11 = 32;
                }
                if (object5 instanceof FrameContainer && bl6) {
                    if (n11 == 4 || n11 == 8) {
                        if (((Component)object5).getParent() instanceof ContainerContainer && ((Component)object5).getParent().getParent() instanceof ContainerContainer) {
                            int n14;
                            object = (ContainerContainer)((Component)object5).getParent();
                            serializable2 = (ContainerContainer)((Component)object).getParent();
                            if (((JideSplitPane)object).getOrientation() == 0 && ((JideSplitPane)serializable2).getPaneCount() > 1 && (n14 = DockingUtils.sideOfComponent((Component)object, ((Point)object4).x, ((Point)object4).y, this.getSensitiveAreaSize() / 2, dockableFrame.isTabDockAllowed())) == n11) {
                                object5 = object;
                                this.setAttachedComponent((Component)object5);
                                this.setAttachedDockingManager(((ContainerContainer)object).getDockingManager());
                            }
                        }
                    } else if ((n11 == 1 || n11 == 2) && ((Component)object5).getParent() instanceof ContainerContainer && ((Component)object5).getParent().getParent() instanceof ContainerContainer) {
                        int n15;
                        object = (ContainerContainer)((Component)object5).getParent();
                        serializable2 = (ContainerContainer)((Component)object).getParent();
                        if (((JideSplitPane)object).getOrientation() == 1 && ((JideSplitPane)serializable2).getPaneCount() > 1 && (n15 = DockingUtils.sideOfComponent((Component)object, ((Point)object4).x, ((Point)object4).y, this.getSensitiveAreaSize() / 2, dockableFrame.isTabDockAllowed())) == n11) {
                            object5 = object;
                            this.setAttachedComponent((Component)object5);
                            this.setAttachedDockingManager(((ContainerContainer)object).getDockingManager());
                        }
                    }
                }
                switch (n11) {
                    case 1: {
                        n9 = ((Component)object5).getWidth();
                        int n16 = dockableFrame.getDockedHeight();
                        int n17 = ((Component)object5).getPreferredSize().height;
                        n10 = n17 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == object5 ? n16 : ((Component)object5).getHeight() * n16 / (n17 + n16);
                        n7 = 0;
                        n8 = 0;
                        break;
                    }
                    case 2: {
                        n9 = ((Component)object5).getWidth();
                        int n18 = dockableFrame.getDockedHeight();
                        int n19 = ((Component)object5).getPreferredSize().height;
                        n10 = n19 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == object5 ? n18 : ((Component)object5).getHeight() * n18 / (n19 + n18);
                        n7 = 0;
                        n8 = ((Component)object5).getHeight() - n10;
                        break;
                    }
                    case 8: {
                        int n20 = dockableFrame.getDockedWidth();
                        int n21 = ((Component)object5).getPreferredSize().width;
                        n9 = n21 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == object5 ? n20 : ((Component)object5).getWidth() * n20 / (n21 + n20);
                        n10 = ((Component)object5).getHeight();
                        n7 = 0;
                        n8 = 0;
                        break;
                    }
                    case 4: {
                        int n22 = dockableFrame.getDockedWidth();
                        int n23 = ((Component)object5).getPreferredSize().width;
                        n9 = n23 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == object5 ? n22 : ((Component)object5).getWidth() * n22 / (n23 + n22);
                        n10 = ((Component)object5).getHeight();
                        n7 = ((Component)object5).getWidth() - n9;
                        n8 = 0;
                        break;
                    }
                    case 16: {
                        object = this.getAttachedDockingManager();
                        if (object == null) {
                            object = this.getDockingManager();
                        }
                        if (object.isTabDockAllowed() && object.isEasyTabDock() && object5 instanceof Workspace && ((Workspace)object5).isAcceptDockableFrame() && ((Workspace)object5).getDockingManager().isDropAllowed(dockableFrame, (Component)object5, n11)) {
                            serializable2 = object.createFrameContainer();
                            boolean bl8 = false;
                            this.setTabHeight(((JideTabbedPane)serializable2).getTabHeight());
                            this.setTabSide(((JTabbedPane)serializable2).getTabPlacement());
                            if (!this.isVisible()) {
                                this.setVisible(true);
                            }
                            Rectangle rectangle4 = this.calculateTabContourBounds(bl8, object.getWorkspace());
                            this.setContourBounds(rectangle4);
                            this.setTabDocking(true);
                            this.setFloating(false);
                            LOGGER_OUTLINE.fine("tabDocking to Workspace");
                            return;
                        }
                        if (!object.isTabDockAllowed() || !object.isEasyTabDock() || !(object5 instanceof FrameContainer) || ((FrameContainer)object5).getSelectedFrame() == null || !((FrameContainer)object5).getSelectedFrame().isTabDockAllowed() || !((serializable2 = ((FrameContainer)object5).getSelectedFrame()) instanceof DockableFrame) || !((DockableFrame)(serializable3 = (DockableFrame)serializable2)).getDockingManager().isDropAllowed(dockableFrame, (Component)serializable3, 16)) break;
                        boolean bl9 = true;
                        if (((Component)serializable3).getParent() != null && ((Component)serializable3).getParent() instanceof FrameContainer && !((FrameContainer)((Component)serializable3).getParent()).isTabShown()) {
                            bl9 = false;
                        }
                        this.setTabHeight(((FrameContainer)((Component)serializable3).getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)((Component)serializable3).getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle rectangle5 = this.calculateTabContourBounds(bl9, (Component)serializable3);
                        this.setContourBounds(rectangle5);
                        this.setTabDocking(true);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("tabDocking to DockableFrame " + ((DockableFrame)serializable3).getKey());
                        return;
                    }
                }
                if (n11 != 32 && n11 != 16) {
                    if (object5 instanceof Workspace && ((Workspace)object5).getDockingManager().isDropAllowed(dockableFrame, (Component)object5, n11)) {
                        this.setAttachedSide(n11);
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle rectangle6 = this.calculateContourBounds(new Rectangle(n7, n8, n9, n10), (Component)object5);
                        this.setContourBounds(rectangle6);
                        this.setTabDocking(false);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("sideDocking to Workspace " + n11);
                        return;
                    }
                    if (serializable3 != null && ((DockableFrame)serializable3).getDockingManager().isDropAllowed(dockableFrame, (Component)serializable3, n11)) {
                        this.setAttachedSide(n11);
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle rectangle7 = this.calculateContourBounds(new Rectangle(n7, n8, n9, n10), (Component)object5);
                        this.setContourBounds(rectangle7);
                        this.setTabDocking(false);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("sideDocking to Workspace");
                        return;
                    }
                }
            }
        }
        this.setAttachedComponent(null);
        if (dockableFrame.isFloatable() && this.getDockingManager().isFloatable() && (!this.getDockingManager().isPreserveStateOnDragging() || dockableFrame.isFloated())) {
            cloneable = this.calculateContourBounds(new Rectangle(0, 0, rectangle.width, rectangle.height), n, n2);
            if (this._dockingManager.isWithinFrameBoundsOnDragging() && this._dockingManager.getRootPaneContainer() != null) {
                RootPaneContainer rootPaneContainer = this._dockingManager.getRootPaneContainer();
                Rectangle rectangle8 = rootPaneContainer.getLayeredPane().getBounds();
                if (this.getRelativeContainer() != this._dockingManager.getRootPaneContainer()) {
                    cloneable = SwingUtilities.convertRectangle(this.getRelativeContainer(), (Rectangle)cloneable, rootPaneContainer.getLayeredPane().getParent());
                }
                if (((Rectangle)cloneable).x < rectangle8.x) {
                    ((Rectangle)cloneable).x = rectangle8.x;
                }
                if (((Rectangle)cloneable).y < rectangle8.y) {
                    ((Rectangle)cloneable).y = rectangle8.y;
                }
                if (((Rectangle)cloneable).x > rectangle8.x + rectangle8.width - ((Rectangle)cloneable).width) {
                    ((Rectangle)cloneable).x = rectangle8.x + rectangle8.width - ((Rectangle)cloneable).width;
                }
                if (((Rectangle)cloneable).y > rectangle8.y + rectangle8.height - ((Rectangle)cloneable).height) {
                    ((Rectangle)cloneable).y = rectangle8.y + rectangle8.height - ((Rectangle)cloneable).height;
                }
                if (this.getRelativeContainer() != this._dockingManager.getRootPaneContainer()) {
                    cloneable = SwingUtilities.convertRectangle(rootPaneContainer.getLayeredPane().getParent(), (Rectangle)cloneable, this.getRelativeContainer());
                }
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.setTabDocking(false);
            this.setFloating(true);
            this.setContourBounds((Rectangle)cloneable);
        } else {
            this.setVisible(false);
            this.setTabDocking(false);
            this.setFloating(true);
        }
    }

    @Override
    public void pauseDragFrame() {
        this.setVisible(false);
        this.setAttachedComponent(null);
    }

    @Override
    public void cancelDragFrame() {
        this.setVisible(false);
        this.cleanup();
    }

    @Override
    public void cleanup() {
        if (this.isHeavyweight()) {
            this._fullOutline.dispose();
            this._fullOutline = null;
            this._leftOutline.dispose();
            this._leftOutline = null;
            this._rightOutline.dispose();
            this._rightOutline = null;
            this._topOutline.dispose();
            this._topOutline = null;
            this._bottomOutline.dispose();
            this._bottomOutline = null;
            this._emptyContent.dispose();
            this._emptyContent = null;
        }
        if (this._dockingManager.isUseGlassPaneEnabled() && this.getGlassPane() != null) {
            DockingUtils.clearGlassPaneCursor(this._dockingManager);
        }
        this.hideOutline();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.updateCursor();
        if (!bl && this.isHeavyweight()) {
            this._leftOutline.setVisible(false);
            this._rightOutline.setVisible(false);
            this._topOutline.setVisible(false);
            this._bottomOutline.setVisible(false);
            this._emptyContent.setVisible(false);
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() || this.isHeavyweight() && (this._fullOutline != null && this._fullOutline.isVisible() || this._topOutline != null && this._topOutline.isVisible() || this._bottomOutline != null && this._bottomOutline.isVisible() || this._leftOutline != null && this._leftOutline.isVisible() || this._rightOutline != null && this._rightOutline.isVisible());
    }

    public int getOutlineMode() {
        return this._outlineMode;
    }

    public void setOutlineMode(int n) {
        this._outlineMode = n;
        if (this.isHeavyweight()) {
            this.initOutline();
        }
    }

    @Override
    public Component getGlassPane() {
        return this._glassPane;
    }

    @Override
    public void setGlassPane(Component component) {
        this._glassPane = component;
    }

    public boolean isChangeCursor() {
        return this._changeCursor;
    }

    @Override
    public void setChangeCursor(boolean bl) {
        this._changeCursor = bl;
    }

    @Override
    public void setRelativeXY(double d, double d2) {
        this._relativeX = d;
        this._relativeY = d2;
    }

    @Override
    public void setRootPaneContainer(RootPaneContainer rootPaneContainer) {
        this._rootPaneContainer = rootPaneContainer;
        this._activeLayerPane = this.getRootPaneContainer().getLayeredPane();
        this._relativeContainer = this._activeLayerPane;
        this._glassPane = this.getRootPaneContainer().getGlassPane();
        this._activeLayerPane.add((Component)this, JLayeredPane.DRAG_LAYER);
    }

    private RootPaneContainer getRootPaneContainer() {
        return this._rootPaneContainer;
    }

    private Component getRootPaneContainerAsComponent() {
        return (Component)((Object)this.getRootPaneContainer());
    }

    @Override
    public Rectangle calculateContourBounds(Rectangle rectangle, int n, int n2) {
        rectangle.x = n - (int)(rectangle.getWidth() * this._relativeX);
        rectangle.y = n2 - (int)(rectangle.getHeight() * this._relativeY);
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this.getRootPaneContainerAsComponent(), rectangle, this.getRelativeContainer());
        this._currentMouseX = (int)((double)rectangle2.width * this._relativeX);
        this._currentMouseY = (int)((double)rectangle2.height * this._relativeY);
        return rectangle2;
    }

    @Override
    public Rectangle calculateContourBounds(Rectangle rectangle, Component component) {
        return SwingUtilities.convertRectangle(component, rectangle, this.getRelativeContainer());
    }

    @Override
    public Rectangle getContourBounds() {
        return this.getBounds();
    }

    @Override
    public void setContourBounds(Rectangle rectangle) {
        this.setBounds(rectangle);
    }

    public int getSensitiveAreaSize() {
        return this._sensitiveAreaSize;
    }

    public void setSensitiveAreaSize(int n) {
        this._sensitiveAreaSize = n;
    }

    public int getOutsideSensitiveAreaSize() {
        return this._outsideSensitiveAreaSize;
    }

    public void setOutsideSensitiveAreaSize(int n) {
        this._outsideSensitiveAreaSize = n;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
        this.setAllowDocking(this._dockingManager.isAutoDockingAsDefault());
        this.setOutlineMode(this._dockingManager.getOutlineMode());
        this.setSensitiveAreaSize(this._dockingManager.getSensitiveAreaSize());
        this.setOutsideSensitiveAreaSize(this._dockingManager.getOutsideSensitiveAreaSize());
        this.setRootPaneContainer(this._dockingManager.getRootPaneContainer());
        this.checkParent();
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this._activeLayerPane;
    }

    private Rectangle calculateTabContourBounds(boolean bl, Component component) {
        Rectangle rectangle;
        switch (this.getTabSide()) {
            case 1: {
                rectangle = this.calculateContourBounds(new Rectangle(0, bl ? -this.getTabHeight() : 0, component.getBounds().width, component.getBounds().height + (bl ? this.getTabHeight() : 0)), component);
                break;
            }
            case 2: {
                rectangle = this.calculateContourBounds(new Rectangle(bl ? -this.getTabHeight() : 0, 0, component.getBounds().width + (bl ? this.getTabHeight() : 0), component.getBounds().height), component);
                break;
            }
            case 4: {
                rectangle = this.calculateContourBounds(new Rectangle(0, 0, component.getBounds().width + (bl ? this.getTabHeight() : 0), component.getBounds().height), component);
                break;
            }
            default: {
                rectangle = this.calculateContourBounds(new Rectangle(0, 0, component.getBounds().width, component.getBounds().height + (bl ? this.getTabHeight() : 0)), component);
            }
        }
        return rectangle;
    }

    private void hideOutline() {
        this._activeLayerPane.remove(this);
    }

    private void showOutline(JLayeredPane jLayeredPane) {
        if (jLayeredPane == null || !jLayeredPane.isShowing()) {
            return;
        }
        if (this._activeLayerPane != null && this._activeLayerPane != jLayeredPane) {
            this._activeLayerPane.repaint();
            this._activeLayerPane = jLayeredPane;
            this._activeLayerPane.add((Component)this, JLayeredPane.DRAG_LAYER);
            this.setRelativeContainer(this._activeLayerPane);
        }
    }

    class OutlineHW
    extends JWindow {
        public OutlineHW() {
            this.initialize();
        }

        public OutlineHW(Window window) {
            super(window);
            this.initialize();
        }

        private void initialize() {
            this.setVisible(false);
            Object object = UIManager.getDefaults().get("Contour.opacity");
            if (object instanceof Double) {
                object = Float.valueOf(((Double)object).floatValue());
            } else if (!(object instanceof Float)) {
                object = Float.valueOf(0.75f);
            }
            JideSwingUtilities.setWindowOpacity(this, ((Float)object).floatValue());
            this.setBackground(OutlineContour.this._lineColor);
            Color color = UIDefaultsLookup.getColor("Contour.background");
            if (color != null) {
                this.getContentPane().setBackground(color);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            OutlineContour.this.paintOutline(graphics, false);
        }
    }

    class Outline
    extends JWindow {
        public Outline() {
            this.setVisible(false);
            this.setBackground(OutlineContour.this._lineColor);
        }

        public Outline(Window window) {
            super(window);
            this.setVisible(false);
            this.setBackground(OutlineContour.this._lineColor);
        }

        @Override
        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(OutlineContour.this._lineColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color);
        }
    }

    private class Content
    extends JWindow {
        public Content() {
            this.setVisible(false);
            JideSwingUtilities.setWindowOpacity(this, 0.1f);
        }

        public Content(Window window) {
            super(window);
            this.setVisible(false);
            JideSwingUtilities.setWindowOpacity(this, 0.1f);
        }
    }
}

