/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.PreviousState;
import java.awt.Rectangle;
import java.io.Serializable;

public class DockContext
implements Serializable {
    public static final int MODE_FLOATABLE = 1;
    public static final int MODE_AUTOHIDABLE = 2;
    public static final int MODE_DOCKABLE = 4;
    public static final int MODE_HIDABLE = 8;
    public static final int MODE_ALL = 15;
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_AUTOHIDE = 2;
    public static final int STATE_AUTOHIDE_SHOWING = 3;
    public static final int STATE_FRAMEDOCKED = 4;
    public static final String[] STATE_NAMES = new String[]{"HIDE", "FLOAT", "AUTOHIDE", "AUTOHIDE_ACTIVE", "DOCK"};
    private int _initMode = 4;
    private int _currentMode = 4;
    private int _canMode = 15;
    public static final int DOCK_SIDE_NORTH = 1;
    public static final int DOCK_SIDE_SOUTH = 2;
    public static final int DOCK_SIDE_EAST = 4;
    public static final int DOCK_SIDE_WEST = 8;
    public static final int DOCK_SIDE_CENTER = 16;
    public static final int DOCK_SIDE_UNKNOWN = 32;
    public static final int DOCK_SIDE_HORIZONTAL = 3;
    public static final int DOCK_SIDE_VERTICAL = 12;
    public static final int DOCK_SIDE_ALL = 15;
    public static final int DOCK_SIDE_ALL_AND_CENTER = 31;
    public static final String[] SIDE_NAMES = new String[]{"NORTH", "SOUTH", "EAST", "WEST", "CENTER", "FLOAT", "UNKNOWN"};
    private int _initSide = 4;
    private int _initIndex;
    private boolean _initPosition = true;
    private int _currentDockSide = 2;
    private Rectangle _undockedBounds;
    private int _dockedWidth = 0;
    private int _dockedHeight = 0;
    private int _autohideWidth = 200;
    private int _autohideHeight = 200;
    private int _initAutohideWidth = 200;
    private int _initAutohideHeight = 200;
    private Rectangle _initUndockedBounds;
    private int _dockID;
    private PreviousState _hiddenPreviousState;
    private PreviousState _closePreviousState;
    private PreviousState _dockPreviousState;
    private PreviousState _floatPreviousState;
    private PreviousState _autohidePreviousState;
    private PreviousState _availablePreviousState;
    private PreviousState _maximizePreviousState;
    private boolean _available = true;

    public int getInitMode() {
        return this._initMode;
    }

    public void setInitMode(int n) {
        if (n > 4 || n < -4) {
            throw new IllegalArgumentException(n + " is an invalid init mode for the setInitMode method. Valid modes are STATE_FRAMEDOCKED, STATE_FLOATING, STATE_AUTOHIDE, STATE_AUTOHIDE_SHOWING, STATE_HIDDEN and their negative values.");
        }
        this._initMode = n;
    }

    public int getCurrentMode() {
        if (this._currentMode == -1) {
            return this._initMode;
        }
        return this._currentMode;
    }

    public boolean isHidden() {
        return this._currentMode == 0;
    }

    public boolean isDocked() {
        return this._currentMode == 4;
    }

    public boolean isFloated() {
        return this._currentMode == 1;
    }

    public boolean isAutohide() {
        return this._currentMode == 2;
    }

    public boolean isAutohideShowing() {
        return this._currentMode == 3;
    }

    public void setCurrentMode(int n) {
        this._currentMode = n;
    }

    public int getInitSide() {
        return this._initSide;
    }

    public void setInitSide(int n) {
        if (n != 4 && n != 8 && n != 2 && n != 1 && n != 16) {
            throw new IllegalArgumentException(n + " is an invalid init side for the setInitSide method. Valid sides are DOCK_SIDE_EAST, DOCK_SIDE_WEST, DOCK_SIDE_SOUTH, DOCK_SIDE_NORTH and DOCK_SIDE_CENTER.");
        }
        this._initSide = n;
    }

    public boolean isInitPosition() {
        return this._initPosition;
    }

    public void setInitPosition(boolean bl) {
        this._initPosition = bl;
    }

    public int getInitIndex() {
        return this._initIndex;
    }

    public void setInitIndex(int n) {
        this._initIndex = n;
    }

    public int getCurrentDockSide() {
        return this._currentDockSide;
    }

    public void setCurrentDockSide(int n) {
        this._currentDockSide = n;
    }

    public Rectangle getUndockedBounds() {
        return this._undockedBounds;
    }

    public void setUndockedBounds(Rectangle rectangle) {
        this._undockedBounds = rectangle;
    }

    public int getAutohideWidth() {
        return this._autohideWidth;
    }

    public void setAutohideWidth(int n) {
        this._autohideWidth = n;
    }

    public int getAutohideHeight() {
        return this._autohideHeight;
    }

    public void setAutohideHeight(int n) {
        this._autohideHeight = n;
    }

    public int getDockedWidth() {
        return this._dockedWidth;
    }

    public void setDockedWidth(int n) {
        this._dockedWidth = n;
    }

    public int getDockedHeight() {
        return this._dockedHeight;
    }

    public void setDockedHeight(int n) {
        this._dockedHeight = n;
    }

    public PreviousState getHiddenPreviousState() {
        return this._hiddenPreviousState;
    }

    public void setHiddenPreviousState(PreviousState previousState) {
        this._hiddenPreviousState = previousState;
    }

    public PreviousState getClosePreviousState() {
        return this._closePreviousState;
    }

    public void setClosePreviousState(PreviousState previousState) {
        this._closePreviousState = previousState;
    }

    public PreviousState getDockPreviousState() {
        return this._dockPreviousState;
    }

    public void setDockPreviousState(PreviousState previousState) {
        this._dockPreviousState = previousState;
    }

    public PreviousState getFloatPreviousState() {
        return this._floatPreviousState;
    }

    public void setFloatPreviousState(PreviousState previousState) {
        this._floatPreviousState = previousState;
    }

    public PreviousState getAutohidePreviousState() {
        return this._autohidePreviousState;
    }

    public void setAutohidePreviousState(PreviousState previousState) {
        this._autohidePreviousState = previousState;
    }

    public static String getDockSideName(int n) {
        return SIDE_NAMES[(int)(Math.log(n) / Math.log(2.0))];
    }

    public static String getStateName(int n) {
        return STATE_NAMES[n];
    }

    public int getDockID() {
        return this._dockID;
    }

    public void setDockID(DockingManager dockingManager, int n) {
        this._dockID = n;
        if (dockingManager != null) {
            DockID.getInstance(dockingManager).reserveID(this._dockID);
        }
    }

    public void resetDockID(DockingManager dockingManager) {
        int n = DockID.getInstance(dockingManager).getID(this.getDockID());
        this.setDockID(dockingManager, n);
    }

    public int getCanMode() {
        return this._canMode;
    }

    public void setCanMode(int n) {
        this._canMode = n;
    }

    public boolean isDockable() {
        return (this.getCanMode() & 4) != 0;
    }

    public void setDockable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 4);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFB);
        }
    }

    public boolean isHidable() {
        return (this.getCanMode() & 8) != 0;
    }

    public void setHidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 8);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFF7);
        }
    }

    public boolean isAutohidable() {
        return (this.getCanMode() & 2) != 0;
    }

    public void setAutohidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 2);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFD);
        }
    }

    public boolean isFloatable() {
        return (this.getCanMode() & 1) != 0;
    }

    public void setFloatable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 1);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFE);
        }
    }

    public PreviousState getAvailablePreviousState() {
        return this._availablePreviousState;
    }

    public void setAvailablePreviousState(PreviousState previousState) {
        this._availablePreviousState = previousState;
    }

    public boolean isAvailable() {
        return this._available;
    }

    public void setAvailable(boolean bl) {
        this._available = bl;
    }

    public PreviousState getMaximizedPreviousState() {
        return this._maximizePreviousState;
    }

    public void setMaximizedPreviousState(PreviousState previousState) {
        this._maximizePreviousState = previousState;
    }

    public Object clone() throws CloneNotSupportedException {
        DockContext dockContext = new DockContext();
        dockContext.setInitSide(this.getInitSide());
        dockContext.setInitMode(this.getInitMode());
        dockContext.setInitIndex(this.getInitIndex());
        dockContext.setUndockedBounds(this.getUndockedBounds());
        dockContext.setAutohideHeight(this.getAutohideHeight());
        dockContext.setAutohideWidth(this.getAutohideWidth());
        dockContext.setCanMode(this.getCanMode());
        dockContext.setCurrentDockSide(this.getCurrentDockSide());
        dockContext.setCurrentMode(this.getCurrentMode());
        dockContext.setDockedHeight(this.getDockedHeight());
        dockContext.setDockedWidth(this.getDockedWidth());
        return dockContext;
    }

    int getInitAutohideWidth() {
        return this._initAutohideWidth;
    }

    void setInitAutohideWidth(int n) {
        this._initAutohideWidth = n;
    }

    int getInitAutohideHeight() {
        return this._initAutohideHeight;
    }

    void setInitAutohideHeight(int n) {
        this._initAutohideHeight = n;
    }

    Rectangle getInitUndockedBounds() {
        return this._initUndockedBounds;
    }

    void setInitUndockedBounds(Rectangle rectangle) {
        this._initUndockedBounds = rectangle;
    }
}

