/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.AbstractMergePane;
import com.jidesoft.diff.CodeEditorCharSequence;
import com.jidesoft.diff.CodeEditorDiffMarkerArea;
import com.jidesoft.diff.CodeEditorDiffPane;
import com.jidesoft.diff.Conflict;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffMargin;
import com.jidesoft.diff.DiffRowNumberMargin;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.LineHighlightPainter;
import com.jidesoft.diff.Merge;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.DocumentListenerEx;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.marker.MarkerArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;

public class CodeEditorMergePane
extends AbstractMergePane {
    protected final int GAP_TITLE_PANE = 2;
    protected CodeEditor _fromEditor;
    protected CodeEditor _toEditor;
    protected CodeEditor _otherEditor;
    private boolean _suppressDocumentEvent = false;
    private DiffDivider _fromToDivider;
    private DiffDivider _toOtherDivider;
    protected DiffMargin _fromDiffMargin;
    protected DiffMargin _otherDiffMargin;
    private JComponent _fromTitle;
    private JComponent _toTitle;
    private JComponent _otherTitle;
    private DiffRowNumberMargin _fromDiffLineNumberMargin;
    private DiffRowNumberMargin _toDiffLineNumberMargin;
    private DiffRowNumberMargin _otherDiffLineNumberMargin;
    private List<Conflict> _conflicts;
    private List<Difference> _fromToDifferences;
    private List<Difference> _toOtherDifferences;
    private boolean _readOnly = false;
    private CodeEditorDiffMarkerArea _otherMarkerArea;
    private CodeEditorDiffMarkerArea _fromMarkerArea;
    private boolean _ignoreLeadingTrailingSpaces = false;
    private boolean _ignoreFromScrollEvent = false;
    private boolean _ignoreToFromScrollEvent = false;
    private boolean _ignoreToOtherScrollEvent = false;
    private boolean _ignoreOtherScrollEvent = false;
    private boolean _merged = false;

    public CodeEditorMergePane() {
        super("", "", "");
    }

    public CodeEditorMergePane(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    public JComponent createPane(Object object, int n) {
        if (n == 0) {
            this._fromEditor = this.createEditor(n);
            this._fromEditor.setEditable(false);
            this._fromEditor.setText(object == null ? null : object.toString());
            CodeEditorRowMarginSupport codeEditorRowMarginSupport = new CodeEditorRowMarginSupport(this._fromEditor);
            this._fromDiffMargin = new DiffMargin(codeEditorRowMarginSupport, true);
            this._fromDiffMargin.setMerge(true);
            this._fromDiffLineNumberMargin = new DiffRowNumberMargin(new CodeEditorRowMarginSupport(this._fromEditor));
            this._fromMarkerArea = new CodeEditorDiffMarkerArea(this._fromEditor);
            this._fromMarkerArea.setChangedColor(this.getChangedColor());
            this._fromMarkerArea.setInsertedColor(this.getInsertedColor());
            this._fromMarkerArea.setDeletedColor(this.getDeletedColor());
            this._fromMarkerArea.setConflictedColor(this.getConflictedColor());
            this._fromEditor.setMarkerArea(this._fromMarkerArea);
            this._fromEditor.getMarginArea().removeAll();
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffMargin);
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffLineNumberMargin);
            this._fromEditor.swap();
            this.customizeEditor(this._fromEditor, n);
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add(this._fromEditor);
            jPanel.add((Component)this._fromMarkerArea, "Before");
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add(jPanel);
            this._fromTitle = this.createFromTitle();
            jPanel2.add((Component)this._fromTitle, "First");
            return jPanel2;
        }
        if (n == 1) {
            this._toEditor = this.createEditor(n);
            this._toEditor.setText(object == null ? null : object.toString());
            this._toDiffLineNumberMargin = new DiffRowNumberMargin(new CodeEditorRowMarginSupport(this._toEditor));
            this._toEditor.getMarginArea().removeAll();
            this._toEditor.getMarginArea().addMarginComponent(this._toDiffLineNumberMargin);
            this.customizeEditor(this._toEditor, n);
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add(this._toEditor);
            JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
            jPanel3.add(jPanel);
            this._toTitle = this.createToTitle();
            jPanel3.add((Component)this._toTitle, "First");
            return jPanel3;
        }
        this._otherEditor = this.createEditor(n);
        this._otherEditor.setEditable(false);
        this._otherEditor.setText(object == null ? null : object.toString());
        CodeEditorRowMarginSupport codeEditorRowMarginSupport = new CodeEditorRowMarginSupport(this._otherEditor);
        this._otherDiffMargin = new DiffMargin(codeEditorRowMarginSupport, false);
        this._otherDiffMargin.setMerge(true);
        this._otherDiffMargin.setOpposite(true);
        this._otherDiffLineNumberMargin = new DiffRowNumberMargin(new CodeEditorRowMarginSupport(this._otherEditor));
        this._otherMarkerArea = new CodeEditorDiffMarkerArea(this._otherEditor);
        this._otherMarkerArea.setChangedColor(this.getChangedColor());
        this._otherMarkerArea.setInsertedColor(this.getInsertedColor());
        this._otherMarkerArea.setDeletedColor(this.getDeletedColor());
        this._otherMarkerArea.setConflictedColor(this.getConflictedColor());
        this._otherEditor.setMarkerArea(this._otherMarkerArea);
        this._otherEditor.getMarginArea().removeAll();
        this._otherEditor.getMarginArea().addMarginComponent(this._otherDiffLineNumberMargin);
        this._otherEditor.getMarginArea().addMarginComponent(this._otherDiffMargin);
        this.customizeEditor(this._otherEditor, n);
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add(this._otherEditor);
        jPanel.add((Component)this._otherMarkerArea, "After");
        JPanel jPanel4 = new JPanel(new BorderLayout(2, 2));
        jPanel4.add(jPanel);
        this._otherTitle = this.createOtherTitle();
        jPanel4.add((Component)this._otherTitle, "First");
        return jPanel4;
    }

    @Override
    public DiffDivider createDivider(int n) {
        return new DiffDivider();
    }

    @Override
    protected void customizeDivider(DiffDivider diffDivider, int n) {
        if (n == 0) {
            this._fromToDivider = diffDivider;
            this._fromToDivider.setChangedColor(this.getChangedColor());
            this._fromToDivider.setInsertedColor(this.getDeletedColor());
            this._fromToDivider.setDeletedColor(this.getInsertedColor());
            this._fromToDivider.setConflictedColor(this.getConflictedColor());
            this._fromToDivider.setFirstConverter(this.createFromRowConverter());
            this._fromToDivider.setSecondConverter(this.createToRowConverter());
            this._fromToDivider.setOpposite(false);
            this._fromToDivider.addPropertyChangeListener("selectedDifference", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (CodeEditorMergePane.this._fromEditor != null) {
                        CodeEditorMergePane.this._fromEditor.repaint();
                    }
                    if (CodeEditorMergePane.this._toEditor != null) {
                        CodeEditorMergePane.this._toEditor.repaint();
                    }
                }
            });
        } else {
            this._toOtherDivider = diffDivider;
            this._toOtherDivider.setChangedColor(this.getChangedColor());
            this._toOtherDivider.setInsertedColor(this.getInsertedColor());
            this._toOtherDivider.setDeletedColor(this.getDeletedColor());
            this._toOtherDivider.setConflictedColor(this.getConflictedColor());
            this._toOtherDivider.setFirstConverter(this.createToRowConverter());
            this._toOtherDivider.setSecondConverter(this.createOtherRowConverter());
            this._toOtherDivider.setOpposite(true);
            this._toOtherDivider.addPropertyChangeListener("selectedDifference", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (CodeEditorMergePane.this._toEditor != null) {
                        CodeEditorMergePane.this._toEditor.repaint();
                    }
                    if (CodeEditorMergePane.this._otherEditor != null) {
                        CodeEditorMergePane.this._otherEditor.repaint();
                    }
                }
            });
        }
    }

    @Override
    public void setChangedColor(Color color) {
        super.setChangedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setChangedColor(this.getChangedColor());
        }
        if (this._toOtherDivider != null) {
            this._toOtherDivider.setChangedColor(this.getChangedColor());
        }
        if (this._fromMarkerArea != null) {
            this._fromMarkerArea.setChangedColor(this.getChangedColor());
        }
        if (this._otherMarkerArea != null) {
            this._otherMarkerArea.setChangedColor(this.getChangedColor());
        }
    }

    @Override
    public void setInsertedColor(Color color) {
        super.setInsertedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setInsertedColor(this.getInsertedColor());
        }
        if (this._toOtherDivider != null) {
            this._toOtherDivider.setInsertedColor(this.getInsertedColor());
        }
        if (this._fromMarkerArea != null) {
            this._fromMarkerArea.setInsertedColor(this.getInsertedColor());
        }
        if (this._otherMarkerArea != null) {
            this._otherMarkerArea.setInsertedColor(this.getInsertedColor());
        }
    }

    @Override
    public void setDeletedColor(Color color) {
        super.setDeletedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setDeletedColor(this.getDeletedColor());
        }
        if (this._toOtherDivider != null) {
            this._toOtherDivider.setDeletedColor(this.getDeletedColor());
        }
        if (this._fromMarkerArea != null) {
            this._fromMarkerArea.setDeletedColor(this.getDeletedColor());
        }
        if (this._otherMarkerArea != null) {
            this._otherMarkerArea.setDeletedColor(this.getDeletedColor());
        }
    }

    @Override
    public void setConflictedColor(Color color) {
        super.setConflictedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setConflictedColor(this.getConflictedColor());
        }
        if (this._toOtherDivider != null) {
            this._toOtherDivider.setConflictedColor(this.getConflictedColor());
        }
        if (this._fromMarkerArea != null) {
            this._fromMarkerArea.setConflictedColor(this.getConflictedColor());
        }
        if (this._otherMarkerArea != null) {
            this._otherMarkerArea.setConflictedColor(this.getConflictedColor());
        }
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n) {
        super.adjustDividerOffset(diffDivider, n);
        if (n == 0) {
            FontMetrics fontMetrics = this._fromEditor.getPainter().getFontMetrics();
            int n2 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
            diffDivider.adjustFirstVerticalOffset(n2 + 1, 2 + this._fromTitle.getPreferredSize().height);
            fontMetrics = this._toEditor.getPainter().getFontMetrics();
            n2 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
            diffDivider.adjustSecondVerticalOffset(n2 + 1, 2 + this._toTitle.getPreferredSize().height);
        } else {
            FontMetrics fontMetrics = this._toEditor.getPainter().getFontMetrics();
            int n3 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
            diffDivider.adjustSecondVerticalOffset(n3 + 1, 2 + this._toTitle.getPreferredSize().height);
            fontMetrics = this._otherEditor.getPainter().getFontMetrics();
            n3 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
            diffDivider.adjustFirstVerticalOffset(n3 + 1, 2 + this._otherTitle.getPreferredSize().height);
        }
    }

    protected JComponent createFromTitle() {
        return new JLabel();
    }

    protected JComponent createToTitle() {
        return new JLabel();
    }

    protected JComponent createOtherTitle() {
        return new JLabel();
    }

    public String getFromTitle() {
        if (this._fromTitle instanceof JLabel) {
            return ((JLabel)this._fromTitle).getText();
        }
        return null;
    }

    public void setFromTitle(String string) {
        if (this._fromTitle instanceof JLabel) {
            ((JLabel)this._fromTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
        }
    }

    public String getToTitle() {
        if (this._toTitle instanceof JLabel) {
            return ((JLabel)this._toTitle).getText();
        }
        return null;
    }

    public void setToTitle(String string) {
        if (this._toTitle instanceof JLabel) {
            ((JLabel)this._toTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
            this.adjustDividerOffset(this._toOtherDivider, 0);
        }
    }

    public String getOtherTitle() {
        if (this._otherTitle instanceof JLabel) {
            return ((JLabel)this._otherTitle).getText();
        }
        return null;
    }

    public void setOtherTitle(String string) {
        if (this._otherTitle instanceof JLabel) {
            ((JLabel)this._otherTitle).setText(string);
            this.adjustDividerOffset(this._toOtherDivider, 0);
        }
    }

    protected CodeEditor createEditor(int n) {
        return this.createEditor();
    }

    protected CodeEditor createEditor() {
        return new CodeEditor();
    }

    protected void customizeEditor(CodeEditor codeEditor, int n) {
        codeEditor.setLineHighlight(false);
        MarkerArea markerArea = codeEditor.getMarkerArea();
        if (markerArea != null) {
            markerArea.getMarkerEye().setVisible(false);
        }
    }

    public CodeEditor getFromEditor() {
        return this._fromEditor;
    }

    public CodeEditor getToEditor() {
        return this._toEditor;
    }

    public CodeEditor getOtherEditor() {
        return this._otherEditor;
    }

    public CharSequence[] getFromItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._fromEditor.getLineCount()];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = this.createLineCharSequence(this._fromEditor, i);
        }
        return charSequenceArray;
    }

    public CharSequence[] getToItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._toEditor.getLineCount()];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = this.createLineCharSequence(this._toEditor, i);
        }
        return charSequenceArray;
    }

    public CharSequence[] getOtherItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._otherEditor.getLineCount()];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = this.createLineCharSequence(this._otherEditor, i);
        }
        return charSequenceArray;
    }

    protected CharSequence createLineCharSequence(CodeEditor codeEditor, int n) {
        return new CodeEditorCharSequence(codeEditor, n, this.isIgnoreLeadingTrailingSpaces());
    }

    public void setFromText(String string) {
        try {
            this._suppressDocumentEvent = true;
            this._fromEditor.setText(string);
        }
        finally {
            this._suppressDocumentEvent = false;
        }
    }

    public String getFromText() {
        return this._fromEditor.getText();
    }

    public void setToText(String string) {
        try {
            this._suppressDocumentEvent = true;
            this._toEditor.setText(string);
        }
        finally {
            this._suppressDocumentEvent = false;
        }
    }

    public String getToText() {
        return this._toEditor.getText();
    }

    public void setOtherText(String string) {
        try {
            this._suppressDocumentEvent = true;
            this._otherEditor.setText(string);
        }
        finally {
            this._suppressDocumentEvent = false;
        }
    }

    public String getOtherText() {
        return this._otherEditor.getText();
    }

    protected DiffDivider.RowConverter createFromRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n) {
                return CodeEditorMergePane.this._fromEditor.lineToY(n);
            }
        };
    }

    protected DiffDivider.RowConverter createToRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n) {
                return CodeEditorMergePane.this._toEditor.lineToY(n);
            }
        };
    }

    protected DiffDivider.RowConverter createOtherRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n) {
                return CodeEditorMergePane.this._otherEditor.lineToY(n);
            }
        };
    }

    protected void synchronizeViewport(DiffDivider diffDivider, CodeEditor codeEditor, CodeEditor codeEditor2, boolean bl) {
        if (bl) {
            int n = codeEditor.getFirstLine();
            int n2 = diffDivider.getSecondMatchLine(codeEditor.getVisibleLines(), n);
            codeEditor2.setFirstLine(n2);
        } else {
            int n = codeEditor2.getFirstLine();
            int n3 = diffDivider.getFirstMatchLine(codeEditor2.getVisibleLines(), n);
            codeEditor.setFirstLine(n3);
        }
    }

    private Difference getMatchingDifference(int n, int n2) {
        if (this._conflicts != null && this._conflicts.size() > 0 && n2 >= 0) {
            int n3;
            int n4;
            Conflict conflict = this._conflicts.get(0);
            Conflict conflict2 = this._conflicts.get(this._conflicts.size() - 1);
            int n5 = n == 0 ? conflict.getDeletedStart() : (n4 = n == 1 ? conflict.getAddedStart() : conflict.getDeleted2Start());
            int n6 = n == 0 ? conflict2.getDeletedStart() : (n == 1 ? conflict2.getAddedStart() : conflict2.getDeleted2Start());
            int n7 = n3 = n == 0 ? conflict2.getDeletedEnd() : conflict2.getAddedEnd();
            if (n2 >= n4 && (n2 <= n6 || n3 >= 0 && n2 <= n3)) {
                int n8 = 0;
                int n9 = this._conflicts.size();
                int n10 = n9 / 2;
                while (n8 < n9) {
                    int n11;
                    int n12;
                    Conflict conflict3 = this._conflicts.get(n10);
                    int n13 = n == 0 ? conflict3.getDeletedStart() : (n12 = n == 1 ? conflict3.getAddedStart() : conflict3.getDeleted2Start());
                    int n14 = n == 0 ? conflict3.getDeletedEnd() : (n11 = n == 1 ? conflict3.getAddedEnd() : conflict3.getDeleted2End());
                    if (n2 == n12 || n11 >= 0 && n2 >= n12 && n2 <= n11) {
                        return conflict3;
                    }
                    if (n2 > n12) {
                        n8 = n10 + 1;
                    } else {
                        n9 = n10;
                    }
                    n10 = n8 + (n9 - n8) / 2;
                }
            }
        }
        return null;
    }

    void updateSelectedDifference(int n) {
        CodeEditor codeEditor = n == 0 ? this._fromEditor : (n == 2 ? this._otherEditor : this._toEditor);
        int n2 = codeEditor.getCaretPosition();
        int n3 = codeEditor.getLineNumber(n2);
        Difference difference = this.getMatchingDifference(n, n3);
        this._fromToDivider.setSelectedDifference(difference);
        this._toOtherDivider.setSelectedDifference(difference);
        this.updateActions(n);
    }

    @Override
    protected void updateActions(int n) {
        if (this._conflicts == null || this._conflicts.size() == 0) {
            ((Action)this._actions.get("first")).setEnabled(false);
            ((Action)this._actions.get("next")).setEnabled(false);
            ((Action)this._actions.get("previous")).setEnabled(false);
            ((Action)this._actions.get("last")).setEnabled(false);
            ((Action)this._actions.get("accept")).setEnabled(false);
        } else {
            int n2 = 0;
            for (Difference difference2 : this._conflicts) {
                if (!difference2.isConflicted()) continue;
                ++n2;
            }
            int n3 = this._conflicts == null || this._conflicts.size() == 0 ? 0 : this._conflicts.size() - n2;
            ((Action)this._actions.get("accept")).setEnabled(n3 > 0);
            if (n == -1) {
                ((Action)this._actions.get("first")).setEnabled(true);
                ((Action)this._actions.get("next")).setEnabled(true);
                ((Action)this._actions.get("previous")).setEnabled(true);
                ((Action)this._actions.get("last")).setEnabled(true);
            } else if (this._fromToDifferences.size() == 0 && n == 0 || this._toOtherDifferences.size() == 0 && n == 2) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(false);
            } else {
                int n4;
                int n5;
                Difference difference;
                int n6;
                Difference difference2;
                difference2 = this._fromToDivider.getSelectedDifference();
                if (difference2 != null && (n6 = this._conflicts.indexOf(difference2)) >= 0) {
                    if (n6 == 0) {
                        ((Action)this._actions.get("first")).setEnabled(false);
                        ((Action)this._actions.get("next")).setEnabled(this._conflicts.size() > 1);
                        ((Action)this._actions.get("previous")).setEnabled(false);
                        ((Action)this._actions.get("last")).setEnabled(this._conflicts.size() > 1);
                    } else if (n6 == this._conflicts.size() - 1) {
                        ((Action)this._actions.get("first")).setEnabled(this._conflicts.size() > 1);
                        ((Action)this._actions.get("next")).setEnabled(false);
                        ((Action)this._actions.get("previous")).setEnabled(this._conflicts.size() > 1);
                        ((Action)this._actions.get("last")).setEnabled(false);
                    } else {
                        ((Action)this._actions.get("first")).setEnabled(true);
                        ((Action)this._actions.get("next")).setEnabled(true);
                        ((Action)this._actions.get("previous")).setEnabled(true);
                        ((Action)this._actions.get("last")).setEnabled(true);
                    }
                    return;
                }
                CodeEditor codeEditor = n == 0 ? this._fromEditor : (n == 2 ? this._otherEditor : this._toEditor);
                int n7 = codeEditor.getCaretPosition();
                int n8 = codeEditor.getLineNumber(n7);
                Conflict conflict = this._conflicts.get(0);
                Conflict conflict2 = this._conflicts.get(this._conflicts.size() - 1);
                Difference difference3 = this._fromToDifferences.size() == 0 ? null : this._fromToDifferences.get(0);
                Difference difference4 = this._toOtherDifferences.size() == 0 ? null : this._toOtherDifferences.get(0);
                Difference difference5 = this._fromToDifferences.size() == 0 ? null : this._fromToDifferences.get(this._fromToDifferences.size() - 1);
                Difference difference6 = difference = this._toOtherDifferences.size() == 0 ? null : this._toOtherDifferences.get(this._toOtherDifferences.size() - 1);
                int n9 = n == 0 ? difference3.getDeletedStart() : (n5 = n == 2 ? difference4.getDeletedStart() : conflict.getAddedStart());
                int n10 = n == 0 ? difference5.getDeletedStart() : (n4 = n == 2 ? difference.getDeletedStart() : conflict2.getAddedStart());
                if (n4 >= codeEditor.getLineCount()) {
                    --n4;
                }
                if (n8 < n5) {
                    ((Action)this._actions.get("first")).setEnabled(false);
                    ((Action)this._actions.get("next")).setEnabled(true);
                    ((Action)this._actions.get("previous")).setEnabled(false);
                    ((Action)this._actions.get("last")).setEnabled(true);
                } else if (n8 == n5) {
                    ((Action)this._actions.get("first")).setEnabled(false);
                    ((Action)this._actions.get("next")).setEnabled(n8 != n4 && (n == 2 ? this._toOtherDifferences.size() != 0 : (n == 0 ? this._fromToDifferences.size() != 0 : this._conflicts.size() != 0)));
                    ((Action)this._actions.get("previous")).setEnabled(false);
                    ((Action)this._actions.get("last")).setEnabled(n8 != n4 && (n == 2 ? this._toOtherDifferences.size() != 0 : (n == 0 ? this._fromToDifferences.size() != 0 : this._conflicts.size() != 0)));
                } else if (n8 > n5 && n8 < n4) {
                    ((Action)this._actions.get("first")).setEnabled(true);
                    ((Action)this._actions.get("next")).setEnabled(true);
                    ((Action)this._actions.get("previous")).setEnabled(true);
                    ((Action)this._actions.get("last")).setEnabled(true);
                } else if (n8 == n4) {
                    ((Action)this._actions.get("first")).setEnabled(n == 2 ? this._toOtherDifferences.size() != 0 : (n == 0 ? this._fromToDifferences.size() != 0 : this._conflicts.size() != 0));
                    ((Action)this._actions.get("next")).setEnabled(false);
                    ((Action)this._actions.get("previous")).setEnabled(n == 2 ? this._toOtherDifferences.size() != 0 : (n == 0 ? this._fromToDifferences.size() != 0 : this._conflicts.size() != 0));
                    ((Action)this._actions.get("last")).setEnabled(false);
                } else if (n8 > n4) {
                    ((Action)this._actions.get("first")).setEnabled(true);
                    ((Action)this._actions.get("next")).setEnabled(false);
                    ((Action)this._actions.get("previous")).setEnabled(true);
                    ((Action)this._actions.get("last")).setEnabled(false);
                }
            }
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this._fromEditor.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorMergePane.this._ignoreFromScrollEvent) {
                    return;
                }
                CodeEditorMergePane.this._ignoreToFromScrollEvent = true;
                try {
                    CodeEditorMergePane.this.synchronizeViewport(CodeEditorMergePane.this._fromToDivider, CodeEditorMergePane.this._fromEditor, CodeEditorMergePane.this._toEditor, true);
                }
                finally {
                    CodeEditorMergePane.this._ignoreToFromScrollEvent = false;
                }
                CodeEditorMergePane.this._fromToDivider.repaint();
            }
        });
        this._toEditor.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!CodeEditorMergePane.this._ignoreToFromScrollEvent) {
                    CodeEditorMergePane.this._ignoreFromScrollEvent = true;
                    try {
                        CodeEditorMergePane.this.synchronizeViewport(CodeEditorMergePane.this._fromToDivider, CodeEditorMergePane.this._fromEditor, CodeEditorMergePane.this._toEditor, false);
                    }
                    finally {
                        CodeEditorMergePane.this._ignoreFromScrollEvent = false;
                    }
                }
                if (!CodeEditorMergePane.this._ignoreToOtherScrollEvent) {
                    CodeEditorMergePane.this._ignoreOtherScrollEvent = true;
                    try {
                        CodeEditorMergePane.this.synchronizeViewport(CodeEditorMergePane.this._toOtherDivider, CodeEditorMergePane.this._toEditor, CodeEditorMergePane.this._otherEditor, true);
                    }
                    finally {
                        CodeEditorMergePane.this._ignoreOtherScrollEvent = false;
                    }
                }
                CodeEditorMergePane.this._fromToDivider.repaint();
                CodeEditorMergePane.this._toOtherDivider.repaint();
            }
        });
        this._otherEditor.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorMergePane.this._ignoreOtherScrollEvent) {
                    return;
                }
                CodeEditorMergePane.this._ignoreToOtherScrollEvent = true;
                try {
                    CodeEditorMergePane.this.synchronizeViewport(CodeEditorMergePane.this._toOtherDivider, CodeEditorMergePane.this._toEditor, CodeEditorMergePane.this._otherEditor, false);
                }
                finally {
                    CodeEditorMergePane.this._ignoreToOtherScrollEvent = false;
                }
                CodeEditorMergePane.this._toOtherDivider.repaint();
            }
        });
        this._fromEditor.getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorMergePane.this.updateSelectedDifference(0);
            }
        });
        this._toEditor.getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorMergePane.this.updateSelectedDifference(1);
            }
        });
        this._otherEditor.getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorMergePane.this.updateSelectedDifference(2);
            }
        });
        final Timer timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeEditorMergePane.this.merge();
            }
        });
        this._toEditor.getDocument().addDocumentListener(new DocumentListenerEx(){
            private transient DocumentEvent _remove = null;

            private void startTimer() {
                if (timer.isRunning()) {
                    timer.restart();
                } else {
                    timer.setRepeats(false);
                    timer.start();
                }
            }

            private void documentChange(DocumentEvent documentEvent, boolean bl) {
                if (!CodeEditorMergePane.this._suppressDocumentEvent) {
                    List<Conflict> list;
                    List<Conflict> list2 = list = CodeEditorMergePane.this._conflicts == null ? null : CodeEditorMergePane.this.acceptDocumentChange(CodeEditorMergePane.this._conflicts, documentEvent);
                    if (list == null) {
                        this.startTimer();
                    } else if (bl) {
                        CodeEditorMergePane.this.conflictsUpdated(list);
                    } else {
                        CodeEditorMergePane.this._conflicts = list;
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (CodeEditorMergePane.this._merged) {
                    this.documentChange(documentEvent, true);
                }
            }

            @Override
            public void removingUpdate(DocumentEvent documentEvent) {
                if (CodeEditorMergePane.this._merged) {
                    this.documentChange(documentEvent, false);
                    this._remove = documentEvent;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (CodeEditorMergePane.this._merged) {
                    if (documentEvent == this._remove && !CodeEditorMergePane.this._suppressDocumentEvent) {
                        CodeEditorMergePane.this.conflictsUpdated(CodeEditorMergePane.this._conflicts);
                    }
                    if (documentEvent != this._remove) {
                        this.startTimer();
                    }
                    this._remove = null;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (CodeEditorMergePane.this._merged) {
                    this.documentChange(documentEvent, true);
                }
            }
        });
    }

    private String getChangeToolTip(int n, int n2) {
        if (n2 == -1 || n == n2) {
            return MessageFormat.format(this.getResourceString("DiffPane.lineChanged"), n + 1);
        }
        return MessageFormat.format(this.getResourceString("DiffPane.linesChanged"), n + 1, n2 + 1);
    }

    @Deprecated
    protected String[] splitString(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        String[] stringArray = string.split(string2);
        if (this.isIgnoreLeadingTrailingSpaces()) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    @Deprecated
    protected List<Conflict> merge(String string, String string2, String string3) {
        String[] stringArray = this.splitString(string, TextUtils.getLineBreak(this._fromEditor.getLineBreakStyle()));
        String[] stringArray2 = this.splitString(string2, TextUtils.getLineBreak(this._toEditor.getLineBreakStyle()));
        String[] stringArray3 = this.splitString(string3, TextUtils.getLineBreak(this._otherEditor.getLineBreakStyle()));
        Merge<String> merge = new Merge<String>(stringArray, stringArray2, stringArray3);
        return merge.merge();
    }

    protected Merge<CharSequence> createMerge() {
        return new Merge<CharSequence>(this.getFromItems(), this.getToItems(), this.getOtherItems());
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
        this._fromDiffMargin.setEditable(!this._readOnly);
        this._otherDiffMargin.setEditable(!this._readOnly);
        this._toEditor.setEditable(!this._readOnly);
    }

    protected List<Difference> getFromToDifferences(List<Conflict> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        if (list != null) {
            for (Conflict conflict : list) {
                Difference difference = this.getFromToDifference(conflict);
                if (difference.getDeletedEnd() == -1 && difference.getDeletedStart() == -1) continue;
                arrayList.add(difference);
            }
        }
        return arrayList;
    }

    private Difference getFromToDifference(Conflict conflict) {
        return new Difference(conflict.getDeletedStart(), conflict.getDeletedEnd(), conflict.getAddedStart(), conflict.getAddedEnd(), conflict.isConflicted());
    }

    protected List<Difference> getToOtherDifferences(List<Conflict> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        if (list != null) {
            for (Conflict conflict : list) {
                Difference difference = this.getToOtherDifference(conflict);
                if (difference.getDeletedEnd() == -1 && difference.getDeletedStart() == -1) continue;
                arrayList.add(difference);
            }
        }
        return arrayList;
    }

    private Difference getToOtherDifference(Conflict conflict) {
        return new Difference(conflict.getDeleted2Start(), conflict.getDeleted2End(), conflict.getAddedStart(), conflict.getAddedEnd(), conflict.isConflicted());
    }

    public List<Conflict> getConflicts() {
        return this._conflicts;
    }

    protected List<Conflict> acceptConflict(List<Conflict> list, Difference difference) {
        boolean bl = false;
        int n = 0;
        ArrayList<Conflict> arrayList = new ArrayList<Conflict>();
        for (Conflict conflict : list) {
            if (conflict.getAddedStart() == difference.getAddedStart() && conflict.getAddedEnd() == difference.getAddedEnd()) {
                bl = true;
                if (difference.getAddedEnd() == -1) {
                    n = -(difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                    continue;
                }
                if (difference.getDeletedEnd() == -1) {
                    n = difference.getAddedEnd() - difference.getAddedStart() + 1;
                    continue;
                }
                n = difference.getAddedEnd() - difference.getAddedStart() + 1 - (difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                continue;
            }
            if (bl && n != 0) {
                conflict.adjustAdded(-n);
            }
            arrayList.add(conflict);
        }
        return arrayList;
    }

    protected List<Conflict> ignoreConflict(List<Conflict> list, Difference difference) {
        ArrayList<Conflict> arrayList = new ArrayList<Conflict>();
        for (Conflict conflict : list) {
            if (conflict.getAddedStart() == difference.getAddedStart() && conflict.getAddedEnd() == difference.getAddedEnd()) continue;
            arrayList.add(conflict);
        }
        return arrayList;
    }

    protected List<Conflict> acceptDocumentChange(List<Conflict> list, DocumentEvent documentEvent) {
        ArrayList<Conflict> arrayList = new ArrayList<Conflict>();
        int n = this._toEditor.getLineNumber(documentEvent.getOffset());
        int n2 = documentEvent.getType() == DocumentEvent.EventType.CHANGE ? n : this._toEditor.getLineNumber(documentEvent.getOffset() + documentEvent.getLength());
        int n3 = documentEvent.getType() == DocumentEvent.EventType.REMOVE ? -(n2 - n) : n2 - n;
        for (Conflict conflict : list) {
            if (!(conflict.getAddedEnd() != -1 ? conflict.getAddedEnd() < n : conflict.getAddedStart() < n)) {
                if (conflict.getAddedStart() > n2) {
                    conflict.adjustAdded(n3);
                } else {
                    return null;
                }
            }
            arrayList.add(conflict);
        }
        return arrayList;
    }

    public List<Conflict> merge() {
        this._merged = true;
        Merge<CharSequence> merge = this.createMerge();
        List<Conflict> list = merge.merge();
        this.conflictsUpdated(list);
        return list;
    }

    public void clearMerge() {
        this._merged = false;
        this.conflictsUpdated(null);
    }

    private void conflictsUpdated(final List<Conflict> list) {
        this._conflicts = list;
        this.updateActions(this._fromEditor.hasFocus() ? 0 : (this._toEditor.hasFocus() ? 1 : (this._otherEditor.hasFocus() ? 2 : -1)));
        this.updateMessage();
        this._fromToDifferences = this.getFromToDifferences(list);
        this._toOtherDifferences = this.getToOtherDifferences(list);
        this._fromToDivider.setDifferences(this._fromToDifferences);
        this._toOtherDivider.setDifferences(this._toOtherDifferences);
        HashMap<Integer, Difference> hashMap = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, Difference> hashMap2 = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashMap<Integer, Difference> hashMap3 = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        this._fromEditor.getFixedHighlighter().removeAllHighlights();
        this._toEditor.getFixedHighlighter().removeAllHighlights();
        this._otherEditor.getFixedHighlighter().removeAllHighlights();
        this._fromEditor.getMarkerModel().clearMarkers();
        this._fromEditor.getMarkerModel().setAdjusting(true);
        this._otherEditor.getMarkerModel().clearMarkers();
        this._otherEditor.getMarkerModel().setAdjusting(true);
        if (list != null) {
            for (Conflict conflict : list) {
                int n = conflict.getAddedStart();
                int n2 = conflict.getAddedEnd();
                int n3 = conflict.getDeletedStart();
                int n4 = conflict.getDeletedEnd();
                int n5 = conflict.getDeleted2Start();
                int n6 = conflict.getDeleted2End();
                if (n4 == -1) {
                    hashMap.put(n3, conflict);
                } else {
                    hashMap.put(n3, this.getFromToDifference(conflict));
                    hashSet.add(n4 + 1);
                }
                if (n2 == -1) {
                    hashMap2.put(n, this.getFromToDifference(conflict));
                } else {
                    hashMap2.put(n, this.getFromToDifference(conflict));
                    hashSet2.add(n2 + 1);
                }
                if (n6 == -1) {
                    hashMap3.put(n5, this.getToOtherDifference(conflict));
                } else {
                    hashMap3.put(n5, this.getToOtherDifference(conflict));
                    hashSet3.add(n6 + 1);
                }
                Color color = Color.GRAY;
                try {
                    int n7 = n3 == -1 ? 0 : this._fromEditor.getLineStartOffset(n3);
                    int n8 = this._fromEditor.getLineStartOffset(n4 + 1);
                    int n9 = n == -1 ? 0 : this._toEditor.getLineStartOffset(n);
                    int n10 = this._toEditor.getLineStartOffset(n2 + 1);
                    int n11 = n5 == -1 ? 0 : this._otherEditor.getLineStartOffset(n5);
                    int n12 = this._otherEditor.getLineStartOffset(n6 + 1);
                    if (n3 != -1 && n4 != -1) {
                        CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n7, n8, color);
                        this._fromEditor.getFixedHighlighter().addHighlight(n7, n8, new LineHighlightPainter(conflict.isConflicted() ? this._conflictedColor : (n2 == -1 ? this._insertedColor : this._changedColor), this._fromToDivider, conflict));
                        this._fromEditor.getMarkerModel().addMarker(n7, n8, conflict.isConflicted() ? 127 : (n2 == -1 ? 125 : 124), "");
                    } else if (n3 != -1) {
                        CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n7, n7, color);
                        this._fromEditor.getMarkerModel().addMarker(n7, n7, conflict.isConflicted() ? 127 : 125, "");
                    }
                    if (n != -1 && n2 != -1) {
                        CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n9, n10, color);
                        this._toEditor.getFixedHighlighter().addHighlight(n9, n10, new LineHighlightPainter(conflict.isConflicted() ? this._conflictedColor : (n4 == -1 && n6 == -1 ? this._deletedColor : this._changedColor), this._fromToDivider, conflict));
                    } else if (n != -1) {
                        CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n9, n9, color);
                    }
                    if (n5 != -1 && n6 != -1) {
                        CodeEditorDiffPane.addSeparatorHighlightPainter(this._otherEditor, n11, n12, color);
                        this._otherEditor.getFixedHighlighter().addHighlight(n11, n12, new LineHighlightPainter(conflict.isConflicted() ? this._conflictedColor : (n2 == -1 ? this._insertedColor : this._changedColor), this._toOtherDivider, conflict));
                        this._otherEditor.getMarkerModel().addMarker(n11, n12, conflict.isConflicted() ? 127 : (n2 == -1 ? 125 : 124), this.getChangeToolTip(n5, n6));
                        continue;
                    }
                    if (n5 == -1) continue;
                    CodeEditorDiffPane.addSeparatorHighlightPainter(this._otherEditor, n11, n11, color);
                    this._otherEditor.getMarkerModel().addMarker(n11, n11 + 1, conflict.isConflicted() ? 127 : 125, this.getChangeToolTip(n, n2));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        this._fromEditor.getMarkerModel().setAdjusting(false);
        this._otherEditor.getMarkerModel().setAdjusting(false);
        this._fromDiffMargin.setDifferences(hashMap, hashSet);
        this._fromDiffLineNumberMargin.setDifferences(hashMap, hashSet);
        this._toDiffLineNumberMargin.setDifferences(hashMap2, hashSet2);
        this._otherDiffMargin.setDifferences(hashMap3, hashSet3);
        this._otherDiffLineNumberMargin.setDifferences(hashMap3, hashSet3);
        this._fromDiffMargin.setHandler(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n) {
                List<Conflict> list2;
                boolean bl;
                boolean bl2 = bl = n < 16;
                if (bl) {
                    if (difference.getDeletedEnd() == -1) {
                        CodeEditorMergePane.this.delete(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, false);
                    } else {
                        CodeEditorMergePane.this.replace(CodeEditorMergePane.this._fromEditor, difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                    }
                    list2 = CodeEditorMergePane.this.acceptConflict(list, difference);
                } else {
                    list2 = CodeEditorMergePane.this.ignoreConflict(list, difference);
                }
                CodeEditorMergePane.this.conflictsUpdated(list2);
            }
        });
        this._otherDiffMargin.setHandler(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n) {
                List<Conflict> list2;
                boolean bl;
                boolean bl2 = bl = n >= 14;
                if (bl) {
                    if (difference.getDeletedEnd() == -1) {
                        CodeEditorMergePane.this.delete(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, false);
                        list2 = CodeEditorMergePane.this.acceptConflict(list, difference);
                    } else {
                        CodeEditorMergePane.this.replace(CodeEditorMergePane.this._otherEditor, difference.getAddedStart(), difference.getAddedEnd() == -1 ? -1 : difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                        list2 = CodeEditorMergePane.this.acceptConflict(list, difference);
                    }
                } else {
                    list2 = CodeEditorMergePane.this.ignoreConflict(list, difference);
                }
                CodeEditorMergePane.this.conflictsUpdated(list2);
            }
        });
    }

    private void updateMessage() {
        int n;
        int n2 = 0;
        if (this._conflicts != null) {
            for (Conflict conflict : this._conflicts) {
                if (!conflict.isConflicted()) continue;
                ++n2;
            }
        }
        int n3 = n = this._conflicts == null || this._conflicts.size() == 0 ? 0 : this._conflicts.size() - n2;
        Object object = n == 0 ? this.getResourceString("DiffPane.noChange") : (n == 1 ? this.getResourceString("DiffPane.oneChange") : MessageFormat.format(this.getResourceString("DiffPane.hasChanges"), n));
        object = n2 == 0 ? (String)object + ". " + this.getResourceString("DiffPane.noConflict") : (n2 == 1 ? (String)object + ". " + this.getResourceString("DiffPane.oneConflict") : (String)object + ". " + MessageFormat.format(this.getResourceString("DiffPane.hasConflicts"), n2));
        this.setMessage((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int n, int n2, boolean bl) {
        if (n2 == -1) {
            return;
        }
        int n3 = this._toEditor.getLineStartOffset(n);
        int n4 = this._toEditor.getLineStartOffset(n + n2);
        this._suppressDocumentEvent = true;
        try {
            if (n4 > this._toEditor.getDocumentLength()) {
                if (n > 0) {
                    n3 = this._toEditor.getLineEndOffset(n - 1);
                }
                n4 = this._toEditor.getDocumentLength();
            }
            this._toEditor.getDocument().remove(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this._suppressDocumentEvent = false;
        }
        if (bl && this._merged) {
            this.merge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CodeEditor codeEditor, int n, int n2, int n3, boolean bl) {
        int n4 = this._toEditor.getLineStartOffset(n);
        int n5 = codeEditor.getLineStartOffset(n2);
        int n6 = codeEditor.getLineStartOffset(n2 + n3);
        String string = codeEditor.getText(n5, n6 - n5);
        this._suppressDocumentEvent = true;
        try {
            this._toEditor.getDocument().insertString(n4, string, null);
            this._toEditor.select(n4);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            this._suppressDocumentEvent = false;
        }
        if (bl && this._merged) {
            this.merge();
        }
    }

    public void replace(CodeEditor codeEditor, int n, int n2, int n3, int n4, boolean bl) {
        this.delete(n, n2, false);
        this.insert(codeEditor, n, n3, n4, false);
        if (bl && this._merged) {
            this.merge();
        }
    }

    private static int binarySearchAdded(List<? extends Difference> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >>> 1;
            Difference difference = list.get(n5);
            int n6 = difference.getAddedStart() < n ? -1 : (n4 = difference.getAddedStart() > n ? 1 : 0);
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    private static int binarySearchDeleted(List<? extends Difference> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >>> 1;
            Difference difference = list.get(n5);
            int n6 = difference.getDeletedStart() < n ? -1 : (n4 = difference.getDeletedStart() > n ? 1 : 0);
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    @Override
    protected void firstChange() {
        super.firstChange();
        if (this._fromEditor.hasFocus()) {
            this._fromEditor.select(this._fromEditor.getLineStartOffset(this._fromToDifferences.get(0).getDeletedStart()));
        } else if (this._otherEditor.hasFocus()) {
            this._otherEditor.select(this._otherEditor.getLineStartOffset(this._toOtherDifferences.get(0).getDeletedStart()));
        } else {
            if (!this._toEditor.hasFocus()) {
                this._toEditor.requestFocusInWindow();
            }
            this._toEditor.select(this._toEditor.getLineStartOffset(this._conflicts.get(0).getAddedStart()));
        }
        this._fromToDivider.setSelectedDifference(this._conflicts.get(0));
        this._toOtherDivider.setSelectedDifference(this._conflicts.get(0));
    }

    @Override
    protected void previousChange() {
        super.previousChange();
        if (this._conflicts != null && this._conflicts.size() > 0) {
            if (this._fromEditor.hasFocus()) {
                int n;
                int n2;
                int n3;
                int n4 = this._fromToDivider.getSelectedDifference() == null ? ((n3 = CodeEditorMergePane.binarySearchDeleted(this._fromToDifferences, n2 = this._fromEditor.getLineNumber(n = this._fromEditor.getCaretPosition()))) < 0 ? Math.abs(n3) - 2 : Math.abs(n3) - 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) - 1;
                if (n4 >= 0 && n4 < this._fromToDifferences.size()) {
                    Difference difference = this._fromToDifferences.get(n4);
                    this._fromEditor.select(this._fromEditor.getLineStartOffset(difference.getDeletedStart()));
                    this._fromToDivider.setSelectedDifference(this._conflicts.get(n4));
                    this._toOtherDivider.setSelectedDifference(this._conflicts.get(n4));
                }
            } else if (this._otherEditor.hasFocus()) {
                int n;
                int n5;
                int n6;
                int n7 = this._fromToDivider.getSelectedDifference() == null ? ((n6 = CodeEditorMergePane.binarySearchDeleted(this._toOtherDifferences, n5 = this._otherEditor.getLineNumber(n = this._otherEditor.getCaretPosition()))) < 0 ? Math.abs(n6) - 2 : Math.abs(n6) - 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) - 1;
                if (n7 >= 0 && n7 < this._toOtherDifferences.size()) {
                    Difference difference = this._toOtherDifferences.get(n7);
                    this._otherEditor.select(this._otherEditor.getLineStartOffset(difference.getDeletedStart()));
                    this._fromToDivider.setSelectedDifference(this._conflicts.get(n7));
                    this._toOtherDivider.setSelectedDifference(this._conflicts.get(n7));
                }
            } else {
                int n;
                int n8;
                int n9;
                int n10;
                if (!this._toEditor.hasFocus()) {
                    this._toEditor.requestFocusInWindow();
                }
                if ((n10 = this._fromToDivider.getSelectedDifference() == null ? ((n9 = CodeEditorMergePane.binarySearchAdded(this._conflicts, n8 = this._toEditor.getLineNumber(n = this._toEditor.getCaretPosition()))) < 0 ? Math.abs(n9) - 2 : Math.abs(n9) - 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) - 1) >= 0 && n10 < this._conflicts.size()) {
                    Difference difference = this._conflicts.get(n10);
                    this._toEditor.select(this._toEditor.getLineStartOffset(difference.getAddedStart()));
                    this._fromToDivider.setSelectedDifference(difference);
                    this._toOtherDivider.setSelectedDifference(difference);
                }
            }
        }
    }

    @Override
    protected void nextChange() {
        super.nextChange();
        if (this._conflicts != null && this._conflicts.size() > 0) {
            if (this._fromEditor.hasFocus()) {
                int n;
                int n2;
                int n3;
                int n4 = this._fromToDivider.getSelectedDifference() == null ? ((n3 = CodeEditorMergePane.binarySearchDeleted(this._fromToDifferences, n2 = this._fromEditor.getLineNumber(n = this._fromEditor.getCaretPosition()))) < 0 ? Math.abs(n3) - 1 : Math.abs(n3) + 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) + 1;
                if (n4 >= 0 && n4 < this._fromToDifferences.size()) {
                    Difference difference = this._fromToDifferences.get(n4);
                    this._fromEditor.select(this._fromEditor.getLineStartOffset(difference.getDeletedStart()));
                    this._fromToDivider.setSelectedDifference(this._conflicts.get(n4));
                    this._toOtherDivider.setSelectedDifference(this._conflicts.get(n4));
                }
            } else if (this._otherEditor.hasFocus()) {
                int n;
                int n5;
                int n6;
                int n7 = this._fromToDivider.getSelectedDifference() == null ? ((n6 = CodeEditorMergePane.binarySearchDeleted(this._toOtherDifferences, n5 = this._otherEditor.getLineNumber(n = this._otherEditor.getCaretPosition()))) < 0 ? Math.abs(n6) - 1 : Math.abs(n6) + 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) + 1;
                if (n7 >= 0 && n7 < this._toOtherDifferences.size()) {
                    Difference difference = this._toOtherDifferences.get(n7);
                    this._otherEditor.select(this._otherEditor.getLineStartOffset(difference.getDeletedStart()));
                    this._fromToDivider.setSelectedDifference(this._conflicts.get(n7));
                    this._toOtherDivider.setSelectedDifference(this._conflicts.get(n7));
                }
            } else {
                int n;
                int n8;
                int n9;
                int n10;
                if (!this._toEditor.hasFocus()) {
                    this._toEditor.requestFocusInWindow();
                }
                if ((n10 = this._fromToDivider.getSelectedDifference() == null ? ((n9 = CodeEditorMergePane.binarySearchAdded(this._conflicts, n8 = this._toEditor.getLineNumber(n = this._toEditor.getCaretPosition()))) < 0 ? Math.abs(n9) - 1 : Math.abs(n9) + 1) : this._conflicts.indexOf(this._fromToDivider.getSelectedDifference()) + 1) >= 0 && n10 < this._conflicts.size()) {
                    Difference difference = this._conflicts.get(n10);
                    this._toEditor.select(this._toEditor.getLineStartOffset(difference.getAddedStart()));
                    this._fromToDivider.setSelectedDifference(difference);
                    this._toOtherDivider.setSelectedDifference(difference);
                }
            }
        }
    }

    @Override
    protected void lastChange() {
        super.lastChange();
        if (this._conflicts != null && this._conflicts.size() > 0) {
            if (this._fromEditor.hasFocus()) {
                this._fromEditor.select(this._fromEditor.getLineStartOffset(this._fromToDifferences.get(this._fromToDifferences.size() - 1).getDeletedStart()));
            } else if (this._otherEditor.hasFocus()) {
                this._otherEditor.select(this._otherEditor.getLineStartOffset(this._toOtherDifferences.get(this._toOtherDifferences.size() - 1).getDeletedStart()));
            } else {
                if (!this._toEditor.hasFocus()) {
                    this._toEditor.requestFocusInWindow();
                }
                this._toEditor.select(this._toEditor.getLineStartOffset(this._conflicts.get(this._conflicts.size() - 1).getAddedStart()));
            }
            this._fromToDivider.setSelectedDifference(this._conflicts.get(this._conflicts.size() - 1));
            this._toOtherDivider.setSelectedDifference(this._conflicts.get(this._conflicts.size() - 1));
        }
    }

    @Override
    public void acceptNonConflicts() {
        super.acceptNonConflicts();
        List<Conflict> list = this._conflicts;
        for (int i = this._conflicts.size() - 1; i >= 0; --i) {
            Difference difference;
            boolean bl;
            Conflict conflict = this._conflicts.get(i);
            if (conflict.isConflicted()) continue;
            boolean bl2 = bl = conflict.getDeleted2Start() == -1;
            if (bl) {
                difference = this.getFromToDifference(conflict);
                if (difference.getAddedEnd() == -1) {
                    this.insert(this._fromEditor, difference.getAddedStart(), difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                    list = this.acceptConflict(list, difference);
                    continue;
                }
                this.replace(this._fromEditor, difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                list = this.acceptConflict(list, difference);
                continue;
            }
            difference = this.getToOtherDifference(conflict);
            if (difference.getAddedEnd() == -1) {
                this.insert(this._otherEditor, difference.getAddedStart(), difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                list = this.acceptConflict(list, difference);
                continue;
            }
            this.replace(this._otherEditor, difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
            list = this.acceptConflict(list, difference);
        }
        this.conflictsUpdated(list);
    }

    public boolean isConflicted() {
        return Conflict.isConflicted(this._conflicts);
    }

    public boolean isIgnoreLeadingTrailingSpaces() {
        return this._ignoreLeadingTrailingSpaces;
    }

    public void setIgnoreLeadingTrailingSpaces(boolean bl) {
        this._ignoreLeadingTrailingSpaces = bl;
    }
}

