/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.TableModelCache;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3405605430548602851L;
    private Class[] _columnClasses;
    private String[] _columnNames;
    protected int _recordCount;
    protected transient int _currentRow = -1;
    protected TableModelCache _cache;
    protected boolean _forwardOnly = false;
    protected ResultSet _resultSet;
    private boolean _updatable = false;
    protected static final Logger LOGGER = Logger.getLogger(ResultSetTableModel.class.getName());

    public ResultSetTableModel(ResultSet resultSet) throws SQLException {
        this._resultSet = resultSet;
        this.initDatabase();
    }

    public ResultSetTableModel(ResultSet resultSet, int n) throws SQLException {
        this._resultSet = resultSet;
        this._recordCount = n;
        this.initDatabase();
    }

    private void initDatabase() throws SQLException {
        this.refreshData();
    }

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    private int internalGetColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this._columnClasses[n];
    }

    @Override
    public int getRowCount() {
        return this._recordCount;
    }

    public void invalidateCache(int n) {
        this._cache.invalidateCache(n);
    }

    public void invalidateCache() {
        this._cache.invalidateCache();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._cache.isCachedValueValid(n, n2)) {
            return this._cache.getValueAt(n, n2);
        }
        try {
            if (this.isForwardOnly()) {
                if (this._currentRow == -1) {
                    this._resultSet.next();
                }
                if (this._currentRow <= n) {
                    for (int i = this._currentRow; i <= n; ++i) {
                        for (int j = 0; j < this.internalGetColumnCount(); ++j) {
                            this._cache.setValueAt(this._resultSet.getObject(j + 1), i, j);
                        }
                        this._resultSet.next();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("next " + this._currentRow);
                        }
                        ++this._currentRow;
                    }
                }
            } else {
                if (n - this._currentRow != 1) {
                    this._resultSet.absolute(n + 1);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("jump " + n);
                    }
                } else {
                    this._resultSet.next();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("next " + n);
                    }
                }
                for (int i = 0; i < this.internalGetColumnCount(); ++i) {
                    this._cache.setValueAt(this._resultSet.getObject(i + 1), n, i);
                }
                this._currentRow = n;
            }
            return this._cache.getValueAt(n, n2);
        }
        catch (SQLException sQLException) {
            LOGGER.severe(sQLException.getLocalizedMessage());
            return null;
        }
    }

    public void refreshData() throws SQLException {
        this.setUpdatable(this._resultSet != null && this._resultSet.getConcurrency() == 1008);
        this.setForwardOnly(this._resultSet == null || this._resultSet.getType() == 1003);
        int n = this._resultSet.getMetaData().getColumnCount();
        this._columnNames = new String[n];
        this._columnClasses = new Class[n];
        for (int i = 0; i < this._columnNames.length; ++i) {
            this._columnNames[i] = this._resultSet.getMetaData().getColumnName(i + 1);
            try {
                this._columnClasses[i] = Class.forName(this._resultSet.getMetaData().getColumnClassName(i + 1));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._columnClasses[i] = Object.class;
            }
        }
        this._cache = new TableModelCache();
        try {
            this._resultSet.last();
            this._recordCount = this._resultSet.getRow();
            this._resultSet.first();
            this._currentRow = 0;
        }
        catch (SQLException sQLException) {
            this.cacheResultSet();
        }
        this._cache.setRowCount(this._recordCount);
        this._cache.setColumnCount(this._columnNames.length);
        this.fireTableDataChanged();
    }

    private void cacheResultSet() {
        this._cache.setMaximumCachedRows(-1);
        int n = 0;
        try {
            boolean bl;
            while (bl = this._resultSet.next()) {
                for (int i = 0; i < this.internalGetColumnCount(); ++i) {
                    this._cache.setValueAt(this._resultSet.getObject(i + 1), n, i);
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._currentRow = n;
        this._recordCount = n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isUpdatable();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            if (!this.isForwardOnly()) {
                ResultSet resultSet = this.getResultSet();
                resultSet.absolute(n + 1);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("jump " + n);
                }
                resultSet.updateObject(n2 + 1, object);
                resultSet.updateRow();
                this._cache.setValueAt(object, n, n2);
                this._currentRow = n;
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.severe(sQLException.getLocalizedMessage());
        }
    }

    public void setUpdatable(boolean bl) {
        this._updatable = bl;
    }

    public boolean isUpdatable() {
        return this._updatable;
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public boolean isForwardOnly() {
        return this._forwardOnly;
    }

    public void setForwardOnly(boolean bl) {
        this._forwardOnly = bl;
    }

    public void close() throws SQLException {
        if (this._resultSet != null) {
            this._resultSet.close();
        }
    }

    public int getMaximumCachedRows() {
        return this._cache.getMaximumCachedRows();
    }

    public void setMaximumCachedRows(int n) {
        this._cache.setMaximumCachedRows(n);
    }
}

