/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.DashboardResource;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPaletteButton;
import com.jidesoft.dashboard.GadgetPaletteInstaller;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GadgetPalette
extends JPanel
implements GadgetListener,
PropertyChangeListener {
    public static final String CONTEXT_BUTTON_ADD = "GadgetPalette.add";
    public static final String CONTEXT_BUTTON_DONE = "GadgetPalette.done";
    public static final String CONTEXT_BUTTON_DESCRIPTION = "GadgetPalette.description";
    private ThemePainter _painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    protected ButtonGroup _buttonGroup;
    private GadgetManager _manager;
    private GadgetPaletteInstaller _installer;
    protected JComponent _status;
    protected Container _gadgetList;
    private ChangeListener _buttonChangeListener;

    public GadgetPalette(GadgetManager gadgetManager, GadgetPaletteInstaller gadgetPaletteInstaller) {
        this._manager = gadgetManager;
        this._manager.addGadgetListener(this);
        this._manager.addPropertyChangeListener(this);
        this._installer = gadgetPaletteInstaller;
        this._buttonGroup = new ButtonGroup();
        Container container = this.createGadgetButtonContainer();
        this.recreateGadgetButtons();
        this._status = this.createDescriptionLabel();
        JPanel jPanel = this.createDescriptionPanel(this._status);
        this.setLayout(new BorderLayout());
        this.add(container);
        if (jPanel != null) {
            this.add((Component)jPanel, "Last");
        }
        this.updateOpaque();
    }

    protected void updateOpaque() {
        JideSwingUtilities.setOpaqueRecursively(this, false);
    }

    protected JComponent createDescriptionLabel() {
        return new JLabel(this.getResourceString("GadgetPalette.hint"));
    }

    protected Container createGadgetButtonContainer() {
        this._gadgetList = new JPanel(new GridLayout(1, 0, 4, 4));
        JPanel jPanel = JideSwingUtilities.createCenterPanel(this._gadgetList);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SimpleScrollPane simpleScrollPane = new SimpleScrollPane(jPanel){

            @Override
            protected AbstractButton createScrollButton(int n) {
                AbstractButton abstractButton = GadgetPalette.this.createScrollButton(n);
                if (abstractButton != null) {
                    return abstractButton;
                }
                return super.createScrollButton(n);
            }
        };
        simpleScrollPane.setRepeatDelay(100);
        simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return simpleScrollPane;
    }

    public void setButtonLayout(LayoutManager layoutManager) {
        if (layoutManager != this._gadgetList.getLayout()) {
            this._gadgetList.setLayout(layoutManager);
            this.recreateGadgetButtons();
        }
    }

    protected void recreateGadgetButtons() {
        Component[] componentArray = this._gadgetList.getComponents();
        Object[] objectArray = componentArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Component component = objectArray[i];
            if (!(component instanceof AbstractButton)) continue;
            this.uncustomizeButton((AbstractButton)component);
            this._buttonGroup.remove((AbstractButton)component);
        }
        this._gadgetList.removeAll();
        for (Object object : objectArray = this._manager.getGadgets()) {
            Gadget gadget = this._manager.getGadget((String)object);
            AbstractButton abstractButton = this.createButton(gadget);
            this.customizeButton(abstractButton);
            this._gadgetList.add(abstractButton);
            this._buttonGroup.add(abstractButton);
        }
        this.revalidate();
        this.repaint();
    }

    protected JPanel createDescriptionPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 0, 6));
        jPanel.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(this._painter.getControlDk(), 1, 1), BorderFactory.createEmptyBorder(2, 10, 2, 10)));
        StyledLabel styledLabel = new StyledLabel(this.getResourceString(CONTEXT_BUTTON_DESCRIPTION));
        styledLabel.addStyleRange(new StyleRange(1));
        styledLabel.setName(CONTEXT_BUTTON_DESCRIPTION);
        jPanel.add(styledLabel);
        jPanel.add(component, "vary");
        JideButton jideButton = new JideButton(new AbstractAction(this.getResourceString(CONTEXT_BUTTON_ADD)){
            private static final long serialVersionUID = -6789710982445459742L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Enumeration<AbstractButton> enumeration = GadgetPalette.this._buttonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (abstractButton.getModel() != GadgetPalette.this._buttonGroup.getSelection()) continue;
                    if (!(abstractButton instanceof GadgetPaletteButton)) break;
                    GadgetPaletteButton gadgetPaletteButton = (GadgetPaletteButton)abstractButton;
                    gadgetPaletteButton.getGadget().getGadgetManager().showGadget(gadgetPaletteButton.getGadget());
                    break;
                }
            }
        });
        jideButton.setName(CONTEXT_BUTTON_ADD);
        jPanel.add(jideButton);
        JideButton jideButton2 = new JideButton(new AbstractAction(this.getResourceString(CONTEXT_BUTTON_DONE)){
            private static final long serialVersionUID = 4836290543086434967L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GadgetPalette.this.getInstaller().hidePalette();
            }
        });
        jideButton2.setName(CONTEXT_BUTTON_DONE);
        jPanel.add(jideButton2);
        return jPanel;
    }

    protected AbstractButton createScrollButton(int n) {
        return null;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintBackground(graphics);
    }

    protected void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this._painter != null) {
            this._painter.fillBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0, this._painter.getControlDk());
        }
        JideSwingUtilities.fillGradient(graphics2D, new Rectangle(0, 0, this.getWidth(), 3), new Color(255, 255, 255, 128), this._painter.getControlDk(), true);
        graphics2D.dispose();
    }

    public GadgetManager getGadgetManager() {
        return this._manager;
    }

    public GadgetPaletteInstaller getInstaller() {
        return this._installer;
    }

    protected AbstractButton createButton(Gadget gadget) {
        return new GadgetPaletteButton(this, gadget);
    }

    protected void customizeButton(AbstractButton abstractButton) {
        abstractButton.addKeyListener(this._manager.getCancelDragAndDropKeyListener());
        abstractButton.addMouseListener(this._manager.getDragAndDropMouseInputListener());
        abstractButton.addMouseMotionListener(this._manager.getDragAndDropMouseInputListener());
        if (this._buttonChangeListener == null) {
            this._buttonChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    if (object instanceof AbstractButton) {
                        AbstractButton abstractButton = (AbstractButton)object;
                        boolean bl = abstractButton.getModel().isRollover();
                        if (bl) {
                            if (abstractButton instanceof GadgetPaletteButton && GadgetPalette.this._status instanceof JLabel) {
                                ((JLabel)GadgetPalette.this._status).setText(((GadgetPaletteButton)abstractButton).getGadget().getDescription());
                            }
                        } else if (GadgetPalette.this._status instanceof JLabel) {
                            ((JLabel)GadgetPalette.this._status).setText(GadgetPalette.this.getResourceString("GadgetPalette.hint"));
                        }
                    }
                }
            };
        }
        abstractButton.getModel().addChangeListener(this._buttonChangeListener);
        abstractButton.setFocusable(true);
        abstractButton.setRequestFocusEnabled(true);
    }

    protected void uncustomizeButton(AbstractButton abstractButton) {
        abstractButton.removeKeyListener(this._manager.getCancelDragAndDropKeyListener());
        abstractButton.removeMouseListener(this._manager.getDragAndDropMouseInputListener());
        abstractButton.removeMouseMotionListener(this._manager.getDragAndDropMouseInputListener());
        if (this._buttonChangeListener != null) {
            abstractButton.getModel().removeChangeListener(this._buttonChangeListener);
        }
    }

    protected String getResourceString(String string) {
        return DashboardResource.getResourceBundle(this.getLocale()).getString(string);
    }

    @Override
    public void eventHappened(GadgetEvent gadgetEvent) {
        if (!(this._manager.isBatchProcessing() || gadgetEvent.getID() != 13199 && gadgetEvent.getID() != 13200)) {
            this.recreateGadgetButtons();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this._manager.isBatchProcessing() && "batchProcessing".equals(propertyChangeEvent.getPropertyName())) {
            this.recreateGadgetButtons();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1024)) {
            Lm.showInvalidProductMessage(GadgetPalette.class.getName(), 1024);
        }
    }
}

