/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DashboardEvent;
import com.jidesoft.dashboard.DashboardHolder;
import com.jidesoft.dashboard.DashboardListener;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetComponent;
import com.jidesoft.dashboard.GadgetContainer;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetMouseListener;
import com.jidesoft.dashboard.ResizableGadgetContainer;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;

public class GadgetManager {
    private boolean _rearrangable = true;
    private List<String> _gadgetKeys;
    private Set<String> _removedGadgetKeys;
    private Map<String, Gadget> _allGadgets;
    private List<String> _dashboardKeys;
    private Map<String, Dashboard> _allDashboards;
    private GadgetMouseListener _dragAndDropListener;
    private String _activeDashboard;
    private static final Logger DASHBOARD_LOGGER;
    private static final Logger GADGET_LOGGER;
    private String _version;
    protected EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener _propertyListener;
    private boolean _disposeGadgetsWhenHidingDashboard = true;
    private boolean _columnResizable = false;
    private boolean _allowDragOutside = true;
    private boolean _allowDragBetweenDashboard = true;
    private boolean _allowMultipleGadgetInstances = true;
    private boolean _batchProcessing;
    private boolean _autoActivate = true;
    private PropertyChangeSupport _changeSupport;
    private transient Object objectLock = new Object();
    public static final String PROPERTY_BATCH_PROCESSING = "batchProcessing";
    public static final String PROPERTY_ALLOW_DRAG_BETWEEN_DASHBOARD = "allowDragBetweenDashboard";
    public static final String PROPERTY_ALLOW_MULTIPLE_GADGET_INSTANCES = "allowMultipleGadgetInstances";
    public static final String PROPERTY_ALLOW_DRAG_OUTSIDE = "allowDragOutside";
    public static final String PROPERTY_COLUMN_RESIZABLE = "columnResizable";
    public static final String PROPERTY_DISPOSE_GADGET_WHEN_HIDING_DASHBOARD = "disposeGadgetsWhenHidingDashboard";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_AUTO_ACTIVATE = "autoActivate";

    public GadgetManager() {
        this.initManager();
    }

    protected void initManager() {
        this._gadgetKeys = new Vector<String>();
        this._removedGadgetKeys = new HashSet<String>();
        this._allGadgets = new Hashtable<String, Gadget>();
        this._dashboardKeys = new Vector<String>();
        this._allDashboards = new Hashtable<String, Dashboard>();
        this._dragAndDropListener = new GadgetMouseListener();
        this._propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() instanceof Dashboard && "key".equals(propertyChangeEvent.getPropertyName())) {
                    int n;
                    String string = (String)propertyChangeEvent.getOldValue();
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    if (GadgetManager.this._dashboardKeys != null && (n = GadgetManager.this._dashboardKeys.indexOf(string)) >= 0) {
                        GadgetManager.this._dashboardKeys.remove(string);
                        GadgetManager.this._dashboardKeys.add(n, string2);
                    }
                    if (GadgetManager.this._allDashboards != null) {
                        GadgetManager.this._allDashboards.remove(string);
                        GadgetManager.this._allDashboards.put(string2, (Dashboard)propertyChangeEvent.getSource());
                    }
                }
            }
        };
        this.addGadgetListener(new GadgetListener(){

            @Override
            public void eventHappened(GadgetEvent gadgetEvent) {
                if (!GadgetManager.this.isAllowMultipleGadgetInstances()) {
                    if (gadgetEvent.getID() == 13201) {
                        GadgetManager.this.internalRemoveGadget(gadgetEvent.getGadget().getKey());
                    } else if (gadgetEvent.getID() == 13202) {
                        GadgetManager.this.internalAddGadget(gadgetEvent.getGadget());
                    }
                }
            }
        });
    }

    public void addGadget(Gadget gadget, int n) {
        if (gadget.getGadgetManager() == this) {
            return;
        }
        if (this._allGadgets.containsKey(gadget.getKey())) {
            throw new IllegalArgumentException("The gadget exists with key \"" + gadget.getKey() + "\". Please specify a new key for the gadget.");
        }
        gadget.setGadgetManager(this);
        if (n < 0) {
            this._gadgetKeys.add(gadget.getKey());
        } else {
            this._gadgetKeys.add(n, gadget.getKey());
        }
        this._allGadgets.put(gadget.getKey(), gadget);
        this.fireGadgetEvent(new GadgetEvent(gadget, 13199));
    }

    public void addGadget(Gadget gadget) {
        this.addGadget(gadget, -1);
    }

    public void addGadgets(Gadget[] gadgetArray) {
        this.setBatchProcessing(true);
        for (Gadget gadget : gadgetArray) {
            this.addGadget(gadget);
        }
        this.setBatchProcessing(false);
    }

    public void removeGadgets(String[] stringArray) {
        this.setBatchProcessing(true);
        for (String string : stringArray) {
            this.removeGadget(string);
        }
        this.setBatchProcessing(false);
    }

    public boolean removeGadget(String string) {
        Gadget gadget = this.getGadget(string);
        if (gadget != null) {
            this._gadgetKeys.remove(string);
            this._allGadgets.remove(string);
            gadget.setGadgetManager(null);
            this.fireGadgetEvent(new GadgetEvent(gadget, 13200));
            return true;
        }
        return false;
    }

    private void internalAddGadget(Gadget gadget) {
        if (gadget != null) {
            this._removedGadgetKeys.remove(gadget.getKey());
            this.fireGadgetEvent(new GadgetEvent(gadget, 13199));
        }
    }

    private boolean internalRemoveGadget(String string) {
        Gadget gadget = this.getGadget(string);
        if (gadget != null) {
            this._removedGadgetKeys.add(string);
            this.fireGadgetEvent(new GadgetEvent(gadget, 13200));
            return true;
        }
        return false;
    }

    protected void gadgetButtonDoubleClicked(Gadget gadget) {
        Dashboard dashboard = this.getDashboard(this.getActiveDashboardKey());
        if (dashboard == null) {
            return;
        }
        Component component = dashboard.getNormalGadgetContainer().getComponent(0);
        int n = 0;
        if (!(component instanceof GadgetContainer) && !(component instanceof ResizableGadgetContainer)) {
            Component[] componentArray = dashboard.getNormalGadgetContainer().getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof GadgetComponent) continue;
                n = i;
                break;
            }
        }
        if (this.validateGadgetDragging(gadget, component instanceof GadgetContainer || component instanceof ResizableGadgetContainer ? (Container)component : dashboard, n, true)) {
            this.showGadget(gadget, dashboard, 0, n);
        }
    }

    public void showGadget(Gadget gadget) {
        this.showGadget(gadget, this.getDashboard(this.getActiveDashboardKey()), 0, 0);
    }

    public void showGadget(Gadget gadget, Dashboard dashboard, int n) {
        this.showGadget(gadget, dashboard, 0, n);
    }

    public void showGadget(Gadget gadget, Dashboard dashboard, int n, int n2) {
        if (dashboard == null) {
            return;
        }
        if (!this.isAllowMultipleGadgetInstances() && this.isGadgetShown(gadget)) {
            return;
        }
        GadgetComponent gadgetComponent = this.createGadgetComponent(gadget);
        if (dashboard.isPredefinedLayoutSet()) {
            if (gadgetComponent != null) {
                JPanel jPanel = dashboard.getNormalGadgetContainer();
                if (n2 < 0 || n2 >= jPanel.getComponentCount()) {
                    n2 = jPanel.getComponentCount() - 1;
                }
                Component component = jPanel.getComponent(n2);
                Object object = dashboard.getComponentConstraints(n2);
                jPanel.remove(component);
                n2 = Math.min(n2, jPanel.getComponentCount());
                if (object != null) {
                    jPanel.add((Component)((Object)gadgetComponent), object, n2);
                } else {
                    jPanel.add((Component)((Object)gadgetComponent), n2);
                }
                ((Component)((Object)gadgetComponent)).setVisible(true);
                this.fireGadgetEvent(new GadgetEvent(gadgetComponent.getGadget(), 13201, gadgetComponent));
            }
            return;
        }
        Container container = dashboard.getGadgetContainer(n);
        if (gadgetComponent != null && GadgetManager.isGadgetContainer(container)) {
            if (n2 < 0 || n2 >= GadgetManager.getGadgetContainerComponentCount(container)) {
                n2 = GadgetManager.getGadgetContainerComponentCount(container);
            }
            if (container instanceof GadgetContainer) {
                container.add((Component)((Object)gadgetComponent), n2);
            } else {
                ((ResizableGadgetContainer)container).insertPane((Component)((Object)gadgetComponent), n2);
            }
            ((Component)((Object)gadgetComponent)).setVisible(true);
            container.invalidate();
            container.repaint();
            dashboard.getNormalGadgetContainer().revalidate();
            dashboard.revalidate();
            this.fireGadgetEvent(new GadgetEvent(gadgetComponent.getGadget(), 13201, gadgetComponent));
        }
    }

    static int getGadgetContainerComponentCount(Container container) {
        if (container == null) {
            return -1;
        }
        return container instanceof ResizableGadgetContainer ? ((ResizableGadgetContainer)container).getPaneCount() : container.getComponentCount() - 1;
    }

    static int indexOfGadgetContainer(Container container, Component component) {
        if (container == null || component == null) {
            return -1;
        }
        if (container instanceof ResizableGadgetContainer) {
            return ((ResizableGadgetContainer)container).indexOfPane(component);
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        for (Component component2 : componentArray) {
            if (component2 == component) break;
            ++n;
        }
        return n >= container.getComponentCount() ? -1 : n;
    }

    static boolean isGadgetContainer(Component component) {
        return component instanceof GadgetContainer || component instanceof ResizableGadgetContainer;
    }

    static Component addGadgetComponent(Container container, Component component, int n) {
        if (container == null || component == null) {
            return null;
        }
        if (container instanceof ResizableGadgetContainer) {
            return ((ResizableGadgetContainer)container).insertPane(component, n);
        }
        return container.add(component, n);
    }

    static void removeGadgetComponent(Container container, Component component) {
        if (container == null || component == null) {
            return;
        }
        if (container instanceof ResizableGadgetContainer) {
            if (((ResizableGadgetContainer)container).indexOfPane(component) >= 0) {
                ((ResizableGadgetContainer)container).removePane(component);
            }
        } else {
            container.remove(component);
        }
    }

    static Container getAncestorOfGadgetContainer(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !GadgetManager.isGadgetContainer(container); container = container.getParent()) {
        }
        return container;
    }

    static Component getGadgetComponent(Container container, int n) {
        if (n < 0 || n >= GadgetManager.getGadgetContainerComponentCount(container)) {
            return null;
        }
        if (container instanceof ResizableGadgetContainer) {
            return ((ResizableGadgetContainer)container).getPaneAt(n);
        }
        return container.getComponent(n);
    }

    public boolean isGadgetShown(String string) {
        return this.isGadgetShown(this.getGadget(string));
    }

    public boolean isGadgetShown(Gadget gadget) {
        if (gadget == null) {
            return false;
        }
        for (String string : this.getDashboards()) {
            Dashboard dashboard = this.getDashboard(string);
            for (GadgetComponent gadgetComponent : dashboard.getGadgetComponents()) {
                if (gadgetComponent.getGadget() != gadget) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public void hideGadget(GadgetComponent gadgetComponent) {
        this.hideGadgetComponent(gadgetComponent);
    }

    public void hideGadgetComponent(GadgetComponent gadgetComponent) {
        Gadget gadget = gadgetComponent.getGadget();
        if (gadget.getGadgetManager() != this) {
            return;
        }
        Container container = SwingUtilities.getAncestorOfClass(Dashboard.class, (Component)((Object)gadgetComponent));
        if (container == null) {
            return;
        }
        Dashboard dashboard = (Dashboard)container;
        Container container2 = ((Component)((Object)gadgetComponent)).getParent();
        if (dashboard.getMaximizedGadgetContainer() == container2) {
            dashboard.restoreGadgetComponent();
            this.hideGadgetComponent(gadgetComponent);
            return;
        }
        if (container2 != null) {
            if (container2 instanceof GadgetContainer || container2 instanceof ResizableGadgetContainer) {
                container2.remove((Component)((Object)gadgetComponent));
            } else {
                this.removeComponent((Component)((Object)gadgetComponent), dashboard);
            }
            ((Component)((Object)gadgetComponent)).setVisible(false);
            container2.invalidate();
            container2.doLayout();
            this.fireGadgetEvent(new GadgetEvent(gadgetComponent.getGadget(), 13202, gadgetComponent));
        }
        gadget.disposeGadgetComponent(gadgetComponent);
        this.uninstallListeners((Component)((Object)gadgetComponent));
        this.fireGadgetEvent(new GadgetEvent(gadgetComponent.getGadget(), 13204, gadgetComponent));
    }

    private void removeComponent(Component component, Dashboard dashboard) {
        Container container = component.getParent();
        if (container != null) {
            int n = GadgetManager.indexOfGadgetContainer(container, component);
            Object object = dashboard.getComponentConstraints(n);
            container.remove(component);
            n = Math.min(n, container.getComponentCount());
            container.add((Component)((Object)dashboard.createDefaultPlaceHolder()), object, n);
        }
    }

    @Deprecated
    public void maximizeGadget(GadgetComponent gadgetComponent) {
        this.maximizeGadgetComponent(gadgetComponent);
    }

    public void maximizeGadgetComponent(GadgetComponent gadgetComponent) {
        Dashboard dashboard = this.getDashboard(this.getActiveDashboardKey());
        if (dashboard != null) {
            dashboard.maximizeGadgetComponent(gadgetComponent);
        }
    }

    @Deprecated
    public void maximizeGadget(int n, int n2) {
        this.maximizeGadgetComponent(n, n2);
    }

    public void maximizeGadgetComponent(int n, int n2) {
        Dashboard dashboard = this.getDashboard(this.getActiveDashboardKey());
        if (dashboard != null) {
            dashboard.maximizeGadgetComponent(n, n2);
        }
    }

    @Deprecated
    public void restoreGadget() {
        this.restoreGadgetComponent();
    }

    public void restoreGadgetComponent() {
        Dashboard dashboard = this.getDashboard(this.getActiveDashboardKey());
        if (dashboard != null) {
            dashboard.restoreGadgetComponent();
        }
    }

    public GadgetComponent createGadgetComponent(Gadget gadget) {
        if (gadget.getGadgetManager() != this) {
            return null;
        }
        GadgetComponent gadgetComponent = gadget.createGadgetComponent();
        if (gadgetComponent != null) {
            this.installListeners((Component)((Object)gadgetComponent));
            this.fireGadgetEvent(new GadgetEvent(gadget, 13203, gadgetComponent));
        }
        return gadgetComponent;
    }

    public String getActiveDashboardKey() {
        if (this.getDashboard(this._activeDashboard) == null && this.getDashboardCount() > 0) {
            this._activeDashboard = this.getDashboard(0).getKey();
        }
        return this._activeDashboard;
    }

    public void setActiveDashboardKey(String string) {
        Dashboard dashboard;
        if (!JideSwingUtilities.equals(this._activeDashboard, string)) {
            if (this._activeDashboard != null && (dashboard = this.getDashboard(this._activeDashboard)) != null) {
                this.fireDashboardEvent(new DashboardEvent(dashboard, 13103, this.getDashboardIndex(this._activeDashboard)));
            }
            this._activeDashboard = string;
            if (this._activeDashboard != null && (dashboard = this.getDashboard(this._activeDashboard)) != null) {
                this.fireDashboardEvent(new DashboardEvent(dashboard, 13102, this.getDashboardIndex(this._activeDashboard)));
            }
        }
        if (this._activeDashboard != null && (dashboard = this.getDashboard(this._activeDashboard)) != null) {
            Container container = dashboard.getTopLevelAncestor();
            if (this.isAutoActivate() && container instanceof Window) {
                ((Window)container).toFront();
            }
            Container container2 = SwingUtilities.getAncestorOfClass(JideTabbedPane.class, dashboard);
            Container container3 = dashboard.getParent();
            if (container3 != null) {
                container3 = container3.getParent();
                if (container2 instanceof JideTabbedPane && container2 instanceof DashboardHolder && ((JideTabbedPane)container2).indexOfComponent(container3) >= 0 && ((JideTabbedPane)container2).getSelectedComponent() != container3) {
                    ((JideTabbedPane)container2).setSelectedComponent(container3);
                }
            }
        }
    }

    public Gadget getGadget(String string) {
        return this._allGadgets.get(string);
    }

    public String[] getGadgets() {
        if (this._removedGadgetKeys.size() == 0) {
            return this._gadgetKeys.toArray(new String[this._gadgetKeys.size()]);
        }
        String[] stringArray = new String[this._gadgetKeys.size() - this._removedGadgetKeys.size()];
        int n = 0;
        for (String string : this._gadgetKeys) {
            if (this._removedGadgetKeys.contains(string)) continue;
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public void addDashboard(Dashboard dashboard) {
        if (this._allDashboards.containsKey(dashboard.getKey())) {
            throw new IllegalArgumentException("The Dashboard exists with key \"" + dashboard.getKey() + "\". Please specify a new key for the dashboard.");
        }
        this._dashboardKeys.add(dashboard.getKey());
        this._allDashboards.put(dashboard.getKey(), dashboard);
        dashboard.addPropertyChangeListener("key", this._propertyListener);
        dashboard.setColumnResizable(this.isColumnResizable());
        this.fireDashboardEvent(new DashboardEvent(dashboard, 13099, this._dashboardKeys.size() - 1));
    }

    public boolean removeDashboard(String string) {
        if (this._allDashboards.containsKey(string)) {
            Dashboard dashboard = this._allDashboards.get(string);
            if (this.isDisposeGadgetsWhenHidingDashboard()) {
                GadgetComponent[] gadgetComponentArray;
                for (GadgetComponent gadgetComponent : gadgetComponentArray = dashboard.getGadgetComponents()) {
                    this.hideGadgetComponent(gadgetComponent);
                }
            }
            int n = this._dashboardKeys.indexOf(string);
            this._dashboardKeys.remove(string);
            this._allDashboards.remove(string);
            dashboard.removePropertyChangeListener(this._propertyListener);
            this.fireDashboardEvent(new DashboardEvent(dashboard, 13100, n));
            if (JideSwingUtilities.equals(string, this._activeDashboard)) {
                if (this._dashboardKeys.size() <= 0) {
                    this.setActiveDashboardKey(null);
                } else {
                    this.setActiveDashboardKey(this._dashboardKeys.get(0));
                }
            }
            return true;
        }
        return false;
    }

    public void moveDashboard(String string, int n) {
        if (this._allDashboards.containsKey(string)) {
            Dashboard dashboard = this._allDashboards.get(string);
            this._dashboardKeys.remove(string);
            if (n < 0) {
                n = 0;
            }
            if (n > this._dashboardKeys.size()) {
                n = this._dashboardKeys.size();
            }
            this._dashboardKeys.add(n, string);
            this.fireDashboardEvent(new DashboardEvent(dashboard, 13101, n));
        }
    }

    public void removeAllDashboards() {
        for (int i = this._dashboardKeys.size() - 1; i >= 0; --i) {
            String string = this._dashboardKeys.get(i);
            this.removeDashboard(string);
        }
    }

    public Dashboard getDashboard(String string) {
        if (string == null) {
            return null;
        }
        return this._allDashboards.get(string);
    }

    public int getDashboardIndex(String string) {
        return this._dashboardKeys.indexOf(string);
    }

    public Dashboard getDashboard(int n) {
        String string = this._dashboardKeys.get(n);
        if (string != null) {
            return this.getDashboard(string);
        }
        return null;
    }

    public String[] getDashboards() {
        return this._dashboardKeys.toArray(new String[this._dashboardKeys.size()]);
    }

    public int getDashboardCount() {
        return this._dashboardKeys.size();
    }

    protected boolean validateGadgetDragging(Gadget gadget, Container container, int n, boolean bl) {
        return this.validateGadgetDragging(gadget, container, n);
    }

    protected boolean validateGadgetDragging(Gadget gadget, Container container, int n) {
        return this.validateGadgetDragging(gadget, container);
    }

    protected boolean validateGadgetDragging(Gadget gadget, Container container) {
        return true;
    }

    public MouseInputListener getDragAndDropMouseInputListener() {
        return this._dragAndDropListener;
    }

    public KeyListener getCancelDragAndDropKeyListener() {
        return this._dragAndDropListener;
    }

    public void installListeners(Component component) {
        KeyListener keyListener;
        MouseInputListener mouseInputListener = this.getDragAndDropMouseInputListener();
        if (!JideSwingUtilities.isMouseListenerRegistered(component, mouseInputListener)) {
            component.addMouseListener(mouseInputListener);
        }
        if (!JideSwingUtilities.isMouseMotionListenerRegistered(component, mouseInputListener)) {
            component.addMouseMotionListener(mouseInputListener);
        }
        if (!JideSwingUtilities.isKeyListenerRegistered(component, keyListener = this.getCancelDragAndDropKeyListener())) {
            component.addKeyListener(keyListener);
        }
    }

    public void uninstallListeners(Component component) {
        MouseInputListener mouseInputListener = this.getDragAndDropMouseInputListener();
        if (JideSwingUtilities.isMouseListenerRegistered(component, mouseInputListener)) {
            component.removeMouseListener(mouseInputListener);
        }
        if (JideSwingUtilities.isMouseMotionListenerRegistered(component, mouseInputListener)) {
            component.removeMouseMotionListener(mouseInputListener);
        }
    }

    public void addGadgetListener(GadgetListener gadgetListener) {
        this.listenerList.add(GadgetListener.class, gadgetListener);
    }

    public void removeGadgetListener(GadgetListener gadgetListener) {
        this.listenerList.remove(GadgetListener.class, gadgetListener);
    }

    public GadgetListener[] getGadgetListeners() {
        return (GadgetListener[])this.listenerList.getListeners(GadgetListener.class);
    }

    protected void fireGadgetEvent(GadgetEvent gadgetEvent) {
        if (GADGET_LOGGER.isLoggable(Level.FINE)) {
            switch (gadgetEvent.getID()) {
                case 13199: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is added");
                    break;
                }
                case 13200: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is removed");
                    break;
                }
                case 13203: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is created");
                    break;
                }
                case 13204: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is disposed");
                    break;
                }
                case 13201: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is shown");
                    break;
                }
                case 13202: {
                    GADGET_LOGGER.fine("Gadget \"" + ((Gadget)gadgetEvent.getSource()).getKey() + "\" is hidden");
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GadgetListener.class) continue;
            ((GadgetListener)objectArray[i + 1]).eventHappened(gadgetEvent);
        }
    }

    public void addDashboardListener(DashboardListener dashboardListener) {
        this.listenerList.add(DashboardListener.class, dashboardListener);
    }

    public void removeDashboardListener(DashboardListener dashboardListener) {
        this.listenerList.remove(DashboardListener.class, dashboardListener);
    }

    public DashboardListener[] getDashboardListeners() {
        return (DashboardListener[])this.listenerList.getListeners(DashboardListener.class);
    }

    protected void fireDashboardEvent(DashboardEvent dashboardEvent) {
        if (DASHBOARD_LOGGER.isLoggable(Level.FINE)) {
            switch (dashboardEvent.getID()) {
                case 13099: {
                    DASHBOARD_LOGGER.fine("Dashboard \"" + ((Dashboard)dashboardEvent.getSource()).getKey() + "\" is added to index " + dashboardEvent.getIndex());
                    break;
                }
                case 13100: {
                    DASHBOARD_LOGGER.fine("Dashboard \"" + ((Dashboard)dashboardEvent.getSource()).getKey() + "\" is removed from index " + dashboardEvent.getIndex());
                    break;
                }
                case 13101: {
                    DASHBOARD_LOGGER.fine("Dashboard \"" + ((Dashboard)dashboardEvent.getSource()).getKey() + "\" is moved to index " + dashboardEvent.getIndex());
                    break;
                }
                case 13102: {
                    DASHBOARD_LOGGER.fine("Dashboard \"" + ((Dashboard)dashboardEvent.getSource()).getKey() + "\" is activated at index " + dashboardEvent.getIndex());
                    break;
                }
                case 13103: {
                    DASHBOARD_LOGGER.fine("Dashboard \"" + ((Dashboard)dashboardEvent.getSource()).getKey() + "\" is deactivated at index " + dashboardEvent.getIndex());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DashboardListener.class) continue;
            ((DashboardListener)objectArray[i + 1]).eventHappened(dashboardEvent);
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public boolean isDisposeGadgetsWhenHidingDashboard() {
        return this._disposeGadgetsWhenHidingDashboard;
    }

    public void setDisposeGadgetsWhenHidingDashboard(boolean bl) {
        if (this._disposeGadgetsWhenHidingDashboard != bl) {
            boolean bl2 = this._disposeGadgetsWhenHidingDashboard;
            this._disposeGadgetsWhenHidingDashboard = bl;
            this.firePropertyChange(PROPERTY_DISPOSE_GADGET_WHEN_HIDING_DASHBOARD, bl2, this._disposeGadgetsWhenHidingDashboard);
        }
    }

    public boolean isColumnResizable() {
        return this._columnResizable;
    }

    public void setColumnResizable(boolean bl) {
        if (this._columnResizable != bl) {
            String[] stringArray;
            boolean bl2 = this._columnResizable;
            this._columnResizable = bl;
            for (String string : stringArray = this.getDashboards()) {
                Dashboard dashboard = this.getDashboard(string);
                dashboard.setColumnResizable(this._columnResizable);
            }
            this.firePropertyChange(PROPERTY_COLUMN_RESIZABLE, bl2, this._columnResizable);
        }
    }

    public boolean isAllowDragOutside() {
        return this._allowDragOutside;
    }

    public void setAllowDragOutside(boolean bl) {
        if (this._allowDragOutside != bl) {
            boolean bl2 = this._allowDragOutside;
            this._allowDragOutside = bl;
            this.firePropertyChange(PROPERTY_ALLOW_DRAG_OUTSIDE, bl2, this._allowDragOutside);
        }
    }

    public boolean isAllowDragBetweenDashboard() {
        return this._allowDragBetweenDashboard;
    }

    public void setAllowDragBetweenDashboard(boolean bl) {
        if (this._allowDragBetweenDashboard != bl) {
            boolean bl2 = this._allowDragBetweenDashboard;
            this._allowDragBetweenDashboard = bl;
            this.firePropertyChange(PROPERTY_ALLOW_DRAG_BETWEEN_DASHBOARD, bl2, this._allowDragBetweenDashboard);
        }
    }

    public boolean isAllowMultipleGadgetInstances() {
        return this._allowMultipleGadgetInstances;
    }

    public void setAllowMultipleGadgetInstances(boolean bl) {
        if (this._allowMultipleGadgetInstances != bl) {
            boolean bl2 = this._allowMultipleGadgetInstances;
            this._allowMultipleGadgetInstances = bl;
            this.firePropertyChange(PROPERTY_ALLOW_MULTIPLE_GADGET_INSTANCES, bl2, this._allowMultipleGadgetInstances);
        }
    }

    boolean isBatchProcessing() {
        return this._batchProcessing;
    }

    void setBatchProcessing(boolean bl) {
        if (this._batchProcessing != bl) {
            boolean bl2 = this._batchProcessing;
            this._batchProcessing = bl;
            this.firePropertyChange(PROPERTY_BATCH_PROCESSING, bl2, this._batchProcessing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (propertyChangeListener == null) {
                return;
            }
            if (this._changeSupport == null) {
                this._changeSupport = new PropertyChangeSupport(this);
            }
            this._changeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (propertyChangeListener == null || this._changeSupport == null) {
                return;
            }
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners() {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (this._changeSupport == null) {
                return new PropertyChangeListener[0];
            }
            return this._changeSupport.getPropertyChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (propertyChangeListener == null) {
                return;
            }
            if (this._changeSupport == null) {
                this._changeSupport = new PropertyChangeSupport(this);
            }
            this._changeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (propertyChangeListener == null || this._changeSupport == null) {
                return;
            }
            this._changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (this._changeSupport == null) {
                return new PropertyChangeListener[0];
            }
            return this._changeSupport.getPropertyChangeListeners(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport;
        Object object3 = this.getObjectLock();
        synchronized (object3) {
            propertyChangeSupport = this._changeSupport;
        }
        if (propertyChangeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    private Object getObjectLock() {
        return this.objectLock;
    }

    public boolean isRearrangable() {
        return this._rearrangable;
    }

    public void setRearrangable(boolean bl) {
        boolean bl2 = this._rearrangable;
        if (this._rearrangable != bl) {
            this._rearrangable = bl;
            this.firePropertyChange(PROPERTY_REARRANGABLE, bl2, this._rearrangable);
        }
    }

    public boolean isAutoActivate() {
        return this._autoActivate;
    }

    public void setAutoActivate(boolean bl) {
        boolean bl2 = this._autoActivate;
        if (this._autoActivate != bl) {
            this._autoActivate = bl;
            this.firePropertyChange(PROPERTY_AUTO_ACTIVATE, bl2, this._autoActivate);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1024)) {
            Lm.showInvalidProductMessage(GadgetManager.class.getName(), 1024);
        }
        DASHBOARD_LOGGER = Logger.getLogger(DashboardEvent.class.getName());
        GADGET_LOGGER = Logger.getLogger(GadgetEvent.class.getName());
    }
}

