/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.TreeChooserPanel;
import com.jidesoft.converter.ObjectConverterManager;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeExComboBox
extends ExComboBox {
    protected TreeCellRenderer renderer;
    protected int maximumRowCount = 8;
    protected Object _object;
    protected TreeModel _treeModel;
    private JTree _tree;
    private boolean _doubleClickExpand;
    private boolean _searchUserObjectToSelect;
    public static final String TREE_MODEL_PROPERTY = "treeModel";

    public TreeExComboBox() {
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(Object[] objectArray) {
        this._object = objectArray;
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(Vector<?> vector) {
        this._object = vector;
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(Hashtable<?, ?> hashtable) {
        this._object = hashtable;
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(TreeNode treeNode) {
        this._object = treeNode;
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(TreeNode treeNode, boolean bl) {
        this._object = new DefaultTreeModel(treeNode, bl);
        this.setTreeModel(TreeChooserPanel.createTreeModel(this._object));
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    public TreeExComboBox(TreeModel treeModel) {
        this._object = treeModel;
        this.setTreeModel(TreeChooserPanel.createTreeModel(this._object));
        this.setType(String.class);
        this.setStretchToFit(true);
    }

    @Override
    protected void initComboBox() {
        super.initComboBox();
        this._treeModel = TreeChooserPanel.createTreeModel(this._object);
        this.putClientProperty("JComboBox.isPopDown", true);
    }

    protected List<TreePath> populateTreePaths(JTree jTree) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Object object = jTree.getModel().getRoot();
        this.populateTreePaths0(object, jTree, new TreePath(object), jTree.getModel(), arrayList);
        return arrayList;
    }

    private void populateTreePaths0(Object object, JTree jTree, TreePath treePath, TreeModel treeModel, List<TreePath> list) {
        if (jTree.isRootVisible() || treePath.getLastPathComponent() != jTree.getModel().getRoot()) {
            list.add(treePath);
        }
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            Object object2 = treeModel.getChild(object, i);
            this.populateTreePaths0(object2, jTree, treePath.pathByAddingChild(object2), treeModel, list);
        }
    }

    @Override
    public PopupPanel createPopupComponent() {
        TreeChooserPanel treeChooserPanel = this.createTreeChooserPanel(this.getTreeModel());
        treeChooserPanel.setResizable(true);
        treeChooserPanel.setResizableCorners(16);
        treeChooserPanel.setMaximumRowCount(this.maximumRowCount);
        treeChooserPanel.setDoubleClickExpand(this.isDoubleClickExpand());
        this._tree = treeChooserPanel.getTree();
        return treeChooserPanel;
    }

    protected TreeChooserPanel createTreeChooserPanel(TreeModel treeModel) {
        TreeChooserPanel treeChooserPanel = new TreeChooserPanel(treeModel){

            @Override
            protected JTree createTree(TreeModel treeModel) {
                JTree jTree = TreeExComboBox.this.createTree(treeModel);
                if (jTree == null) {
                    return super.createTree(treeModel);
                }
                return jTree;
            }

            @Override
            protected void setupTree(final JTree jTree) {
                super.setupTree(jTree);
                jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        TreePath treePath = treeSelectionEvent.getPath();
                        if (treePath != null && !Boolean.TRUE.equals(jTree.getClientProperty("PopupPanel.selectedByMouseRollover"))) {
                            if (!treeSelectionEvent.isAddedPath(treePath) || !this.isValidSelection(treePath)) {
                                TreeExComboBox.this.setSelectedItem(null, !treeSelectionEvent.isAddedPath(treePath));
                            } else {
                                TreeExComboBox.this.setSelectedItem(treePath, false);
                            }
                        }
                    }
                });
                TreeExComboBox.this.setupTree(jTree);
            }

            @Override
            protected boolean isValidSelection(TreePath treePath) {
                return TreeExComboBox.this.isValidSelection(treePath);
            }
        };
        treeChooserPanel.setCellRenderer(this.getCellRenderer());
        treeChooserPanel.setSearchUserObjectToSelect(this.isSearchUserObjectToSelect());
        return treeChooserPanel;
    }

    protected JTree createTree(TreeModel treeModel) {
        return null;
    }

    protected void setupTree(JTree jTree) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jTree.setFont(font);
        }
    }

    private Object validateItem(Object object) {
        if (!this.isPopupVisible()) {
            return object;
        }
        JTree jTree = this.getTree();
        if (jTree == null || object == null) {
            return null;
        }
        if (object instanceof TreePath) {
            return object;
        }
        List<TreePath> list = this.populateTreePaths(jTree);
        for (TreePath treePath : list) {
            if (!this.isValidSelection(treePath) || !object.equals(this.convertElementToString(treePath))) continue;
            return treePath;
        }
        return null;
    }

    @Override
    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    @Override
    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.renderer;
        this.renderer = treeCellRenderer;
        this.firePropertyChange("renderer", treeCellRenderer2, this.renderer);
        this.invalidate();
    }

    public TreeCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public JTree getTree() {
        if (this.isPopupVisible() && this.isShowing()) {
            return this._tree;
        }
        return null;
    }

    @Override
    public void setPopupVisible(boolean bl) {
        super.setPopupVisible(bl);
    }

    @Override
    protected JComponent getDelegateTarget(PopupPanel popupPanel) {
        return popupPanel instanceof TreeChooserPanel ? ((TreeChooserPanel)popupPanel).getTree() : super.getDelegateTarget(popupPanel);
    }

    @Override
    public String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            return object2.toString();
        }
        if (object != null) {
            return ObjectConverterManager.toString(object, this.getType(), this.getConverterContext());
        }
        return "";
    }

    protected boolean isValidSelection(TreePath treePath) {
        return true;
    }

    public TreeModel getTreeModel() {
        return this._treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        if (this._treeModel != treeModel) {
            TreeModel treeModel2 = this._treeModel;
            this._treeModel = treeModel;
            this.updateUI();
            this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, treeModel);
        }
    }

    public boolean isDoubleClickExpand() {
        return this._doubleClickExpand;
    }

    public void setDoubleClickExpand(boolean bl) {
        this._doubleClickExpand = bl;
    }

    public boolean isSearchUserObjectToSelect() {
        return this._searchUserObjectToSelect;
    }

    public void setSearchUserObjectToSelect(boolean bl) {
        this._searchUserObjectToSelect = bl;
    }
}

