/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.InfiniteComboBoxModel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.AbstractJideCellEditor;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.plaf.ExComboBoxUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;

public abstract class ExComboBox
extends JComboBox
implements ConverterContextSupport,
PropertyChangeListener {
    private static final String uiClassID = "ExComboBoxUI";
    private static final String uiComboBoxPopupClassID = "ExComboBox.comboBoxPopup";
    private static final String uiComboBoxRendererClassID = "ExComboBox.comboBoxRenderer";
    private static final String uiComboBoxEditorClassID = "ExComboBox.comboBoxEditor";
    protected static final String OBJECT_UNINITIALIZED = "__UNINITIALIZED__";
    private Object _lastActionSelectedItem = "__UNINITIALIZED__";
    private boolean _popupVolatile = false;
    private boolean _buttonVisible;
    private boolean _buttonOnly = false;
    private boolean _emptyStringNull = true;
    private int _popupLocation = 3;
    private Action _okAction;
    private Action _cancelAction;
    private boolean _popupInLocalScreen = false;
    public static final int DROPDOWN = 0;
    public static final int DIALOG = 1;
    private int _popupType;
    private ConverterContext _converterContext;
    private ObjectConverter _converter;
    private Class<?> _clazz;
    private boolean _stretchToFit = false;
    private boolean _stretchToFitSet = false;
    private boolean _keepPopupSize = false;
    private boolean _blockActionEvent;
    private boolean _itemEventSent;
    private int _focusLostBehavior = 1;
    private int _popupCancelBehavior = 3;
    private int _downKeyBehavior = 0;
    private Dimension _preferredPopupSize;
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    public static final int COMMIT_OR_RESET = 4;
    public static final int DOWN_KEY_BEHAVIOR_SELECT_NEXT = 0;
    public static final int DOWN_KEY_BEHAVIOR_SHOW_POPUP = 1;
    public static final int RESET = 5;
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_BUTTON_VISIBLE = "buttonVisible";
    public static final String CLIENT_PROPERTY_TABLE_CELL_RENDERER = "AbstractComboBox.isTableCellRenderer";
    public static final String CLIENT_PROPERTY_TABLE_CELL_EDITOR = "AbstractComboBox.isTableCellEditor";
    public static final String CLIENT_PROPERTY_HIDE_POPUP_ON_LIST_DATA_CHANGED = "AbstractComboBox.isHidePopupOnListDataChanged";
    public static final String CLIENT_PROPERTY_POPUP_PANEL = "ExComboBox.popupPanel";
    private Map<KeyStroke, Action> _savedActions = new HashMap<KeyStroke, Action>();
    private boolean _retrievingValueFromPopup;
    private boolean _settingPopupInitialValue = true;

    public ExComboBox() {
        super(new InfiniteComboBoxModel());
        this.initComboBox();
    }

    public ExComboBox(Vector<?> vector) {
        super(vector);
        this.initComboBox();
    }

    public ExComboBox(Object[] objectArray) {
        super(objectArray);
        this.initComboBox();
    }

    public ExComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.initComboBox();
    }

    public ExComboBox(int n) {
        this(n, ConverterContext.DEFAULT_CONTEXT);
    }

    public ExComboBox(int n, ConverterContext converterContext) {
        super(new InfiniteComboBoxModel());
        this._popupType = n;
        this._converterContext = converterContext;
        this.initComboBox();
    }

    protected void initComboBox() {
        this.addPropertyChangeListener(this);
        this.setButtonVisible(true);
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    public String getUIComboBoxPopupClassID() {
        return uiComboBoxPopupClassID;
    }

    public String getUIComboBoxEditorClassID() {
        return uiComboBoxEditorClassID;
    }

    public String getUIComboBoxRendererClassID() {
        return uiComboBoxRendererClassID;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> clazz = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> clazz2 = JComponent.class;
            Method method = clazz.getMethod("createUI", clazz2);
            if (method != null) {
                Object object = method.invoke(null, this);
                this.setUI((ComponentUI)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract PopupPanel createPopupComponent();

    public AbstractButton createButtonComponent() {
        return null;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.setSelectedItem(object, true);
    }

    private boolean isEqual(Object object, Object object2, boolean bl) {
        if (OBJECT_UNINITIALIZED.equals(object)) {
            object = null;
        }
        if (OBJECT_UNINITIALIZED.equals(object2)) {
            object2 = null;
        }
        return JideSwingUtilities.equals(object, object2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItem(Object object, boolean bl) {
        Object object2 = this.selectedItemReminder;
        if (object != null && !this.isEditable() && !this.validateValueForNonEditable(object)) {
            return;
        }
        this._blockActionEvent = true;
        this._itemEventSent = false;
        try {
            this.dataModel.setSelectedItem(object);
        }
        finally {
            this._blockActionEvent = false;
        }
        if (this.isEditable()) {
            this.getEditor().setItem(object);
            if (this.isButtonVisible()) {
                this.getEditor().selectAll();
            }
        }
        if (bl && (null != this.getClientProperty(CLIENT_PROPERTY_TABLE_CELL_EDITOR) || !this.equals(this.selectedItemReminder, this.dataModel.getSelectedItem()))) {
            if (this._itemEventSent) {
                this.selectedItemReminder = this.dataModel.getSelectedItem();
            } else {
                this.selectedItemChanged();
            }
        }
        if (this.equals(object2, object) && object != null && bl) {
            object2 = null;
        }
        this.firePropertyChange(PROPERTY_SELECTED_ITEM, object2, object);
        if (bl) {
            this.fireActionEvent();
            this._lastActionSelectedItem = this.getSelectedItemCloneIfNecessary();
        }
    }

    @Override
    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        super.setEditable(bl);
        if (bl && bl2 != bl) {
            this.getEditor().setItem(this.getSelectedItem());
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent itemEvent) {
        super.fireItemStateChanged(itemEvent);
        this._itemEventSent = true;
    }

    protected boolean equals(Object object, Object object2) {
        return object == object2;
    }

    protected boolean validateValueForNonEditable(Object object) {
        boolean bl = false;
        if (this.dataModel.getSize() == -1) {
            bl = true;
        } else {
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                if (!JideSwingUtilities.equals(object, this.dataModel.getElementAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public Object getSelectedItem() {
        if (this.dataModel != null) {
            return this.dataModel.getSelectedItem();
        }
        return null;
    }

    protected JComponent getDelegateTarget(PopupPanel popupPanel) {
        return popupPanel;
    }

    public void customizeRendererComponent(Component component, Object object, int n, boolean bl, boolean bl2) {
        if (component instanceof JLabel) {
            ((JLabel)component).setText(this.convertElementToString(object));
        }
    }

    public int getDownKeyBehavior() {
        return this._downKeyBehavior;
    }

    public void setDownKeyBehavior(int n) {
        this._downKeyBehavior = n;
    }

    public void delegateKeyStrokes() {
        ExComboBox exComboBox;
        Component component = exComboBox = this.isEditable() ? this.getEditor().getEditorComponent() : this;
        if (exComboBox instanceof JComponent) {
            List<KeyStroke> list = this.getDelegateKeyStrokes();
            for (KeyStroke keyStroke : list) {
                LazyDelegateAction lazyDelegateAction = new LazyDelegateAction(keyStroke);
                DelegateAction.replaceAction(exComboBox, 0, keyStroke, lazyDelegateAction);
                this._savedActions.put(keyStroke, lazyDelegateAction);
            }
        }
    }

    boolean originalSelectWithKeyChar(char c) {
        return super.selectWithKeyChar(c);
    }

    @Override
    public boolean selectWithKeyChar(char c) {
        return false;
    }

    public void undelegateKeyStrokes() {
        ExComboBox exComboBox;
        Component component = exComboBox = this.isEditable() ? this.getEditor().getEditorComponent() : this;
        if (exComboBox instanceof JComponent) {
            List<KeyStroke> list = this.getDelegateKeyStrokes();
            for (KeyStroke keyStroke : list) {
                Action action = this._savedActions.get(keyStroke);
                if (action != null) {
                    DelegateAction.restoreAction((JComponent)exComboBox, 0, keyStroke, action);
                    continue;
                }
                DelegateAction.restoreAction((JComponent)exComboBox, 0, keyStroke, LazyDelegateAction.class);
            }
        }
        this._savedActions.clear();
    }

    public List<KeyStroke> getDelegateKeyStrokes() {
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        arrayList.add(KeyStroke.getKeyStroke(27, 0));
        arrayList.add(KeyStroke.getKeyStroke(38, 0));
        arrayList.add(KeyStroke.getKeyStroke(40, 0));
        arrayList.add(KeyStroke.getKeyStroke(34, 0));
        arrayList.add(KeyStroke.getKeyStroke(33, 0));
        arrayList.add(KeyStroke.getKeyStroke(10, 0));
        arrayList.add(KeyStroke.getKeyStroke(37, 0));
        arrayList.add(KeyStroke.getKeyStroke(39, 0));
        arrayList.add(KeyStroke.getKeyStroke(36, 0));
        arrayList.add(KeyStroke.getKeyStroke(35, 0));
        return arrayList;
    }

    public String convertElementToString(Object object, Class clazz) {
        if (this._converter != null) {
            return this._converter.toString(object, this._converterContext);
        }
        return ObjectConverterManager.toString(object, clazz, this._converterContext);
    }

    public String convertElementToString(Object object) {
        return this.convertElementToString(object, object != null ? object.getClass() : this.getType());
    }

    public Object convertStringToElement(String string) {
        return this.convertStringToElement(string, this._clazz);
    }

    public Object convertStringToElement(String string, Class clazz) {
        if (String.class.equals((Object)clazz) && string != null && string.length() == 0 && this.isEmptyStringNull()) {
            return null;
        }
        if (this._converter != null) {
            return this._converter.fromString(string, this._converterContext);
        }
        return ObjectConverterManager.fromString(string, clazz, this._converterContext);
    }

    public ObjectConverter getConverter() {
        return this._converter;
    }

    public void setConverter(ObjectConverter objectConverter) {
        this._converter = objectConverter;
        this.getEditor().setItem(this.getSelectedItem());
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._converterContext = converterContext;
        this.getEditor().setItem(this.getSelectedItem());
    }

    @Override
    public Class<?> getType() {
        return this._clazz;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._clazz = clazz;
    }

    public boolean isPopupVolatile() {
        return this._popupVolatile;
    }

    public void setPopupVolatile(boolean bl) {
        this._popupVolatile = bl;
    }

    public void setButtonVisible(boolean bl) {
        if (this._buttonVisible != bl) {
            boolean bl2 = this._buttonVisible;
            this._buttonVisible = bl;
            this.firePropertyChange(PROPERTY_BUTTON_VISIBLE, bl2, this._buttonVisible);
        }
    }

    public boolean isButtonVisible() {
        return this._buttonVisible;
    }

    public void setButtonOnly(boolean bl) {
        this._buttonOnly = bl;
    }

    public boolean isButtonOnly() {
        return this._buttonOnly;
    }

    public int getPopupType() {
        return this._popupType;
    }

    public void setPopupType(int n) {
        this._popupType = n;
    }

    public int getPopupLocation() {
        return this._popupLocation;
    }

    public void setPopupLocation(int n) {
        this._popupLocation = n;
    }

    public boolean isStretchToFit() {
        return this._stretchToFit;
    }

    public void setStretchToFit(boolean bl) {
        this._stretchToFit = bl;
        this._stretchToFitSet = true;
    }

    public boolean isStretchToFitSet() {
        return this._stretchToFitSet;
    }

    public boolean isKeepPopupSize() {
        return this._keepPopupSize;
    }

    public void setKeepPopupSize(boolean bl) {
        this._keepPopupSize = bl;
    }

    public void setFocusLostBehavior(int n) {
        if (n != 0 && n != 1 && n != 4 && n != 3 && n != 2 && n != 5) {
            throw new IllegalArgumentException("setFocusLostBehavior must be one of: ExComboBox.COMMIT, ExComboBox.COMMIT_OR_REVERT, ExComboBox.REVERT, ExComboBox.PERSIST, ExComboBox.COMMIT_OR_RESET or ExComboBox.RESET");
        }
        this._focusLostBehavior = n;
    }

    public int getFocusLostBehavior() {
        return this._focusLostBehavior;
    }

    public void setPopupCancelBehavior(int n) {
        if (n != 3 && n != 2 && n != 5) {
            throw new IllegalArgumentException("setPopupCancelBehavior must be one of: ExComboBox.PERSIST, ExComboBox.REVERT, or ExComboBox.RESET");
        }
        this._popupCancelBehavior = n;
    }

    public int getPopupCancelBehavior() {
        return this._popupCancelBehavior;
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        PopupPanel popupPanel = ((ExComboBoxUI)((Object)this.getUI())).getPopupPanel();
        switch (this.getPopupCancelBehavior()) {
            case 3: {
                this.fireActionEvent();
                break;
            }
            case 5: {
                if (popupPanel == null) break;
                popupPanel.setSelectedObject(null);
                break;
            }
            case 2: {
                if (popupPanel == null) break;
                popupPanel.setSelectedObject(popupPanel.getPreviousSelectedObject());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (PROPERTY_SELECTED_ITEM.equals(propertyChangeEvent.getPropertyName())) {
            this.repaint();
        }
    }

    protected AbstractAction getDefaultOKAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 6965229655601970261L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ExComboBox.this.getClientProperty(ExComboBox.CLIENT_PROPERTY_TABLE_CELL_EDITOR);
                if (object instanceof CellEditor) {
                    if (object instanceof AbstractJideCellEditor) {
                        if (((AbstractJideCellEditor)object).isAutoStopCellEditing()) {
                            ((CellEditor)object).stopCellEditing();
                        }
                    } else {
                        ((CellEditor)object).stopCellEditing();
                    }
                }
                ExComboBox.this.hidePopup();
            }
        };
    }

    protected AbstractAction getDefaultCancelAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 2626780908578421972L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ExComboBox.this.getClientProperty(ExComboBox.CLIENT_PROPERTY_TABLE_CELL_EDITOR);
                if (object instanceof CellEditor) {
                    ((CellEditor)object).cancelCellEditing();
                }
                ExComboBox.this.hidePopup();
            }
        };
    }

    protected boolean isUpdateFromPopupOnFly() {
        return true;
    }

    public Action getDialogOKAction() {
        if (this._okAction == null) {
            this._okAction = new AbstractAction(){
                private static final long serialVersionUID = -7149449840313602840L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    if (ExComboBox.this.getEditor() != null && (object = ExComboBox.this.getClientProperty(ExComboBox.CLIENT_PROPERTY_POPUP_PANEL)) instanceof PopupPanel) {
                        ExComboBox.this.setSelectedItem(((PopupPanel)object).getSelectedObject());
                        ExComboBox.this.getEditor().getEditorComponent().repaint();
                    }
                }
            };
        }
        return this._okAction;
    }

    public Action getDialogCancelAction() {
        if (this._cancelAction == null) {
            this._cancelAction = new AbstractAction(){
                private static final long serialVersionUID = -5653555874369511434L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
        }
        return this._cancelAction;
    }

    private static boolean isTemporary(Component component, Component component2) {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        Window window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, component2);
        return (window != null || window2 != null) && (window == null || window2 != null && window != window2);
    }

    public boolean isReallyFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return false;
        }
        if (SystemInfo.isMacOSX() && ExComboBox.isTemporary(focusEvent.getOppositeComponent(), focusEvent.getComponent())) {
            return false;
        }
        if (focusEvent.getSource() == this && focusEvent.getOppositeComponent() == this.getEditor().getEditorComponent()) {
            return false;
        }
        if (focusEvent.getOppositeComponent() == this && focusEvent.getSource() == this.getEditor().getEditorComponent()) {
            return false;
        }
        if (this.getClientProperty(CLIENT_PROPERTY_TABLE_CELL_EDITOR) != null) {
            return false;
        }
        if (this.isEditable() && focusEvent.getSource() == this.getEditor().getEditorComponent() || !this.isEditable() && this == focusEvent.getSource()) {
            if (!focusEvent.isTemporary()) {
                this.commitEditWithFocusLostBehavior(false);
            }
            return true;
        }
        PopupPanel popupPanel = ((ExComboBoxUI)((Object)this.getUI())).getPopupPanel();
        if (popupPanel == null) {
            return false;
        }
        Container container = popupPanel.getTopLevelAncestor();
        if (container == null) {
            return false;
        }
        Component component = focusEvent.getOppositeComponent();
        if (this.isAncestorOf(component)) {
            return false;
        }
        return container != component && !container.isAncestorOf(component);
    }

    public void commitEditWithFocusLostBehavior(boolean bl) {
        switch (this.getFocusLostBehavior()) {
            case 0: {
                if (this.commitEdit()) break;
                this.notifyUser();
                break;
            }
            case 3: {
                if (!bl || this.commitEdit()) break;
                this.notifyUser();
                break;
            }
            case 5: {
                if (bl) {
                    if (this.commitEdit()) break;
                    this.notifyUser();
                    this.resetEdit();
                    break;
                }
                this.resetEdit();
                break;
            }
            case 2: {
                if (bl) {
                    this.commitOrRevert();
                    break;
                }
                this.revertEdit();
                break;
            }
            case 4: {
                if (this.commitEdit()) break;
                this.notifyUser();
                this.resetEdit();
                break;
            }
            default: {
                this.commitOrRevert();
            }
        }
    }

    private void commitOrRevert() {
        Object object = this.getSelectedItem();
        if (!this.commitEdit()) {
            this.notifyUser();
            if (this.getSelectedItem() == null) {
                this.setSelectedItem(object);
            } else {
                this.revertEdit();
            }
        }
    }

    protected void notifyUser() {
        PortingUtils.notifyUser(this);
    }

    public boolean isRetrievingValueFromPopup() {
        return this._retrievingValueFromPopup;
    }

    public boolean isSettingPopupInitialValue() {
        return this._settingPopupInitialValue;
    }

    public void setSettingPopupInitialValue(boolean bl) {
        this._settingPopupInitialValue = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitEdit() {
        Object object = null;
        try {
            Object object2 = this.getSelectedItem();
            PopupPanel popupPanel = ((ExComboBoxUI)((Object)this.getUI())).getPopupPanel();
            if (this.isPopupVisible() && popupPanel != null && popupPanel.isShowing()) {
                Object object3;
                if (this.isUpdateFromPopupOnFly()) {
                    object3 = this.getEditor();
                    object = object3.getItem();
                }
                if (object == null) {
                    try {
                        Action action;
                        this._retrievingValueFromPopup = true;
                        object3 = popupPanel.getInputMap(1).get(KeyStroke.getKeyStroke(10, 0));
                        if (object3 != null && (action = popupPanel.getActionMap().get(object3)) != null) {
                            action.actionPerformed(null);
                        }
                        object = popupPanel.getSelectedObject();
                    }
                    finally {
                        this._retrievingValueFromPopup = false;
                    }
                }
                if (this.isPopupVisible()) {
                    this.hidePopup();
                }
            } else {
                ComboBoxEditor comboBoxEditor = this.getEditor();
                object = comboBoxEditor.getItem();
            }
            if (!JideSwingUtilities.equals(object, object2, true) || !JideSwingUtilities.equals(object, this.selectedItemReminder, true)) {
                this.setSelectedItem(object);
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (JideSwingUtilities.equals(object, this.getSelectedItem(), true)) {
            this.getEditor().setItem(object);
            if (!OBJECT_UNINITIALIZED.equals(this._lastActionSelectedItem)) {
                this.fireActionEvent();
            }
            return true;
        }
        return false;
    }

    public void revertEdit() {
        Object object = null;
        Object object2 = null;
        try {
            object2 = this.getSelectedItem();
            object = this.getEditor().getItem();
        }
        catch (Exception exception) {
            this.getEditor().setItem(object2);
            this.setSelectedItem(object2);
        }
        if (object != object2) {
            this.getEditor().setItem(object2);
            this.setSelectedItem(object2);
        }
    }

    protected boolean comboBoxSelected() {
        return this.hasFocus();
    }

    protected void installColorFontAndBorder(JTable jTable, boolean bl, boolean bl2, int n, int n2) {
        ContextSensitiveCellRenderer.installColorFontAndBorder(jTable, this, bl, bl2, n, n2);
    }

    public void resetEdit() {
        Object object = null;
        Object object2 = null;
        try {
            object2 = this.getSelectedItem();
            object = this.getEditor().getItem();
        }
        catch (Exception exception) {
            this.getEditor().setItem(null);
            this.setSelectedItem(null);
        }
        if (object != object2) {
            this.getEditor().setItem(null);
            this.setSelectedItem(null);
        }
    }

    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void customizeDialogLocation(JDialog jDialog) {
    }

    public void customizeDialog(JDialog jDialog) {
    }

    public void customizePopup(JidePopup jidePopup, PopupPanel popupPanel) {
    }

    @Override
    public void fireActionEvent() {
        if (this._blockActionEvent || this.isEqual(this.getSelectedItem(), this._lastActionSelectedItem, true) && this.getClientProperty(CLIENT_PROPERTY_TABLE_CELL_EDITOR) == null) {
            return;
        }
        super.fireActionEvent();
        this._lastActionSelectedItem = this.getSelectedItemCloneIfNecessary();
    }

    Object getSelectedItemCloneIfNecessary() {
        return this.getSelectedItem();
    }

    public boolean isEmptyStringNull() {
        return this._emptyStringNull;
    }

    public void setEmptyStringNull(boolean bl) {
        this._emptyStringNull = bl;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        super.setModel(comboBoxModel);
        this._lastActionSelectedItem = OBJECT_UNINITIALIZED;
    }

    public boolean isPopupInLocalScreen() {
        return this._popupInLocalScreen;
    }

    public void setPopupInLocalScreen(boolean bl) {
        this._popupInLocalScreen = bl;
    }

    public void setPreferredPopupSize(Dimension dimension) {
        this._preferredPopupSize = dimension;
    }

    public Dimension getPreferredPopupSize() {
        return this._preferredPopupSize;
    }

    protected class LazyDelegateAction
    extends DelegateAction {
        protected KeyStroke _keyStroke;
        private static final long serialVersionUID = 5999374439334066208L;

        public LazyDelegateAction(KeyStroke keyStroke) {
            this._keyStroke = keyStroke;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            ComboBoxUI comboBoxUI = ExComboBox.this.getUI();
            if (comboBoxUI instanceof ExComboBoxUI) {
                PopupPanel popupPanel = ((ExComboBoxUI)((Object)comboBoxUI)).getPopupPanel();
                JComponent jComponent = this._keyStroke.getKeyCode() == 27 ? (JidePopup)SwingUtilities.getAncestorOfClass(JidePopup.class, popupPanel) : ExComboBox.this.getDelegateTarget(popupPanel);
                if (jComponent != null) {
                    Action action;
                    Object object = jComponent.getInputMap().get(this._keyStroke);
                    Object object2 = object = object == null ? jComponent.getInputMap(1).get(this._keyStroke) : object;
                    if (object != null && (action = jComponent.getActionMap().get(object)) instanceof Action) {
                        action.actionPerformed(new ActionEvent(jComponent, 0, "" + object));
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

