/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.PopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ColorExComboBox
extends ExComboBox
implements PropertyChangeListener {
    private int _colorMode = 1;
    private boolean _colorValueVisible = true;
    private boolean _colorIconVisible = true;
    private PopupPanel _popupPanel;
    public static final String PROPERTY_COLOR_MODE = "colorMode";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";
    private boolean _crossBackGroundStyle = false;
    private boolean _allowDefaultColor = true;
    private boolean _allowMoreColors = true;
    private boolean _invalidValueAllowed = false;
    protected ColorIcon _colorIcon;

    public ColorExComboBox() {
        super(0);
        this.setType(Color.class);
    }

    public ColorExComboBox(int n) {
        super(0);
        this.setType(Color.class);
        this._colorMode = n;
    }

    @Override
    public PopupPanel createPopupComponent() {
        ColorChooserPanel colorChooserPanel = new ColorChooserPanel(this.getColorMode(), this.isAllowMoreColors(), this.isAllowDefaultColor(), this.getLocale());
        colorChooserPanel.addPropertyChangeListener(PROPERTY_SELECTED_COLOR, this);
        if (this.getSelectedItem() instanceof Color) {
            Color color = (Color)this.getSelectedItem();
            int n = 255;
            if (color != null) {
                n = color.getAlpha();
            }
            colorChooserPanel.setAlphaValue(n);
        }
        this._popupPanel = colorChooserPanel;
        return colorChooserPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (PROPERTY_SELECTED_COLOR.equals(propertyChangeEvent.getPropertyName())) {
            Object object = this.getSelectedItem();
            this.setSelectedItem(propertyChangeEvent.getNewValue(), false);
            this.fireItemStateChanged(new ItemEvent(this, 701, object, 2));
            this.fireItemStateChanged(new ItemEvent(this, 701, propertyChangeEvent.getNewValue(), 1));
            this.repaint();
        }
        super.propertyChange(propertyChangeEvent);
    }

    public int getColorMode() {
        return this._colorMode;
    }

    public void setColorMode(int n) {
        int n2 = this._colorMode;
        if (n2 != n) {
            this._colorMode = n;
            this.firePropertyChange(PROPERTY_COLOR_MODE, n2, this._colorMode);
        }
    }

    public boolean isAllowDefaultColor() {
        return this._allowDefaultColor;
    }

    public void setAllowDefaultColor(boolean bl) {
        this._allowDefaultColor = bl;
    }

    public boolean isAllowMoreColors() {
        return this._allowMoreColors;
    }

    public void setAllowMoreColors(boolean bl) {
        this._allowMoreColors = bl;
    }

    public Color getSelectedColor() {
        this.updateColorFromEditorComponent();
        if (this.getSelectedItem() instanceof Color) {
            return (Color)this.getSelectedItem();
        }
        return null;
    }

    protected void updateColorFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Color && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedItem(color);
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) throws IllegalArgumentException {
        if (!(object instanceof Color) && !this.isInvalidValueAllowed() && object != null) {
            object = null;
            bl = false;
        }
        if (!this.isInvalidValueAllowed() && object == null && !this.isAllowDefaultColor()) {
            throw new IllegalArgumentException("Null color not accepted.");
        }
        super.setSelectedItem(object, bl);
        if (object instanceof Color) {
            if (this._popupPanel != null && this._popupPanel instanceof ColorChooserPanel) {
                int n = 255;
                n = ((Color)object).getAlpha();
                ((ColorChooserPanel)this._popupPanel).setAlphaValue(n);
            }
        } else if (object == null) {
            if (this._popupPanel != null && this._popupPanel instanceof ColorChooserPanel) {
                ((ColorChooserPanel)this._popupPanel).setAlphaValue(255);
            }
        } else if (this.isInvalidValueAllowed() && this._popupPanel != null && this._popupPanel instanceof ColorChooserPanel) {
            ((ColorChooserPanel)this._popupPanel).setAlphaValue(255);
        }
    }

    public boolean isCrossBackGroundStyle() {
        return this._crossBackGroundStyle;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this._crossBackGroundStyle != bl) {
            this._crossBackGroundStyle = bl;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isColorIconVisible()) {
            dimension.width += 20;
        }
        return dimension;
    }

    public boolean isColorValueVisible() {
        return this._colorValueVisible;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this._colorValueVisible;
        if (bl2 != bl) {
            this._colorValueVisible = bl;
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isColorIconVisible() {
        return this._colorIconVisible;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this._colorIconVisible;
        if (bl2 != bl) {
            this._colorIconVisible = bl;
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isInvalidValueAllowed() {
        return this._invalidValueAllowed;
    }

    public void setInvalidValueAllowed(boolean bl) {
        this._invalidValueAllowed = bl;
    }

    @Override
    public void customizeRendererComponent(Component component, Object object, int n, boolean bl, boolean bl2) {
        super.customizeRendererComponent(component, object, n, bl, bl2);
        if (component instanceof JLabel) {
            if (this._colorIcon == null) {
                this._colorIcon = new ColorIcon();
            }
            if (object instanceof Color) {
                this._colorIcon.setColor((Color)object);
            } else {
                this._colorIcon.setColor(null);
            }
            if (this.isColorIconVisible()) {
                ((JLabel)component).setIcon(this._colorIcon);
            } else {
                ((JLabel)component).setIcon(null);
            }
            ((JLabel)component).setIconTextGap(10);
            if (!this.isColorValueVisible()) {
                ((JLabel)component).setText("");
            }
        }
    }

    public class ColorIcon
    implements Icon {
        private int _margin = 1;
        private static final double RATIO = 1.618;
        private Color _color;

        public ColorIcon() {
            ColorExComboBox.this.setOpaque(false);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = component.getHeight();
            if (n3 > 18) {
                this._margin = 2;
            }
            if (!ColorExComboBox.this.isColorIconVisible()) {
                return;
            }
            int n4 = ColorExComboBox.this.isColorValueVisible() ? (int)((double)n3 * 1.618) : component.getWidth();
            Rectangle rectangle = new Rectangle(this._margin, this._margin, n4 - 2 * this._margin, n3 - 2 * this._margin - (ColorExComboBox.this.getHeight() - n3 + 1) % 2);
            if (ColorExComboBox.this.isCrossBackGroundStyle()) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n5 = rectangle.x + rectangle.width;
                int n6 = rectangle.y + rectangle.height;
                int n7 = 4;
                int n8 = 4;
                boolean bl = false;
                for (int i = rectangle.y + 1; i <= n6; i += n8) {
                    int n9 = bl ? rectangle.x + 1 : rectangle.x + 1 + n7;
                    boolean bl2 = bl = !bl;
                    while (n9 <= n5) {
                        graphics.fillRect(n9, i, Math.min(n7, n5 - n9 + 1), Math.min(n8, n6 - i + 1));
                        n9 += 2 * n7;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(Color.gray);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        public int getIconWidth() {
            return 26;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }
}

