/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Chartable3D;
import com.jidesoft.chart.render.AbstractPointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class SphericalPointRenderer
extends AbstractPointRenderer {
    @Override
    public Shape renderPoint(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        ChartStyle chartStyle = this.getStyle(chart, chartModel, chartable, bl, bl2, bl3);
        if (!chartStyle.isPointsVisible()) {
            return null;
        }
        float f = this.getOutlineWidth();
        Color color = chartStyle.getPointColor();
        Color color2 = ColorUtils.getDerivedColor(color, 0.25f);
        Color color3 = ColorUtils.getDerivedColor(color, 0.63f);
        Color color4 = ColorUtils.getDerivedColor(color, 0.75f);
        int n3 = chartStyle.getPointSize();
        if (chartable != null && chartable instanceof Chartable3D) {
            n3 = (int)((Chartable3D)chartable).getZ().position();
        }
        int n4 = n - (int)Math.floor((double)n3 / 2.0);
        int n5 = n2 - (int)Math.floor((double)n3 / 2.0);
        Ellipse2D.Double double_ = new Ellipse2D.Double(n4, n5, n3, n3);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(JideSwingUtilities.getRadialGradientPaint(new Point2D.Double((double)n4 + (double)(2 * n3) / 5.0, (double)n5 + (double)(2 * n3) / 5.0), (float)n3 / 2.0f, new float[]{0.2f, 0.6f, 0.8f, 1.0f}, new Color[]{color4, color3, color, color2}));
        graphics2D.fill(double_);
        if (bl && chart.isSelectionShowsOutline()) {
            graphics2D.setColor(this.getSelectionColor());
            graphics2D.setStroke(new BasicStroke(f));
            Ellipse2D.Double double_2 = new Ellipse2D.Double((float)n4 - f / 2.0f, (float)n5 - f / 2.0f, (float)n3 + f, (float)n3 + f);
            graphics2D.draw(double_2);
        }
        graphics2D.dispose();
        return double_;
    }
}

