/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractPieLabelRenderer;
import com.jidesoft.chart.render.DefaultPointLabeler;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListSelectionModel;

public class LinePieLabelRenderer
extends AbstractPieLabelRenderer
implements PieLabelRenderer2D {
    private Chart chart;
    private int labelXOffset = 20;
    private int labelLineGapSize = 3;
    private Color lineColor = Color.darkGray;
    private Stroke lineStroke = new BasicStroke(1.0f);
    private PointLabeler pointLabeler = new DefaultPointLabeler();
    private int tickLength = 10;
    private int segmentControlPointDistance = 12;
    private int labelControlPointDistance = 5;
    private boolean showAllLabels = false;

    @Override
    public PointLabeler getPointLabeler() {
        return this.pointLabeler;
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        this.pointLabeler = pointLabeler;
    }

    @Override
    public int getTickLength() {
        return this.tickLength;
    }

    @Override
    public void setTickLength(int n) {
        this.tickLength = n;
    }

    public int getSegmentControlPointDistance() {
        return this.segmentControlPointDistance;
    }

    public void setSegmentControlPointDistance(int n) {
        this.segmentControlPointDistance = n;
    }

    public int getLabelControlPointDistance() {
        return this.labelControlPointDistance;
    }

    public void setLabelControlPointDistance(int n) {
        this.labelControlPointDistance = n;
    }

    public int getLabelLineGapSize() {
        return this.labelLineGapSize;
    }

    public void setLabelLineGapSize(int n) {
        this.labelLineGapSize = n;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    protected Color createLineColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLineColor();
    }

    protected Color createLabelColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelColor();
    }

    protected Font createLabelFont(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelFont();
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }

    public int getLabelXOffset() {
        return this.labelXOffset;
    }

    public void setLabelXOffset(int n) {
        this.labelXOffset = n;
    }

    public boolean isShowAllLabels() {
        return this.showAllLabels;
    }

    public void setShowAllLabels(boolean bl) {
        this.showAllLabels = bl;
    }

    @Override
    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n, int n2, int[] nArray, ChartStyle chartStyle) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.renderLabels((Graphics2D)graphics, chart, chartModel, (Point2D)point, (double)n, (double)n2, fArray, chartStyle);
    }

    @Override
    public void renderLabels(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d, double d2, float[] fArray, ChartStyle chartStyle) {
        this.chart = chart;
        Pair<List<PieLabel>, List<PieLabel>> pair = this.createLabels(graphics2D, chart, chartModel, point2D, d, d2, fArray, chartStyle);
        List<PieLabel> list = pair.getFirst();
        List<PieLabel> list2 = pair.getSecond();
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 1));
        for (PieLabel pieLabel : list) {
            if (!pieLabel.isVisible()) continue;
            pieLabel.draw(graphics2D);
        }
        for (PieLabel pieLabel : list2) {
            if (!pieLabel.isVisible()) continue;
            pieLabel.draw(graphics2D);
        }
    }

    Pair<List<PieLabel>, List<PieLabel>> createLabels(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d, double d2, float[] fArray, ChartStyle chartStyle) {
        Object object;
        double d3 = chartStyle.getPieOffsetAngle();
        ArrayList<Chartable> arrayList = new ArrayList<Chartable>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Chartable> arrayList4 = new ArrayList<Chartable>();
        ArrayList<Float> arrayList5 = new ArrayList<Float>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        for (int i = 0; i < fArray.length; ++i) {
            object = chartModel.getPoint(i);
            double d4 = d3 + (double)(fArray[i] / 2.0f);
            if (Math.cos(Math.toRadians(d4)) >= 0.0) {
                arrayList6.add(i);
                arrayList5.add(Float.valueOf((float)d4));
                arrayList4.add((Chartable)object);
            } else {
                arrayList3.add(i);
                arrayList2.add(Float.valueOf((float)d4));
                arrayList.add((Chartable)object);
            }
            d3 += (double)fArray[i];
        }
        List<PieLabel> list = this.createLabelColumn(graphics2D, chart, chartModel, point2D, d, d2, -1, arrayList2, arrayList3, arrayList, chartStyle);
        object = this.createLabelColumn(graphics2D, chart, chartModel, point2D, d, d2, 1, arrayList5, arrayList6, arrayList4, chartStyle);
        return new Pair<List<PieLabel>, Object>(list, object);
    }

    private List<PieLabel> createLabelColumn(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d, double d2, int n, List<Float> list, List<Integer> list2, List<Chartable> list3, ChartStyle chartStyle) {
        double d3;
        Serializable serializable;
        int n2;
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        Insets insets = chart.getInsets();
        Dimension dimension = chart.getSize();
        double d6 = dimension == null ? d2 : dimension.getHeight();
        ArrayList<PieLabel> arrayList = new ArrayList<PieLabel>();
        int n3 = list3.size();
        List<Integer> list4 = LinePieLabelRenderer.reorder(n3);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Font> arrayList3 = new ArrayList<Font>();
        ArrayList<PieLabelLocator> arrayList4 = new ArrayList<PieLabelLocator>();
        double d7 = 0.0;
        for (int i = 0; i < list4.size() && d7 < d6; ++i) {
            int n4 = list4.get(i);
            Chartable chartable = list3.get(n4);
            Font font = this.createLabelFont(chart, chartModel, chartable);
            if (font == null) {
                font = graphics2D.getFont();
            }
            arrayList3.add(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            d7 += (double)fontMetrics.getHeight();
            if (!(d7 < d6)) continue;
            arrayList2.add(n4);
        }
        double d8 = d / 2.0;
        int n5 = (int)(0.2 * d8);
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n6 = (Integer)arrayList2.get(i);
            int n7 = list2.get(n6);
            float f = list.get(n6).floatValue();
            double d9 = (double)this.getTickLength() / 2.0;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            n2 = listSelectionModel != null && listSelectionModel.isSelectedIndex(n7) ? 1 : 0;
            int n8 = chartStyle.isPieSegmentsAlwaysExploded() || n2 != 0 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n5 * Math.cos(Math.toRadians(f))) : 0;
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || n2 != 0 && chart.isSelectionShowsExplodedSegments() ? (int)(-((double)n5 * Math.sin(Math.toRadians(f)))) : 0;
            double d10 = d5 - (d2 / 2.0 - d9) * Math.sin(Math.toRadians(f));
            serializable = (Font)arrayList3.get(i);
            PieLabelLocator pieLabelLocator = new PieLabelLocator(n6, (Font)serializable, d10 + (double)n9, n8, n9);
            arrayList4.add(pieLabelLocator);
        }
        Collections.sort(arrayList4);
        double d11 = 0.0;
        Font font = graphics2D.getFont();
        for (PieLabelLocator pieLabelLocator : arrayList4) {
            font = pieLabelLocator.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n10 = fontMetrics.getDescent();
            pieLabelLocator.setActualPosition(d11 += (double)fontMetrics.getAscent());
            d11 += (double)n10;
        }
        while ((d3 = this.adjust(graphics2D, 0.0, d6 - (double)font.getSize(), arrayList4)) > 1.0) {
        }
        for (PieLabelLocator pieLabelLocator : arrayList4) {
            int n11;
            int n12;
            n2 = pieLabelLocator.getModelIndex();
            double d12 = list.get(n2).floatValue();
            Chartable chartable = list3.get(n2);
            String string = this.pointLabeler == null ? null : this.pointLabeler.getDisplayText(chartable);
            font = pieLabelLocator.getFont();
            serializable = graphics2D.getFontMetrics(font);
            int n13 = ((FontMetrics)serializable).getDescent();
            int n14 = n12 = string == null ? 0 : ((FontMetrics)serializable).stringWidth(string);
            if (n > 0) {
                n11 = (int)(d4 + d / 2.0 + (double)this.labelXOffset);
                if ((n11 -= insets.right) + n12 > chart.getWidth()) {
                    n11 = chart.getWidth() - n12 - insets.right;
                }
            } else {
                n11 = (int)(d4 - d / 2.0 - (double)n12) - this.labelXOffset;
                if ((n11 += insets.left) < insets.left) {
                    n11 = insets.left;
                }
            }
            double d13 = (double)this.getTickLength() / 2.0;
            double d14 = d4 + (d / 2.0 - d13) * Math.cos(Math.toRadians(d12));
            double d15 = d5 - (d2 / 2.0 - d13) * Math.sin(Math.toRadians(d12));
            double d16 = d4 + (d / 2.0 + d13) * Math.cos(Math.toRadians(d12));
            double d17 = d5 - (d2 / 2.0 + d13) * Math.sin(Math.toRadians(d12));
            double d18 = d4 + (d / 2.0 + (double)this.segmentControlPointDistance) * Math.cos(Math.toRadians(d12));
            double d19 = d5 - (d2 / 2.0 + (double)this.segmentControlPointDistance) * Math.sin(Math.toRadians(d12));
            Point2D.Double double_ = new Point2D.Double(d14, d15);
            Point2D.Double double_2 = new Point2D.Double(d16, d17);
            Point2D.Double double_3 = new Point2D.Double(d18, d19);
            PieLabel pieLabel = new PieLabel(chartModel, chartable, string, n11, (int)pieLabelLocator.getActualPosition(), double_, double_2, double_3, n, n12, ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getDescent(), n13, ((FontMetrics)serializable).getAscent(), pieLabelLocator.getxOffset(), pieLabelLocator.getyOffset());
            arrayList.add(pieLabel);
        }
        return arrayList;
    }

    private double adjust(Graphics2D graphics2D, double d, double d2, List<PieLabelLocator> list) {
        double d3 = -1.0;
        PieLabelLocator pieLabelLocator = null;
        for (PieLabelLocator pieLabelLocator2 : list) {
            double d4 = this.adjust(graphics2D, d, d2, pieLabelLocator2, list, false);
            if (!(d4 > d3)) continue;
            d3 = d4;
            pieLabelLocator = pieLabelLocator2;
        }
        if (pieLabelLocator != null) {
            this.adjust(graphics2D, d, d2, pieLabelLocator, list, true);
        }
        return d3;
    }

    private double adjust(Graphics2D graphics2D, double d, double d2, PieLabelLocator pieLabelLocator, List<PieLabelLocator> list, boolean bl) {
        double d3;
        int n = list.indexOf(pieLabelLocator);
        int n2 = (int)Math.round(Math.signum(pieLabelLocator.difference()));
        if (n2 == 0) {
            return 0.0;
        }
        int n3 = n + n2;
        if (n3 < 0) {
            d3 = d;
        } else if (n3 >= list.size()) {
            d3 = d2;
        } else {
            PieLabelLocator pieLabelLocator2 = list.get(n3);
            d3 = n2 < 0 ? pieLabelLocator2.maxPosition(graphics2D) + (double)pieLabelLocator.getAscent(graphics2D) : pieLabelLocator2.minPosition(graphics2D) - (double)pieLabelLocator.getDescent(graphics2D);
        }
        assert (d3 <= d2);
        double d4 = pieLabelLocator.getExpectedPosition();
        double d5 = d4 > d3 && d4 < pieLabelLocator.getActualPosition() || d4 < d3 && d4 > pieLabelLocator.getActualPosition() ? d4 : (pieLabelLocator.getActualPosition() + d3) / 2.0;
        double d6 = Math.abs(d5 - pieLabelLocator.getActualPosition());
        if (bl) {
            pieLabelLocator.setActualPosition(d5);
        }
        return d6;
    }

    public static List<Integer> reorder(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        if (n == 0) {
            return arrayList;
        }
        if (n == 1) {
            arrayList.add(0);
            return arrayList;
        }
        boolean[] blArray = new boolean[n];
        double d = (double)n - 1.0;
        do {
            for (double d2 = 0.0; d2 < (double)n; d2 += d) {
                int n2 = (int)d2;
                if (blArray[n2]) continue;
                blArray[n2] = true;
                arrayList.add(n2);
            }
            d /= 2.0;
        } while (arrayList.size() < n);
        return arrayList;
    }

    class PieLabel
    implements Drawable,
    Comparable<PieLabel> {
        private ChartModel model;
        private Chartable chartable;
        private Point2D tickStart;
        private Point2D tickEnd;
        private Point2D controlPoint;
        int x;
        int y;
        int direction;
        int labelWidth;
        int fontHeight;
        int labelDescent;
        int labelAscent;
        int xOffset;
        int yOffset;
        private String labelString;
        private boolean visible = true;
        private boolean positioned = false;

        public PieLabel(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public PieLabel(ChartModel chartModel, Chartable chartable, String string, int n, int n2, Point2D point2D, Point2D point2D2, Point2D point2D3, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.model = chartModel;
            this.chartable = chartable;
            this.tickStart = point2D;
            this.tickEnd = point2D2;
            this.controlPoint = point2D3;
            this.x = n;
            this.y = n2;
            this.direction = n3;
            this.labelWidth = n4;
            this.fontHeight = n5;
            this.labelDescent = n6;
            this.labelAscent = n7;
            this.xOffset = n8;
            this.yOffset = n9;
            this.labelString = string;
        }

        public PieLabel(PieLabel pieLabel) {
            this.model = pieLabel.model;
            this.chartable = pieLabel.chartable;
            this.tickStart = pieLabel.tickStart;
            this.tickEnd = pieLabel.tickEnd;
            this.controlPoint = pieLabel.controlPoint;
            this.x = pieLabel.x;
            this.y = pieLabel.y;
            this.direction = pieLabel.direction;
            this.labelWidth = pieLabel.labelWidth;
            this.fontHeight = pieLabel.fontHeight;
            this.labelDescent = pieLabel.labelDescent;
            this.labelAscent = pieLabel.labelAscent;
            this.xOffset = pieLabel.xOffset;
            this.yOffset = pieLabel.yOffset;
            this.labelString = pieLabel.labelString;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean isPositioned() {
            return this.positioned;
        }

        public void setPositioned(boolean bl) {
            this.positioned = bl;
        }

        public String toString() {
            return String.format("#<PieLabel label=%s x=%d y=%d>", this.labelString, this.x, this.y);
        }

        @Override
        public int compareTo(PieLabel pieLabel) {
            if (this.y == pieLabel.y) {
                if (this.x < pieLabel.x) {
                    return -1;
                }
                if (this.x > pieLabel.x) {
                    return 1;
                }
                return 0;
            }
            if (this.y < pieLabel.y) {
                return -1;
            }
            return 1;
        }

        @Override
        public void draw(Graphics graphics) {
            Serializable serializable;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.labelString == null) {
                return;
            }
            Color color = LinePieLabelRenderer.this.createLineColor(LinePieLabelRenderer.this.chart, this.model, this.chartable);
            int n = Math.max(this.x + this.xOffset, 0);
            if (n + this.labelWidth > LinePieLabelRenderer.this.chart.getXEnd()) {
                n = LinePieLabelRenderer.this.chart.getXEnd() - this.labelWidth;
            }
            int n2 = n + this.labelWidth;
            if (this.direction < 0 && n < 0) {
                n = 0;
                n2 = this.labelWidth;
            } else if (this.direction > 0 && n + this.labelWidth > LinePieLabelRenderer.this.chart.getXEnd()) {
                n2 = n = LinePieLabelRenderer.this.chart.getXEnd() - this.labelWidth;
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(LinePieLabelRenderer.this.getLineStroke());
            if (this.direction == 1) {
                if (this.tickEnd.getX() < (double)n) {
                    serializable = new CubicCurve2D.Double(this.tickStart.getX() + (double)this.xOffset, this.tickStart.getY() + (double)this.yOffset, this.controlPoint.getX() + (double)this.xOffset, this.controlPoint.getY() + (double)this.yOffset, n - LinePieLabelRenderer.this.labelLineGapSize - LinePieLabelRenderer.this.labelControlPointDistance, this.y, n - LinePieLabelRenderer.this.labelLineGapSize, this.y);
                    graphics2D.draw((Shape)((Object)serializable));
                }
            } else if ((double)n2 < this.tickEnd.getX()) {
                serializable = new CubicCurve2D.Double(this.tickStart.getX() + (double)this.xOffset, this.tickStart.getY() + (double)this.yOffset, this.tickEnd.getX() + (double)this.xOffset, this.tickEnd.getY() + (double)this.yOffset, n2 + LinePieLabelRenderer.this.labelLineGapSize + LinePieLabelRenderer.this.labelControlPointDistance, this.y, n2 + LinePieLabelRenderer.this.labelLineGapSize, this.y);
                graphics2D.draw((Shape)((Object)serializable));
            }
            if (this.labelString != null) {
                serializable = LinePieLabelRenderer.this.createLabelFont(LinePieLabelRenderer.this.chart, this.model, this.chartable);
                if (serializable != null) {
                    graphics2D.setFont((Font)serializable);
                }
                graphics2D.setColor(LinePieLabelRenderer.this.createLabelColor(LinePieLabelRenderer.this.chart, this.model, this.chartable));
                graphics2D.drawString(this.labelString, n, this.y + this.labelDescent);
            }
            graphics2D.dispose();
        }
    }

    static class PieLabelLocator
    implements Comparable<PieLabelLocator> {
        private final double expectedPosition;
        private double actualPosition;
        private final Font font;
        private final int modelIndex;
        private final int xOffset;
        private final int yOffset;

        public PieLabelLocator(int n, Font font, Number number, int n2, int n3) {
            this.modelIndex = n;
            this.font = font;
            this.actualPosition = this.expectedPosition = number.doubleValue();
            this.xOffset = n2;
            this.yOffset = n3;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public void setActualPosition(double d) {
            this.actualPosition = d;
        }

        public double getExpectedPosition() {
            return this.expectedPosition;
        }

        public double getActualPosition() {
            return this.actualPosition;
        }

        public Font getFont() {
            return this.font;
        }

        public int getHeight() {
            return this.font.getSize();
        }

        public int getAscent(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            return fontMetrics.getAscent();
        }

        public int getDescent(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            return fontMetrics.getDescent();
        }

        public double minPosition(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            return this.actualPosition - (double)fontMetrics.getAscent();
        }

        public double maxPosition(Graphics2D graphics2D) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            return this.actualPosition + (double)fontMetrics.getDescent();
        }

        public double difference() {
            return this.expectedPosition - this.actualPosition;
        }

        public double variance() {
            double d = this.difference();
            return d * d;
        }

        public int getxOffset() {
            return this.xOffset;
        }

        public int getyOffset() {
            return this.yOffset;
        }

        @Override
        public int compareTo(PieLabelLocator pieLabelLocator) {
            double d = this.expectedPosition + (double)this.getyOffset();
            double d2 = pieLabelLocator.getExpectedPosition() + (double)pieLabelLocator.getyOffset();
            return Double.compare(d, d2);
        }

        public String toString() {
            return "PieLabelLocator{expectedPosition=" + this.expectedPosition + ", actualPosition=" + this.actualPosition + ", modelIndex=" + this.modelIndex + '}';
        }
    }
}

