/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.UIManager;

public abstract class AbstractRenderer {
    public static final String PROPERTY_OUTLINE_WIDTH = "Outline Width";
    private float outlineWidth = 2.0f;
    protected static final int ROLLOVER_INTENSITY = 50;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean alwaysShowOutlines = false;
    private Color selectionColor;
    private Color outlineColor = null;

    public AbstractRenderer() {
        Color color = UIManager.getColor("Chart.selectionBackground");
        if (color == null) {
            color = UIManager.getColor("Chart.selection");
        }
        this.selectionColor = color == null ? Color.orange : color;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public Color getOutlineColor() {
        if (this.outlineColor == null) {
            this.outlineColor = UIManager.getColor("Chart.background");
            if (this.outlineColor == null) {
                this.outlineColor = UIManager.getColor("Panel.background");
            }
        }
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public float getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(float f) {
        float f2 = this.outlineWidth;
        this.outlineWidth = f;
        this.support.firePropertyChange(PROPERTY_OUTLINE_WIDTH, Float.valueOf(f2), Float.valueOf(f));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isAlwaysShowOutlines() {
        return this.alwaysShowOutlines;
    }

    public void setAlwaysShowOutlines(boolean bl) {
        this.alwaysShowOutlines = bl;
    }
}

