/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RangeProvider;
import com.jidesoft.range.AggregatedRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SummingChartModel
extends AbstractDelegatingChartModel
implements RangeProvider {
    private static int instance = 1;
    private List<Chartable> points = null;
    private Range<?> xRange = null;
    private Range<?> yRange = null;
    private Orientation orientation = Orientation.vertical;
    private Map<Positionable, AggregatedRange> xRanges = null;
    private Map<Positionable, AggregatedRange> yRanges = null;
    private boolean considerDelegateRanges = true;

    public SummingChartModel() {
        this.setName(this.getClass().getSimpleName() + "-" + instance);
        ++instance;
    }

    public SummingChartModel(ChartModel ... chartModelArray) {
        super(chartModelArray);
        this.setName(this.getClass().getSimpleName() + "-" + instance);
        ++instance;
    }

    public SummingChartModel(Collection<ChartModel> collection) {
        super(collection);
        this.setName(this.getClass().getSimpleName() + "-" + instance);
        ++instance;
    }

    public SummingChartModel(String string, ChartModel ... chartModelArray) {
        super(chartModelArray);
        this.setName(string);
        ++instance;
    }

    public void clear() {
        this.setDelegates(null, false);
        if (this.points != null) {
            this.points.clear();
        }
    }

    public boolean isConsiderDelegateRanges() {
        return this.considerDelegateRanges;
    }

    public void setConsiderDelegateRanges(boolean bl) {
        this.considerDelegateRanges = bl;
    }

    @Override
    public Annotation getAnnotation(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public boolean isAnnotationsVisible() {
        return false;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.update();
    }

    @Override
    public Chartable getPoint(int n) {
        if (this.points == null) {
            this.update();
        }
        return this.points.get(n);
    }

    @Override
    public int getPointCount() {
        if (this.points == null) {
            this.update();
        }
        return this.points.size();
    }

    @Override
    public Range<?> getXRange() {
        if (this.xRange == null) {
            this.update();
        }
        return this.xRange;
    }

    public AggregatedRange getXRange(Positionable positionable) {
        if (this.xRanges == null) {
            this.update();
        }
        return this.xRanges.get(positionable);
    }

    @Override
    public Range<?> getYRange() {
        if (this.yRange == null) {
            this.update();
        }
        return this.yRange;
    }

    public AggregatedRange getYRange(Positionable positionable) {
        if (this.yRanges == null) {
            this.update();
        }
        return this.yRanges.get(positionable);
    }

    protected Chartable createChartable(Positionable positionable, Positionable positionable2) {
        return new ChartPoint(positionable, positionable2);
    }

    @Override
    protected void update() {
        if (this.points == null) {
            this.points = new ArrayList<Chartable>();
        } else {
            this.points.clear();
        }
        this.xRanges = this.getXRanges(this.getDelegates());
        this.yRanges = this.getYRanges(this.getDelegates());
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        if (this.orientation == Orientation.horizontal) {
            for (Map.Entry<Positionable, AggregatedRange> entry : this.xRanges.entrySet()) {
                double d5;
                double d6;
                double d7;
                Positionable positionable = entry.getKey();
                AggregatedRange aggregatedRange = entry.getValue();
                if (aggregatedRange == null) continue;
                double d8 = positionable.position();
                if (d8 < d3) {
                    d3 = d8;
                }
                if (d8 > d4) {
                    d4 = d8;
                }
                if ((d7 = (d6 = aggregatedRange.getPositiveSum()) + (d5 = aggregatedRange.getNegativeSum())) > d2) {
                    d2 = d7;
                }
                if (this.considerDelegateRanges && d6 > d4) {
                    d4 = d6;
                }
                if (d7 < d) {
                    d = d7;
                }
                if (this.considerDelegateRanges && d5 < d3) {
                    d3 = d5;
                }
                ChartPoint chartPoint = new ChartPoint(d7, positionable);
                this.points.add(chartPoint);
            }
        } else {
            for (Map.Entry<Positionable, AggregatedRange> entry : this.yRanges.entrySet()) {
                double d9;
                double d10;
                double d11;
                Positionable positionable = entry.getKey();
                AggregatedRange aggregatedRange = entry.getValue();
                if (aggregatedRange == null) continue;
                double d12 = positionable.position();
                if (d12 < d) {
                    d = d12;
                }
                if (d12 > d2) {
                    d2 = d12;
                }
                if ((d11 = (d10 = aggregatedRange.getPositiveSum()) + (d9 = aggregatedRange.getNegativeSum())) > d4) {
                    d4 = d11;
                }
                if (this.considerDelegateRanges && d10 > d4) {
                    d4 = d10;
                }
                if (d11 < d3) {
                    d3 = d11;
                }
                if (this.considerDelegateRanges && d9 < d3) {
                    d3 = d9;
                }
                ChartPoint chartPoint = new ChartPoint(positionable, d11);
                this.points.add(chartPoint);
            }
        }
        Collections.sort(this.points);
        this.xRange = new NumericRange(d, d2);
        this.yRange = new NumericRange(d3, d4);
    }

    Map<Positionable, AggregatedRange> getYRanges(ChartModel ... chartModelArray) {
        TreeMap<Positionable, ArrayList<Positionable>> treeMap = new TreeMap<Positionable, ArrayList<Positionable>>();
        for (ChartModel object : chartModelArray) {
            for (int aggregatedRange = 0; aggregatedRange < object.getPointCount(); ++aggregatedRange) {
                Chartable chartable = object.getPoint(aggregatedRange);
                Positionable positionable = chartable.getX();
                if (positionable == null) continue;
                Positionable positionable2 = chartable.getY();
                ArrayList<Positionable> arrayList = (ArrayList<Positionable>)treeMap.get(positionable);
                if (arrayList == null) {
                    arrayList = new ArrayList<Positionable>();
                }
                if (positionable2 != null) {
                    arrayList.add(positionable2);
                }
                treeMap.put(positionable, arrayList);
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : treeMap.entrySet()) {
            Positionable positionable = (Positionable)entry.getKey();
            AggregatedRange aggregatedRange = this.computeAggregatedRange((List)entry.getValue());
            hashMap.put(positionable, aggregatedRange);
        }
        return hashMap;
    }

    Map<Positionable, AggregatedRange> getXRanges(ChartModel ... chartModelArray) {
        TreeMap<Positionable, ArrayList<Positionable>> treeMap = new TreeMap<Positionable, ArrayList<Positionable>>();
        for (ChartModel object : chartModelArray) {
            for (int aggregatedRange = 0; aggregatedRange < object.getPointCount(); ++aggregatedRange) {
                Chartable chartable = object.getPoint(aggregatedRange);
                Positionable positionable = chartable.getY();
                if (positionable == null) continue;
                Positionable positionable2 = chartable.getX();
                ArrayList<Positionable> arrayList = (ArrayList<Positionable>)treeMap.get(positionable);
                if (arrayList == null) {
                    arrayList = new ArrayList<Positionable>();
                }
                if (positionable2 != null) {
                    arrayList.add(positionable2);
                }
                treeMap.put(positionable, arrayList);
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : treeMap.entrySet()) {
            Positionable positionable = (Positionable)entry.getKey();
            AggregatedRange aggregatedRange = this.computeAggregatedRange((List)entry.getValue());
            hashMap.put(positionable, aggregatedRange);
        }
        return hashMap;
    }

    private AggregatedRange computeAggregatedRange(List<Positionable> list) {
        Positionable positionable;
        Positionable positionable2 = list == null || list.size() == 0 ? null : list.get(0);
        Positionable positionable3 = positionable = list == null || list.size() == 0 ? null : list.get(list.size() - 1);
        if (positionable2 == null || positionable == null) {
            return null;
        }
        return new AggregatedRange(list);
    }
}

