/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.util.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Immutable
public final class LeanMemoryChartModel
implements LeanChartModel {
    private static int instanceCount = 0;
    private String name;
    private boolean cyclical;
    private List<double[]> points = new CopyOnWriteArrayList<double[]>();
    private final List<ChartModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public LeanMemoryChartModel(List<double[]> list) {
        this(null, list);
    }

    public LeanMemoryChartModel(double[][] dArray) {
        this(null, dArray);
    }

    public LeanMemoryChartModel(String string, List<double[]> list) {
        this.name = string;
        this.init();
        this.setPoints(list);
    }

    public LeanMemoryChartModel(String string, double[][] dArray) {
        this.name = string;
        this.init();
        this.setPoints(dArray);
    }

    protected void init() {
        ++instanceCount;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getClass().getName() + "@" + Integer.toHexString(instanceCount);
        }
        return this.name;
    }

    @Override
    public Chartable getPoint(int n) {
        double[] dArray = this.points.get(n);
        return new ChartPoint(dArray[0], dArray[1]);
    }

    @Override
    public double[] getPointPositions(int n) {
        return this.points.get(n);
    }

    @Override
    public int getPointCount() {
        return this.points.size();
    }

    private void setPoints(List<double[]> list) {
        this.points = list == null ? new CopyOnWriteArrayList<double[]>() : new CopyOnWriteArrayList<double[]>(list);
        this.fireModelChanged();
    }

    private void setPoints(double[][] dArray) {
        LinkedList<double[]> linkedList = new LinkedList<double[]>();
        Collections.addAll(linkedList, dArray);
        this.setPoints(linkedList);
    }

    public void setCyclical(boolean bl) {
        this.cyclical = bl;
        this.fireModelChanged();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChanged() {
        List<ChartModelListener> list = this.listeners;
        synchronized (list) {
            for (ChartModelListener chartModelListener : this.listeners) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.listeners.contains(chartModelListener)) {
            this.listeners.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new Iterator<Chartable>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < LeanMemoryChartModel.this.points.size();
            }

            @Override
            public Chartable next() {
                double[] dArray = (double[])LeanMemoryChartModel.this.points.get(this.pos++);
                return new ChartPoint(dArray[0], dArray[1]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an element of an array.");
            }
        };
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LeanMemoryChartModel leanMemoryChartModel = (LeanMemoryChartModel)object;
        return !(this.name == null ? leanMemoryChartModel.name != null : !this.name.equals(leanMemoryChartModel.name));
    }
}

