/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Polynomial {
    private List<Double> coefficients;

    public Polynomial(Double[] doubleArray) {
        this.setCoefficients(doubleArray);
    }

    public Polynomial(double ... dArray) {
        this.coefficients = new ArrayList<Double>();
        for (double d : dArray) {
            this.coefficients.add(d);
        }
    }

    public List<Double> getCoefficients() {
        return this.coefficients;
    }

    public Double getCoefficient(int n) {
        return this.coefficients.get(n);
    }

    public void setCoefficients(List<Double> list) {
        this.coefficients = list;
    }

    public void setCoefficients(Double[] doubleArray) {
        this.coefficients = Arrays.asList(doubleArray);
    }

    public double eval(double d) {
        double d2 = 0.0;
        for (int i = this.coefficients.size() - 1; i >= 0; --i) {
            d2 = d2 * d + this.coefficients.get(i);
        }
        return d2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.coefficients == null ? 0 : this.coefficients.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Polynomial polynomial = (Polynomial)object;
        return !(this.coefficients == null ? polynomial.coefficients != null : !this.coefficients.equals(polynomial.coefficients));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<Polynomial expression='");
        boolean bl = true;
        for (int i = 0; i < this.coefficients.size(); ++i) {
            Double d = this.coefficients.get(i);
            if (d == 0.0) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("+");
            }
            stringBuilder.append(this.coefficients.get(i));
            if (i >= 1) {
                stringBuilder.append("x");
            }
            if (i < 2) continue;
            stringBuilder.append("^");
            stringBuilder.append(i);
        }
        stringBuilder.append("'>");
        return stringBuilder.toString();
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Polynomial.class.getName(), 4096);
        }
    }
}

