/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.AboveBoundsException;
import com.jidesoft.chart.BelowBoundsException;
import com.jidesoft.chart.ChartBoundsException;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.List;

public class FunctionMap {
    public static double getXApproximately(ChartModel chartModel, double d) throws ChartException {
        boolean bl = false;
        int n = chartModel.getPointCount();
        if (n <= 1) {
            throw new IllegalStateException("Too few points in model to estimate an X value");
        }
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        for (int i = 1; i < n; ++i) {
            Positionable positionable;
            Chartable chartable = chartModel.getPoint(i - 1);
            Chartable chartable2 = chartModel.getPoint(i);
            if (chartable == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + (i - 1));
            }
            if (chartable2 == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + i);
            }
            double d4 = Math.min(chartable.getY().position(), chartable2.getY().position());
            double d5 = Math.max(chartable.getY().position(), chartable2.getY().position());
            int n2 = chartable.getY().position() < chartable2.getY().position() ? 1 : -1;
            Positionable positionable2 = n2 == 1 ? chartable.getX() : chartable2.getX();
            Positionable positionable3 = positionable = n2 == 1 ? chartable2.getX() : chartable.getX();
            if (d4 <= d && d5 >= d) {
                double d6 = (d5 - d4) / (positionable.position() - positionable2.position());
                double d7 = positionable2.position() + (d - d4) / d6;
                return d7;
            }
            if (d < d4) {
                bl = true;
            }
            d2 = Math.min(d2, positionable2.position());
            d3 = Math.max(d3, positionable.position());
        }
        if (bl) {
            throw new BelowBoundsException((double)d2, d + " is less than the value of the first line segment in " + chartModel);
        }
        throw new AboveBoundsException((double)d3, d + " is greater than the value of the first line segment in " + chartModel);
    }

    public static List<Double> getXsApproximately(ChartModel chartModel, double d) throws BelowBoundsException, AboveBoundsException {
        boolean bl = false;
        int n = chartModel.getPointCount();
        if (n <= 1) {
            throw new IllegalStateException("Too few points in model to estimate an X value");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        for (int i = 1; i < n; ++i) {
            Chartable chartable = chartModel.getPoint(i - 1);
            Chartable chartable2 = chartModel.getPoint(i);
            Positionable positionable = chartable.getY();
            Positionable positionable2 = chartable2.getY();
            Positionable positionable3 = chartable.getX();
            Positionable positionable4 = chartable2.getX();
            if (positionable.position() <= d && positionable2.position() >= d) {
                double d4 = (positionable2.position() - positionable.position()) / (positionable4.position() - positionable3.position());
                double d5 = positionable3.position() + (d - positionable.position()) / d4;
                arrayList.add(d5);
            } else if (d < positionable.position()) {
                bl = true;
            }
            d2 = Math.min(d2, positionable3.position());
            d3 = Math.max(d3, positionable4.position());
        }
        if (arrayList.size() == 0) {
            if (bl) {
                throw new BelowBoundsException((double)d2, d + " is less than the value of the first line segment in " + chartModel);
            }
            throw new AboveBoundsException((double)d3, d + " is greater than the value of the first line segment in " + chartModel);
        }
        return arrayList;
    }

    public static List<Double> getYsApproximately(ChartModel chartModel, double d) throws BelowBoundsException, AboveBoundsException {
        boolean bl = false;
        int n = chartModel.getPointCount();
        if (n <= 1) {
            throw new IllegalStateException("Too few points in model to estimate a Y value");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        for (int i = 1; i < n; ++i) {
            Chartable chartable = chartModel.getPoint(i - 1);
            Chartable chartable2 = chartModel.getPoint(i);
            Positionable positionable = chartable.getX();
            Positionable positionable2 = chartable2.getX();
            Positionable positionable3 = chartable.getY();
            Positionable positionable4 = chartable2.getY();
            if (positionable.position() <= d && positionable2.position() >= d) {
                double d4 = (positionable4.position() - positionable3.position()) / (positionable2.position() - positionable.position());
                double d5 = positionable3.position() + (d - positionable.position()) * d4;
                arrayList.add(d5);
            } else if (d < positionable.position()) {
                bl = true;
            }
            d2 = Math.min(d2, positionable.position());
            d3 = Math.max(d3, positionable2.position());
        }
        if (arrayList.size() == 0) {
            if (bl) {
                throw new BelowBoundsException((double)d2, d + " is less than the value of the first line segment in " + chartModel);
            }
            throw new AboveBoundsException((double)d3, d + " is greater than the value of the first line segment in " + chartModel);
        }
        return arrayList;
    }

    public static double getYApproximately(ChartModel chartModel, double d) throws ChartException {
        if (chartModel == null) {
            throw new NullPointerException("Cannot compute y values from a null ChartModel!");
        }
        int n = chartModel.getPointCount();
        if (n <= 1) {
            throw new ChartException("Too few points in model to estimate a Y value");
        }
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        for (int i = 1; i < n; ++i) {
            Chartable chartable = chartModel.getPoint(i - 1);
            Chartable chartable2 = chartModel.getPoint(i);
            if (chartable == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + (i - 1));
            }
            if (chartable2 == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + i);
            }
            double d4 = Math.min(chartable.getX().position(), chartable2.getX().position());
            double d5 = Math.max(chartable.getX().position(), chartable2.getX().position());
            int n2 = chartable.getX().position() < chartable2.getX().position() ? 1 : -1;
            Positionable positionable = n2 == 1 ? chartable.getY() : chartable2.getY();
            Positionable positionable2 = chartable2.getY();
            if (d4 <= d && d5 >= d) {
                double d6 = (double)n2 * (chartable2.getY().position() - chartable.getY().position()) / (d5 - d4);
                double d7 = positionable.position() + (d - d4) * d6;
                return d7;
            }
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d5);
        }
        if (d < d2) {
            throw new BelowBoundsException((double)d2, d + " is less than " + d2 + ", which is the value of the first line segment in " + chartModel);
        }
        if (d > d3) {
            throw new AboveBoundsException((double)d3, d + " is greater than " + d3 + ", which is the value of the last line segment in " + chartModel);
        }
        throw new ChartBoundsException("Out of bounds with x = " + d);
    }
}

