/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.SortedChartModel;

public class Areas {
    public static double areaUnder(ChartModel chartModel) {
        if (chartModel == null || chartModel.getPointCount() < 2) {
            return 0.0;
        }
        Double d = null;
        Double d2 = null;
        for (Chartable chartable : chartModel) {
            double d3 = chartable.getX().position();
            if (d == null || d3 < d) {
                d = d3;
            }
            if (d2 != null && !(d3 > d2)) continue;
            d2 = d3;
        }
        return Areas.areaUnder(chartModel, d, d2);
    }

    public static double areaUnder(ChartModel chartModel, double d, double d2) {
        if (chartModel == null || chartModel.getPointCount() < 2) {
            return 0.0;
        }
        SortedChartModel sortedChartModel = new SortedChartModel(chartModel, Orientation.vertical);
        double d3 = 0.0;
        for (int i = 0; i < sortedChartModel.getPointCount() - 1; ++i) {
            double d4;
            double d5;
            double d6;
            Chartable chartable = sortedChartModel.getPoint(i);
            Chartable chartable2 = sortedChartModel.getPoint(i + 1);
            double d7 = chartable.getX().position();
            double d8 = chartable2.getX().position();
            double d9 = chartable.getY().position();
            double d10 = chartable2.getY().position();
            if (!(d8 > d) || !(d7 < d2)) continue;
            if (d > d7 && d < d8) {
                d6 = Areas.computeGradient(d7, d9, d8, d10);
                d5 = d6 * (d - d7);
                d7 = d;
                d9 += d5;
            } else if (d2 > d7 && d2 < d8) {
                d6 = Areas.computeGradient(d7, d9, d8, d10);
                d5 = d6 * (d2 - d7);
                d8 = d2;
                d10 = d9 + d5;
            }
            if (Math.signum(d9) != Math.signum(d10)) {
                d6 = Areas.computeGradient(d7, d9, d8, d10);
                d5 = d9 / Math.abs(d6);
                d4 = d5 * d9 / 2.0;
                d3 += d4;
                d7 += d5;
                d9 = 0.0;
            }
            d6 = d8 - d7;
            d5 = Math.min(Math.abs(d9), Math.abs(d10));
            d4 = Math.abs(d9 - d10);
            double d11 = d5 * d6 + 0.5 * d4 * d6;
            d3 += d11;
        }
        return d3;
    }

    private static double computeGradient(double d, double d2, double d3, double d4) {
        double d5 = d4 - d2;
        double d6 = d3 - d;
        return d5 / d6;
    }
}

