/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import javax.xml.bind.annotation.XmlAttribute;

public class Tick {
    private double position = 0.0;
    private String label;
    private boolean major = true;

    public Tick() {
    }

    public Tick(double d) {
        this(d, false);
    }

    public Tick(double d, boolean bl) {
        this.setPosition(d);
        this.setMajor(bl);
    }

    public Tick(double d, String string) {
        this.setPosition(d);
        this.setLabel(string);
    }

    @XmlAttribute
    public boolean isMajor() {
        return this.major;
    }

    public void setMajor(boolean bl) {
        this.major = bl;
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    @XmlAttribute
    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.label == null ? 0 : this.label.hashCode());
        long l = Double.doubleToLongBits(this.position);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tick tick = (Tick)object;
        if (this.label == null ? tick.label != null : !this.label.equals(tick.label)) {
            return false;
        }
        return Double.doubleToLongBits(this.position) == Double.doubleToLongBits(tick.position);
    }

    public String toString() {
        return String.format("#<Tick position='%.2f' label='%s'>", this.position, this.label);
    }
}

