/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class SimpleNumericTickCalculator
implements NumericTickCalculator {
    public static final String PROPERTY_NUMBER_FORMAT = "Number Format";
    public static final String PROPERTY_START = "Start";
    public static final String PROPERTY_MAJOR_TICK_INTERVAL = "Major Tick Interval";
    public static final String PROPERTY_MINOR_TICK_INTERVAL = "Minor Tick Interval";
    private int maxTickCount = 3000;
    private double start = 0.0;
    private Double minorTickInterval = 0.1;
    private Double majorTickInterval = 1.0;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private int scale = 0;

    public SimpleNumericTickCalculator() {
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setGroupingUsed(false);
    }

    public SimpleNumericTickCalculator(double d, double d2) {
        this();
        this.start = d;
        this.majorTickInterval = d2 <= 0.0 ? null : Double.valueOf(d2);
        this.minorTickInterval = null;
    }

    public SimpleNumericTickCalculator(double d, double d2, double d3) {
        this();
        this.start = d;
        this.majorTickInterval = d2 <= 0.0 ? null : Double.valueOf(d2);
        this.minorTickInterval = d3 <= 0.0 ? null : Double.valueOf(d3);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = this.numberFormat;
        this.numberFormat = numberFormat;
        this.support.firePropertyChange(PROPERTY_NUMBER_FORMAT, numberFormat2, numberFormat);
    }

    @Override
    public void setNumberFormat(String string) {
        this.setNumberFormat(new DecimalFormat(string));
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double d) {
        double d2 = this.start;
        this.start = d;
        this.support.firePropertyChange(PROPERTY_START, d2, d);
    }

    public double getMajorTickInterval() {
        return this.majorTickInterval;
    }

    public void setMajorTickInterval(double d) {
        double d2 = this.majorTickInterval;
        this.majorTickInterval = d;
        this.support.firePropertyChange(PROPERTY_MAJOR_TICK_INTERVAL, d2, d);
    }

    public Double getMinorTickInterval() {
        return this.minorTickInterval;
    }

    public void setMinorTickInterval(Double d) {
        Double d2 = this.minorTickInterval;
        this.minorTickInterval = d;
        this.support.firePropertyChange(PROPERTY_MINOR_TICK_INTERVAL, d2, d);
    }

    public int getMaxTickCount() {
        return this.maxTickCount;
    }

    public void setMaxTickCount(int n) {
        this.maxTickCount = n;
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        double d;
        double d2;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        double d3 = this.start;
        double d4 = this.majorTickInterval == null ? 0.0 : this.majorTickInterval;
        double d5 = d3 + d4;
        double d6 = d2 = this.minorTickInterval == null ? range.maximum() + d4 / 2.0 : range.maximum() + this.minorTickInterval / 2.0;
        double d7 = this.minorTickInterval == null ? (this.majorTickInterval == null ? 0.0 : this.majorTickInterval / 100.0) : (d = this.minorTickInterval / 100.0);
        while (d3 < d2 && arrayList.size() < this.maxTickCount) {
            Tick tick;
            String string;
            double d8;
            if (d3 == this.start || Math.abs(d3 - d5) <= d) {
                d8 = this.scale == 0 ? d3 : d3 * Math.pow(10.0, this.scale);
                string = this.numberFormat.format(d8);
                tick = new Tick(d3, string);
                arrayList.add(tick);
                if (Math.abs(d3 - d5) <= d) {
                    d5 += this.majorTickInterval == null ? 0.0 : this.majorTickInterval;
                }
            } else if (d3 < d5) {
                arrayList.add(new Tick(d3));
            } else {
                d8 = this.scale == 0 ? d5 : d5 * Math.pow(10.0, this.scale);
                string = this.numberFormat.format(d8);
                tick = new Tick(d5, string);
                arrayList.add(tick);
                arrayList.add(new Tick(d3));
                d5 += this.majorTickInterval.doubleValue();
            }
            if (this.majorTickInterval == null) break;
            if (this.minorTickInterval == null) {
                d3 += this.majorTickInterval.doubleValue();
                continue;
            }
            d3 += this.minorTickInterval.doubleValue();
        }
        Tick[] tickArray = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

