/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.math.BigDecimal;
import java.util.ArrayList;

public class IntegerTickCalculator
extends DefaultNumericTickCalculator {
    private double tolerance = 1.0E-10;

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    private BigDecimal getInteger(double d) {
        double d2 = Math.rint(d);
        if (Math.abs(d - d2) <= this.tolerance) {
            return new BigDecimal(d2);
        }
        return null;
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        Tick[] tickArray = super.calculateTicks(range);
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (Tick tick : tickArray) {
            double d = tick.getPosition();
            BigDecimal bigDecimal = this.getInteger(d);
            if (bigDecimal == null) continue;
            tick.setPosition(bigDecimal.doubleValue());
            arrayList.add(tick);
        }
        Tick[] tickArray2 = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray2);
    }
}

