/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.AbstractAutoRanger;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.MultiAutoRanger;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.CombinedNumericRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZeroAlignedAutoRanger
extends AbstractAutoRanger
implements MultiAutoRanger {
    private boolean alwaysIncludeXZero = false;
    private boolean alwaysIncludeYZeros = false;

    public ZeroAlignedAutoRanger() {
    }

    public ZeroAlignedAutoRanger(Double d, Double d2, Double d3, Double d4) {
        super(d, d2, d3, d4);
    }

    public boolean isAlwaysIncludeZeros() {
        return this.alwaysIncludeXZero && this.alwaysIncludeYZeros;
    }

    public void setAlwaysIncludeZeros(boolean bl) {
        this.setAlwaysIncludeXZero(bl);
        this.setAlwaysIncludeYZeros(bl);
    }

    public boolean isAlwaysIncludeXZero() {
        return this.alwaysIncludeXZero;
    }

    public void setAlwaysIncludeXZero(boolean bl) {
        this.alwaysIncludeXZero = bl;
    }

    public boolean isAlwaysIncludeYZeros() {
        return this.alwaysIncludeYZeros;
    }

    public void setAlwaysIncludeYZeros(boolean bl) {
        this.alwaysIncludeYZeros = bl;
    }

    @Override
    public Pair<Range<?>, Range<?>> getRanges(Chart chart) {
        Map<Axis, Range<?>> map = this.getAxisRanges(chart);
        Range<?> range = map.get(chart.getXAxis());
        Range<?> range2 = map.get(chart.getYAxis());
        return new Pair(range, range2);
    }

    @Override
    public Map<Axis, Range<?>> getAxisRanges(Chart chart) {
        Object object;
        Axis axis = chart.getYAxis();
        Axis axis2 = chart.getXAxis();
        RangeDescriptor rangeDescriptor = new RangeDescriptor(chart);
        AbstractNumericRange abstractNumericRange = rangeDescriptor.xRange;
        Map map = rangeDescriptor.axisRanges;
        Double d = rangeDescriptor.findPlusMinusRatio();
        if (!rangeDescriptor.changeRanges || d == null) {
            return null;
        }
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        Double d2 = null;
        Double d3 = null;
        for (Map.Entry entry : map.entrySet()) {
            double d4;
            double d5;
            double d6;
            Axis axis3 = (Axis)entry.getKey();
            Range range = (Range)entry.getValue();
            double d7 = range.maximum() > 0.0 ? range.maximum() : 0.0;
            double d8 = d6 = range.minimum() < 0.0 ? Math.abs(range.minimum()) : 0.0;
            if (rangeDescriptor.allYPositive) {
                if (!this.alwaysIncludeYZeros) {
                    if (d2 == null) {
                        d2 = this.findSmallestRangeMinimum((Range)map.get(axis), axis.isFlipped(), map);
                    }
                    d5 = this.convertPrimaryToY((Range)map.get(axis), axis.isFlipped(), d2, range, axis3.isFlipped());
                } else {
                    d5 = 0.0;
                }
                d4 = range.maximum();
            } else if (rangeDescriptor.allYNegative) {
                if (!this.alwaysIncludeYZeros) {
                    if (d3 == null) {
                        d3 = this.findLargestRangeMaximum((Range)map.get(axis), axis.isFlipped(), map);
                    }
                    d4 = this.convertPrimaryToY((Range)map.get(axis), axis.isFlipped(), d3, range, axis3.isFlipped());
                } else {
                    d4 = 0.0;
                }
                d5 = range.minimum();
            } else if (Math.abs(d) < 1.0E-10) {
                if (d7 > d6) {
                    d4 = d7;
                    d5 = -d7;
                } else {
                    d5 = -d6;
                    d4 = d6;
                }
            } else if (d7 > d6) {
                d4 = d7;
                d5 = -d7 / d;
            } else {
                d5 = -d6;
                d4 = d6 * d;
            }
            map.put(axis3, new NumericRange(d5, d4));
        }
        if (this.alwaysIncludeXZero && axis2.getQuantity() == AxisQuantity.NUMBER) {
            if (rangeDescriptor.allXPositive) {
                abstractNumericRange = new NumericRange(0.0, abstractNumericRange.maximum());
            } else if (rangeDescriptor.allXNegative) {
                abstractNumericRange = new NumericRange(abstractNumericRange.minimum(), 0.0);
            }
        }
        double d9 = abstractNumericRange.minimum();
        double d10 = abstractNumericRange.maximum();
        Range<?> range = (Range<?>)map.get(chart.getYAxis());
        if (range == null) {
            range = chart.getYAxis().getRange();
        }
        double d11 = range.minimum();
        double d12 = range.maximum();
        if (!chart.isBarsGrouped() && (object = this.adjustForStackedBars(chart, d9, d11, d10, d12)) != null) {
            d9 = ((Pair)object).getFirst().minimum();
            d10 = ((Range)((Pair)object).getFirst()).maximum();
            d11 = ((Range)((Pair)object).getSecond()).minimum();
            d12 = ((Range)((Pair)object).getSecond()).maximum();
        }
        this.rescaleYAxes(chart, map, d11, d12);
        object = this.applyXRangeConstraints(chart.getXAxis(), d9, d10);
        map.put(chart.getXAxis(), object);
        return map;
    }

    void rescaleYAxes(Chart chart, Map<Axis, Range<?>> map, double d, double d2) {
        Range<?> range = this.applyYRangeConstraints(chart.getYAxis(), d, d2);
        double d3 = (range.minimum() - d2) / (d - d2);
        double d4 = (range.maximum() - d) / (d2 - d);
        Double d5 = this.getFixMinY();
        for (Map.Entry<Axis, Range<?>> entry : map.entrySet()) {
            Axis axis = entry.getKey();
            if (axis == null || axis.equals(chart.getYAxis())) continue;
            Range<?> range2 = entry.getValue();
            Range<?> range3 = this.applyYRangeConstraints(axis, range2.minimum(), range2.maximum());
            double d6 = range3.size();
            map.put(axis, new NumericRange(range3.minimum(), range3.maximum()));
        }
        map.put(chart.getYAxis(), range);
    }

    private Pair<Range<?>, Range<?>> adjustForStackedBars(Chart chart, double d, double d2, double d3, double d4) {
        Pair<Range<?>, Range<?>> pair = this.getStackedRanges(chart);
        if (pair == null) {
            return null;
        }
        NumericRange numericRange = pair.getFirst();
        NumericRange numericRange2 = pair.getSecond();
        if (numericRange != null) {
            if (numericRange.minimum() < d) {
                d = numericRange.minimum();
            }
            if (numericRange.maximum() > d3) {
                d3 = numericRange.maximum();
            }
        }
        if (numericRange2 != null) {
            if (numericRange2.minimum() < d2) {
                d2 = numericRange2.minimum();
            }
            if (numericRange2.maximum() > d4) {
                d4 = numericRange2.maximum();
            }
        }
        numericRange = new NumericRange(d, d3);
        numericRange2 = new NumericRange(d2, d4);
        return new Pair(numericRange, numericRange2);
    }

    private double findSmallestRangeMinimum(Range<?> range, boolean bl, Map<Axis, Range<?>> map) {
        double d = Double.MAX_VALUE;
        for (Map.Entry<Axis, Range<?>> entry : map.entrySet()) {
            Axis axis = entry.getKey();
            Range<?> range2 = entry.getValue();
            double d2 = range == range2 ? range2.minimum() : this.convertYToPrimary(range, bl, range2.minimum(), range2, axis.isFlipped());
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    private double findLargestRangeMaximum(Range<?> range, boolean bl, Map<Axis, Range<?>> map) {
        double d = -1.7976931348623157E308;
        for (Map.Entry<Axis, Range<?>> entry : map.entrySet()) {
            Axis axis = entry.getKey();
            Range<?> range2 = entry.getValue();
            double d2 = range == range2 ? range2.maximum() : this.convertYToPrimary(range, bl, range2.maximum(), range2, axis.isFlipped());
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double convertYToPrimary(Range<?> range, boolean bl, double d, Range<?> range2, boolean bl2) {
        if (range == null || range.equals(range2) || range2.maximum() == range2.minimum()) {
            return d;
        }
        double d2 = Math.max(Math.abs(range.minimum()), Math.abs(range.maximum()));
        boolean bl3 = d2 == Math.abs(range.maximum());
        double d3 = bl3 ? range.maximum() / range2.maximum() : range.minimum() / range2.minimum();
        double d4 = bl2 ? (range2.maximum() - d) * d3 : (d - range2.minimum()) * d3;
        double d5 = bl ? range.maximum() - d4 : range.minimum() + d4;
        return d5;
    }

    private double convertPrimaryToY(Range<?> range, boolean bl, double d, Range<?> range2, boolean bl2) {
        if (range == null || range.equals(range2) || range2.size() == 0.0) {
            return d;
        }
        double d2 = Math.max(Math.abs(range.minimum()), Math.abs(range.maximum()));
        boolean bl3 = d2 == Math.abs(range.maximum());
        double d3 = bl3 ? range.maximum() / range2.maximum() : range.minimum() / range2.minimum();
        double d4 = bl ? range.maximum() - d : d - range.minimum();
        double d5 = bl2 ? range2.maximum() - d4 / d3 : range2.minimum() + d4 / d3;
        return d5;
    }

    private class RangeDescriptor {
        private CombinedNumericRange xRange = new CombinedNumericRange();
        private Map<Axis, Range<?>> axisRanges = new HashMap();
        private boolean allYPositive = true;
        private boolean allYNegative = true;
        private boolean allXPositive = true;
        private boolean allXNegative = true;
        private boolean changeRanges;

        RangeDescriptor(Chart chart) {
            Object object;
            Axis axis;
            List<ChartModel> list = chart.getModels();
            this.changeRanges = list.size() > 0;
            for (ChartModel object2 : list) {
                axis = chart.getAxisForModel(object2);
                object = ZeroAlignedAutoRanger.this.getRanges(object2);
                Range<?> range = ((Pair)object).getFirst();
                if (range != null) {
                    this.xRange.add(new NumericRange(range.minimum(), range.maximum()));
                }
                Range<?> range2 = ((Pair)object).getSecond();
                this.allYPositive = this.allYPositive && range2 != null && range2.minimum() > 0.0 && range2.maximum() > 0.0;
                this.allYNegative = this.allYNegative && range2 != null && range2.minimum() < 0.0 && range2.maximum() < 0.0;
                this.allXPositive = this.allXPositive && range != null && range.minimum() > 0.0 && range.maximum() > 0.0;
                this.allXNegative = this.allXNegative && range != null && range.minimum() < 0.0 && range.maximum() < 0.0;
                CombinedNumericRange combinedNumericRange = (CombinedNumericRange)this.axisRanges.get(axis);
                if (ZeroAlignedAutoRanger.this.isNullOrInfinite(range2)) continue;
                if (combinedNumericRange == null) {
                    combinedNumericRange = new CombinedNumericRange();
                }
                this.axisRanges.put(axis, combinedNumericRange);
                combinedNumericRange.add(new NumericRange(range2.minimum(), range2.maximum()));
            }
            for (Map.Entry entry : this.axisRanges.entrySet()) {
                axis = (Axis)entry.getKey();
                object = (Range)entry.getValue();
                if (object.minimum() == object.maximum()) {
                    object = ZeroAlignedAutoRanger.this.applyYRangeConstraints(axis, object.minimum(), object.maximum());
                }
                this.axisRanges.put(axis, (Range<?>)object);
            }
        }

        private Double findPlusMinusRatio() {
            HashMap<Axis, Double> hashMap = new HashMap<Axis, Double>();
            for (Map.Entry<Axis, Range<?>> object : this.axisRanges.entrySet()) {
                Axis axis = object.getKey();
                Range<?> range = object.getValue();
                double d = range.maximum() > 0.0 ? range.maximum() : 0.0;
                double d2 = range.minimum() < 0.0 ? Math.abs(range.minimum()) : 0.0;
                double d3 = d / d2;
                hashMap.put(axis, d3);
            }
            Object object = null;
            for (Map.Entry entry : hashMap.entrySet()) {
                double d = (Double)entry.getValue();
                if (object != null && !(Math.abs(d - 0.5) < Math.abs((Double)object - 0.5))) continue;
                object = d;
            }
            return object;
        }
    }
}

