/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.PointShape;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import javax.swing.JComponent;

public class SimpleLegendItem<Item>
extends JComponent
implements LegendItem<Item, Object> {
    private String label;
    private Paint fill;
    private PointShape shape;
    private Color outlineColor;
    private int outlineWidth = 1;

    public SimpleLegendItem(PointShape pointShape, Paint paint, String string) {
        this.setShape(pointShape);
        this.fill = paint;
        this.label = string;
        Dimension dimension = new Dimension(30, 20);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public PointShape getShape() {
        return this.shape;
    }

    public void setShape(PointShape pointShape) {
        if (pointShape == null) {
            pointShape = PointShape.BOX;
        }
        this.shape = pointShape;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public Item getItem() {
        return null;
    }

    @Override
    public Object getSource() {
        return null;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int n) {
        this.outlineWidth = n;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl = this.outlineColor != null;
        int n = bl ? this.outlineWidth : 0;
        int n2 = 20 - 2 * (2 + n);
        int n3 = 30 - 2 * (2 + n);
        int n4 = Math.min(n3, n2);
        this.shape.paint(graphics, 15.0, 10.0, n4, this.fill, bl, this.outlineColor, n);
    }
}

