/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.alert;

import com.jidesoft.alert.AlertGroup;
import com.jidesoft.alert.ScreenCapture;
import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class Alert
extends JidePopup {
    private CustomAnimation _hideAnimation;
    private CustomAnimation _showAnimation;
    private Image _screenImage;
    private boolean _alwaysOnTop = true;
    private AlertGroup _alertGroup;

    public Alert() {
        this.setFocusCycleRoot(true);
        this.setPopupType(2);
        this.setKeepPreviousSize(false);
    }

    @Override
    protected void internalShowPopup(int n, int n2, Component component) {
        Component component2 = this._actualOwner = component != null ? component : this.getOwner();
        if (this._actualOwner != null) {
            this._actualOwnerLocation = this._actualOwner.getLocationOnScreen();
        }
        this.createWindow(this._actualOwner, n, n2);
        if (this._showAnimation != null && this._showAnimation.getEffect() == 201 || this._hideAnimation != null && this._hideAnimation.getEffect() == 201) {
            this.captureScreen();
        }
        if (this._showAnimation != null) {
            if (this._showAnimation.getEndLocation() == null) {
                this._showAnimation.setEndLocation(new Point(n, n2));
            }
            this._showAnimation.setScreenImage(this._screenImage);
            this._showAnimation.setVisibleBounds(PortingUtils.getLocalScreenBounds());
            this._showAnimation.start(this._window);
            this._showAnimation.setCallback(new CustomAnimation.Callback(){

                @Override
                public void performed() {
                    Alert.this.showAnimationEnds();
                }
            });
        } else {
            this.showPopupImmediately();
        }
    }

    protected void showAnimationEnds() {
        if (this.getPopupType() == 2 && this._window != null) {
            this._window.pack();
        }
        this.showPopupImmediately();
    }

    private void captureScreen() {
        try {
            ScreenCapture screenCapture = new ScreenCapture(PortingUtils.getLocalScreenBounds());
            this._screenImage = screenCapture.getScreenshot();
            screenCapture.resetScreenshot();
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public void hidePopup(final boolean bl) {
        if (this._window == null || !this._window.isShowing()) {
            return;
        }
        if (this._hideAnimation != null) {
            this._hideAnimation.setStartLocation(this._window.getLocationOnScreen());
            this._hideAnimation.setScreenImage(this._screenImage);
            this._hideAnimation.setCallback(new CustomAnimation.Callback(){

                @Override
                public void performed() {
                    Alert.this.hidePopupImmediately(bl);
                }
            });
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Alert.this._hideAnimation.start(Alert.this._window);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.hidePopupImmediately(bl);
        }
    }

    @Override
    public void hidePopupImmediately(boolean bl) {
        super.hidePopupImmediately(bl);
        this._screenImage = null;
        if (this._showAnimation != null) {
            this._showAnimation.stop();
        }
        if (this._hideAnimation != null) {
            this._hideAnimation.stop();
        }
        if (this.getAlertGroup() != null) {
            this.getAlertGroup().remove(this);
        }
    }

    public CustomAnimation getHideAnimation() {
        return this._hideAnimation;
    }

    public void setHideAnimation(CustomAnimation customAnimation) {
        this._hideAnimation = customAnimation;
    }

    public CustomAnimation getShowAnimation() {
        return this._showAnimation;
    }

    public void setShowAnimation(CustomAnimation customAnimation) {
        this._showAnimation = customAnimation;
    }

    @Override
    protected void showPopupImmediately() {
        super.showPopupImmediately();
        if (this.isAlwaysOnTop() && !SystemInfo.isJdk15Above() && this._window != null) {
            this._window.toFront();
        }
    }

    @Override
    protected ResizableWindow createHeavyweightPopupContainer(Component component) {
        ResizableWindow resizableWindow = super.createHeavyweightPopupContainer(component);
        if (this.isAlwaysOnTop() && SystemInfo.isJdk15Above()) {
            resizableWindow.setAlwaysOnTop(true);
        }
        return resizableWindow;
    }

    public boolean isAlwaysOnTop() {
        return this._alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean bl) {
        this._alwaysOnTop = bl;
    }

    public AlertGroup getAlertGroup() {
        return this._alertGroup;
    }

    public void setAlertGroup(AlertGroup alertGroup) {
        this._alertGroup = alertGroup;
    }

    @Override
    protected Point getDisplayStartLocation(Rectangle rectangle, Dimension dimension, int n) {
        if (this.getAlertGroup() != null) {
            return this.getAlertGroup().getDisplayStartLocation(this, rectangle, dimension, n, this.DISTANCE_TO_SCREEN_BORDER);
        }
        return super.getDisplayStartLocation(rectangle, dimension, n);
    }

    @Override
    protected void contentResized() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        if (this.getPopupBorder() != null) {
            Insets insets = this.getPopupBorder().getBorderInsets(this);
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
        } else if (this._window.getBorder() != null) {
            Insets insets = this._window.getBorder().getBorderInsets(this._window);
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
        }
        this._window.setSize(dimension2);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(Alert.class.getName(), 2);
        }
    }
}

