/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.PreviousState;
import java.awt.Rectangle;
import java.io.Serializable;

public class DockableBarContext
implements Serializable {
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_HORI_DOCKED = 2;
    public static final int STATE_VERT_DOCKED = 3;
    public static final String[] STATE_NAMES = new String[]{"\"HIDE\"", "\"FLOAT\"", "\"HORI_DOCKED\"", "\"VERT_DOCKED\""};
    private int _initMode = 2;
    private int _currentMode = -1;
    public static final int DOCK_SIDE_NORTH = 1;
    public static final int DOCK_SIDE_SOUTH = 2;
    public static final int DOCK_SIDE_EAST = 4;
    public static final int DOCK_SIDE_WEST = 8;
    public static final int DOCK_SIDE_HORIZONTAL = 3;
    public static final int DOCK_SIDE_VERTICAL = 12;
    public static final int DOCK_SIDE_ALL = 15;
    public static final String[] SIDE_NAMES = new String[]{"\"NORTH\"", "\"SOUTH\"", "\"EAST\"", "\"WEST\""};
    private int _initSide = 1;
    private int _initIndex;
    private int _initSubindex;
    private boolean _initPosition = true;
    private int _currentDockSide = 1;
    private Rectangle _undockedBounds;
    private int _dockedWidth;
    private int _dockedHeight;
    private int _dockID;
    private PreviousState _hiddenPreviousState;
    private PreviousState _closePreviousState;
    private PreviousState _dockPreviousState;
    private PreviousState _floatPreviousState;
    private boolean _available = true;
    private PreviousState _availablePreviousState;

    public int getInitMode() {
        return this._initMode;
    }

    public void setInitMode(int n) {
        if (n > 3 || n < -3) {
            throw new IllegalArgumentException("initMode must be one of the following values - DockableBarContext.STATE_FLOATING, DockableBarContext.STATE_HIDDEN, DockableBarContext.STATE_HORI_DOCKED or DockableBarContext.STATE_VERT_DOCKED");
        }
        this._initMode = n;
    }

    public int getCurrentMode() {
        if (this._currentMode == -1) {
            return this._initMode;
        }
        return this._currentMode;
    }

    public void setCurrentMode(int n) {
        if (n != 1 && n != 0 && n != 2 && n != 3) {
            throw new IllegalArgumentException("currentMode must be one of the following values - DockableBarContext.STATE_FLOATING, DockableBarContext.STATE_HIDDEN, DockableBarContext.STATE_HORI_DOCKED or DockableBarContext.STATE_VERT_DOCKED");
        }
        this._currentMode = n;
    }

    public boolean isHidden() {
        return this.getCurrentMode() == 0;
    }

    public boolean isHoriDocked() {
        return this.getCurrentMode() == 2;
    }

    public boolean isVertDocked() {
        return this.getCurrentMode() == 3;
    }

    public boolean isFloating() {
        return this.getCurrentMode() == 1;
    }

    public int getInitSide() {
        return this._initSide;
    }

    public void setInitSide(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException("initSide must be one of the following values - DockableBarContext.DOCK_SIDE_NORTH, DockableBarContext.DOCK_SIDE_SOUTH, DockableBarContext.DOCK_SIDE_EAST or DockableBarContext.DOCK_SIDE_WEST");
        }
        this._initSide = n;
    }

    public boolean isInitPosition() {
        return this._initPosition;
    }

    public void setInitPosition(boolean bl) {
        this._initPosition = bl;
    }

    public int getInitIndex() {
        return this._initIndex;
    }

    public void setInitIndex(int n) {
        this._initIndex = n;
    }

    public int getInitSubindex() {
        return this._initSubindex;
    }

    public void setInitSubindex(int n) {
        this._initSubindex = n;
    }

    public int getCurrentDockSide() {
        return this._currentDockSide;
    }

    public void setCurrentDockSide(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException("currentDockSide must be one of the following values - DockableBarContext.DOCK_SIDE_NORTH, DockableBarContext.DOCK_SIDE_SOUTH, DockableBarContext.DOCK_SIDE_EAST or DockableBarContext.DOCK_SIDE_WEST");
        }
        this._currentDockSide = n;
    }

    public Rectangle getUndockedBounds() {
        return this._undockedBounds;
    }

    public void setUndockedBounds(Rectangle rectangle) {
        this._undockedBounds = rectangle;
    }

    public int getDockedWidth() {
        return this._dockedWidth;
    }

    public void setDockedWidth(int n) {
        this._dockedWidth = n;
    }

    public int getDockedHeight() {
        return this._dockedHeight;
    }

    public void setDockedHeight(int n) {
        this._dockedHeight = n;
    }

    public PreviousState getHiddenPreviousState() {
        return this._hiddenPreviousState;
    }

    public void setHiddenPreviousState(PreviousState previousState) {
        this._hiddenPreviousState = previousState;
    }

    public PreviousState getClosePreviousState() {
        return this._closePreviousState;
    }

    public void setClosePreviousState(PreviousState previousState) {
        this._closePreviousState = previousState;
    }

    public PreviousState getDockPreviousState() {
        return this._dockPreviousState;
    }

    public void setDockPreviousState(PreviousState previousState) {
        this._dockPreviousState = previousState;
    }

    public PreviousState getFloatPreviousState() {
        return this._floatPreviousState;
    }

    public void setFloatPreviousState(PreviousState previousState) {
        this._floatPreviousState = previousState;
    }

    public static String getDockSideName(int n) {
        return SIDE_NAMES[(int)(Math.log(n) / Math.log(2.0))];
    }

    public int getDockID() {
        return this._dockID;
    }

    public void setDockID(int n) {
        this._dockID = n;
    }

    public void resetDockID() {
    }

    public boolean isAvailable() {
        return this._available;
    }

    public void setAvailable(boolean bl) {
        this._available = bl;
    }

    public PreviousState getAvailablePreviousState() {
        return this._availablePreviousState;
    }

    public void setAvailablePreviousState(PreviousState previousState) {
        this._availablePreviousState = previousState;
    }
}

