/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainerLayout;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class DockableBarContainer
extends JComponent
implements SwingConstants {
    private int _side;
    private DockableBarListList _dockableBarList;
    public static int OFFSET = 3;
    private DockableBarManager _dockableBarManager;
    private DockableBarShrinkOrderProvider _shrinkOrderProvider;

    public DockableBarContainer(DockableBarManager dockableBarManager, int n) {
        this(dockableBarManager);
        this.setSide(n);
    }

    public DockableBarContainer(DockableBarManager dockableBarManager) {
        this._dockableBarManager = dockableBarManager;
        this._dockableBarList = new DockableBarListList(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateGaps();
    }

    private void updateGaps() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof DockableBarContainerLayout) {
            int n;
            if (UIDefaultsLookup.get("CommandBarContainer.verticalGap") instanceof Integer) {
                n = UIDefaultsLookup.getInt("CommandBarContainer.verticalGap");
                ((DockableBarContainerLayout)layoutManager).setVerticalGap(n);
            }
            if (UIDefaultsLookup.get("CommandBarContainer.horizontalGap") instanceof Integer) {
                n = UIDefaultsLookup.getInt("CommandBarContainer.horizontalGap");
                ((DockableBarContainerLayout)layoutManager).setHorizontalGap(n);
            }
            this.revalidate();
        }
    }

    public void setSide(int n) {
        this._side = n;
        this.setLayout(new DockableBarContainerLayout(this, this._side));
        this.updateGaps();
        if (this._side == 3 || this._side == 7) {
            JideSwingUtilities.setOrientationOf(this, 1);
        } else if (this._side == 1 || this._side == 5) {
            JideSwingUtilities.setOrientationOf(this, 0);
        }
    }

    public int getSide() {
        return this._side;
    }

    public void setDockableBarList(DockableBarListList dockableBarListList) {
        this.removeAll();
        this._dockableBarList = dockableBarListList;
        for (int i = 0; i < dockableBarListList.size(); ++i) {
            DockableBarList dockableBarList = (DockableBarList)dockableBarListList.get(i);
            for (int j = 0; j < dockableBarList.size(); ++j) {
                DockableBarItem dockableBarItem = (DockableBarItem)dockableBarList.get(j);
                dockableBarItem.getComponent().setVisible(true);
                this.add(dockableBarItem.getComponent());
            }
        }
        this.invalidate();
    }

    public DockableBarShrinkOrderProvider getShrinkOrderProvider() {
        return this._shrinkOrderProvider;
    }

    public void setShrinkOrderProvider(DockableBarShrinkOrderProvider dockableBarShrinkOrderProvider) {
        this._shrinkOrderProvider = dockableBarShrinkOrderProvider;
    }

    public DockableBarListList getDockableBarList() {
        return this._dockableBarList;
    }

    public int getRowCount() {
        return this.getDockableBarList().size();
    }

    public int getRowHeight(int n) {
        return ((DockableBarContainerLayout)this.getLayout()).getRowHeightAt(n);
    }

    public int getRowAndGapIndexAt(Point point) {
        int n;
        int n2 = n = this.getOrientation() == 0 ? point.y : point.x;
        if (n < 0) {
            return 0;
        }
        if (n >= (this.getOrientation() == 0 ? this.getHeight() : this.getWidth())) {
            return this.getRowCount() * 2;
        }
        int n3 = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (n >= n3 + OFFSET && n < n3 + this.getRowHeight(i) - (i != this.getRowCount() - 1 ? OFFSET : 0)) {
                return i * 2 + 1;
            }
            n3 += this.getRowHeight(i);
            if (i == this.getRowCount() - 1) continue;
            if (n >= n3 - OFFSET && n < n3 + ((DockableBarContainerLayout)this.getLayout()).getVerticalGap() + OFFSET) {
                return i * 2 + 2;
            }
            n3 += ((DockableBarContainerLayout)this.getLayout()).getVerticalGap();
        }
        return -1;
    }

    public int getOrientation() {
        if (this._side == 1 || this._side == 5) {
            return 0;
        }
        return 1;
    }

    public boolean isHorizontal() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        JideSwingUtilities.setOrientationOf(component, this.getOrientation());
    }

    public void addDockableBar(DockableBar dockableBar, int n, boolean bl, int n2) {
        try {
            if (this.isHorizontal()) {
                dockableBar.setHoriDocked();
            } else {
                dockableBar.setVertDocked();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(dockableBar);
        this._dockableBarList.changeComponentRow(dockableBar, n, bl, n2);
        this.revalidate();
    }

    public int getCurrentRowOf(DockableBar dockableBar) {
        DockableBarItem dockableBarItem = this.getDockableBarList().getDockableBarItemOf(dockableBar);
        return dockableBarItem.getRow();
    }

    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    public static interface DockableBarShrinkOrderProvider {
        public int[] getShrinkOrder(int var1);
    }
}

