/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.swing.DraggableHandle;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class CommandBarBorderListener
extends MouseInputAdapter
implements SwingConstants {
    private static int _eventMouseScreenX;
    private static int _eventMouseScreenY;
    private static int _eventMouseRelativeX;
    private static int _eventMouseRelativeY;
    private static double _relativeX;
    private static double _relativeY;
    private static Rectangle _startingBounds;
    private int _resizeDir;
    private static boolean _startInFloat;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private DockableBar _component;
    private DockableBarManager _dockableBarManager;
    static String _currentName;

    public CommandBarBorderListener(DockableBar dockableBar) {
        this._component = dockableBar;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point;
        this._dockableBarManager = this._component.getDockableBarManager();
        if (this._dockableBarManager == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Container container = this._component.getTopLevelAncestor();
        if (CommandBarBorderListener.isStartInDockingMode(container)) {
            _startInFloat = false;
        } else {
            _startInFloat = true;
            if (container instanceof Window) {
                ((Window)container).toFront();
            }
        }
        if (this._component != null) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._component);
            _eventMouseRelativeX = point.x;
            _eventMouseRelativeY = point.y;
        }
        _startingBounds = this._component.getBounds();
        _relativeX = (double)_eventMouseRelativeX / (double)CommandBarBorderListener._startingBounds.width;
        _relativeY = (double)_eventMouseRelativeY / (double)CommandBarBorderListener._startingBounds.height;
        point = new Point(mouseEvent.getX(), mouseEvent.getY());
        CommandBarBorderListener.convertPointToScreen(point, (Component)mouseEvent.getSource(), _startInFloat);
        _eventMouseScreenX = point.x;
        _eventMouseScreenY = point.y;
        if (this._component != null && mouseEvent.getSource() instanceof DraggableHandle) {
            this._dockableBarManager.beginDraggingDockableBar(this._component, point.x, point.y, _relativeX, _relativeY, _startInFloat);
            return;
        }
        if (!_startInFloat) {
            return;
        }
        this._resizeDir = 0;
        if (mouseEvent.getSource() == this._component) {
            Insets insets = this._component.getInsets();
            if (insets.right > 0 && mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                this._resizeDir = 3;
            } else if (insets.bottom > 0 && mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                this._resizeDir = 5;
            } else {
                this._discardRelease = true;
                return;
            }
            Cursor cursor = Cursor.getDefaultCursor();
            switch (this._resizeDir) {
                case 5: {
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 3: {
                    cursor = Cursor.getPredefinedCursor(11);
                }
            }
            Container container2 = container;
            if (container2 instanceof JFrame) {
                ((JFrame)container2).getGlassPane().setVisible(true);
                ((JFrame)container2).getGlassPane().setCursor(cursor);
            } else if (container2 instanceof JApplet) {
                ((JApplet)container2).getGlassPane().setVisible(true);
                ((JApplet)container2).getGlassPane().setCursor(cursor);
            } else if (container2 instanceof JWindow) {
                ((JWindow)container2).getGlassPane().setVisible(true);
                ((JWindow)container2).getGlassPane().setCursor(cursor);
            } else if (container2 instanceof JDialog) {
                ((JDialog)container2).getGlassPane().setVisible(true);
                ((JDialog)container2).getGlassPane().setCursor(cursor);
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.beginResizingDockableBar(this._component, this._resizeDir);
            }
            return;
        }
    }

    private static boolean isStartInDockingMode(Component component) {
        return component instanceof JFrame || component instanceof JDialog;
    }

    public static void convertPointFromScreen(Point point, Component component, boolean bl) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = component.getX();
                n = component.getY();
            } else if (component instanceof Applet || (bl ? component instanceof Window : CommandBarBorderListener.isStartInDockingMode(component))) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n2 = point2.x;
                    n = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n2 = component.getX();
                    n = component.getY();
                }
            } else {
                n2 = component.getX();
                n = component.getY();
            }
            point.x -= n2;
            point.y -= n;
            if (!bl ? CommandBarBorderListener.isStartInDockingMode(component) : component instanceof Window) break;
        } while (!(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static void convertPointToScreen(Point point, Component component, boolean bl) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = component.getX();
                n = component.getY();
            } else if (component instanceof Applet || (bl ? component instanceof Window : CommandBarBorderListener.isStartInDockingMode(component))) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n2 = point2.x;
                    n = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n2 = component.getX();
                    n = component.getY();
                }
            } else {
                n2 = component.getX();
                n = component.getY();
            }
            point.x += n2;
            point.y += n;
            if (!bl ? CommandBarBorderListener.isStartInDockingMode(component) : component instanceof Window) break;
        } while (!(component instanceof Applet) && (component = component.getParent()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._dockableBarManager == null) {
            return;
        }
        if (_startingBounds == null || this._discardRelease) {
            return;
        }
        Object object = this._component.getTreeLock();
        synchronized (object) {
            if (this._component != null && this._resizeDir == 0) {
                return;
            }
            Point point = new Point(mouseEvent.getPoint());
            if (((Component)mouseEvent.getSource()).isShowing()) {
                CommandBarBorderListener.convertPointToScreen(point, (Component)mouseEvent.getSource(), _startInFloat);
            } else {
                CommandBarBorderListener.convertPointToScreen(point, (Component)mouseEvent.getSource(), _startInFloat);
            }
            int n = _eventMouseScreenX - point.x;
            int n2 = _eventMouseScreenY - point.y;
            int n3 = this._component.getX();
            int n4 = this._component.getY();
            int n5 = this._component.getWidth();
            int n6 = this._component.getHeight();
            switch (this._resizeDir) {
                case 0: {
                    return;
                }
                case 3: {
                    n5 = CommandBarBorderListener._startingBounds.width - n;
                    n6 = -1;
                    break;
                }
                case 5: {
                    n5 = -1;
                    n6 = CommandBarBorderListener._startingBounds.height - n2;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.resizingDockableBar(this._component, n3, n4, n5, n6, n, n2);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._dockableBarManager == null) {
            return;
        }
        _startingBounds = null;
        if (this._discardRelease) {
            this._discardRelease = false;
            return;
        }
        if (this._resizeDir == 0) {
            if (this._component != null && this._dockableBarManager != null) {
                this._dockableBarManager.endDraggingDockableBar();
                return;
            }
        } else {
            Container container = this._component.getTopLevelAncestor();
            if (container instanceof JFrame) {
                ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)container).getGlassPane().setVisible(false);
            }
            if (this._dockableBarManager != null) {
                this._dockableBarManager.endResizingDockableBar(this._component);
            }
        }
        _eventMouseScreenX = 0;
        _eventMouseScreenY = 0;
        _eventMouseRelativeX = 0;
        _eventMouseRelativeY = 0;
        _startingBounds = null;
        this._resizeDir = 0;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._component) {
            if (!this._component.isFloating()) {
                return;
            }
            Insets insets = this._component.getInsets();
            if (mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                this._component.setCursor(Cursor.getPredefinedCursor(11));
            } else if (mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                this._component.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this._component.setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this._component.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._component == null) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._component == null) {
            return;
        }
        this._component.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._component.getDockableBarManager() != null && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && this._component.getDockableBarManager().getDoubleClickAction() == 0) {
            this._component.getDockableBarManager().toggleState(this._component);
        }
    }
}

