/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

import com.vertica.localization.VMessageKey;
import com.vertica.parser.Quote;
import com.vertica.parser.Token;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ClientErrorException;

public class Tokenizer {
    private int m_currentPos;
    private char[] m_statementChars;
    private boolean m_useStandardStrings;

    public Tokenizer(String string, boolean bl) {
        this.m_statementChars = string.toCharArray();
        this.m_useStandardStrings = bl;
    }

    public Token next() throws ErrorException {
        if (!this.hasNext()) {
            return null;
        }
        Quote quote = this.getCurrentQuote(null);
        boolean bl = quote.type != 1;
        int n = this.m_currentPos;
        int n2 = Integer.MAX_VALUE;
        String string = "";
        String string2 = "";
        while (this.hasNext()) {
            if (!bl) {
                if (n == this.m_currentPos && this.isSpecialChar(this.currentChar())) {
                    n2 = ++this.m_currentPos;
                    break;
                }
                if (this.atMultiLineCommentStart()) {
                    if (n != this.m_currentPos) break;
                    this.m_currentPos += 2;
                    while (this.hasNext()) {
                        if (this.currentChar() == '*' && this.peekNextChar() == '/') {
                            this.m_currentPos += 2;
                            break;
                        }
                        ++this.m_currentPos;
                    }
                    n2 = this.m_currentPos > this.m_statementChars.length ? this.m_statementChars.length : this.m_currentPos;
                    break;
                }
                if (this.atSingleLineCommentStart()) {
                    if (n != this.m_currentPos) break;
                    this.m_currentPos += 2;
                    while (this.hasNext()) {
                        if ('\n' == this.currentChar()) {
                            ++this.m_currentPos;
                            break;
                        }
                        ++this.m_currentPos;
                    }
                    n2 = this.m_currentPos > this.m_statementChars.length ? this.m_statementChars.length : this.m_currentPos;
                    break;
                }
                boolean bl2 = Character.isWhitespace(this.currentChar()) || this.atCommentStart();
                char c = this.currentChar();
                if (bl2 || this.isSpecialChar(c) || this.atOpeningQuote()) {
                    n2 = this.m_currentPos;
                    break;
                }
            } else if (!this.atEscapeChar(quote)) {
                Quote quote2 = this.getCurrentQuote(quote);
                if (quote2.type != 1) {
                    n2 = this.m_currentPos - (quote2.type != 16 ? 1 : 2 + quote2.tag.length());
                    break;
                }
            }
            ++this.m_currentPos;
        }
        if (n2 == Integer.MAX_VALUE) {
            if (quote.type != 1) {
                throw new ErrorException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, 101, VMessageKey.ERROR_UNCLOSED_QUOTE.toString(), new String[]{new String(this.m_statementChars)});
            }
            n2 = this.m_currentPos;
        }
        string = new String(this.m_statementChars, n, n2 - n);
        if (this.skipNoise() && this.hasNext()) {
            string2 = " ";
        }
        return new Token(string, quote, string2);
    }

    public boolean atEscapeChar(Quote quote) {
        char c = this.currentChar();
        if (this.m_currentPos + 1 == this.m_statementChars.length) {
            return false;
        }
        switch (quote.type) {
            case 32: {
                if (c == '\"') {
                    ++this.m_currentPos;
                    char c2 = this.currentChar();
                    if (c2 == '\"') {
                        return true;
                    }
                    --this.m_currentPos;
                    break;
                }
                if (this.m_useStandardStrings || c != '\\') break;
                ++this.m_currentPos;
                char c3 = this.currentChar();
                if (c3 == '\\' || c3 == '\"') {
                    return true;
                }
                --this.m_currentPos;
                break;
            }
            case 2: {
                if (c == '\'') {
                    ++this.m_currentPos;
                    char c4 = this.currentChar();
                    if (c4 == '\'') {
                        return true;
                    }
                    --this.m_currentPos;
                    break;
                }
                if (this.m_useStandardStrings || c != '\\') break;
                ++this.m_currentPos;
                char c5 = this.currentChar();
                if (c5 == '\\' || c5 == '\'') {
                    return true;
                }
                --this.m_currentPos;
                break;
            }
            case 4: {
                if (c != '\\') break;
                ++this.m_currentPos;
                char c6 = this.currentChar();
                if (c6 == '\\' || c6 == '\'') {
                    return true;
                }
                --this.m_currentPos;
            }
        }
        return false;
    }

    private boolean isSpecialChar(char c) {
        return c == '?' || c == '.' || c == ',' || c == '(' || c == ')' || c == ';' || c == '\\' || c == '{' || c == '}';
    }

    public Token peek() {
        int n = this.m_currentPos;
        Token token = null;
        try {
            if (this.hasNext()) {
                token = this.next();
            }
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        this.m_currentPos = n;
        return token;
    }

    public boolean hasNext() {
        return this.m_currentPos < this.m_statementChars.length;
    }

    private boolean atOpeningQuote() throws ClientErrorException {
        int n = this.m_currentPos;
        Quote quote = this.getCurrentQuote(null);
        this.m_currentPos = n;
        return quote.type != 1;
    }

    private char currentChar() {
        return this.m_statementChars[this.m_currentPos];
    }

    private char peekNextChar() {
        int n = this.m_currentPos + 1;
        if (n < this.m_statementChars.length) {
            return this.m_statementChars[n];
        }
        return '\u0000';
    }

    private Quote getCurrentQuote(Quote quote) throws ClientErrorException {
        Quote quote2;
        block24: {
            char c;
            block23: {
                if (!this.hasNext()) {
                    throw new ClientErrorException("No next character available");
                }
                if (quote != null && quote.type == 1) {
                    throw new ClientErrorException("Starting quote is not null and is of type QUOTE_NONE");
                }
                boolean bl = quote == null;
                c = this.currentChar();
                quote2 = Quote.NO_QUOTES;
                if (!bl) break block23;
                switch (c) {
                    case '\'': {
                        quote2 = Quote.SINGLE_QUOTES;
                        ++this.m_currentPos;
                        break;
                    }
                    case '\"': {
                        quote2 = Quote.DOUBLE_QUOTES;
                        ++this.m_currentPos;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (this.m_currentPos + 1 < this.m_statementChars.length && this.m_statementChars[this.m_currentPos + 1] == '\'') {
                            quote2 = Quote.EXTENDED_QUOTES;
                            this.m_currentPos += 2;
                            break;
                        }
                        break block24;
                    }
                    case 'U': 
                    case 'u': {
                        if (this.m_currentPos + 2 < this.m_statementChars.length && this.m_statementChars[this.m_currentPos + 1] == '&' && this.m_statementChars[this.m_currentPos + 2] == '\'') {
                            quote2 = Quote.UNICODE_QUOTES;
                            this.m_currentPos += 3;
                            break;
                        }
                        break block24;
                    }
                    case '$': {
                        int n = this.m_currentPos++;
                        if (!this.hasNext()) {
                            quote2 = Quote.NO_QUOTES;
                            break;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        char c2 = this.currentChar();
                        while (this.hasNext() && c2 != '$') {
                            stringBuilder.append(c2);
                            ++this.m_currentPos;
                            if (!this.hasNext()) continue;
                            c2 = this.currentChar();
                        }
                        if (this.hasNext()) {
                            if (c2 != '$') {
                                throw new ClientErrorException("Next character must be '$' but is not");
                            }
                            quote2 = new Quote();
                            quote2.tag = stringBuilder.toString();
                            quote2.setType(16);
                            ++this.m_currentPos;
                            break;
                        }
                        quote2 = Quote.NO_QUOTES;
                        this.m_currentPos = n + 1;
                        break;
                    }
                    default: {
                        return Quote.NO_QUOTES;
                    }
                }
                break block24;
            }
            if (c != quote.closing) {
                return Quote.NO_QUOTES;
            }
            if (quote.type == 16) {
                int n = this.m_currentPos++;
                if (!this.hasNext()) {
                    return Quote.NO_QUOTES;
                }
                int n2 = this.m_currentPos + quote.tag.length();
                int n3 = 0;
                char c3 = this.currentChar();
                boolean bl = true;
                while (this.hasNext() && this.m_currentPos < n2) {
                    c3 = this.currentChar();
                    if (c3 != quote.tag.charAt(n3++)) {
                        bl = false;
                        break;
                    }
                    ++this.m_currentPos;
                }
                if (bl && this.currentChar() == '$' && this.m_currentPos == n2) {
                    quote2 = quote;
                    ++this.m_currentPos;
                } else {
                    this.m_currentPos = n + 1;
                    quote2 = Quote.NO_QUOTES;
                }
            } else {
                quote2 = quote;
                ++this.m_currentPos;
            }
        }
        return quote2;
    }

    private boolean skipNoise() {
        if (!this.hasNext()) {
            return false;
        }
        boolean bl = false;
        while (this.hasNext() && Character.isWhitespace(this.currentChar())) {
            ++this.m_currentPos;
            bl = true;
        }
        return bl;
    }

    private boolean atSingleLineCommentStart() {
        return this.currentChar() == '-' && this.peekNextChar() == '-';
    }

    private boolean atMultiLineCommentStart() {
        return this.currentChar() == '/' && this.peekNextChar() == '*';
    }

    private boolean atCommentStart() {
        return this.atSingleLineCommentStart() || this.atMultiLineCommentStart();
    }

    public static String quoteIdentifier(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(string.replace("\"", "\"\""));
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

