/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.agent;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;

public class RunnableTransformer
implements ClassFileTransformer {
    private static final String INVOCATION_EVENT_CLASSNAME = "java/awt/event/InvocationEvent";
    private static final String THREAD_CLASSNAME = "java/lang/Thread";
    private static final String FUTURE_TASK_CLASSNAME = "java/util/concurrent/FutureTask";

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] byteCode = classfileBuffer;
        try {
            switch (className) {
                case "java/awt/event/InvocationEvent": {
                    CtClass ctClass = this.replaceInvocationEventConstructors();
                    byteCode = ctClass.toBytecode();
                    break;
                }
                case "java/lang/Thread": {
                    CtClass ctClass = this.replaceThreadConstructors();
                    byteCode = ctClass.toBytecode();
                    break;
                }
                case "java/util/concurrent/FutureTask": {
                    CtClass ctClass = this.replaceFutureTaskConstructors();
                    byteCode = ctClass.toBytecode();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteCode;
    }

    private CtClass replaceInvocationEventConstructors() throws NotFoundException, CannotCompileException {
        ClassPool classPool = ClassPool.getDefault();
        classPool.appendSystemPath();
        CtClass ctClass = classPool.getCtClass(INVOCATION_EVENT_CLASSNAME.replace("/", "."));
        String signature = "(Ljava/lang/Object;ILjava/lang/Runnable;Ljava/lang/Object;Ljava/lang/Runnable;Z)V";
        String body = "{ super($1, $2);this.runnable = new com.onseven.dbvis.agent.RunnableWithException($3, new java.lang.Exception());this.notifier = $4;this.listener = $5;this.catchExceptions = $6;this.when = java.lang.System.currentTimeMillis(); }";
        this.replaceConstructor(ctClass, signature, body);
        return ctClass;
    }

    private CtClass replaceThreadConstructors() throws NotFoundException, CannotCompileException {
        ClassPool classPool = ClassPool.getDefault();
        CtClass ctClass = classPool.getCtClass(THREAD_CLASSNAME.replace("/", "."));
        this.replaceConstructor(ctClass, "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;J)V", "{ this($1, new com.onseven.dbvis.agent.RunnableWithException($2, new java.lang.Exception()), $3, $4, null, true); }");
        this.replaceConstructor(ctClass, "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;JZ)V", "{ this($1, new com.onseven.dbvis.agent.RunnableWithException($2, new java.lang.Exception()), $3, $4, null, $5); }");
        this.replaceConstructor(ctClass, "(Ljava/lang/Runnable;Ljava/security/AccessControlContext;)V", "{ this((java.lang.ThreadGroup)null, new com.onseven.dbvis.agent.RunnableWithException($1, new java.lang.Exception()), \"Thread-\" + java.lang.Thread.nextThreadNum(), 0L, $2, false); }");
        return ctClass;
    }

    private CtClass replaceFutureTaskConstructors() throws NotFoundException, CannotCompileException {
        ClassPool classPool = ClassPool.getDefault();
        CtClass ctClass = classPool.getCtClass(FUTURE_TASK_CLASSNAME.replace("/", "."));
        ctClass.defrost();
        this.replaceConstructor(ctClass, "(Ljava/lang/Runnable;Ljava/lang/Object;)V", "{ this.callable = java.util.concurrent.Executors.callable(new com.onseven.dbvis.agent.RunnableWithException($1, new java.lang.Exception()), $2);this.state = java.util.concurrent.FutureTask.NEW; }");
        return ctClass;
    }

    private void replaceConstructor(CtClass ctClass, String signature, String body) throws NotFoundException, CannotCompileException {
        CtConstructor constructor = ctClass.getConstructor(signature);
        constructor.setBody(body);
    }
}

