/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

abstract class InputStreamFile<F extends BaseStorageFactory>
implements StorageFile {
    final String path;
    final int nameStart;
    final F storageFactory;

    InputStreamFile(F f, String string) {
        this.storageFactory = f;
        if (string == null || string.length() == 0) {
            this.path = ((BaseStorageFactory)f).dataDirectory;
            this.nameStart = -1;
        } else {
            StringBuilder stringBuilder = new StringBuilder(((BaseStorageFactory)f).separatedDataDirectory);
            if (File.separatorChar != '/') {
                stringBuilder.append(string.replace(File.separatorChar, '/'));
            } else {
                stringBuilder.append(string);
            }
            this.path = stringBuilder.toString();
            this.nameStart = this.path.lastIndexOf(47) + 1;
        }
    }

    InputStreamFile(F f, String string, String string2) {
        this.storageFactory = f;
        StringBuilder stringBuilder = new StringBuilder(((BaseStorageFactory)f).separatedDataDirectory);
        if (File.separatorChar != '/') {
            stringBuilder.append(string.replace(File.separatorChar, '/'));
            stringBuilder.append('/');
            stringBuilder.append(string2.replace(File.separatorChar, '/'));
        } else {
            stringBuilder.append(string);
            stringBuilder.append('/');
            stringBuilder.append(string2);
        }
        this.path = stringBuilder.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(InputStreamFile<F> inputStreamFile, String string) {
        this.storageFactory = inputStreamFile.storageFactory;
        StringBuilder stringBuilder = new StringBuilder(inputStreamFile.path);
        stringBuilder.append('/');
        if (File.separatorChar != '/') {
            stringBuilder.append(string.replace(File.separatorChar, '/'));
        } else {
            stringBuilder.append(string);
        }
        this.path = stringBuilder.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(F f, String string, int n) {
        this.storageFactory = f;
        this.path = string.substring(0, n);
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        InputStreamFile inputStreamFile = (InputStreamFile)object;
        return this.path.equals(inputStreamFile.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public abstract boolean exists();

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean deleteAll() {
        return false;
    }

    @Override
    public String getPath() {
        if (File.separatorChar != '/') {
            return this.path.replace('/', File.separatorChar);
        }
        return this.path;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return ((BaseStorageFactory)this.storageFactory).getCanonicalName() + "/" + this.path;
    }

    @Override
    public String getName() {
        return this.nameStart < 0 ? "" : this.path.substring(this.nameStart);
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new IOException("createNewFile called in a read-only file system.");
    }

    @Override
    public boolean renameTo(StorageFile storageFile) {
        return false;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean mkdirs() {
        return false;
    }

    @Override
    public StorageFile getParentDir() {
        if (this.path.length() <= ((BaseStorageFactory)this.storageFactory).separatedDataDirectory.length()) {
            return null;
        }
        return this.getParentDir(this.path.lastIndexOf(47));
    }

    abstract StorageFile getParentDir(int var1);

    @Override
    public boolean setReadOnly() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    @Override
    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    @Override
    public abstract InputStream getInputStream() throws FileNotFoundException;

    @Override
    public int getExclusiveFileLock() throws StandardException {
        return 0;
    }

    @Override
    public void releaseExclusiveFileLock() {
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        return null;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public void limitAccessToOwner() {
    }
}

