/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] \u0136 = new int[]{0};

    public TableSearchable(JTable jTable) {
        super(jTable);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().addTableModelListener(this);
            this._component.addPropertyChangeListener("model", this);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().removeTableModelListener(this);
            this._component.removePropertyChangeListener("model", this);
        }
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            int n3 = n2;
            int n4 = this.getMainIndex();
            this.addTableSelection(jTable, n4, n3, bl);
        } else if (this.isRowSelectionAllowed(jTable)) {
            int n5 = n2;
            int n6 = jTable.convertColumnIndexToView(this.getMainIndex());
            this.addTableSelection(jTable, n5, n6, bl);
        } else {
            int n7 = jTable.getColumnCount();
            if (n7 == 0) {
                return;
            }
            int n8 = n2 / n7;
            int n9 = n2 % n7;
            this.addTableSelection(jTable, n8, n9, bl);
        }
    }

    protected void addTableSelection(JTable jTable, int n2, int n3, boolean bl) {
        if (!bl) {
            jTable.clearSelection();
        }
        if (n2 >= 0 && n3 >= 0 && n2 < jTable.getRowCount() && n3 < jTable.getColumnCount() && !jTable.isCellSelected(n2, n3)) {
            jTable.changeSelection(n2, n3, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable jTable) {
        return this.getSearchColumnIndices().length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable jTable) {
        return this.getSearchColumnIndices().length == 1 && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    protected boolean isSearchSelectedRows() {
        return this.getSearchColumnIndices().length > 1;
    }

    @Override
    protected int getSelectedIndex() {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getSelectionModel().getAnchorSelectionIndex();
        }
        return jTable.getSelectionModel().getAnchorSelectionIndex() * jTable.getColumnCount() + jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
    }

    @Override
    protected Object getElementAt(int n2) {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return this.getValueAt(jTable, this.getMainIndex(), n2);
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return this.getValueAt(jTable, n2, jTable.convertColumnIndexToView(this.getMainIndex()));
        }
        if (this.isSearchSelectedRows()) {
            int n3 = n2 % jTable.getColumnCount();
            int n4 = jTable.convertColumnIndexToModel(n3);
            boolean bl = true;
            for (int n5 : this.getSearchColumnIndices()) {
                if (n5 != n4) continue;
                bl = false;
            }
            if (bl) {
                return null;
            }
            int n6 = n2 / jTable.getColumnCount();
            return this.getValueAt(jTable, n6, n3);
        }
        int n7 = n2 % jTable.getColumnCount();
        int n8 = n2 / jTable.getColumnCount();
        return this.getValueAt(jTable, n8, n7);
    }

    protected Object getValueAt(JTable jTable, int n2, int n3) {
        if (n2 >= 0 && n2 < jTable.getRowCount() && n3 >= 0 && n3 < jTable.getColumnCount()) {
            return jTable.getValueAt(n2, n3);
        }
        return null;
    }

    @Override
    protected int getElementCount() {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getColumnCount();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getRowCount();
        }
        return jTable.getColumnCount() * jTable.getRowCount();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this.\u0136;
    }

    public int getMainIndex() {
        if (this.\u0136.length == 0) {
            return -1;
        }
        return this.\u0136[0];
    }

    public void setSearchColumnIndices(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (!JideSwingUtilities.equals(nArray2 = this.\u0136, nArray, true)) {
            this.\u0136 = nArray;
            this.hidePopup();
        }
    }

    public void setMainIndex(int n2) {
        int[] nArray;
        int[] nArray2 = new int[]{n2};
        if (n2 < 0) {
            nArray2 = new int[]{};
        }
        if ((nArray = this.\u0136) != nArray2) {
            this.\u0136 = nArray2;
            this.hidePopup();
        }
    }

    @Override
    protected boolean isFindNextKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return n2 == 39;
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return n2 == 40;
        }
        return n2 == 40 || n2 == 39;
    }

    @Override
    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return n2 == 37;
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return n2 == 38;
        }
        return n2 == 38 || n2 == 37;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent keyEvent) {
        boolean bl = this.isSelectedCellEditable();
        return !bl && super.isActivateKey(keyEvent);
    }

    protected boolean isSelectedCellEditable() {
        int n2 = ((JTable)this._component).getSelectedRow();
        int n3 = ((JTable)this._component).getSelectedColumn();
        return n2 != -1 && n3 != -1 && ((JTable)this._component).isCellEditable(n2, n3);
    }
}

