/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreePath;

public class AutoCompletion {
    private Searchable \u010d;
    private JTextComponent \u0108;
    private AutoCompletionDocument \u010a;
    private boolean \u0106 = false;
    private boolean \u0107;
    private boolean \u010b = false;
    private boolean \u0102 = false;
    private boolean \u010e;
    private KeyListener \u0109;
    private boolean \u0105 = true;
    private boolean \u0101 = true;
    private PropertyChangeListener \u0103;
    private JComboBox \u010c;
    private Document \u0104;
    public static final String CLIENT_PROPERTY_AUTO_COMPLETION = "AutoCompletion";

    public AutoCompletion(JComboBox jComboBox) {
        this(jComboBox, (Searchable)new ComboBoxSearchable(jComboBox));
    }

    public AutoCompletion(JComboBox jComboBox, Searchable searchable) {
        this.\u010d = searchable;
        this.\u0103 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editor".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() != null) {
                    AutoCompletion.this.\u0108 = (JTextComponent)((ComboBoxEditor)propertyChangeEvent.getNewValue()).getEditorComponent();
                    AutoCompletion.this.\u0101(AutoCompletion.this.getTextComponent());
                }
            }
        };
        this.\u010c = jComboBox;
        this.\u010d.setWildcardEnabled(false);
        if (this.\u010d instanceof ComboBoxSearchable) {
            ((ComboBoxSearchable)this.\u010d).setShowPopupDuringSearching(false);
        }
        this.\u0108 = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, Searchable searchable) {
        this.\u010d = searchable;
        this.\u010d.setWildcardEnabled(false);
        this.\u0108 = jTextComponent;
        this.\u0101(this.getSearchable());
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, final List list) {
        this(jTextComponent, new Searchable((JComponent)new JLabel()){
            int \u0125;
            {
                super(jComponent);
                this.\u0125 = -1;
            }

            @Override
            protected int getSelectedIndex() {
                return this.\u0125;
            }

            @Override
            protected void setSelectedIndex(int n2, boolean bl) {
                this.\u0125 = n2;
            }

            @Override
            protected int getElementCount() {
                return list.size();
            }

            @Override
            protected Object getElementAt(int n2) {
                return list.get(n2);
            }

            @Override
            protected String convertElementToString(Object object) {
                return "" + object;
            }
        });
    }

    public AutoCompletion(JTextComponent jTextComponent, final Object[] objectArray) {
        this(jTextComponent, new Searchable((JComponent)new JLabel()){
            int \u0122;
            {
                super(jComponent);
                this.\u0122 = -1;
            }

            @Override
            protected int getSelectedIndex() {
                return this.\u0122;
            }

            @Override
            protected void setSelectedIndex(int n2, boolean bl) {
                this.\u0122 = n2;
            }

            @Override
            protected int getElementCount() {
                return objectArray.length;
            }

            @Override
            protected Object getElementAt(int n2) {
                return objectArray[n2];
            }

            @Override
            protected String convertElementToString(Object object) {
                return "" + object;
            }
        });
    }

    private void \u0101(Searchable searchable) {
        if (searchable.getComponent() instanceof JList) {
            final JList jList = (JList)this.getSearchable().getComponent();
            jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n2 = jList.getSelectedIndex();
                    if (n2 != -1) {
                        AutoCompletion.this.getTextComponent().setText(AutoCompletion.this.getSearchable().convertElementToString(jList.getModel().getElementAt(n2)));
                        AutoCompletion.this.\u0101(0);
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(34, 0));
        } else if (searchable.getComponent() instanceof JTree) {
            final JTree jTree = (JTree)this.getSearchable().getComponent();
            jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = jTree.getSelectionPath();
                    if (treePath != null) {
                        AutoCompletion.this.getTextComponent().setText("" + treePath.getLastPathComponent());
                        AutoCompletion.this.\u0101(0);
                    } else {
                        AutoCompletion.this.getTextComponent().setText("");
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(34, 0));
        }
    }

    private boolean \u0101() {
        return this.\u010b;
    }

    private void \u0101(boolean bl) {
        this.\u010b = bl;
    }

    private void \u0102() {
        int n2 = this.getSearchable().getSelectedIndex();
        if (n2 != -1) {
            Object object = this.getSearchable().getElementAt(n2);
            if (object != null) {
                this.\u010a.setText(this.getSearchable().convertElementToString(object));
            }
            this.\u0101(0);
        } else {
            this.\u010a.setText("");
        }
    }

    public void uninstallListeners() {
        if (this.\u0103 != null && this.\u010c != null) {
            this.\u010c.removePropertyChangeListener(this.\u0103);
        }
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this.\u0109);
            String string = this.getTextComponent().getText();
            if (this.\u0104 != null) {
                this.getTextComponent().setDocument(this.\u0104);
                this.\u0104 = null;
            }
            this.getTextComponent().setText(string);
        }
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, null);
    }

    public void installListeners() {
        if (this.\u010c != null && this.\u0103 != null) {
            this.\u010c.addPropertyChangeListener(this.\u0103);
        }
        this.\u0109 = new KeyAdapter(){
            private boolean \u0103;
            private String \u0102;

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AutoCompletion.this.\u0102 = false;
                if (27 != keyEvent.getKeyCode()) {
                    AutoCompletion.this.\u0101(true);
                }
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        if (!AutoCompletion.this.isStrict()) break;
                        AutoCompletion.this.\u0102 = true;
                        AutoCompletion.this.\u010e = AutoCompletion.this.getTextComponent().getSelectionStart() != AutoCompletion.this.getTextComponent().getSelectionEnd();
                        break;
                    }
                    case 127: {
                        if (!AutoCompletion.this.isStrict()) break;
                        this.\u0103 = true;
                        this.\u0102 = AutoCompletion.this.getTextComponent().getText();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                try {
                    if (this.\u0103) {
                        this.\u0103 = false;
                        String string = AutoCompletion.this.getTextComponent().getText();
                        int n2 = AutoCompletion.this.getSearchable().findFirst(string);
                        if (n2 != -1) {
                            if (string.length() == 0) {
                                AutoCompletion.this.\u0101("");
                            } else {
                                Object object = AutoCompletion.this.getSearchable().getElementAt(n2);
                                AutoCompletion.this.\u0101(object);
                                AutoCompletion.this.getTextComponent().setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                                AutoCompletion.this.\u0101(string.length());
                            }
                        } else if (AutoCompletion.this.isStrict()) {
                            AutoCompletion.this.getTextComponent().setText(this.\u0102);
                            keyEvent.consume();
                            PortingUtils.notifyUser(AutoCompletion.this.\u0108);
                        }
                    }
                }
                finally {
                    if (27 != keyEvent.getKeyCode()) {
                        AutoCompletion.this.\u0101(false);
                    }
                }
            }
        };
        this.\u0107 = SystemInfo.isJdk15Above();
        this.\u010a = this.createDocument();
        this.\u0101(this.getTextComponent());
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, this);
    }

    protected AutoCompletionDocument createDocument() {
        return new AutoCompletionDocument();
    }

    private void \u0101(JTextComponent jTextComponent) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this.\u0109);
        }
        if (jTextComponent != null) {
            this.\u0108 = jTextComponent;
            this.getTextComponent().addKeyListener(this.\u0109);
            String string = this.getTextComponent().getText();
            this.\u0104 = this.getTextComponent().getDocument();
            if (this.\u0104 instanceof AbstractDocument && this.\u010a != null) {
                this.\u010a.setDocumentFilter(((AbstractDocument)this.\u0104).getDocumentFilter());
            }
            this.getTextComponent().setDocument(this.\u010a);
            this.getTextComponent().setText(string);
        }
    }

    private void \u0101(int n2) {
        int n3 = this.getTextComponent().getDocument().getLength();
        this.getTextComponent().setCaretPosition(n3);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.getTextComponent().moveCaretPosition(n2);
    }

    private void \u0101(Object object) {
        this.\u0106 = true;
        int n2 = this.getSearchable().getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.getSearchable().getElementAt(i2);
            if (!JideSwingUtilities.equals(object, object2)) continue;
            this.getSearchable().setSelectedIndex(i2, false);
        }
        this.\u0106 = false;
    }

    public boolean isStrict() {
        return this.\u0105;
    }

    public void setStrict(boolean bl) {
        this.\u0105 = bl;
    }

    public boolean isStrictCompletion() {
        return this.\u0101;
    }

    public void setStrictCompletion(boolean bl) {
        this.\u0101 = bl;
    }

    protected JTextComponent getTextComponent() {
        return this.\u0108;
    }

    public Searchable getSearchable() {
        return this.\u010d;
    }

    public static AutoCompletion getAutoCompletion(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION);
        if (object instanceof AutoCompletion) {
            return (AutoCompletion)object;
        }
        return null;
    }

    protected class AutoCompletionDocument
    extends PlainDocument {
        protected AutoCompletionDocument() {
        }

        @Override
        public void remove(int n2, int n3) throws BadLocationException {
            if (AutoCompletion.this.\u0106) {
                return;
            }
            if (AutoCompletion.this.\u0102) {
                if (n2 > 0) {
                    if (AutoCompletion.this.\u010e) {
                        --n2;
                    }
                } else {
                    PortingUtils.notifyUser(AutoCompletion.this.\u0108);
                }
                AutoCompletion.this.\u0101(n2);
            } else {
                super.remove(n2, n3);
            }
        }

        @Override
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoCompletion.this.\u0106) {
                return;
            }
            super.insertString(n2, string, attributeSet);
            if (AutoCompletion.this.\u0101() || AutoCompletion.this.isStrict()) {
                String string2 = this.getText(0, this.getLength());
                int n3 = AutoCompletion.this.getSearchable().findFirstExactly(string2);
                if (n3 != -1) {
                    return;
                }
                int n4 = AutoCompletion.this.getSearchable().findFromCursor(string2);
                if (n4 != -1) {
                    Object object = AutoCompletion.this.getSearchable().getElementAt(n4);
                    AutoCompletion.this.\u0101(object);
                    this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                    AutoCompletion.this.\u0101(n2 + string.length());
                } else if (AutoCompletion.this.isStrict()) {
                    if (n2 == 0 && string2.equals(string)) {
                        AutoCompletion.this.getSearchable().textChanged("");
                        n4 = AutoCompletion.this.getSearchable().findFromCursor(string2);
                        if (n4 != -1) {
                            Object object = AutoCompletion.this.getSearchable().getElementAt(n4);
                            AutoCompletion.this.\u0101(object);
                            this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                            AutoCompletion.this.\u0101(n2 + string.length());
                        } else if (AutoCompletion.this.isStrict()) {
                            n4 = AutoCompletion.this.getSearchable().getSelectedIndex();
                            if (n4 == -1 && AutoCompletion.this.getSearchable().getElementCount() > 0) {
                                n4 = 0;
                                AutoCompletion.this.getSearchable().setSelectedIndex(0, false);
                            }
                            if (n4 != -1) {
                                Object object = AutoCompletion.this.getSearchable().getElementAt(n4);
                                PortingUtils.notifyUser(AutoCompletion.this.\u0108);
                                this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                                AutoCompletion.this.\u0101((n2 -= string.length()) + string.length());
                            }
                        }
                        return;
                    }
                    n4 = AutoCompletion.this.getSearchable().getSelectedIndex();
                    if (n4 == -1 && AutoCompletion.this.getSearchable().getElementCount() > 0) {
                        n4 = 0;
                        AutoCompletion.this.getSearchable().setSelectedIndex(0, false);
                    }
                    if (n4 != -1) {
                        Object object = AutoCompletion.this.getSearchable().getElementAt(n4);
                        PortingUtils.notifyUser(AutoCompletion.this.\u0108);
                        this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                        AutoCompletion.this.\u0101((n2 -= string.length()) + string.length());
                    }
                }
            }
        }

        protected void setText(String string) {
            try {
                if (AutoCompletion.this.isStrictCompletion()) {
                    super.remove(0, this.getLength());
                    super.insertString(0, string, null);
                } else {
                    String string2 = super.getText(0, this.getLength());
                    int n2 = string2.length() <= string.length() ? string2.length() : string.length();
                    for (int i2 = 0; i2 < string2.length(); ++i2) {
                        if (string2.substring(0, n2).equalsIgnoreCase(string.substring(0, n2))) continue;
                        --n2;
                    }
                    super.remove(n2, this.getLength() - n2);
                    super.insertString(n2, string.substring(n2), null);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException.toString());
            }
        }
    }
}

