/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.NestedTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledToolTip;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class NestedTableHeader
extends AutoFilterTableHeader {
    private static final String \u1e9b = "NestedTableHeaderUI";
    private static final String \u1ea1 = "TableHeader.nestedTableHeaderUIDelegate";
    protected Vector<TableColumn> _columnGroups = null;
    private boolean \u1ea0 = true;
    private int \u1e99 = 0;
    private int \u1e9a = -1;
    public static final String PROPERTY_ORIGINAL_TABLE_HEADER_VISIBLE = "originalTableHeaderVisible";

    public NestedTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public NestedTableHeader(JTable jTable) {
        super(jTable);
        this.setTable(jTable);
    }

    @Override
    public Rectangle getHeaderRect(int n2) {
        return n2 >= 0 && n2 < this.getColumnCount() ? this.getCellRect(this.getRowCount() - 1, n2) : this.getBounds();
    }

    @Override
    public String getActualUIClassID() {
        return \u1e9b;
    }

    @Override
    public String getUIDelegateClassID() {
        return \u1ea1;
    }

    @Override
    protected void tableModelChanged(JTable jTable) {
        super.tableModelChanged(jTable);
        this.\u0103(jTable);
    }

    private void \u0103(JTable jTable) {
        if (this._columnGroups == null) {
            return;
        }
        Vector<TableColumn> vector = new Vector<TableColumn>();
        for (TableColumn tableColumn : this._columnGroups) {
            TableColumn tableColumn2;
            if (tableColumn instanceof TableColumnGroup) {
                this.\u0101((TableColumnGroup)tableColumn, jTable);
                vector.add(tableColumn);
                continue;
            }
            if (tableColumn == null || (tableColumn2 = this.\u0101(tableColumn, jTable)) == null) continue;
            vector.add(tableColumn2);
        }
        this._columnGroups = vector;
        this.\u0389();
    }

    private TableColumn \u0101(TableColumn tableColumn, JTable jTable) {
        Object object;
        Object object2 = tableColumn.getIdentifier() == null ? tableColumn.getHeaderValue() : tableColumn.getIdentifier();
        Object object3 = tableColumn.getHeaderValue();
        Vector vector = new Vector();
        for (int i2 = jTable.getColumnModel().getColumnCount() - 1; i2 >= 0; --i2) {
            object = jTable.getColumnModel().getColumn(i2);
            if (JideSwingUtilities.equals(object2, ((TableColumn)object).getIdentifier())) {
                return object;
            }
            if (!JideSwingUtilities.equals(object3, ((TableColumn)object).getHeaderValue())) continue;
            vector.add(object);
        }
        Object object4 = jTable.getClientProperty("HiddenIdentifiersList");
        if (object4 instanceof List) {
            object = (List)object4;
            Iterator object5 = object.iterator();
            while (object5.hasNext()) {
                Object object6;
                Object e2 = object5.next();
                if (!JideSwingUtilities.equals(e2, object2) || !((object6 = jTable.getClientProperty("TableColumnIdentifier:" + e2)) instanceof TableColumn)) continue;
                return (TableColumn)object6;
            }
        }
        if (vector.size() == 1) {
            return (TableColumn)vector.get(0);
        }
        if (vector.size() > 1) {
            for (TableColumn tableColumn2 : vector) {
                if (tableColumn2.getModelIndex() != tableColumn.getModelIndex()) continue;
                return tableColumn2;
            }
        }
        return null;
    }

    private void \u0101(TableColumnGroup tableColumnGroup, JTable jTable) {
        TableColumnGroup tableColumnGroup2 = new TableColumnGroup("temp");
        List list = tableColumnGroup.getChildren();
        for (Object e2 : list) {
            if (e2 instanceof TableColumnGroup) {
                this.\u0101((TableColumnGroup)e2, jTable);
                tableColumnGroup2.add(e2);
                continue;
            }
            if (e2 instanceof TableColumn) {
                TableColumn tableColumn = this.\u0101((TableColumn)e2, jTable);
                tableColumnGroup2.add(tableColumn);
                continue;
            }
            tableColumnGroup2.add(e2);
        }
        tableColumnGroup.\u0102();
        for (Object e2 : tableColumnGroup2.getChildren()) {
            tableColumnGroup.add(e2);
        }
    }

    public TableColumn[] getTableColumnGroups() {
        return this._columnGroups != null ? this._columnGroups.toArray(new TableColumn[this._columnGroups.size()]) : new TableColumn[]{};
    }

    void \u0388() {
        for (TableColumn tableColumn : this.getTableColumnGroups()) {
            if (!(tableColumn instanceof TableColumnGroup)) continue;
            ((TableColumnGroup)tableColumn).setTableHeader(null);
        }
    }

    void \u0389() {
        this.\u1e9a = -1;
    }

    public void addColumnGroup(TableColumnGroup tableColumnGroup) {
        if (this._columnGroups == null) {
            this._columnGroups = new Vector();
        }
        this._columnGroups.addElement(tableColumnGroup);
        tableColumnGroup.setTableHeader(this);
        this.\u0389();
        this.revalidate();
    }

    public void removeColumnGroup(TableColumnGroup tableColumnGroup) {
        if (this._columnGroups == null) {
            return;
        }
        this._columnGroups.removeElement(tableColumnGroup);
        this.\u0389();
        this.revalidate();
    }

    public void clearColumnGroups() {
        if (this._columnGroups == null) {
            return;
        }
        this._columnGroups.removeAllElements();
        this.\u0389();
        this.revalidate();
    }

    public Object getParent(TableColumn tableColumn) {
        if (this._columnGroups != null) {
            Enumeration<TableColumn> enumeration = this._columnGroups.elements();
            while (enumeration.hasMoreElements()) {
                TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
                Object object = this.\u0101(tableColumnGroup, tableColumn);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public int rowAtPoint(Point point) {
        int n2 = this.getRowCount();
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            NestedTableHeaderUIDelegate nestedTableHeaderUIDelegate = (NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate());
            int[] nArray = new int[n2];
            int n3 = 0;
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = nestedTableHeaderUIDelegate.getRowPreferredHeight(i2);
                n3 += nArray[i2];
            }
            float f2 = this.getHeight() / n3;
            n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!((float)point.y < (float)(n3 += nArray[i3]) * f2)) continue;
                return i3;
            }
            return -1;
        }
        int n4 = this.getSize().height / n2;
        if (!this.isOriginalTableHeaderVisible()) {
            return point.y / n4;
        }
        int n5 = this.getActualHeaderY();
        int n6 = this.originalColumnAtPoint(point);
        if (n6 >= 0) {
            if (point.y >= n5) {
                return n2 - 1;
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(n6);
            Vector vector = this.\u0103(tableColumn);
            return vector == null ? 0 : Math.min(point.y * (this.getRowCount() - 1) / n5, vector.size());
        }
        return point.y / n4;
    }

    private Object \u0101(TableColumnGroup tableColumnGroup, TableColumn tableColumn) {
        Vector vector = tableColumnGroup._columns;
        if (vector.contains(tableColumn)) {
            return tableColumnGroup;
        }
        for (Object e2 : vector) {
            Object object;
            if (!(e2 instanceof TableColumnGroup) || (object = this.\u0101((TableColumnGroup)e2, tableColumn)) == null) continue;
            return object;
        }
        return null;
    }

    public Enumeration getColumnGroups(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return null;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.\u0101(tableColumn, new Vector());
            if (vector == null) continue;
            return vector.elements();
        }
        return null;
    }

    public int getRowAt(TableColumn tableColumn) {
        Vector vector = this.\u0103(tableColumn);
        return vector == null ? 0 : vector.size();
    }

    private Vector \u0103(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return null;
        }
        if (tableColumn instanceof TableColumnGroup) {
            Vector<TableColumnGroup> vector = new Vector<TableColumnGroup>();
            for (TableColumnGroup tableColumnGroup = ((TableColumnGroup)tableColumn).getParent(); tableColumnGroup != null; tableColumnGroup = tableColumnGroup.getParent()) {
                vector.add(tableColumnGroup);
            }
            return vector;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.\u0101(tableColumn, new Vector());
            if (vector == null) continue;
            return vector;
        }
        return null;
    }

    public int getLevel(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return 1;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.\u0101(tableColumn, new Vector());
            if (vector == null) continue;
            return vector.size();
        }
        return 1;
    }

    public boolean isOriginalTableHeaderVisible() {
        return this.\u1ea0;
    }

    public void setOriginalTableHeaderVisible(boolean bl) {
        boolean bl2 = this.\u1ea0;
        if (bl2 != bl) {
            this.\u1ea0 = bl;
            this.firePropertyChange(PROPERTY_ORIGINAL_TABLE_HEADER_VISIBLE, bl2, this.\u1ea0);
            this.revalidate();
            if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate) {
                ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).invalidateCache(true);
            }
        }
    }

    public boolean isMouseOnOriginalTableHeader(Point point) {
        int n2 = this.columnAtPoint(point);
        if (n2 >= 0) {
            int n3 = this.rowAtPoint(point);
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            Vector vector = this.\u0103(tableColumn);
            return vector == null || n3 >= vector.size();
        }
        return false;
    }

    public TableColumnGroup getTableColumnGroup(int n2, int n3) {
        TableColumn tableColumn;
        Vector vector;
        if (n3 >= 0 && n2 >= 0 && (vector = this.\u0103(tableColumn = this.getColumnModel().getColumn(n3))) != null && n2 < vector.size()) {
            return (TableColumnGroup)vector.get(n2);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this._columnGroups == null) {
            return 1;
        }
        if (this.\u1e9a > 0) {
            return this.\u1e9a;
        }
        int n2 = 1;
        for (TableColumn tableColumn : this._columnGroups) {
            int n3;
            if (!(tableColumn instanceof TableColumnGroup) || (n3 = this.\u0107((TableColumnGroup)tableColumn)) + 1 <= n2) continue;
            n2 = n3 + 1;
        }
        if (!this.isOriginalTableHeaderVisible() && n2 > 1) {
            --n2;
        }
        this.\u1e9a = n2;
        return n2;
    }

    private int \u0107(TableColumnGroup tableColumnGroup) {
        int n2 = 1;
        for (Object e2 : tableColumnGroup.getChildren()) {
            int n3;
            if (!(e2 instanceof TableColumnGroup) || (n3 = this.\u0107((TableColumnGroup)e2)) + 1 <= n2) continue;
            n2 = n3 + 1;
        }
        return n2;
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public CellSpan getCellSpanAt(int n2, int n3) {
        int n4 = this.getRowCount();
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        Vector vector = this.\u0103(tableColumn);
        if (vector != null && n2 < vector.size()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)vector.get(n2);
            int n5 = tableColumnGroup.getColumnIndex();
            return new CellSpan(n2, n5, 1, tableColumnGroup.getLastColumnIndex() - n5 + 1);
        }
        if (vector == null) {
            return new CellSpan(0, n3, n4, 1);
        }
        return new CellSpan(vector.size(), n3, n4 - vector.size(), 1);
    }

    public Rectangle originalGetCellRect(int n2, int n3) {
        Rectangle rectangle = super.getHeaderRect(n3);
        int n4 = this.getRowCount();
        if (n2 < 0 || n3 < 0 || n4 <= n2 || this.getColumnCount() <= n3) {
            return rectangle;
        }
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            int n5;
            NestedTableHeaderUIDelegate nestedTableHeaderUIDelegate = (NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate());
            int[] nArray = new int[n4];
            int n6 = 0;
            int n7 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                nArray[n5] = nestedTableHeaderUIDelegate.getRowPreferredHeight(n5);
                if (n5 == n2) {
                    n7 = n6;
                }
                n6 += nArray[n5];
            }
            if (n6 == this.getHeight() || n2 != n4 - 1) {
                rectangle.y = n7;
                rectangle.height = nArray[n2];
            } else if (n6 > 0) {
                rectangle.y = 0;
                rectangle.height = this.getHeight();
                for (n5 = 0; n5 < n2; ++n5) {
                    rectangle.y += nArray[n5];
                    rectangle.height -= nArray[n5];
                }
            }
        }
        return rectangle;
    }

    public Rectangle getCellRect(int n2, int n3) {
        Rectangle rectangle = this.originalGetCellRect(n2, n3);
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan == null) {
            return rectangle;
        }
        if (n2 != (cellSpan = (CellSpan)cellSpan.clone()).getRow() || n3 != cellSpan.getColumn()) {
            rectangle = this.originalGetCellRect(cellSpan.getRow(), cellSpan.getColumn());
        }
        block0: for (int i2 = cellSpan.getRowSpan() - 1; i2 >= 0; --i2) {
            for (int i3 = cellSpan.getColumnSpan() - 1; i3 >= 0; --i3) {
                Rectangle rectangle2 = this.originalGetCellRect(cellSpan.getRow() + i2, cellSpan.getColumn() + i3);
                if (rectangle2.getWidth() == 0.0 && rectangle2.getHeight() == 0.0) continue;
                rectangle = rectangle.union(rectangle2);
                continue block0;
            }
        }
        return rectangle;
    }

    @Override
    public int getActualHeaderY() {
        if (this.getColumnCount() > 0 && this.getRowCount() > 0) {
            if (!this.isOriginalTableHeaderVisible()) {
                return this.getHeight();
            }
            Rectangle rectangle = this.getCellRect(this.getRowCount() - 1, 0);
            return rectangle.y;
        }
        return 0;
    }

    @Override
    public int columnAtPoint(Point point) {
        int n2 = super.columnAtPoint(point);
        if (this.getRowCount() <= 1 || n2 < 0) {
            return n2;
        }
        int n3 = this.getActualHeaderY();
        if (point.y >= n3) {
            return n2;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        Vector vector = this.\u0103(tableColumn);
        return vector == null || n3 / (this.getRowCount() - 1) * vector.size() <= point.y ? n2 : -1;
    }

    @Override
    public int originalColumnAtPoint(Point point) {
        return super.columnAtPoint(point);
    }

    public Object getHeaderValueAt(int n2, int n3) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        Vector vector = this.\u0103(tableColumn);
        if (vector != null && n2 < vector.size()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)vector.get(n2);
            return "" + tableColumnGroup.getHeaderValue();
        }
        return this.getColumnModel().getColumn(n3).getHeaderValue();
    }

    public int getMargin() {
        return this.\u1e99;
    }

    public void setMargin(int n2) {
        this.\u1e99 = n2;
    }

    @Override
    public JToolTip createToolTip() {
        return new StyledToolTip();
    }
}

