/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.BatchedOperations;
import com.jidesoft.database.CrudTableModel;
import com.jidesoft.database.DefaultRecord;
import com.jidesoft.database.Record;
import com.jidesoft.database.TableModelCache;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class BatchedCrudTableModelWrapper
extends TableModelWrapperImpl
implements CrudTableModel,
TableModelWrapper,
BatchedOperations {
    private static final long \u0d0b = 9059733619283066142L;
    protected TableModelCache _cache = new TableModelCache();
    private Vector<Integer> \u0d08 = new Vector();
    private Vector<Record> \u0d07 = new Vector();
    private int \u0d06 = 0;
    private int \u0d0a = 0;
    private boolean \u0d09 = false;

    public BatchedCrudTableModelWrapper(TableModel tableModel) {
        super(tableModel);
        if (!(tableModel instanceof CrudTableModel)) {
            throw new IllegalArgumentException("The model wrapped in BatchedCrudTableModelWrapper must be a CrudTableModel instance.");
        }
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount() - this.\u0d06 + this.\u0d0a;
    }

    private int \u01e2() {
        return this._model.getRowCount() - this.\u0d06;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Object object = null;
        if (!this.\u0d09) {
            if (n2 >= this.\u01e2()) {
                Record record = this.\u0d07.get(n2 - this.\u01e2());
                if (record != null) {
                    object = record.getValue(this.getColumnName(n3));
                }
            } else {
                int n4 = this.getActualIndexAt(n2);
                object = this._cache.\u0101(n4, n3) ? this._cache.\u0107(n4, n3) : this._model.getValueAt(n4, n3);
            }
        } else {
            object = this._model.getValueAt(n2, n3);
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (!this.\u0d09) {
            int n4 = this.\u01e2();
            if (n2 >= n4) {
                this.\u0101(object, n2 - n4, n3);
            } else {
                this._cache.\u0102(object, this.getActualIndexAt(n2), n3);
            }
            this.fireTableCellUpdated(n2, n3);
        } else {
            this._model.setValueAt(object, n2, n3);
        }
    }

    private void \u0101(Object object, int n2, int n3) {
        Record record;
        if (this.\u0d07.get(n2) == null) {
            record = this.createRowRecord();
            this.\u0d07.setElementAt(record, n2);
        } else {
            record = this.\u0d07.get(n2);
        }
        record.setValue(this.getColumnName(n3), object);
    }

    @Override
    public void rollback() {
        this.resetState();
        this.fireTableStructureChanged();
    }

    protected int getActualIndexAt(int n2) {
        int n3;
        int n4 = n2;
        Iterator<Integer> iterator = this.\u0d08.iterator();
        while (iterator.hasNext() && (n3 = iterator.next().intValue()) <= n2) {
            ++n4;
        }
        return n4;
    }

    protected void resetState() {
        this.\u0d08.clear();
        this.\u0d07.clear();
        this.\u0d06 = 0;
        this.\u0d0a = 0;
        this._cache = new TableModelCache();
    }

    @Override
    public void commit() throws Exception {
        int[] nArray = this.\u0108(this._cache.\u0104());
        int[] nArray2 = this.\u0108(this.\u0d08);
        int n2 = 0;
        int n3 = 0;
        if (nArray2.length > 0 && nArray.length > 0 && nArray2[0] < nArray[0]) {
            do {
                ((CrudTableModel)this._model).deleteRow(nArray2[n2++]);
            } while (n2 < nArray2.length && nArray2[n2] < nArray[0]);
        }
        for (int n4 : nArray) {
            while (n2 < nArray2.length && nArray2[n2] < n4) {
                ((CrudTableModel)this._model).deleteRow(nArray2[n2++]);
            }
            ((CrudTableModel)this._model).updateRow(n4 - n3, this.readRow(n4 - n3));
        }
        while (n2 < nArray2.length) {
            ((CrudTableModel)this._model).deleteRow(nArray2[n2++]);
        }
        Object object = this.\u0d07.iterator();
        while (object.hasNext()) {
            Record record = (Record)object.next();
            ((CrudTableModel)this._model).insertRow(record);
        }
        this.resetState();
        this.fireTableDataChanged();
    }

    private int[] \u0108(List<Integer> list) {
        if (list == null) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[i2] = list.get(i2);
        }
        return nArray;
    }

    @Override
    public void insertRow(Record record) throws Exception {
        if (!this.\u0d09) {
            this.\u0d07.add(record != Record.EMPTY ? record : null);
            int n2 = this.getRowCount();
            ++this.\u0d0a;
            this.fireTableRowsInserted(n2, n2);
        } else {
            ((CrudTableModel)this._model).insertRow(record);
        }
    }

    @Override
    public Record readRow(int n2) throws Exception {
        Record record = this.createRowRecord();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            record.setValue(this.getColumnName(i2), this.getValueAt(n2, i2));
        }
        return record;
    }

    protected Record createRowRecord() {
        return new DefaultRecord();
    }

    @Override
    public void updateRow(int n2, Record record) throws Exception {
        if (!this.\u0d09) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.setValueAt(record.getValue(this.getColumnName(i2)), n2, i2);
            }
            this.fireTableRowsUpdated(n2, n2);
        } else {
            ((CrudTableModel)this._model).updateRow(n2, record);
        }
    }

    @Override
    public void deleteRow(int n2) throws Exception {
        if (!this.\u0d09) {
            if (n2 >= this.\u01e2()) {
                this.\u0d07.removeElementAt(n2 - this.\u01e2());
                --this.\u0d0a;
            } else {
                int n3 = this.getActualIndexAt(n2);
                this.\u0d08.add(n2);
                if (this._cache.\u0104() != null && this._cache.\u0104().contains(n3)) {
                    this._cache.\u0103(n3);
                }
                ++this.\u0d06;
                Collections.sort(this.\u0d08);
            }
            this.fireTableRowsDeleted(n2, n2);
        } else {
            ((CrudTableModel)this._model).deleteRow(n2);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) {
        if (this.\u0d09 && !bl) {
            this.rollback();
        }
        this.\u0d09 = bl;
        this.resetState();
    }

    @Override
    public boolean isAutoCommit() {
        return this.\u0d09;
    }
}

