/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ExceptionType;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class AbstractDataStream {
    protected static final int MAX_FETCH_SIZE = 4000;
    protected static final int UNKNOWN_SIZE = -1;
    protected int m_numRead = 0;
    protected long m_streamLength = 0L;
    protected long m_lastChunkReadSize = 0L;
    protected InputStream m_stream = null;
    protected int m_type;
    protected IWarningListener m_warningListener = null;

    protected AbstractDataStream(InputStream stream, long streamLength, int type, IWarningListener warningListener) {
        this.m_stream = stream;
        this.m_streamLength = streamLength;
        this.m_type = type;
        this.m_warningListener = warningListener;
    }

    public void close() {
        try {
            this.m_stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_stream = null;
    }

    public abstract Pair<DataWrapper, Long> getNextValue() throws SQLException;

    public boolean hasMoreData() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (-1L != this.m_streamLength) {
            return (long)this.m_numRead < this.m_streamLength;
        }
        return -1L != this.m_lastChunkReadSize;
    }

    protected int getNumToFetch() {
        if (-1L != this.m_streamLength) {
            long numLeft = this.m_streamLength - (long)this.m_numRead;
            return (int)Math.min(4000L, numLeft);
        }
        return 4000;
    }

    protected boolean isClosed() {
        return null == this.m_stream;
    }
}

