/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SArray;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41ForwardResultSet;
import com.vertica.jdbc.jdbc42.S42Array;
import com.vertica.jdbc.jdbc42.S42ResultSetMetaData;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42ForwardResultSet
extends S41ForwardResultSet {
    public S42ForwardResultSet(SStatement statement, IResultSet resultSet, ILogger logger) throws SQLException {
        super(statement, resultSet, logger);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SArray createArrayResult(IArray array) throws SQLException {
        return new S42Array(array, this.getParentConnection(), this.getLogger(), this.getWarningListener());
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object columnValue, SQLType targetSqlType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, targetSqlType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object columnValue, SQLType targetSqlType, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, targetSqlType, scale);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(String columnName, Object columnValue, SQLType targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, targetSqlType);
        this.updateObject(this.findColumn(columnName), columnValue, targetSqlType);
    }

    @Override
    public synchronized void updateObject(String columnName, Object columnValue, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, targetSqlType, scale);
        this.updateObject(this.findColumn(columnName), columnValue, targetSqlType, scale);
    }
}

