/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    public static final String PROPERTY_VALUES = "values";
    public static final String PROPERTY_COMPARATOR = "comparator";
    public static final String PROPERTY_SORTED = "sorted";
    private List<T> \u010f = null;
    private List<Category<T>> \u010c = null;
    private Double \u0111;
    private Double \u010d;
    private Comparator<T> \u010b = null;
    private boolean \u0110 = false;
    private boolean \u0112 = false;
    private Map<T, Integer> \u010e = new HashMap<T, Integer>();

    public CategoryRange() {
        this.\u010f = new ArrayList<T>();
        this.\u010c = new ArrayList<Category<T>>();
        this.\u0112 = false;
    }

    public CategoryRange(T ... TArray) {
        this.\u010f = new ArrayList<T>();
        this.\u010f.addAll(Arrays.asList(TArray));
        this.\u0112 = false;
    }

    public CategoryRange(Set<T> set) {
        this.\u010f = new ArrayList<T>(set);
        this.\u0112 = false;
    }

    public CategoryRange(CategoryRange<T> categoryRange) {
        this.\u010c = new ArrayList<Category<T>>(categoryRange.getCategoryValues());
        this.\u010f = new ArrayList<T>(categoryRange.getPossibleValues());
        this.\u010b = categoryRange.getComparator();
        this.setMinimum(categoryRange.minimum());
        this.setMaximum(categoryRange.maximum());
        this.\u0112 = false;
    }

    public List<T> getPossibleValues() {
        if (this.\u0110 && !this.\u0112) {
            if (this.\u010b == null) {
                Comparator comparator = new Comparator<T>(){

                    @Override
                    public int compare(T t2, T t3) {
                        if (t2 == null && t3 == null) {
                            return 0;
                        }
                        if (t2 == null) {
                            return -1;
                        }
                        if (t3 == null) {
                            return 1;
                        }
                        if (t2 instanceof Comparable) {
                            Comparable comparable = (Comparable)t2;
                            return comparable.compareTo(t3);
                        }
                        String string = t2.toString();
                        String string2 = t3.toString();
                        return string.compareTo(string2);
                    }
                };
                Collections.sort(this.\u010f, comparator);
                this.\u010e.clear();
            } else {
                Collections.sort(this.\u010f, this.\u010b);
                this.\u010e.clear();
            }
        }
        return this.\u010f;
    }

    public Category<T> getCategory(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Supplied category index was " + n2 + " but it should be >= 1");
        }
        return this.getCategoryValues().get(n2 - 1);
    }

    public CategoryRange<T> add(Category<T> category) {
        if (!this.contains(category)) {
            if (this.\u010b == null) {
                this.\u010f.add(category.getValue());
                this.\u010c.add(category);
            } else {
                this.\u010f.add(category.getValue());
                this.\u0112 = false;
                this.\u010c = null;
            }
            category.setRange(this);
            this.firePropertyChange(PROPERTY_VALUES, null, this.\u010f);
        }
        return this;
    }

    public void setSorted(boolean bl) {
        boolean bl2 = this.\u0110;
        this.\u0110 = bl;
        if (bl) {
            this.\u010c = null;
        }
        this.\u010e.clear();
        this.firePropertyChange(PROPERTY_SORTED, bl2, bl);
    }

    public boolean isSorted() {
        return this.\u0110;
    }

    public Comparator<T> getComparator() {
        return this.\u010b;
    }

    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.\u010b;
        this.\u010b = comparator;
        this.setSorted(comparator != null);
        this.firePropertyChange(PROPERTY_COMPARATOR, comparator2, comparator);
    }

    @Override
    public Range<T> copy() {
        return new CategoryRange<T>(this);
    }

    @Override
    public T lower() {
        if (this.\u010f == null || this.\u010f.size() == 0) {
            return null;
        }
        return this.\u010f.get(0);
    }

    @Override
    public T upper() {
        if (this.\u010f == null || this.\u010f.size() == 0) {
            return null;
        }
        int n2 = this.\u010f.size();
        return this.\u010f.get(n2 - 1);
    }

    @Override
    public void adjust(T t2, T t3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        if (this.\u010d == null) {
            T t2 = this.upper();
            if (t2 == null) {
                return 1.0;
            }
            this.\u010d = (double)this.position(t2) + 1.0;
        }
        return this.\u010d;
    }

    @Override
    public double minimum() {
        if (this.\u0111 == null) {
            T t2 = this.lower();
            if (t2 == null) {
                return 0.0;
            }
            this.\u0111 = (double)this.position(t2) - 1.0;
        }
        return this.\u0111;
    }

    public void reset() {
        this.\u010d = null;
        this.\u0111 = null;
        this.\u010e.clear();
    }

    public void setMinimum(double d2) {
        Double d3 = this.\u0111;
        this.\u0111 = d2;
        this.firePropertyChange("min", d3, d2);
    }

    public void setMaximum(double d2) {
        Double d3 = this.\u010d;
        this.\u010d = d2;
        this.firePropertyChange("max", d3, d2);
    }

    @Override
    public double size() {
        if (this.\u010f == null) {
            return 0.0;
        }
        int n2 = this.\u010f.size();
        if (n2 == 0) {
            return 0.0;
        }
        return this.maximum() - this.minimum();
    }

    public int position(T t2) {
        Integer n2 = this.\u010e.get(t2);
        if (n2 == null) {
            List<T> list = this.getPossibleValues();
            n2 = list.indexOf(t2);
            if (n2 < 0) {
                throw new IllegalArgumentException("Value " + t2 + " not known");
            }
            this.\u010e.put(t2, n2);
        }
        return 1 + n2;
    }

    @Override
    public boolean contains(T t2) {
        if (t2 == null) {
            return false;
        }
        for (T t3 : this.\u010f) {
            if (!t2.equals(t3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> category) {
        if (category == null) {
            return false;
        }
        for (Category<T> category2 : this.getCategoryValues()) {
            if (!category.equals(category2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this.\u010c == null) {
            this.\u010c = new ArrayList<Category<T>>();
            for (T t2 : this.getPossibleValues()) {
                this.\u010c.add(new Category<T>(t2, this));
            }
        }
        return this.\u010c;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.\u010c == null ? 0 : this.\u010c.hashCode());
        n2 = 31 * n2 + (this.\u010f == null ? 0 : this.\u010f.hashCode());
        n2 = 31 * n2 + (this.\u010d == null ? 0 : this.\u010d.hashCode());
        n2 = 31 * n2 + (this.\u0111 == null ? 0 : this.\u0111.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CategoryRange categoryRange = (CategoryRange)object;
        if (this.\u010c == null ? categoryRange.\u010c != null : !this.\u010c.equals(categoryRange.\u010c)) {
            return false;
        }
        if (this.\u010f == null ? categoryRange.\u010f != null : !this.\u010f.equals(categoryRange.\u010f)) {
            return false;
        }
        if (this.\u010d == null ? categoryRange.\u010d != null : !this.\u010d.equals(categoryRange.\u010d)) {
            return false;
        }
        return !(this.\u0111 == null ? categoryRange.\u0111 != null : !this.\u0111.equals(categoryRange.\u0111));
    }

    @Override
    public Range<T> createIntermediate(Range<T> range, double d2) {
        CategoryRange<T> categoryRange;
        double d3 = this.minimum();
        double d4 = this.maximum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        if (d2 < 0.5) {
            categoryRange = new CategoryRange<T>(this);
        } else if (range instanceof CategoryRange) {
            categoryRange = new CategoryRange<T>((CategoryRange)range);
        } else {
            throw new IllegalArgumentException("Cannot create intermediate range from " + range.getClass());
        }
        categoryRange.setMinimum(d7);
        categoryRange.setMaximum(d8);
        return categoryRange;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<CategoryRange ");
        stringBuilder.append("minimum=");
        stringBuilder.append(this.\u0111);
        stringBuilder.append(" maximum=");
        stringBuilder.append(this.\u010d);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

