/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.AllFilter;
import com.jidesoft.filter.BetweenFilter;
import com.jidesoft.filter.EmptyFilter;
import com.jidesoft.filter.EqualFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactory;
import com.jidesoft.filter.FilterFactoryWithEditProperty;
import com.jidesoft.filter.GreaterOrEqualFilter;
import com.jidesoft.filter.GreaterThanFilter;
import com.jidesoft.filter.InFilter;
import com.jidesoft.filter.LastMonthFilter;
import com.jidesoft.filter.LastQuarterFilter;
import com.jidesoft.filter.LastWeekFilter;
import com.jidesoft.filter.LastYearFilter;
import com.jidesoft.filter.LessOrEqualFilter;
import com.jidesoft.filter.LessThanFilter;
import com.jidesoft.filter.MonthFilter;
import com.jidesoft.filter.NextMonthFilter;
import com.jidesoft.filter.NextQuarterFilter;
import com.jidesoft.filter.NextWeekFilter;
import com.jidesoft.filter.NextYearFilter;
import com.jidesoft.filter.NotBetweenFilter;
import com.jidesoft.filter.NotEqualFilter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.ThisMonthFilter;
import com.jidesoft.filter.ThisQuarterFilter;
import com.jidesoft.filter.ThisWeekFilter;
import com.jidesoft.filter.ThisYearFilter;
import com.jidesoft.filter.TodayFilter;
import com.jidesoft.filter.TomorrowFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.filter.YesterdayFilter;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FilterFactoryManager {
    public static final String DATA_TYPE_DATE = "date";
    public static final String DATA_TYPE_STRING = "string";
    public static final String DATA_TYPE_NUMBER = "number";
    public static final String DATA_TYPE_BOOLEAN = "boolean";
    private Map<Class, List<FilterFactory>> \u0103 = new HashMap<Class, List<FilterFactory>>();
    private Map<Class, List<String>> \u0102 = new HashMap<Class, List<String>>();
    private static FilterFactoryManager \u0101;

    public void registerFilterFactory(Class clazz, FilterFactory filterFactory) {
        this.registerFilterFactory(clazz, filterFactory, -1);
    }

    public void registerFilterFactory(Class clazz, FilterFactory filterFactory, int n2) {
        List<String> list;
        List<FilterFactory> list2 = this.\u0103.get(clazz);
        if (list2 == null) {
            list2 = new ArrayList<FilterFactory>();
            this.\u0103.put(clazz, list2);
        }
        if ((list = this.\u0102.get(clazz)) != null && filterFactory != null) {
            list.remove(filterFactory.getName());
        }
        if (n2 >= list2.size() || n2 == -1) {
            list2.add(filterFactory);
        } else {
            list2.add(n2, filterFactory);
        }
    }

    public boolean unregisterFilterFactory(Class clazz, FilterFactory filterFactory) {
        if (filterFactory == null) {
            return true;
        }
        List<FilterFactory> list = this.\u0103.get(clazz);
        List<String> list2 = this.\u0102.get(clazz);
        if (list2 == null) {
            list2 = new ArrayList<String>();
            this.\u0102.put(clazz, list2);
        }
        list2.add(filterFactory.getName());
        return list != null && list.remove(filterFactory);
    }

    public List<FilterFactory> getFilterFactories(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList<FilterFactory>();
        }
        ArrayList<FilterFactory> arrayList = new ArrayList<FilterFactory>();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(clazz);
        Class<?>[] classArray = clazz.getInterfaces();
        arrayList2.addAll(Arrays.asList(classArray));
        Class<?> clazz2 = clazz;
        while (!clazz2.isInterface() && (clazz2 = clazz2.getSuperclass()) != null) {
            arrayList2.add(clazz2);
            classArray = clazz2.getInterfaces();
            arrayList2.addAll(Arrays.asList(classArray));
        }
        if (clazz == Integer.TYPE) {
            arrayList2.add(Integer.class);
            arrayList2.add(Number.class);
        } else if (clazz == Double.TYPE) {
            arrayList2.add(Double.class);
            arrayList2.add(Number.class);
        } else if (clazz == Float.TYPE) {
            arrayList2.add(Float.class);
            arrayList2.add(Number.class);
        } else if (clazz == Long.TYPE) {
            arrayList2.add(Long.class);
            arrayList2.add(Number.class);
        } else if (clazz == Short.TYPE) {
            arrayList2.add(Short.class);
            arrayList2.add(Number.class);
        } else if (clazz == Character.TYPE) {
            arrayList2.add(Character.class);
        } else if (clazz == Byte.TYPE) {
            arrayList2.add(Byte.class);
            arrayList2.add(Number.class);
        } else if (clazz == Boolean.TYPE) {
            arrayList2.add(Boolean.class);
        }
        if (!arrayList2.contains(Object.class)) {
            arrayList2.add(Object.class);
        }
        arrayList2.remove(Comparable.class);
        if (!arrayList2.contains(String.class)) {
            arrayList2.add(Comparable.class);
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Class clazz3 : arrayList2) {
            List<FilterFactory> list = this.\u0103.get(clazz3);
            List<String> list2 = this.\u0102.get(clazz3);
            if (list2 != null) {
                hashSet2.addAll(list2);
            }
            if (list == null) continue;
            for (FilterFactory filterFactory : list) {
                if (filterFactory == null || filterFactory.getName() == null || hashSet2.contains(filterFactory.getName()) || hashSet.contains(filterFactory.getName())) continue;
                arrayList.add(filterFactory);
                hashSet.add(filterFactory.getName());
            }
        }
        return arrayList;
    }

    public void clear() {
        this.\u0103.clear();
    }

    public void registerDefaultFilterFactories() {
        this.registerDefaultFilterFactories(true);
    }

    public void registerDefaultFilterFactories(boolean bl) {
        this.\u0101(String.class, DATA_TYPE_STRING);
        this.\u0102(Boolean.class, DATA_TYPE_BOOLEAN);
        this.\u0101(Date.class, DATA_TYPE_DATE, bl);
        this.\u0101(Calendar.class, DATA_TYPE_DATE, bl);
        this.\u0103(Number.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Integer.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Double.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Float.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Short.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Long.class, DATA_TYPE_NUMBER, bl);
        this.\u0103(Integer.TYPE, DATA_TYPE_NUMBER, bl);
        this.\u0103(Double.TYPE, DATA_TYPE_NUMBER, bl);
        this.\u0103(Float.TYPE, DATA_TYPE_NUMBER, bl);
        this.\u0103(Long.TYPE, DATA_TYPE_NUMBER, bl);
        this.\u0103(Byte.TYPE, DATA_TYPE_NUMBER, bl);
        this.\u0102(Enum.class, DATA_TYPE_STRING, bl);
        this.\u0102(Object.class, DATA_TYPE_STRING, bl);
        this.\u0101(DATA_TYPE_STRING, bl);
    }

    private void \u0102(final Class<?> clazz, final String string, boolean bl) {
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                return new AllFilter<Object>();
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                return new EqualFilter<Object>(objectArray[0]);
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                return new NotEqualFilter<Object>(objectArray[0]);
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "not.equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new InFilter<Object>((Object[])objectArray[0]);
                }
                return new InFilter<Object>(objectArray);
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new NotFilter(new InFilter<Object>((Object[])objectArray[0]));
                }
                return new NotFilter(new InFilter<Object>(objectArray));
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "not.in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                return new EmptyFilter<Object>();
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter<Object> createFilter(Object ... objectArray) {
                return new NotFilter(new EmptyFilter());
            }

            public Class<?>[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "not.empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
    }

    private void \u0101(final Class clazz, final String string) {
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new AllFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<String>((String)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotEqualFilter<String>((String)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "not.equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new InFilter<Object>((Object[])objectArray[0]);
                }
                return new InFilter<Object>(objectArray);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new NotFilter(new InFilter<Object>((Object[])objectArray[0]));
                }
                return new NotFilter(new InFilter<Object>(objectArray));
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "not.in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EmptyFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotFilter(new EmptyFilter());
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "not.empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter((String)objectArray[0]);
                wildcardFilter.setBeginWith(true);
                wildcardFilter.setEndWith(false);
                return wildcardFilter;
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "beginWith";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter((String)objectArray[0]);
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(true);
                return wildcardFilter;
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "endWith";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter((String)objectArray[0]);
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(false);
                return wildcardFilter;
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "contain";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                WildcardFilter wildcardFilter = new WildcardFilter((String)objectArray[0]);
                wildcardFilter.setBeginWith(false);
                wildcardFilter.setEndWith(false);
                return new NotFilter(wildcardFilter);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "not.contain";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
    }

    private void \u0102(Class clazz, final String string) {
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new AllFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<Boolean>(true);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "true";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<Boolean>(false);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "false";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
    }

    private void \u0101(final Class clazz, final String string, boolean bl) {
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new AllFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotEqualFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "not.equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new InFilter<Object>((Object[])objectArray[0]);
                }
                return new InFilter<Object>(objectArray);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new NotFilter(new InFilter<Object>((Object[])objectArray[0]));
                }
                return new NotFilter(new InFilter<Object>(objectArray));
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "not.in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EmptyFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotFilter(new EmptyFilter());
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "not.empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterThanFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "greater";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterOrEqualFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "greaterOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessThanFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "less";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessOrEqualFilter<Object>(objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "lessOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        if (bl) {
            this.registerFilterFactory(clazz, new FilterFactory(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new BetweenFilter<Object>(objectArray[0], objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public String getName() {
                    return "between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
            this.registerFilterFactory(clazz, new FilterFactory(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new NotBetweenFilter<Object>(objectArray[0], objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public String getName() {
                    return "not.between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
        }
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new TodayFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "today";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new YesterdayFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "yesterday";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new TomorrowFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "tomorrow";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new ThisWeekFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "thisWeek";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new ThisQuarterFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "thisQuarter";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new ThisMonthFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "thisMonth";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new ThisYearFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "thisYear";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LastWeekFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "lastWeek";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LastQuarterFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "lastQuarter";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LastMonthFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "lastMonth";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LastYearFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "lastYear";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NextWeekFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "nextWeek";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NextQuarterFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "nextQuarter";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NextMonthFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "nextMonth";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NextYearFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "nextYear";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        int n2 = 0;
        while (n2 < 12) {
            final int n3 = n2++;
            this.registerFilterFactory(clazz, new FilterFactory(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new MonthFilter(n3);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[0];
                }

                @Override
                public String getName() {
                    return "month " + n3;
                }

                @Override
                public String getConditionString(Locale locale) {
                    String string2 = AbstractFilter.getConditionString(locale, string, "month");
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(5, 1);
                    calendar.set(2, n3);
                    return MessageFormat.format(string2, new SimpleDateFormat("MMMMM", locale).format(calendar.getTime()));
                }
            });
        }
    }

    private void \u0101(final String string, boolean bl) {
        final Class<Comparable> clazz = Comparable.class;
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new AllFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotEqualFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "not.equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new InFilter<Object>((Object[])objectArray[0]);
                }
                return new InFilter<Object>(objectArray);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new NotFilter(new InFilter<Object>((Object[])objectArray[0]));
                }
                return new NotFilter(new InFilter<Object>(objectArray));
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "not.in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EmptyFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotFilter(new EmptyFilter());
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "not.empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterThanFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "greater";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterOrEqualFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "greaterOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessThanFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "less";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessOrEqualFilter<Comparable>((Comparable)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public boolean[] getEditableProperties() {
                return new boolean[]{false};
            }

            @Override
            public String getName() {
                return "lessOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        if (bl) {
            this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new BetweenFilter<Comparable>((Comparable)objectArray[0], (Comparable)objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public boolean[] getEditableProperties() {
                    return new boolean[]{false, false};
                }

                @Override
                public String getName() {
                    return "between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
            this.registerFilterFactory(clazz, new FilterFactoryWithEditProperty(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new NotBetweenFilter<Comparable>((Comparable)objectArray[0], (Comparable)objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public boolean[] getEditableProperties() {
                    return new boolean[]{false, false};
                }

                @Override
                public String getName() {
                    return "not.between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
        }
    }

    private void \u0103(final Class clazz, final String string, boolean bl) {
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new AllFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "all";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EqualFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotEqualFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "not.equal";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new InFilter<Object>((Object[])objectArray[0]);
                }
                return new InFilter<Object>(objectArray);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                if (objectArray[0] instanceof Object[]) {
                    return new NotFilter(new InFilter<Object>((Object[])objectArray[0]));
                }
                return new NotFilter(new InFilter<Object>(objectArray));
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{Array.newInstance(clazz, 0).getClass()};
            }

            @Override
            public String getName() {
                return "not.in";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new EmptyFilter();
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new NotFilter(new EmptyFilter());
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[0];
            }

            @Override
            public String getName() {
                return "not.empty";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterThanFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "greater";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new GreaterOrEqualFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "greaterOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessThanFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "less";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        this.registerFilterFactory(clazz, new FilterFactory(){

            @Override
            public Filter createFilter(Object ... objectArray) {
                return new LessOrEqualFilter<Number>((Number)objectArray[0]);
            }

            @Override
            public Class[] getExpectedDataTypes() {
                return new Class[]{clazz};
            }

            @Override
            public String getName() {
                return "lessOrEqual";
            }

            @Override
            public String getConditionString(Locale locale) {
                return AbstractFilter.getConditionString(locale, string, this.getName());
            }
        });
        if (bl) {
            this.registerFilterFactory(clazz, new FilterFactory(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new BetweenFilter<Number>((Number)objectArray[0], (Number)objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public String getName() {
                    return "between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
            this.registerFilterFactory(clazz, new FilterFactory(){

                @Override
                public Filter createFilter(Object ... objectArray) {
                    return new NotBetweenFilter<Number>((Number)objectArray[0], (Number)objectArray[1]);
                }

                @Override
                public Class[] getExpectedDataTypes() {
                    return new Class[]{clazz, clazz};
                }

                @Override
                public String getName() {
                    return "not.between";
                }

                @Override
                public String getConditionString(Locale locale) {
                    return AbstractFilter.getConditionString(locale, string, this.getName());
                }
            });
        }
    }

    public static FilterFactoryManager getDefaultInstance() {
        if (\u0101 == null) {
            \u0101 = new FilterFactoryManager();
            \u0101.registerDefaultFilterFactories();
        }
        return \u0101;
    }

    public static void setDefaultInstance(FilterFactoryManager filterFactoryManager) {
        \u0101 = filterFactoryManager;
    }

    public FilterFactory findFilterFactoryByName(Class clazz, String string) {
        for (FilterFactory filterFactory : this.getFilterFactories(clazz)) {
            if (!string.equals(filterFactory.getName())) continue;
            return filterFactory;
        }
        return null;
    }

    public Filter createFilter(String string, Class clazz, Object ... objectArray) {
        FilterFactory filterFactory = this.findFilterFactoryByName(clazz, string);
        return this.createFilter(filterFactory, objectArray);
    }

    public Filter createFilter(FilterFactory filterFactory, Object ... objectArray) {
        if (filterFactory != null) {
            Filter filter = filterFactory.createFilter(objectArray);
            filter.setFilterFactory(filterFactory);
            filter.setFilterFactoryName(filterFactory.getName());
            return filter;
        }
        return null;
    }
}

