/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jytable;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.util.Contract;

public class TableColumnResizer {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private JXTable table;
    private Resizer mouseInputListener;
    private static final Logger LOG = Logger.getLogger(TableColumnResizer.class.getName());

    public TableColumnResizer(JXTable table) {
        this.table = (JXTable)Contract.asNotNull((Object)table, (String)"target table must not be null");
        this.installTableListeners();
    }

    public void release() {
        this.table.removeMouseListener((MouseListener)this.mouseInputListener);
        this.table.removeMouseMotionListener((MouseMotionListener)this.mouseInputListener);
        this.mouseInputListener = null;
        this.table = null;
    }

    private void installTableListeners() {
        MouseMotionListener[] motionListeners;
        MouseListener mouseListener;
        MouseListener[] ml;
        this.mouseInputListener = new Resizer();
        MouseListener[] mouseListenerArray = ml = this.table.getMouseListeners();
        int n = ml.length;
        int n2 = 0;
        while (n2 < n) {
            mouseListener = mouseListenerArray[n2];
            this.table.removeMouseListener(mouseListener);
            ++n2;
        }
        this.table.addMouseListener((MouseListener)this.mouseInputListener);
        mouseListenerArray = ml;
        n = ml.length;
        n2 = 0;
        while (n2 < n) {
            mouseListener = mouseListenerArray[n2];
            this.table.addMouseListener(mouseListener);
            ++n2;
        }
        MouseMotionListener[] mouseMotionListenerArray = motionListeners = this.table.getMouseMotionListeners();
        int n3 = motionListeners.length;
        n = 0;
        while (n < n3) {
            MouseMotionListener mm = mouseMotionListenerArray[n];
            this.table.removeMouseMotionListener(mm);
            ++n;
        }
        this.table.addMouseMotionListener((MouseMotionListener)this.mouseInputListener);
        mouseMotionListenerArray = motionListeners;
        n3 = motionListeners.length;
        n = 0;
        while (n < n3) {
            MouseMotionListener mm = mouseMotionListenerArray[n];
            this.table.addMouseMotionListener(mm);
            ++n;
        }
    }

    private class Resizer
    extends MouseInputAdapter {
        private int mouseXOffset;
        private Cursor otherCursor = TableColumnResizer.access$0();

        private Resizer() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.shouldSwapCursor(e.getPoint())) {
                this.doSwapCursor();
            }
        }

        private boolean shouldSwapCursor(Point point) {
            TableColumn resizingColumn = this.getResizeCandidateColumnAt(point);
            return this.isResizingAllowed(resizingColumn) ^ this.hasResizeCursor();
        }

        private boolean hasResizeCursor() {
            return TableColumnResizer.this.table.getCursor() == resizeCursor;
        }

        private void doSwapCursor() {
            Cursor tmp = TableColumnResizer.this.table.getCursor();
            TableColumnResizer.this.table.setCursor(this.otherCursor);
            this.otherCursor = tmp;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.reset();
            TableColumn resizableColumn = this.getResizableColumnAt(e.getPoint());
            if (resizableColumn == null) {
                return;
            }
            if (this.isPackGesture(e)) {
                TableColumnResizer.this.table.packColumn(TableColumnResizer.this.table.convertColumnIndexToView(resizableColumn.getModelIndex()), -1);
            } else {
                TableColumnResizer.this.table.getTableHeader().setResizingColumn(resizableColumn);
                this.mouseXOffset = TableColumnResizer.this.table.getComponentOrientation().isLeftToRight() ? e.getX() - resizableColumn.getWidth() : e.getX() + resizableColumn.getWidth();
            }
            e.consume();
        }

        private void reset() {
            TableColumnResizer.this.table.getTableHeader().setDraggedColumn(null);
            TableColumnResizer.this.table.getTableHeader().setResizingColumn(null);
            TableColumnResizer.this.table.getTableHeader().setDraggedDistance(0);
        }

        private TableColumn getResizableColumnAt(Point p) {
            TableColumn resizeCandidate = this.getResizeCandidateColumnAt(p);
            return this.isResizingAllowed(resizeCandidate) ? resizeCandidate : null;
        }

        private TableColumn getResizeCandidateColumnAt(Point p) {
            int columnIndex = this.getResizeCandidateColumnIndexAt(p);
            TableColumn resizeCandidate = columnIndex < 0 ? null : TableColumnResizer.this.table.getColumnModel().getColumn(columnIndex);
            return resizeCandidate;
        }

        private boolean isPackGesture(MouseEvent e) {
            return e.getClickCount() % 2 == 0;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.getResizingColumn() != null) {
                TableColumnResizer.this.table.getTableHeader().setResizingColumn(null);
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.getResizingColumn() == null) {
                return;
            }
            int oldWidth = this.getResizingColumn().getWidth();
            int newWidth = this.calculateNewColumnWidth(e.getX());
            this.getResizingColumn().setWidth(newWidth);
            this.mouseXOffset += this.adjustViewportWidthIfRToL(newWidth - oldWidth);
            e.consume();
        }

        private int calculateNewColumnWidth(int mouseX) {
            if (TableColumnResizer.this.table.getComponentOrientation().isLeftToRight()) {
                return mouseX - this.mouseXOffset;
            }
            return this.mouseXOffset - mouseX;
        }

        private TableColumn getResizingColumn() {
            return TableColumnResizer.this.table.getTableHeader().getResizingColumn();
        }

        private int adjustViewportWidthIfRToL(int diff) {
            JScrollPane scrollPane = this.getEnclosingScrollPaneRToL();
            if (scrollPane == null) {
                return 0;
            }
            int viewportWidth = scrollPane.getViewport().getWidth();
            int newHeaderWidth = TableColumnResizer.this.table.getWidth() + diff;
            Dimension tableSize = TableColumnResizer.this.table.getSize();
            tableSize.width += diff;
            TableColumnResizer.this.table.setSize(tableSize);
            if (newHeaderWidth >= viewportWidth && TableColumnResizer.this.table.getAutoResizeMode() == 0) {
                Point p = scrollPane.getViewport().getViewPosition();
                p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                scrollPane.getViewport().setViewPosition(p);
                return diff;
            }
            return 0;
        }

        private JScrollPane getEnclosingScrollPaneRToL() {
            Container scrollPane;
            JTableHeader header = TableColumnResizer.this.table.getTableHeader();
            if (header.getParent() == null || (scrollPane = header.getParent().getParent()) == null || !(scrollPane instanceof JScrollPane)) {
                return null;
            }
            if (!scrollPane.getComponentOrientation().isLeftToRight() && !header.getComponentOrientation().isLeftToRight()) {
                return (JScrollPane)scrollPane;
            }
            return null;
        }

        private boolean isEnabled() {
            return TableColumnResizer.this.table.isEnabled() && TableColumnResizer.this.table.getTableHeader() != null;
        }

        private boolean isResizingAllowed(TableColumn column) {
            return column != null && TableColumnResizer.this.table.getTableHeader().getResizingAllowed() && column.getResizable();
        }

        private int getResizeCandidateColumnIndexAt(Point p) {
            int column = TableColumnResizer.this.table.columnAtPoint(p);
            if (column == -1) {
                return -1;
            }
            Rectangle r = TableColumnResizer.this.table.getCellRect(0, column, true);
            r.grow(-3, TableColumnResizer.this.table.getHeight());
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.x + r.width / 2;
            int columnIndex = TableColumnResizer.this.table.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            return columnIndex;
        }
    }
}

